(defn- extract-ontology-frame
  "Extracts the ontology frames from a list of frames.
Currently, we define this to be the second value iff the first is an :ontology
keyword. Returns a map of :ontology and the ontology or nil, and :args with
the args minus the ontology frame if it exists."
  [frames]
  (if (= :ontology (first frames))
    {:ontology (second frames)
     :frames (nthrest frames 2)}
    {:ontology nil
     :frames frames}))



;; This has to run when we have the frames and entity, so it needs to run at
;; the time that the macro runs, not the macro defining macro.
(defn- entity-generator [entity frames entity-function]
  (let [ontsplit (extract-ontology-frame frames)
        ont (:ontology ontsplit)
        frames (:frames ontsplit)]
    `(let [entity-name# (name '~entity)
           entity#
           (~entity-function
            ~ont
            entity-name#
            ~@frames)]
       (tawny.owl/intern-owl ~entity entity#))))


(defmacro ^{:private true} defentity
  "Defines a new entity macro."
  [name docstring entity-function]
  `(defmacro ~name
     ~docstring
     [entity# & frames#]
     (entity-generator entity# frames# ~entity-function)))

(defentity defnewentity "Doc" 'new-entity)





(defmacro defmynewentity
  "My hand written macro we want to get"
  [entity & frames]
  (entity-generator entity frames 'tawny.owl/annotation-property))


(defmynewentity bob :ontology 0 :a 1 :b 2)


