(ns tawny.temp
  (:use [clojure.test])
  (:require [clojure.string :as s])
  (:import
   (org.semanticweb.owlapi.model
    OWLAxiom IRI
    OWLOntologyManager)
   (org.semanticweb.owlapi.apibinding OWLManager)))

(defn get0[^java.util.List l]
  (.get l 0))

(defn getletter0[^java.util.List l]
  (.get l "0"))


(defn all-classes [& args]
  (vec (map class args)))


(all-classes 1 2 3 4 "hello")

(defn prnt [& args]
  (s/join ":" args))

(defmulti on-class #'all-classes)


(defmethod on-class [java.lang.Long] [one]
  (prnt [java.lang.Long] one))

(defmethod on-class [java.lang.Long Long] [one two]
  (prnt [Long Long] one two))

(defmethod on-class [String Long] [one two]
  (prnt [String Long] one two))

(on-class 1)
(on-class 1 2)
(on-class "One" 2)
