;; The contents of this file are subject to the LGPL License, Version 3.0.
;;
;; Copyright (C) 2013, Phillip Lord, Newcastle University
;;
;; This program is free software: you can redistribute it and/or modify it
;; under the terms of the GNU Lesser General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at your
;; option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;; FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
;; for more details.
;;
;; You should have received a copy of the GNU Lesser General Public License
;; along with this program. If not, see http://www.gnu.org/licenses/.
(ns tawny.explanation
  (:require [tawny reasoner owl render])
  (:import [com.clarkparsia.owlapi.explanation DefaultExplanationGenerator]
           [com.clarkparsia.owlapi.explanation.util
            SilentExplanationProgressMonitor]
           [org.semanticweb.owlapi.model
            OWLOntology]))

(defn explanation-generator [^OWLOntology ontology]
  (DefaultExplanationGenerator.
    (tawny.owl/owl-ontology-manager)
    (tawny.reasoner/reasoner-factory)
    ontology
    (tawny.reasoner/reasoner-for-ontology ontology)
    (SilentExplanationProgressMonitor.)))

(defn orderer []
  (uk.ac.manchester.cs.owl.explanation.ordering.ExplanationOrdererImpl.
   (tawny.owl/owl-ontology-manager)))

(defn tree [axioms explanation]
  (.getOrderedExplanation (orderer) axioms explanation))

(defn explanation [ontology axioms]
  (.getExplanation (explanation-generator ontology) axioms))

(defn printtree
  ([tree]
     (printtree tree ""))
  ([tree indent]
     (let [axiom (.getUserObject tree)]
        (println (tawny.render/as-form axiom))
        (when (.isLeaf tree)
          (doseq [a ( .getChildren tree)]
            (printtree tree (str "  " indent)))))))

;;(comment
;;   DefaultExplanationGenerator explanationGenerator =
;;   new DefaultExplanationGenerator(
;;                                   manager, reasonerFactory, ontology, reasoner, new SilentExplanationProgressMonitor());
;;   Set<OWLAxiom> explanation = explanationGenerator.getExplanation(axiomToExplain);
;;   ExplanationOrderer deo = new ExplanationOrdererImpl(manager);
;;   ExplanationTree explanationTree = deo.getOrderedExplanation(axiomToExplain, explanation);
;;   System.out.println();
;;   System.out.println("-- explanation --");
;;   printIndented(explanationTree, "");

;;   private static void printIndented(Tree<OWLAxiom> node, String indent) {
;;                                                      OWLAxiom axiom = node.getUserObject();
;;                                                                          System.out.println(indent + renderer.render(axiom));
;;                                                                          if (!node.isLeaf()) {
;;                                                                                               for (Tree<OWLAxiom> child : node.getChildren()) {
;;                                                                                                                                                printIndented(child, indent + "    ");
;;                                                                                                                                                }
;;                                                                                               }
;;                                                                          }
;; )
