(in-ns 'sio-header)
(owl-class (iri "http://semanticscience.org/resource/SIO_000395") :subclass (iri "http://semanticscience.org/resource/SIO_000343") :annotation (label (literal "to regulate" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to regulate is to control or maintain the rate or speed of an object or process." :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "to modulate" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000396") :subclass (iri "http://semanticscience.org/resource/SIO_000602") :annotation (label (literal "file" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a file is an information-bearing object that contains a physical embodiment of some information using a particular character encoding." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000393") :subclass (iri "http://semanticscience.org/resource/SIO_000498") (object-some (iri "http://semanticscience.org/resource/SIO_000228") (iri "http://semanticscience.org/resource/SIO_000715")) :annotation (label (literal "patient" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a patient is an individual that is the recepient of medical care." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000394") :subclass (iri "http://semanticscience.org/resource/SIO_000716") (object-some (iri "http://semanticscience.org/resource/SIO_000228") (iri "http://semanticscience.org/resource/SIO_000713")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a doctor is an individual who practices medicine, which is concerned with promoting, maintaining or restoring human health through the study, diagnosis, and treatment of disease, injury, and other physical and mental impairments." :lang "en")) (label (literal "doctor" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000399") :subclass (iri "http://semanticscience.org/resource/SIO_000498") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a study subject is an individual that is the subject of the study." :lang "en")) (label (literal "study subject" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000397") :subclass (iri "http://semanticscience.org/resource/SIO_000494") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to provide is the capability to make available some object to another that requires it." :lang "en")) (label (literal "to provide" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000398") :subclass (iri "http://semanticscience.org/resource/SIO_000716") (object-some (iri "http://semanticscience.org/resource/SIO_000228") (iri "http://semanticscience.org/resource/SIO_000714")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A nurse is an individual that is involved in the protection, promotion, and optimization of health and abilities, prevention of illness and injury, alleviation of suffering through the diagnosis and treatment of human response, and advocacy in the care of individuals, families, communities, and populations." :lang "en")) (label (literal "nurse" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000391") :subclass (iri "http://semanticscience.org/resource/SIO_000258") (data-some (iri "http://semanticscience.org/resource/SIO_000300") :XSD_DATE_TIME) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "time measurement is a measurement value of the duration of some interval of time or a particular instant of time (against some frame of reference)." :lang "en")) (owl-comment (literal "time intervals are specified as date/datetime ranges." :type :RDF_PLAIN_LITERAL)) (label (literal "time measurement" :lang "en")) (annotation (iri "http://semanticscience.org/resource/example") (literal "the duration of my life; the duration of a surgical procedure, the moment of death" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000392") :subclass (iri "http://semanticscience.org/resource/SIO_000343") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to change spatially is the capability to affect the physical movement of some entity." :lang "en")) (label (literal "to change spatially" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000390") :subclass (iri "http://semanticscience.org/resource/SIO_000494") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to transport is the capability to displace a material from one location to another." :lang "en")) (label (literal "to transport" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000382") :subclass (iri "http://semanticscience.org/resource/SIO_000349") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "To filter is the capability to retain certain entities based on selected attribute(s) while allowing other entities to pass through." :lang "en")) (label (literal "to filter" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000383") :subclass (iri "http://semanticscience.org/resource/SIO_000351") :annotation (label (literal "to excite" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "To excite is the capability to supply energy to a materila by bombarding it with energetic particles (e.g., photons)." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000384") :subclass (iri "http://semanticscience.org/resource/SIO_000374") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "To emit is the capability to release some physical entity (light, pollution, etc)." :lang "en")) (label (literal "to emit" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000385") :subclass (iri "http://semanticscience.org/resource/SIO_000343") :annotation (label (literal "to change energetically" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to change energetically is the capability to change the energetic aspects of an object." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000386") :subclass (iri "http://semanticscience.org/resource/SIO_000350") :annotation (label (literal "to positively charge" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to positively charge is the capability to remove an electron or add a  positively charged ion to a chemical entity." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000387") :subclass (iri "http://semanticscience.org/resource/SIO_000350") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to negatively charge is the capability to add an electron or negatively charged ion to a chemical entity." :lang "en")) (label (literal "to negatively charge" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000388") :subclass (iri "http://semanticscience.org/resource/SIO_000494") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to assemble is the capability to combine entities together into a larger object that persists in time." :lang "en")) (label (literal "to assemble" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000389") :subclass (iri "http://semanticscience.org/resource/SIO_000349") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "To extract is the capability to remove certain entities based on selected attribute(s) while allowing other entities to remain." :lang "en")) (label (literal "to extract" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000380") :subclass (iri "http://semanticscience.org/resource/SIO_000392") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "To contain is the capability to bound or constrain a physical entity in some site." :lang "en")) (label (literal "to contain" :lang "en")))

(owl-class (iri "http://semanticscience.org/resource/SIO_000381") :subclass (iri "http://semanticscience.org/resource/SIO_000380") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "To immobilize is the capability to contain an entity in such a way that it may not move in space." :lang "en")) (label (literal "to immobilize" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000377") :subclass (iri "http://semanticscience.org/resource/SIO_000378") :annotation (label (literal "to demagnify" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "To demagnify is the capability to decrease the appearance of the size of an object." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000378") :subclass (iri "http://semanticscience.org/resource/SIO_000343") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to change appearance is the capability to change the visual attributes of an object." :lang "en")) (label (literal "to change appearance" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000375") :subclass (iri "http://semanticscience.org/resource/SIO_000351") :annotation (label (literal "to supply electricity" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "To supply electricity is the capability to transfer electricity from a source to a sink." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000376") :subclass (iri "http://semanticscience.org/resource/SIO_000343") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to change appearance is the capability to change the material composition of an object." :lang "en")) (label (literal "to change materially" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000373") :subclass (iri "http://semanticscience.org/resource/SIO_000346") :annotation (label (literal "to boil" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "To boil is the capability to increase the internal kinetic energy of a material such that it changes state from a solid or liquid to a gas." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000374") :subclass (iri "http://semanticscience.org/resource/SIO_000385") :annotation (label (literal "to reduce energy" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "To reduce energy is the capability to remove energy from a source." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000371") :subclass (iri "http://semanticscience.org/resource/SIO_000408") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "To measure is the capability to obtain information about some entity by examining its attributes in relation to some reference metric." :lang "en")) (label (literal "to measure" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000372") :subclass (iri "http://semanticscience.org/resource/SIO_000343") :annotation (label (literal "to inject" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "To inject is the capability to administer a substance into some object through its external barrier." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000370") :subclass (iri "http://semanticscience.org/resource/SIO_000776") (object-only (iri "http://semanticscience.org/resource/SIO_000028") (iri "http://semanticscience.org/resource/SIO_000370")) :annotation (label (literal "spatial region" :lang "en")) (annotation (iri "http://semanticscience.org/resource/example") (literal "the airspace above Ottawa airport; the band around the northern hemisphere between 50 degrees N and 60 degrees N; the spatial region occupied by a bottle" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a spatial region is an object contained in some region of space." :lang "en")))
(annotation-property (iri "http://semanticscience.org/resource/narrowerThan"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000379") :subclass (iri "http://semanticscience.org/resource/SIO_001055") :annotation (label (literal "perception" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Perception is the organization, identification, and interpretation of sensory information in order to fabricate a mental representation through the process of transduction, which sensors in the body transform signals from the environment into encoded neural signals." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000366") :subclass (iri "http://semanticscience.org/resource/SIO_000075") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A number is a mathematical object used to count, label, and measure." :lang "en")) (label (literal "number" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000367") :subclass (iri "http://semanticscience.org/resource/SIO_000075") :annotation (label (literal "variable" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a variable is a value that may change within the scope of a given problem or set of operations." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000360") :subclass (iri "http://semanticscience.org/resource/SIO_000256") (object-some (iri "http://semanticscience.org/resource/SIO_000338") (object-or (iri "http://semanticscience.org/resource/SIO_000269") (object-some (iri "http://semanticscience.org/resource/SIO_000218") (iri "http://semanticscience.org/resource/SIO_000256")))) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a belief is a proposition that is believed to be true." :lang "en")) (label (literal "belief" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000628") :inverse (iri "http://semanticscience.org/resource/SIO_000212"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000368") :subclass (iri "http://semanticscience.org/resource/SIO_000075") :annotation (label (literal "equation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An equation is a mathematical statement that asserts the equality of two expressions." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000351") :subclass (iri "http://semanticscience.org/resource/SIO_000385") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "To supply energy is the capability to transfer energy from a source to a sink." :lang "en")) (label (literal "to supply energy" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000350") :subclass (iri "http://semanticscience.org/resource/SIO_001087") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "To ionize is the capability to physically convert an atom or molecule into an ion by adding or removing charged particles such as electrons or other ions." :lang "en")) (label (literal "to ionize" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000354") :subclass (iri "http://semanticscience.org/resource/SIO_000112") :disjoint (iri "http://semanticscience.org/resource/SIO_000017") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "dysfunction is a capability to act in a manner that is abnormal or opposite  to the object's typical function." :lang "en")) (label (literal "dysfunction" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000353") :subclass (iri "http://semanticscience.org/resource/SIO_000639") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to observe is the capability to watch attentively." :lang "en")) (label (literal "to observe" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000359") :subclass (iri "http://semanticscience.org/resource/SIO_001053") :annotation (label (literal "purpose" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "purpose is the reason for which something is done or created or for which something exists." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000357") :subclass (iri "http://semanticscience.org/resource/SIO_000026") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "fitness is the quality of an object with respect to some stated functions or evolutionary adaptation." :lang "en")) (label (literal "fitness" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000358") :subclass (iri "http://semanticscience.org/resource/SIO_000825") :annotation (label (literal "intent" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "intent is a desire to realize a particular outcome." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000340") :subclass (iri "http://semanticscience.org/resource/SIO_000614") (object-some (iri "http://semanticscience.org/resource/SIO_000643") (iri "http://semanticscience.org/resource/SIO_000000")) (object-only (iri "http://semanticscience.org/resource/SIO_000668") (iri "http://semanticscience.org/resource/SIO_000000")) :disjoint (iri "http://semanticscience.org/resource/SIO_000005") :annotation (annotation (iri "http://semanticscience.org/resource/subset") (literal "core" :type :RDF_PLAIN_LITERAL)) (label (literal "realizable entity" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A realizable entity is an attribute that is exhibited under some condition and is realized in some process." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000343") :subclass (iri "http://semanticscience.org/resource/SIO_000494") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to modify is the capability to change some entity." :lang "en")) (label (literal "to modify" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000342") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_000275") (object-some (iri "http://semanticscience.org/resource/SIO_000272") (iri "http://semanticscience.org/resource/SIO_000275"))) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a term variant is a term that is a variant of another term." :lang "en")) (label (literal "term variant" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000345") :subclass (iri "http://semanticscience.org/resource/SIO_000378") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "To magnify is the capability to increase the appearance of the size of an object." :lang "en")) (label (literal "to magnify" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000344") :subclass (iri "http://semanticscience.org/resource/SIO_000639") :annotation (annotation (iri "http://www.w3.org/2000/01/rdf-schema#seeAlso") (literal "http://purl.obolibrary.org/obo/OBI_0000368" :type :XSD_ANY_URI)) (annotation (iri "http://purl.org/dc/terms/description") (literal "To record is the capability to detect and transcribe information in a specified format on some physical medium." :lang "en")) (label (literal "to record" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000346") :subclass (iri "http://semanticscience.org/resource/SIO_000351") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "To heat is a capability to increase the internal kinetic energy of a material." :lang "en")) (label (literal "to heat" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000347") :subclass (iri "http://semanticscience.org/resource/SIO_000374") :annotation (annotation (iri "http://www.w3.org/2000/01/rdf-schema#seeAlso") (literal "http://purl.obolibrary.org/obo/OBI_0000387" :type :XSD_ANY_URI)) (annotation (iri "http://purl.org/dc/terms/description") (literal "To cool is the capability to decrease the internal kinetic energy of a material." :lang "en")) (label (literal "to cool" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000348") :subclass (iri "http://semanticscience.org/resource/SIO_000347") :annotation (label (literal "to freeze" :lang "en")) (annotation (iri "http://www.w3.org/2000/01/rdf-schema#seeAlso") (literal "http://purl.obolibrary.org/obo/OBI_0000375" :type :XSD_ANY_URI)) (annotation (iri "http://purl.org/dc/terms/description") (literal "To freeze is the capability to decrease the internal kinetic energy of a material such that it changes state from a gas or liquid to a solid." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000349") :subclass (iri "http://semanticscience.org/resource/SIO_000343") :annotation (label (literal "to separate" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "To separate is the capability to i) distinguish some entities based on some attribute(s) and ii) subsequently physically displace them." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000333") :subclass (iri "http://semanticscience.org/resource/SIO_000072") (object-or (object-exactly 1 (iri "http://semanticscience.org/resource/SIO_000273") (iri "http://semanticscience.org/resource/SIO_000400")) (object-exactly 1 (iri "http://semanticscience.org/resource/SIO_000273") (iri "http://semanticscience.org/resource/SIO_000401")) (object-exactly 1 (iri "http://semanticscience.org/resource/SIO_000273") (iri "http://semanticscience.org/resource/SIO_000402"))) :disjoint (iri "http://semanticscience.org/resource/SIO_000400") (iri "http://semanticscience.org/resource/SIO_000401") (iri "http://semanticscience.org/resource/SIO_000402") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a 3D cartesian coordinate is a coordinate that is composed of an x,y and z coordinate." :lang "en")) (label (literal "3D cartesian coordinate" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000331") :subclass (iri "http://semanticscience.org/resource/SIO_000129") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an OWL ontology is an ontology as specified by the W3C OWL specification." :lang "en")) (label (literal "OWL ontology" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000330") :subclass (iri "http://semanticscience.org/resource/SIO_000320") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a spherical coordinate system is a coordinate system for three-dimensional space where the position of a point is specified by three numbers: the radial distance of that point from a fixed origin, its polar angle measured from a fixed zenith direction, and the azimuth angle of its orthogonal projection on a reference plane that passes through the origin and is orthogonal to the zenith, measured from a fixed reference direction on that plane." :lang "en")) (label (literal "spherical coordinate system" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000337") :subclass (iri "http://semanticscience.org/resource/SIO_000256") (object-only (iri "http://semanticscience.org/resource/SIO_000339") (iri "http://semanticscience.org/resource/SIO_000091")) (object-only (iri "http://semanticscience.org/resource/SIO_000356") (iri "http://semanticscience.org/resource/SIO_000006")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an objective is a proposition that indicates a planned or anticipated outcome." :lang "en")) (label (literal "objective" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000321") :subclass (iri "http://semanticscience.org/resource/SIO_000320") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A Cartesian coordinate system specifies each point uniquely in a plane by a pair of numerical coordinates, which are the signed distances from the point to two fixed perpendicular directed lines, measured in the same unit of length." :lang "en")) (label (literal "cartesian coordinate system" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000320") :subclass (iri "http://semanticscience.org/resource/SIO_000317") :annotation (label (literal "coordinate system" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A coordinate system is a specification for spatial location that uses a set of numbers, or coordinates, to uniquely determine the position of a point or other geometric element." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000328") :subclass (iri "http://semanticscience.org/resource/SIO_000115") (object-some (iri "http://semanticscience.org/resource/SIO_000011") (iri "http://semanticscience.org/resource/SIO_000056")) :annotation (label (literal "positional identifier" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a positional description is a description of location using some system or frame of reference." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001095") :subclass (iri "http://semanticscience.org/resource/SIO_000537") :disjoint (iri "http://semanticscience.org/resource/SIO_000538") (iri "http://semanticscience.org/resource/SIO_001094") :annotation (label (literal "curved" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "curved is the quality of a line that deviates from straightness in a smooth, continuous fashion." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000329") :subclass (iri "http://semanticscience.org/resource/SIO_000320") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A cylindrical coordinate system is a three-dimensional coordinate system that specifies point positions by the distance from a chosen reference axis, the direction from the axis relative to a chosen reference direction, and the distance from a chosen reference plane perpendicular to the axis." :lang "en")) (label (literal "cylindrical coordinate system" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001093") :subclass (iri "http://semanticscience.org/resource/SIO_001092") :disjoint (iri "http://semanticscience.org/resource/SIO_000758") :annotation (label (literal "rigid" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "rigid is the quality of maintaining structural integrity (and not bending) under pressure." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001094") :subclass (iri "http://semanticscience.org/resource/SIO_000537") :disjoint (iri "http://semanticscience.org/resource/SIO_000538") (iri "http://semanticscience.org/resource/SIO_001095") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "bent is the quality of a line being sharply curved or having an angle." :lang "en")) (label (literal "bent" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001091") :subclass (iri "http://semanticscience.org/resource/SIO_000051") :disjoint (iri "http://semanticscience.org/resource/SIO_001090") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "homogeneous is a quality that describes the varied composition of an object." :lang "en")) (label (literal "heterogeneous" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001092") :subclass (iri "http://semanticscience.org/resource/SIO_000026") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a structural quality is a quality of an object that describes its structure." :lang "en")) (label (literal "structural quality" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000326") :subclass (iri "http://semanticscience.org/resource/SIO_000275") :annotation (label (literal "concept" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A concept is term that refers to a generalization of a set of attributes or entities." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000327") :subclass (iri "http://semanticscience.org/resource/SIO_000320") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a polar coordinate system is a two-dimensional coordinate system in which each point on a plane is determined by a distance from a fixed point and an angle from a fixed direction." :lang "en")) (label (literal "polar coordinate system" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001090") :subclass (iri "http://semanticscience.org/resource/SIO_000051") :disjoint (iri "http://semanticscience.org/resource/SIO_001091") :annotation (label (literal "homogeneous" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "homogeneous is a quality that describes the uniform composition of an object." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001099") :subclass (iri "http://semanticscience.org/resource/SIO_000625") :annotation (label (literal "electronic structure" :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "electronic configuration" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://semanticscience.org/resource/example") (literal "the electron configuration of the neon atom is 1s2 2s2 2p6." :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "electronic structure is the electron configuration is the distribution of electrons of an atom or molecule (or other physical structure) in atomic or molecular orbitals." :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000679") :range (iri "http://semanticscience.org/resource/SIO_000418") :inverse (iri "http://semanticscience.org/resource/SIO_000029") :characteristic :functional)
(object-property (iri "http://semanticscience.org/resource/SIO_000291") :inverse (iri "http://semanticscience.org/resource/SIO_000292"))
(object-property (iri "http://semanticscience.org/resource/SIO_000293") :domain (object-or (iri "http://semanticscience.org/resource/SIO_011125") (object-some (iri "http://semanticscience.org/resource/SIO_000068") (iri "http://semanticscience.org/resource/SIO_011125"))) :range (object-or (iri "http://semanticscience.org/resource/SIO_011125") (object-some (iri "http://semanticscience.org/resource/SIO_000068") (iri "http://semanticscience.org/resource/SIO_011125"))) :characteristic :transitive :symmetric)
(object-property (iri "http://semanticscience.org/resource/SIO_000292") :inverse (iri "http://semanticscience.org/resource/SIO_000291"))
(object-property (iri "http://semanticscience.org/resource/SIO_000671") :range (iri "http://semanticscience.org/resource/SIO_000115") :inverse (iri "http://semanticscience.org/resource/SIO_000672"))
(object-property (iri "http://semanticscience.org/resource/SIO_000673") :range (iri "http://semanticscience.org/resource/SIO_000675") :inverse (iri "http://semanticscience.org/resource/SIO_000674") :characteristic :inversefunctional)
(object-property (iri "http://semanticscience.org/resource/SIO_000672") :domain (iri "http://semanticscience.org/resource/SIO_000115") :inverse (iri "http://semanticscience.org/resource/SIO_000671"))
(object-property (iri "http://semanticscience.org/resource/SIO_000674") :domain (iri "http://semanticscience.org/resource/SIO_000675") :inverse (iri "http://semanticscience.org/resource/SIO_000673") :characteristic :functional)
(object-property (iri "http://semanticscience.org/resource/SIO_000294") :inverse (iri "http://semanticscience.org/resource/SIO_000352"))
(object-property (iri "http://semanticscience.org/resource/SIO_000687") :range (iri "http://semanticscience.org/resource/SIO_000391"))
(object-property (iri "http://semanticscience.org/resource/SIO_000682") :domain (iri "http://semanticscience.org/resource/SIO_000418") :inverse (iri "http://semanticscience.org/resource/SIO_000680"))
(object-property (iri "http://semanticscience.org/resource/SIO_000681") :range (iri "http://semanticscience.org/resource/SIO_000418") :inverse (iri "http://semanticscience.org/resource/SIO_000684") :characteristic :functional)
(object-property (iri "http://semanticscience.org/resource/SIO_000680") :range (iri "http://semanticscience.org/resource/SIO_000418") :inverse (iri "http://semanticscience.org/resource/SIO_000682") :characteristic :functional)
(object-property (iri "http://semanticscience.org/resource/SIO_000684") :domain (iri "http://semanticscience.org/resource/SIO_000418") :inverse (iri "http://semanticscience.org/resource/SIO_000681"))
(annotation-property (iri "http://semanticscience.org/resource/equivalentTo"))
(object-property (iri "http://semanticscience.org/resource/SIO_000699") :inverse (iri "http://semanticscience.org/resource/SIO_000733"))
(object-property (iri "http://semanticscience.org/resource/SIO_000697") :characteristic :symmetric)
(object-property (iri "http://semanticscience.org/resource/SIO_000277") :inverse (iri "http://semanticscience.org/resource/SIO_000278"))
(object-property (iri "http://semanticscience.org/resource/SIO_000278") :inverse (iri "http://semanticscience.org/resource/SIO_000277"))
(object-property (iri "http://semanticscience.org/resource/SIO_000272") :characteristic :transitive :symmetric)
(object-property (iri "http://semanticscience.org/resource/SIO_000273") :inverse (iri "http://semanticscience.org/resource/SIO_000310"))
(object-property (iri "http://semanticscience.org/resource/SIO_000274") :inverse (iri "http://semanticscience.org/resource/SIO_000286"))
(object-property (iri "http://semanticscience.org/resource/SIO_000288") :domain (iri "http://semanticscience.org/resource/SIO_010044") :range (iri "http://semanticscience.org/resource/SIO_010044") :characteristic :transitive :symmetric)
(object-property (iri "http://semanticscience.org/resource/SIO_000286") :inverse (iri "http://semanticscience.org/resource/SIO_000274"))
(object-property (iri "http://semanticscience.org/resource/SIO_000283") :characteristic :symmetric)
(object-property (iri "http://semanticscience.org/resource/SIO_000630") :characteristic :symmetric)
(object-property (iri "http://semanticscience.org/resource/SIO_000631") :inverse (iri "http://semanticscience.org/resource/SIO_000252"))
(object-property (iri "http://semanticscience.org/resource/SIO_000632") :inverse (iri "http://semanticscience.org/resource/SIO_000633"))
(object-property (iri "http://semanticscience.org/resource/SIO_000633") :inverse (iri "http://semanticscience.org/resource/SIO_000632"))
(object-property (iri "http://semanticscience.org/resource/SIO_000634") :characteristic :symmetric)
(object-property (iri "http://semanticscience.org/resource/SIO_000635") :inverse (iri "http://semanticscience.org/resource/SIO_000636"))
(object-property (iri "http://semanticscience.org/resource/SIO_000636") :inverse (iri "http://semanticscience.org/resource/SIO_000635"))
(object-property (iri "http://semanticscience.org/resource/SIO_000251") :inverse (iri "http://semanticscience.org/resource/SIO_000250"))
(object-property (iri "http://semanticscience.org/resource/SIO_000250") :inverse (iri "http://semanticscience.org/resource/SIO_000251"))
(object-property (iri "http://semanticscience.org/resource/SIO_000629") :inverse (iri "http://semanticscience.org/resource/SIO_000332"))
(object-property (iri "http://semanticscience.org/resource/SIO_000253") :inverse (iri "http://semanticscience.org/resource/SIO_000219"))
(object-property (iri "http://semanticscience.org/resource/SIO_000252") :inverse (iri "http://semanticscience.org/resource/SIO_000631"))
(object-property (iri "http://semanticscience.org/resource/SIO_000255") :range (iri "http://semanticscience.org/resource/SIO_000078") :inverse (iri "http://semanticscience.org/resource/SIO_000254"))
(object-property (iri "http://semanticscience.org/resource/SIO_000254") :domain (iri "http://semanticscience.org/resource/SIO_000078") :inverse (iri "http://semanticscience.org/resource/SIO_000255"))
(object-property (iri "http://semanticscience.org/resource/SIO_000641") :domain (iri "http://semanticscience.org/resource/SIO_000340") :range (iri "http://semanticscience.org/resource/SIO_000005") :inverse (iri "http://semanticscience.org/resource/SIO_000642"))
(object-property (iri "http://semanticscience.org/resource/SIO_000642") :domain (iri "http://semanticscience.org/resource/SIO_000005") :range (iri "http://semanticscience.org/resource/SIO_000340") :inverse (iri "http://semanticscience.org/resource/SIO_000641"))
(object-property (iri "http://semanticscience.org/resource/SIO_000646") :domain (iri "http://semanticscience.org/resource/SIO_000112") :inverse (iri "http://semanticscience.org/resource/SIO_000586") :characteristic :functional)
(object-property (iri "http://semanticscience.org/resource/SIO_000643") :inverse (iri "http://semanticscience.org/resource/SIO_000644") :characteristic :functional)
(object-property (iri "http://semanticscience.org/resource/SIO_000644") :inverse (iri "http://semanticscience.org/resource/SIO_000643") :characteristic :inversefunctional)
(owl-class (iri "http://semanticscience.org/resource/SIO_010383") :subclass (iri "http://semanticscience.org/resource/SIO_000619") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A drug regulatory authority is a regulatory authority which acts to control what substances may be used to treat individuals." :lang "en")) (label (literal "drug regulatory authority" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000652") :characteristic :symmetric)
(owl-class (iri "http://semanticscience.org/resource/SIO_010379") :subclass (iri "http://semanticscience.org/resource/SIO_010378") :annotation (label (literal "virus" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A virus is a non-cellular organism that can replicate only inside the living cells of an organism." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010378") :subclass (iri "http://semanticscience.org/resource/SIO_010000") :disjoint (iri "http://semanticscience.org/resource/SIO_010377") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a non-cellular organism is an organism that does not contain a cell." :lang "en")) (label (literal "non-cellular organism" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000658") :inverse (iri "http://semanticscience.org/resource/SIO_000656"))
(object-property (iri "http://semanticscience.org/resource/SIO_000655") :inverse (iri "http://semanticscience.org/resource/SIO_000657") :characteristic :transitive)
(object-property (iri "http://semanticscience.org/resource/SIO_000656") :inverse (iri "http://semanticscience.org/resource/SIO_000658"))
(object-property (iri "http://semanticscience.org/resource/SIO_000657") :inverse (iri "http://semanticscience.org/resource/SIO_000655") :characteristic :transitive)
(object-property (iri "http://semanticscience.org/resource/SIO_000233") :inverse (iri "http://semanticscience.org/resource/SIO_000234"))
(object-property (iri "http://semanticscience.org/resource/SIO_000232") :inverse (iri "http://semanticscience.org/resource/SIO_000229"))
(object-property (iri "http://semanticscience.org/resource/SIO_000235") :range (iri "http://semanticscience.org/resource/SIO_000014") :inverse (iri "http://semanticscience.org/resource/SIO_000236") :characteristic :inversefunctional)
(object-property (iri "http://semanticscience.org/resource/SIO_000234") :inverse (iri "http://semanticscience.org/resource/SIO_000233"))
(object-property (iri "http://semanticscience.org/resource/SIO_000231") :inverse (iri "http://semanticscience.org/resource/SIO_000230"))
(object-property (iri "http://semanticscience.org/resource/SIO_000230") :inverse (iri "http://semanticscience.org/resource/SIO_000231"))
(owl-class (iri "http://semanticscience.org/resource/SIO_010376") :subclass (iri "http://semanticscience.org/resource/SIO_010001") (iri "http://semanticscience.org/resource/SIO_010377") (object-not (object-some (iri "http://semanticscience.org/resource/SIO_000093") (iri "http://semanticscience.org/resource/SIO_010046"))) :disjoint (iri "http://semanticscience.org/resource/SIO_010375") :annotation (label (literal "unicellular organism" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a unicellular organism is a organism that is composed of a single cell." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010377") :subclass (iri "http://semanticscience.org/resource/SIO_010000") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_010375") (iri "http://semanticscience.org/resource/SIO_010376")) :disjoint (iri "http://semanticscience.org/resource/SIO_010378") :annotation (label (literal "cellular organism" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a cellular organism is an organism that contains one or more cells." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010374") :subclass (iri "http://semanticscience.org/resource/SIO_010364") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to be conformationally changed is the capability to be modified in such a way that the object's conformation is changed." :lang "en")) (label (literal "to be conformationally changed" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010375") :subclass (iri "http://semanticscience.org/resource/SIO_010377") (object-at-least 2 (iri "http://semanticscience.org/resource/SIO_000053") (iri "http://semanticscience.org/resource/SIO_010001")) :disjoint (iri "http://semanticscience.org/resource/SIO_010376") :annotation (label (literal "multicellular organism" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a multi-cellular organism is an organism that consists of more than one cell." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010372") :subclass (iri "http://semanticscience.org/resource/SIO_010374") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to be activated is the capability to be modified in such a way that the conformational change leads to an increase in another capability." :lang "en")) (label (literal "to be activated" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000236") :domain (iri "http://semanticscience.org/resource/SIO_000014") :inverse (iri "http://semanticscience.org/resource/SIO_000235") :characteristic :functional)
(owl-class (iri "http://semanticscience.org/resource/SIO_010373") :subclass (iri "http://semanticscience.org/resource/SIO_010374") :annotation (label (literal "to be inhibited" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to be inhibited is the capability to be modified in such a way that the conformational change leads to an decrease in another capability." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010370") :subclass (iri "http://semanticscience.org/resource/SIO_010369") :annotation (label (literal "to gain an electron" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to gain an electron is the capability of a chemical entity to receive an electron." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010371") :subclass (iri "http://semanticscience.org/resource/SIO_010369") :annotation (label (literal "to lose an electron" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to lose an electron is the capability of a chemical entity to lose an electron." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010368") :subclass (iri "http://semanticscience.org/resource/SIO_000692") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to be transported is the disposition to undergo motion." :lang "en")) (label (literal "to be transported" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010367") :subclass (iri "http://semanticscience.org/resource/SIO_010364") :annotation (label (literal "to be combined" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to be combined is the capability to be modified in a way that the object is merged with another object to form a new object or substance." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010369") :subclass (iri "http://semanticscience.org/resource/SIO_010364") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to be electronically modified is the capability of a chemical entity to have electrons added or removed" :lang "en")) (label (literal "to be electronically modified" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000668") :inverse (iri "http://semanticscience.org/resource/SIO_000892"))
(object-property (iri "http://semanticscience.org/resource/SIO_000246") :inverse (iri "http://semanticscience.org/resource/SIO_000247"))
(object-property (iri "http://semanticscience.org/resource/SIO_000245") :domain (iri "http://semanticscience.org/resource/SIO_000776") :range (iri "http://semanticscience.org/resource/SIO_000776") :inverse (iri "http://semanticscience.org/resource/SIO_000244") :characteristic :transitive)
(object-property (iri "http://semanticscience.org/resource/SIO_000244") :inverse (iri "http://semanticscience.org/resource/SIO_000245") :characteristic :transitive)
(object-property (iri "http://semanticscience.org/resource/SIO_000243") :characteristic :transitive :symmetric)
(object-property (iri "http://semanticscience.org/resource/SIO_000242") :inverse (iri "http://semanticscience.org/resource/SIO_000241") :characteristic :functional)
(object-property (iri "http://semanticscience.org/resource/SIO_000241") :inverse (iri "http://semanticscience.org/resource/SIO_000242") :characteristic :functional)
(object-property (iri "http://semanticscience.org/resource/SIO_000240") :inverse (iri "http://semanticscience.org/resource/SIO_000211") :characteristic :transitive)
(owl-class (iri "http://semanticscience.org/resource/SIO_010363") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_011125") (object-some (iri "http://semanticscience.org/resource/SIO_000232") (iri "http://semanticscience.org/resource/SIO_010345")) (object-some (iri "http://semanticscience.org/resource/SIO_000244") (iri "http://semanticscience.org/resource/SIO_010362"))) :annotation (label (literal "product" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010364") :subclass (iri "http://semanticscience.org/resource/SIO_000692") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to be modified is the capability to be actively interacted with in such a way that it leads to a physical reconfiguration." :lang "en")) (label (literal "to be modified" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010365") :subclass (iri "http://semanticscience.org/resource/SIO_010364") :annotation (label (literal "to be cleaved" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to be cleaved is the capability to be modified in a way that splits one part of the object from the other." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010366") :subclass (iri "http://semanticscience.org/resource/SIO_010364") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to be covalently modified is the capability of a chemical entity to have bonds added or removed" :lang "en")) (label (literal "to be covalently modified" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000249") :inverse (iri "http://semanticscience.org/resource/SIO_000248") :characteristic :transitive)
(owl-class (iri "http://semanticscience.org/resource/SIO_010360") :subclass (iri "http://semanticscience.org/resource/SIO_001087") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to modify the oxidation state of is to change the number of electrons of a molecule, atom or ion." :lang "en")) (label (literal "to modify oxidation state of" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000248") :inverse (iri "http://semanticscience.org/resource/SIO_000249") :characteristic :transitive)
(object-property (iri "http://semanticscience.org/resource/SIO_000247") :inverse (iri "http://semanticscience.org/resource/SIO_000246"))
(owl-class (iri "http://semanticscience.org/resource/SIO_010362") :subclass (iri "http://semanticscience.org/resource/SIO_010423") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_011125") (object-some (iri "http://semanticscience.org/resource/SIO_000245") (iri "http://semanticscience.org/resource/SIO_010363")) (object-some (iri "http://semanticscience.org/resource/SIO_000292") (iri "http://semanticscience.org/resource/SIO_010345"))) :annotation (label (literal "substrate" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a substrate is a molecule that is consumed in the course of a biochemical reaction." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010344") :subclass (iri "http://semanticscience.org/resource/SIO_011125") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a catalyst is a molecule that has the capability to reduce the activation energy of a reaction and hence increase the overall rate of reaction." :lang "en")) (label (literal "catalyst" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000229") :inverse (iri "http://semanticscience.org/resource/SIO_000232"))
(owl-class (iri "http://semanticscience.org/resource/SIO_010343") :subclass (iri "http://semanticscience.org/resource/SIO_010344") (object-or (iri "http://semanticscience.org/resource/SIO_010043") (iri "http://semanticscience.org/resource/SIO_010497")) :equivalent (object-or (object-or (iri "http://semanticscience.org/resource/SIO_010043") (iri "http://semanticscience.org/resource/SIO_010497")) (object-some (iri "http://semanticscience.org/resource/SIO_000225") (object-or (iri "http://semanticscience.org/resource/SIO_010340") (object-some (iri "http://semanticscience.org/resource/SIO_000356") (iri "http://semanticscience.org/resource/SIO_010345")) (object-some (iri "http://semanticscience.org/resource/SIO_000668") (iri "http://semanticscience.org/resource/SIO_010004"))))) :annotation (label (literal "enzyme" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an enzyme is a protein or protein complex that realizes its disposition to covalently modify some molecule during a chemical reaction." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010342") :subclass (iri "http://semanticscience.org/resource/SIO_011126") (object-some (iri "http://semanticscience.org/resource/SIO_000028") (object-some (iri "http://semanticscience.org/resource/SIO_000335") (iri "http://semanticscience.org/resource/SIO_000004"))) :disjoint (iri "http://semanticscience.org/resource/SIO_010020") (iri "http://semanticscience.org/resource/SIO_010341") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a chemical complex is a chemical entity composed of a weakly connected ions or molecules." :lang "en")) (label (literal "chemical complex" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010341") :subclass (iri "http://semanticscience.org/resource/SIO_010004") (object-some (iri "http://semanticscience.org/resource/SIO_000028") (object-or (iri "http://semanticscience.org/resource/SIO_010044") (object-some (iri "http://semanticscience.org/resource/SIO_000334") (iri "http://semanticscience.org/resource/SIO_010044")))) (object-some (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_011118")) :disjoint (iri "http://semanticscience.org/resource/SIO_010020") (iri "http://semanticscience.org/resource/SIO_010342") :annotation (label (literal "covalently connected entity" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A covalently connected molecular entity is the mereological sum of a collection of covalently bonded atoms." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010340") :subclass (iri "http://semanticscience.org/resource/SIO_000376") :annotation (label (literal "to covalently modify" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to covalently modify is to materially change a molecule by adding or removing covalent bonds between atoms." :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000225") :range (iri "http://semanticscience.org/resource/SIO_000017") :inverse (iri "http://semanticscience.org/resource/SIO_000226") :characteristic :inversefunctional)
(object-property (iri "http://semanticscience.org/resource/SIO_000226") :domain (iri "http://semanticscience.org/resource/SIO_000017") :inverse (iri "http://semanticscience.org/resource/SIO_000225") :characteristic :functional)
(object-property (iri "http://semanticscience.org/resource/SIO_000227") :domain (iri "http://semanticscience.org/resource/SIO_000016") :inverse (iri "http://semanticscience.org/resource/SIO_000228") :characteristic :functional)
(object-property (iri "http://semanticscience.org/resource/SIO_000228") :range (iri "http://semanticscience.org/resource/SIO_000016") :inverse (iri "http://semanticscience.org/resource/SIO_000227") :characteristic :inversefunctional)
(object-property (iri "http://semanticscience.org/resource/SIO_000221") :range (iri "http://semanticscience.org/resource/SIO_000074") :inverse (iri "http://semanticscience.org/resource/SIO_000222") :characteristic :functional)
(object-property (iri "http://semanticscience.org/resource/SIO_000222") :domain (iri "http://semanticscience.org/resource/SIO_000074") :inverse (iri "http://semanticscience.org/resource/SIO_000221"))
(object-property (iri "http://semanticscience.org/resource/SIO_000223") :inverse (iri "http://semanticscience.org/resource/SIO_000224") :characteristic :inversefunctional)
(object-property (iri "http://semanticscience.org/resource/SIO_000224") :inverse (iri "http://semanticscience.org/resource/SIO_000223") :characteristic :functional)
(owl-class (iri "http://semanticscience.org/resource/SIO_001118") :subclass (iri "http://semanticscience.org/resource/SIO_000150") (object-some (iri "http://semanticscience.org/resource/SIO_000059") (object-or (iri "http://semanticscience.org/resource/SIO_000000") (object-some (iri "http://semanticscience.org/resource/SIO_000008") (iri "http://semanticscience.org/resource/SIO_000613")) (object-some (iri "http://semanticscience.org/resource/SIO_000628") (iri "http://semanticscience.org/resource/SIO_000000")))) :annotation (label (literal "sequence" :lang "en")) (annotation (iri "http://semanticscience.org/resource/example") (literal "For example, (M, A, R, Y) is a sequence of letters that differs from (A, R, M, Y), as the ordering matters, and (1, 1, 2, 3, 5, 8), which contains the number 1 at two different positions, is a valid sequence. " :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a sequence is an ordered list of entities. Like a set, it contains members (also called elements, or terms)." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000797") :subclass (iri "http://semanticscience.org/resource/SIO_000879") :annotation (label (literal "substrate role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "the role of a chemical entity that is modified in a chemical reaction" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001119") :subclass (iri "http://semanticscience.org/resource/SIO_001122") :annotation (label (literal "gene-disease association linked with causal mutation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a gene-variant disease association in which a mutation in the gene/protein results in the development or maintenance of the disease." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000798") :subclass (iri "http://semanticscience.org/resource/SIO_000889") (object-some (iri "http://semanticscience.org/resource/SIO_000227") (iri "http://semanticscience.org/resource/SIO_010363")) :annotation (label (literal "product role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "the role of a chemical entity present at the end of a chemical reaction." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001116") :subclass (iri "http://semanticscience.org/resource/SIO_000150") :disjoint (iri "http://semanticscience.org/resource/SIO_001117") :annotation (label (literal "union" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a union is a list of all of the values of an attribute for the entities in the defined set." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000799") :subclass (iri "http://semanticscience.org/resource/SIO_000889") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "the role of a chemical entity involved in the mechanism for enzyme-mediated catalysis." :lang "en")) (label (literal "cofactor role" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001117") :subclass (iri "http://semanticscience.org/resource/SIO_000150") :disjoint (iri "http://semanticscience.org/resource/SIO_001116") :annotation (label (literal "intersection" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an intersection is a list of only the values of an attribute for the entities in the defined set where all entities have that value." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001115") :subclass (iri "http://semanticscience.org/resource/SIO_000794") :annotation (label (literal "member count" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a count of the instances of a class or members in a collection." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000067") :subclass (iri "http://semanticscience.org/resource/SIO_000602") (object-only (iri "http://semanticscience.org/resource/SIO_000059") (iri "http://semanticscience.org/resource/SIO_000115")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A namespace is an informational entity that defines a logical container for a set of symbols or identifiers." :lang "en")) (label (literal "namespace" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000794") :subclass (iri "http://semanticscience.org/resource/SIO_000257") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "The number of elements of a finite set of objects." :lang "en")) (label (literal "count" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001114") :subclass (iri "http://semanticscience.org/resource/SIO_000052") (object-some (iri "http://semanticscience.org/resource/SIO_000011") (iri "http://semanticscience.org/resource/SIO_000616")) :annotation (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "max" :type :RDF_PLAIN_LITERAL)) (label (literal "maximal value" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a maximal value is largest value of an attribute for the entities in the defined set." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001113") :subclass (iri "http://semanticscience.org/resource/SIO_000052") (object-some (iri "http://semanticscience.org/resource/SIO_000011") (iri "http://semanticscience.org/resource/SIO_000616")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a minimal value is smallest value of an attribute for the entities in the defined set." :lang "en")) (label (literal "minimal value" :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "min" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000069") :subclass (iri "http://semanticscience.org/resource/SIO_000602") (object-some (iri "http://semanticscience.org/resource/SIO_000062") (object-or (iri "http://semanticscience.org/resource/SIO_000006") (object-some (iri "http://semanticscience.org/resource/SIO_000355") (iri "http://semanticscience.org/resource/SIO_000337")))) :annotation (label (literal "data item" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a data item consists of information that has been collected/generated towards some purpose." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000796") :subclass (iri "http://semanticscience.org/resource/SIO_000880") :annotation (label (literal "catalytic role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "the role of a chemical participant that serves to increase the rate of reaction by lowering the activiation energy." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001112") :subclass (iri "http://semanticscience.org/resource/SIO_000052") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a sum is the result of adding a set of values together." :lang "en")) (label (literal "sum" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000795") :subclass (iri "http://semanticscience.org/resource/SIO_000677") (object-some (iri "http://semanticscience.org/resource/SIO_000227") (iri "http://semanticscience.org/resource/SIO_010004")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a chemical role is a processual role held by a chemical entity" :lang "en")) (label (literal "chemical entity role" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001111") :subclass (iri "http://semanticscience.org/resource/SIO_001108") :annotation (label (literal "mode" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a mode is the value that appears most often in a set of data." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000790") :subclass (iri "http://semanticscience.org/resource/SIO_010035") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a non-protein coding RNA (ncRNA) gene is a gene that encodes for a RNA transcript that is not further translated into a protein product." :lang "en")) (label (literal "non-protein coding RNA (ncRNA) gene" :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "ncRNA gene" :lang "en")) (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "http://purl.obolibrary.org/obo/SO_0001263" :type :XSD_ANY_URI)))
(owl-class (iri "http://semanticscience.org/resource/SIO_001110") :subclass (iri "http://semanticscience.org/resource/SIO_001108") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a median is the numerical value separating the higher half of a sample, a population, or a probability distribution, from the lower half. " :lang "en")) (label (literal "median" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000792") :subclass (iri "http://semanticscience.org/resource/SIO_000789") (iri "http://semanticscience.org/resource/SIO_000953") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a sequence end position is the position of the last character in a sequence of characters relative to some linear frame of reference." :lang "en")) (label (literal "sequence end position" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000791") :subclass (iri "http://semanticscience.org/resource/SIO_000789") (iri "http://semanticscience.org/resource/SIO_000943") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a sequence start position is the start position for a sequence of characters." :lang "en")) (label (literal "sequence start position" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010349") :subclass (iri "http://semanticscience.org/resource/SIO_000698") :annotation (label (literal "to cleave" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to cleave is to split or sever an object along a natural line or grain." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010347") :subclass (iri "http://semanticscience.org/resource/SIO_000343") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to modify conformation of is to affect the spatial arrangement of an entity." :lang "en")) (label (literal "to modify conformation of" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010345") :subclass (iri "http://semanticscience.org/resource/SIO_010013") (object-or (object-some (iri "http://semanticscience.org/resource/SIO_000053") (iri "http://semanticscience.org/resource/SIO_000559")) (object-some (iri "http://semanticscience.org/resource/SIO_000053") (iri "http://semanticscience.org/resource/SIO_000592"))) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A chemical reaction is a process that leads to the transformation of one set of chemical substances to another." :lang "en")) (label (literal "chemical reaction" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010346") :subclass (iri "http://semanticscience.org/resource/SIO_010072") (object-some (iri "http://semanticscience.org/resource/SIO_000273") (iri "http://semanticscience.org/resource/SIO_010071")) :disjoint (iri "http://semanticscience.org/resource/SIO_010011") (iri "http://semanticscience.org/resource/SIO_010030") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an organic polymer is an organic molecule composed of connected set of monomeric units." :lang "en")) (label (literal "organic polymer" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010353") :subclass (iri "http://semanticscience.org/resource/SIO_000494") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to breathe is the capability to inhale and exhale air into the body during respiration." :lang "en")) (label (literal "to breathe" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010355") :subclass (iri "http://semanticscience.org/resource/SIO_010347") :annotation (label (literal "to conformationally inhibit" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to conformationally inhibit is to modify the conformation of an entity in such a way that it functionally is reduced or inhibited." :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000218") :domain (iri "http://semanticscience.org/resource/SIO_000005") :inverse (iri "http://semanticscience.org/resource/SIO_000217"))
(owl-class (iri "http://semanticscience.org/resource/SIO_010354") :subclass (iri "http://semanticscience.org/resource/SIO_010347") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to conformationally activate is to modify the conformation of an entity in such a way that it becomes activated or functional." :lang "en")) (label (literal "to conformationally activate" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000219") :inverse (iri "http://semanticscience.org/resource/SIO_000253"))
(object-property (iri "http://semanticscience.org/resource/SIO_000216") :range (iri "http://semanticscience.org/resource/SIO_000070") :inverse (iri "http://semanticscience.org/resource/SIO_000215"))
(object-property (iri "http://semanticscience.org/resource/SIO_000217") :range (iri "http://semanticscience.org/resource/SIO_000005") :inverse (iri "http://semanticscience.org/resource/SIO_000218") :characteristic :inversefunctional)
(owl-class (iri "http://semanticscience.org/resource/SIO_010351") :subclass (iri "http://semanticscience.org/resource/SIO_000376") :annotation (label (literal "to combine" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to combine is the capability to modify a set of objects in a way that the object is merged with another object to form a new object or substance." :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000214") :inverse (iri "http://semanticscience.org/resource/SIO_000213"))
(object-property (iri "http://semanticscience.org/resource/SIO_000215") :domain (iri "http://semanticscience.org/resource/SIO_000070") :inverse (iri "http://semanticscience.org/resource/SIO_000216"))
(object-property (iri "http://semanticscience.org/resource/SIO_000212") :inverse (iri "http://semanticscience.org/resource/SIO_000628"))
(object-property (iri "http://semanticscience.org/resource/SIO_000213") :inverse (iri "http://semanticscience.org/resource/SIO_000214"))
(object-property (iri "http://semanticscience.org/resource/SIO_000210") :inverse (iri "http://semanticscience.org/resource/SIO_000205"))
(object-property (iri "http://semanticscience.org/resource/SIO_000211") :inverse (iri "http://semanticscience.org/resource/SIO_000240") :characteristic :transitive)
(owl-class (iri "http://semanticscience.org/resource/SIO_001127") :subclass (iri "http://semanticscience.org/resource/SIO_001145") :annotation (label (literal "regulation of molecular quantity" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A process that modulates the frequency, rate or extent of process involved in the creation or destruction of a molecule." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000788") :subclass (iri "http://semanticscience.org/resource/SIO_000056") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a linear position is the position of some object against a linear positioning system." :lang "en")) (label (literal "linear position" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001128") :subclass (iri "http://semanticscience.org/resource/SIO_001127") :annotation (label (literal "regulation of molecular production" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A process that modulates the frequency, rate or extent of process involved in the production of a molecule." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000789") :subclass (iri "http://semanticscience.org/resource/SIO_000788") :annotation (label (literal "sequence element position" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a sequence element position is the position of an element of a linear sequence." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001129") :subclass (iri "http://semanticscience.org/resource/SIO_001127") (object-some (iri "http://semanticscience.org/resource/SIO_001154") (iri "http://semanticscience.org/resource/SIO_000592")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A process that modulates the frequency, rate or extent of process involved in the destruction of a molecule." :lang "en")) (label (literal "regulation of molecular degradation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000786") :subclass (iri "http://semanticscience.org/resource/SIO_000078") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a verbal language entity is a language entity that is manifested through sound." :lang "en")) (label (literal "verbal language entity" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000787") :subclass (iri "http://semanticscience.org/resource/SIO_000794") :annotation (label (literal "page number" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a page number is the count of a page in a sequence of pages." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001124") :subclass (iri "http://semanticscience.org/resource/SIO_001121") :annotation (label (literal "gene-disease association linked with post-translational modification" :lang "en")) (annotation (iri "http://semanticscience.org/resource/example") (literal "methylation or phosphorylation of protein product" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a gene-disease association in which the disease phenotype is associated with post-translational modifications in the protein product." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000785") :subclass (iri "http://semanticscience.org/resource/SIO_000136") :annotation (label (literal "answer" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an answer is a reply to a question." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001123") :subclass (iri "http://semanticscience.org/resource/SIO_001121") :annotation (label (literal "gene-disease association linked with altered gene expression" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a gene-disease association in which the disease phenotype is associated with an altered expression of the gene." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000784") :subclass (iri "http://semanticscience.org/resource/SIO_010029") :disjoint (iri "http://semanticscience.org/resource/SIO_010048") (iri "http://semanticscience.org/resource/SIO_010052") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "hermaphrodite is a biological sex of an individual with both male and female sexual organs." :lang "en")) (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "PATO:0001827" :type :RDF_PLAIN_LITERAL)) (label (literal "hermaphrodite" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001126") :subclass (iri "http://semanticscience.org/resource/SIO_010287") :annotation (label (literal "regulation of translation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A process that modulates the frequency, rate or extent of translation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000078") :subclass (iri "http://semanticscience.org/resource/SIO_000015") (data-some (iri "http://semanticscience.org/resource/SIO_000300") :RDFS_LITERAL) :annotation (annotation (iri "http://semanticscience.org/resource/subset") (literal "nlp+" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "A language entity implements some language specification for the visual interpretation and is part of some document." :lang "en")) (label (literal "language entity" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000783") :subclass (iri "http://semanticscience.org/resource/SIO_000370") :annotation (label (literal "spatial boundary" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a spatial boundary is the closure minus the interior of a subset of a topological space." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001125") :subclass (iri "http://semanticscience.org/resource/SIO_010287") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A process that modulates the frequency, rate or extent of transcription" :lang "en")) (label (literal "regulation of transcription" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000079") :subclass (iri "http://semanticscience.org/resource/SIO_000078") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A visual language entity is a language entity that is expressed through physical expression of manual  " :lang "en")) (label (literal "visual language entity" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001120") :subclass (iri "http://semanticscience.org/resource/SIO_000983") :annotation (label (literal "therapeutic gene-disease association" :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "gene-disease association arising from a therapeutic role of the gene/protein" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "a gene disease association in which the gene is a therapeutic marker for the disease." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000076") :subclass (iri "http://semanticscience.org/resource/SIO_000091") :annotation (label (literal "plan" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a plan is a set of intended actions, through which one expects to achieve a goal." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000077") :subclass (iri "http://semanticscience.org/resource/SIO_000116") :annotation (label (literal "generic name" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A generic name is the preferred name provided by manufacturer" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000780") :subclass (iri "http://semanticscience.org/resource/SIO_000690") :annotation (label (literal "to bind to" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to bind to is the capability to physically interact with another object through a set of non-covalent interactions." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001122") :subclass (iri "http://semanticscience.org/resource/SIO_001121") :annotation (label (literal "gene-disease association linked with genetic variation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a gene-disease association in which a sequence variation (a mutation, a SNP) is associated with the disease." :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "gene variant-disease association" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000074") :subclass (iri "http://semanticscience.org/resource/SIO_000052") :annotation (label (literal "unit of measurement" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A unit of measurement is a definite magnitude of a physical quantity, defined and adopted by convention and/or by law, that is used as a standard for measurement of the same physical quantity." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001121") :subclass (iri "http://semanticscience.org/resource/SIO_000983") :annotation (label (literal "gene-disease biomarker association" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a gene-disease association in which the gene/protein is involved in the etiology or maintenance of the disease." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000075") :subclass (iri "http://semanticscience.org/resource/SIO_000015") :annotation (label (literal "mathematical entity" :lang "en")) (annotation (iri "http://semanticscience.org/resource/subset") (literal "math+" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "a mathematical entity is an information content entity that are components of a mathematical system or can be defined in mathematical terms." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000072") :subclass (iri "http://semanticscience.org/resource/SIO_000071") (object-some (iri "http://semanticscience.org/resource/SIO_000093") (iri "http://semanticscience.org/resource/SIO_000321")) :disjoint (iri "http://semanticscience.org/resource/SIO_000073") :annotation (label (literal "cartesian coordinate" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A Cartesian coordinate is the signed distance of a point to some referent line." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000073") :subclass (iri "http://semanticscience.org/resource/SIO_000071") (object-some (iri "http://semanticscience.org/resource/SIO_000093") (iri "http://semanticscience.org/resource/SIO_000327")) :disjoint (iri "http://semanticscience.org/resource/SIO_000072") :annotation (label (literal "polar coordinate" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a polar coordinate is a position characterized by a distance from a fixed point and an angle from a fixed direction." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000070") :subclass (iri "http://semanticscience.org/resource/SIO_000366") (object-or (data-some (iri "http://semanticscience.org/resource/SIO_000300") :XSD_DATE_TIME) (data-some (iri "http://semanticscience.org/resource/SIO_000300") :XSD_DOUBLE) (data-some (iri "http://semanticscience.org/resource/SIO_000300") :XSD_FLOAT) (data-some (iri "http://semanticscience.org/resource/SIO_000300") :XSD_INTEGER)) :annotation (label (literal "measurement value" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A measurement value is a quantitative description that reflects the magnitude of some attribute." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000071") :subclass (iri "http://semanticscience.org/resource/SIO_000056") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A coordinate is a measurement of position in n-dimensional space." :lang "en")) (label (literal "coordinate" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010358") :subclass (iri "http://semanticscience.org/resource/SIO_010360") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to oxidize is the capability to remove an electron or an increase in oxidation state of a chemical entity." :lang "en")) (label (literal "to oxidize" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010359") :subclass (iri "http://semanticscience.org/resource/SIO_010360") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to reduce is the capability to add an electron or an decrease in oxidation state of a chemical entity." :lang "en")) (label (literal "to reduce" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000203") :characteristic :transitive :symmetric)
(object-property (iri "http://semanticscience.org/resource/SIO_000204") :characteristic :symmetric)
(object-property (iri "http://semanticscience.org/resource/SIO_000205") :inverse (iri "http://semanticscience.org/resource/SIO_000210"))
(owl-class (iri "http://semanticscience.org/resource/SIO_011000") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "boron atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:27560" :type :RDF_PLAIN_LITERAL)))
(object-property (iri "http://semanticscience.org/resource/SIO_000206") :inverse (iri "http://semanticscience.org/resource/SIO_000208"))
(owl-class (iri "http://semanticscience.org/resource/SIO_011001") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:27594" :type :RDF_PLAIN_LITERAL)) (label (literal "carbon atom" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000207") :inverse (iri "http://semanticscience.org/resource/SIO_000209"))
(owl-class (iri "http://semanticscience.org/resource/SIO_011002") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:49637" :type :RDF_PLAIN_LITERAL)) (label (literal "hydrogen atom" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000208") :inverse (iri "http://semanticscience.org/resource/SIO_000206"))
(owl-class (iri "http://semanticscience.org/resource/SIO_011003") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:30217" :type :RDF_PLAIN_LITERAL)) (label (literal "helium atom" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000209") :inverse (iri "http://semanticscience.org/resource/SIO_000207"))
(owl-class (iri "http://semanticscience.org/resource/SIO_011004") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:30145" :type :RDF_PLAIN_LITERAL)) (label (literal "lithium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000776") :subclass (iri "http://semanticscience.org/resource/SIO_000000") (object-only (iri "http://semanticscience.org/resource/SIO_000053") (iri "http://semanticscience.org/resource/SIO_000776")) :disjoint (iri "http://semanticscience.org/resource/SIO_000006") (iri "http://semanticscience.org/resource/SIO_000614") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An object is an entity that is wholly identifiable at any instant of time during which it exists." :lang "en")) (label (literal "object" :lang "en")) (annotation (iri "http://semanticscience.org/resource/subset") (literal "core" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000049") :subclass (iri "http://semanticscience.org/resource/SIO_000048") :annotation (label (literal "volume" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "volume is the quantity of three-dimensional space enclosed by some closed boundary." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000777") :subclass (iri "http://semanticscience.org/resource/SIO_000639") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to be a member of is the capability to be considered a part of a collection." :lang "en")) (label (literal "to be a member of" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000778") :subclass (iri "http://semanticscience.org/resource/SIO_000378") :annotation (label (literal "to distort" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to distort is the capability to change the appearance of an entity by some transformation." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000779") :subclass (iri "http://semanticscience.org/resource/SIO_011125") (object-or (iri "http://semanticscience.org/resource/SIO_010008") (object-some (iri "http://semanticscience.org/resource/SIO_000586") (object-or (iri "http://semanticscience.org/resource/SIO_000780") (object-some (iri "http://semanticscience.org/resource/SIO_000586") (iri "http://semanticscience.org/resource/SIO_010094")) (object-some (iri "http://semanticscience.org/resource/SIO_000668") (object-or (iri "http://semanticscience.org/resource/SIO_010008") (object-some (iri "http://semanticscience.org/resource/SIO_000586") (iri "http://semanticscience.org/resource/SIO_010091"))))))) :annotation (label (literal "primer" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a primer is a nucleic acid that enables the synthesis of a complement strand of DNA by binding to it and acting as a point of transcription initiation." :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000202") :inverse (iri "http://semanticscience.org/resource/SIO_000128") :characteristic :transitive)
(owl-class (iri "http://semanticscience.org/resource/SIO_000041") :subclass (iri "http://semanticscience.org/resource/SIO_000038") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "length is the longer dimensional extent along a 2D projection of the object." :lang "en")) (label (literal "length" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000042") :subclass (iri "http://semanticscience.org/resource/SIO_000038") :annotation (label (literal "width" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "width is the shorter dimensional extent perpendicular to a 2D projection of the object." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000770") :subclass (iri "http://semanticscience.org/resource/SIO_000052") :annotation (label (literal "standard deviation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a standard deviation (represented by the symbol σ) is the quantity of  variation from the average (mean, or expected value)." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000043") :subclass (iri "http://semanticscience.org/resource/SIO_000039") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "thickness is the shortest dimensional extent of a 3D projection of an object." :lang "en")) (label (literal "thickness" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000044") :subclass (iri "http://semanticscience.org/resource/SIO_000037") :annotation (label (literal "2D extent quantity" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a quantity that extends in two dimensions" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000045") :subclass (iri "http://semanticscience.org/resource/SIO_000044") :annotation (label (literal "area" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "area is a quantity that pertains to the extent of a two-dimensional surface or shape, or planar lamina, in the plane." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000771") :subclass (iri "http://semanticscience.org/resource/SIO_000088") :annotation (label (literal "versioned record" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a versioned record is a record for which there exists another variant based that was derived via modification of the facts." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000046") :subclass (iri "http://semanticscience.org/resource/SIO_000044") :annotation (label (literal "length of perimeter" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A perimeter is a length of the outline that surrounds a two-dimensional shape. " :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000047") :subclass (iri "http://semanticscience.org/resource/SIO_000046") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "circumference is the length of the outline of a circle or ellipse. it is defined as c = 2*pi*r, where r is the radius." :lang "en")) (label (literal "circumference" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000048") :subclass (iri "http://semanticscience.org/resource/SIO_000037") :annotation (label (literal "3D extent quantity" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a quantity that extends in three dimensions" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011006") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "nitrogen atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:25555" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011005") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "beryllium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:30501" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011008") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:24061" :type :RDF_PLAIN_LITERAL)) (label (literal "fluorine atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011007") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "oxygen atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:25805" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011009") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "neon atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33310" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000040") :subclass (iri "http://semanticscience.org/resource/SIO_000038") :annotation (label (literal "height" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "height is the one dimensional extent along the vertical projection of a 3D object from a base plane of reference." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000766") :subclass (iri "http://semanticscience.org/resource/SIO_000328") :annotation (label (literal "street name" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a street name is the token given to identify a particular street." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001105") :subclass (iri "http://semanticscience.org/resource/SIO_000492") :annotation (label (literal "to ingest" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to ingest is the capability to take into the body by the mouth for digestion or absorption" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000767") :subclass (iri "http://semanticscience.org/resource/SIO_000013") :annotation (label (literal "postal code" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a postal code is a geographic coordinate composed of a series of letters and/or digits appended to a postal address for the purpose of sorting mail." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001106") :subclass (iri "http://semanticscience.org/resource/SIO_000494") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to produce is the capability to create new objects" :lang "en")) (label (literal "to produce" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000764") :subclass (iri "http://semanticscience.org/resource/SIO_000762") (object-some (iri "http://semanticscience.org/resource/SIO_000631") (iri "http://semanticscience.org/resource/SIO_000762")) :annotation (label (literal "foreign database key" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a foreign database key is a database key that refers to a key in some table" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001107") :subclass (iri "http://semanticscience.org/resource/SIO_000091") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a pathway is an effective specification that outlines a set of actions that forms a way to achieve an objective." :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "biological pathway" :type :RDF_PLAIN_LITERAL)) (label (literal "pathway" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000765") :subclass (iri "http://semanticscience.org/resource/SIO_000638") (data-some (iri "http://semanticscience.org/resource/SIO_000300") (span <= 1.0) (span >= 0.0)) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a p-value or probability value is the probability of obtaining a test statistic at least as extreme as the one that was actually observed, assuming that the null hypothesis is true" :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "p-value" :lang "en")) (label (literal "probability value" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001108") :subclass (iri "http://semanticscience.org/resource/SIO_000052") :annotation (label (literal "centrality measure" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a central tendency measure is a central value or a typical value for a probability distribution." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001109") :subclass (iri "http://semanticscience.org/resource/SIO_001108") :annotation (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "average" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "arithmeritic mean" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "a mean is the central tendency of a collection of numbers taken as the sum of the numbers divided by the size of the collection." :lang "en")) (label (literal "mean" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000768") :subclass (iri "http://semanticscience.org/resource/SIO_000328") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an apartment number is the number assigned to identify an apartment in a building of apartments." :lang "en")) (label (literal "apartment number" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000769") :subclass (iri "http://semanticscience.org/resource/SIO_000052") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "the uncertainty value (margin of error) of a measurement is a range of values likely to enclose the true value. " :lang "en")) (label (literal "uncertainty value" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000055") :subclass (iri "http://semanticscience.org/resource/SIO_000026") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "shape is the quality of a bearer that relates to its spatial extent." :lang "en")) (label (literal "shape" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000052") :subclass (iri "http://semanticscience.org/resource/SIO_000070") (object-some (iri "http://semanticscience.org/resource/SIO_000011") (iri "http://semanticscience.org/resource/SIO_000000")) (object-some (iri "http://semanticscience.org/resource/SIO_000215") (iri "http://semanticscience.org/resource/SIO_000000")) :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_000257") (iri "http://semanticscience.org/resource/SIO_000258")) :annotation (label (literal "quantity" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A quantity is an informational entity that gives the magnitude of a property." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001100") :subclass (iri "http://semanticscience.org/resource/SIO_000626") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a crystal structure is the arrangement of atoms or molecules in a crystalline liquid or solid." :lang "en")) (label (literal "crystal structure" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000763") :subclass (iri "http://semanticscience.org/resource/SIO_000762") (object-not (data-has-value (iri "http://semanticscience.org/resource/SIO_000300") (literal "null" :type :RDF_PLAIN_LITERAL))) (object-some (iri "http://semanticscience.org/resource/SIO_000674") (iri "http://semanticscience.org/resource/SIO_000752")) :annotation (label (literal "primary database key" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A primary database key is a database key that identifies every row of a table." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001102") :subclass (iri "http://semanticscience.org/resource/SIO_000409") (object-or (object-some (iri "http://semanticscience.org/resource/SIO_000053") (iri "http://semanticscience.org/resource/SIO_000701")) (object-some (iri "http://semanticscience.org/resource/SIO_000053") (iri "http://semanticscience.org/resource/SIO_000702"))) :annotation (label (literal "to interact and to be interacted with" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to interact and to be interacted with is a mutual disposition of interacting objects." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000762") :subclass (iri "http://semanticscience.org/resource/SIO_000602") (object-some (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_000753")) (data-some (iri "http://semanticscience.org/resource/SIO_000300") :RDFS_LITERAL) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A database key is an informational entity whose value is constructed from one or more database columns." :lang "en")) (label (literal "database key" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000761") :subclass (iri "http://semanticscience.org/resource/SIO_000755") (object-some (iri "http://semanticscience.org/resource/SIO_000212") (iri "http://semanticscience.org/resource/SIO_000755")) :annotation (label (literal "referent cell" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a referent cell is a cell that is the referent of some function or pointer." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000056") :subclass (iri "http://semanticscience.org/resource/SIO_000070") (object-some (iri "http://semanticscience.org/resource/SIO_000008") (iri "http://semanticscience.org/resource/SIO_000328")) :annotation (label (literal "position" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A measurement of a spatial location relative to a frame of reference or other objects." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001104") :subclass (iri "http://semanticscience.org/resource/SIO_010366") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to lose a covalent bond is the capability of a chemical entity to have bonds removed." :lang "en")) (label (literal "to lose a covalent bond" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000760") :subclass (iri "http://semanticscience.org/resource/SIO_000755") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a referenceing cell is a cell of a cellular automata that refers to another cell." :lang "en")) (label (literal "referencing cell" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000057") :subclass (iri "http://semanticscience.org/resource/SIO_000056") :annotation (label (literal "orientation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "orientation is an angle between the bearer and an axis, or the angle between the bearer and another object." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001103") :subclass (iri "http://semanticscience.org/resource/SIO_010366") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to gain a covalent bond is the capability of a chemical entity to have bonds added." :lang "en")) (label (literal "to gain a covalent bond" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010334") :subclass (iri "http://semanticscience.org/resource/SIO_010071") (object-some (iri "http://semanticscience.org/resource/SIO_000244") (iri "http://semanticscience.org/resource/SIO_010030")) :annotation (label (literal "carbohydrate residue" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a carbohydrate residue is a part of a molecule that was derived from a monosaccharide molecule." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010335") :subclass (iri "http://semanticscience.org/resource/SIO_010071") (object-some (iri "http://semanticscience.org/resource/SIO_000068") (iri "http://semanticscience.org/resource/SIO_010008")) (object-some (iri "http://semanticscience.org/resource/SIO_000273") (iri "http://semanticscience.org/resource/SIO_010075")) :annotation (label (literal "nucleic acid part" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a nucleic acid part is a component of a nucleic acid." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010336") :subclass (iri "http://semanticscience.org/resource/SIO_010075") :disjoint (iri "http://semanticscience.org/resource/SIO_010337") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a deoxyribonucleotide residue is a part of a molecule that derives from a deoxyribonucleotide." :lang "en")) (label (literal "deoxyribonucleotide residue" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010337") :subclass (iri "http://semanticscience.org/resource/SIO_010075") :disjoint (iri "http://semanticscience.org/resource/SIO_010336") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a ribonucleotide residue is a part of a molecule that derives from a ribonucleotide." :lang "en")) (label (literal "ribonucleotide residue" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010338") :subclass (iri "http://semanticscience.org/resource/SIO_011125") (object-some (iri "http://semanticscience.org/resource/SIO_000093") (iri "http://semanticscience.org/resource/SIO_010039")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a pharmaceutical component is a part of a pharmaceutical preparation." :lang "en")) (label (literal "pharmaceutical component" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000051") :subclass (iri "http://semanticscience.org/resource/SIO_000026") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "composition quality is a quality that describes its composition or anatomy." :lang "en")) (label (literal "compositional quality" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000758") :subclass (iri "http://semanticscience.org/resource/SIO_001092") (object-some (iri "http://semanticscience.org/resource/SIO_000218") (object-or (iri "http://semanticscience.org/resource/SIO_000000") (object-some (iri "http://semanticscience.org/resource/SIO_000217") (iri "http://semanticscience.org/resource/SIO_000555")))) :disjoint (iri "http://semanticscience.org/resource/SIO_001093") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "disordered is a structural quality in which the parts of an object are non-rigid." :lang "en")) (label (literal "disordered" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000757") :subclass (iri "http://semanticscience.org/resource/SIO_000753") (object-some (iri "http://semanticscience.org/resource/SIO_000093") (iri "http://semanticscience.org/resource/SIO_000754")) :annotation (label (literal "database column" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a database collumn is a column in a database table" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000759") :subclass (iri "http://semanticscience.org/resource/SIO_000755") (object-some (iri "http://semanticscience.org/resource/SIO_000008") (iri "http://semanticscience.org/resource/SIO_000675")) :annotation (label (literal "unique cell" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a unique cell is a cell that contains a unique value in the cellular automaton." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000754") :subclass (iri "http://semanticscience.org/resource/SIO_000602") (object-some (iri "http://semanticscience.org/resource/SIO_000093") (iri "http://semanticscience.org/resource/SIO_000750")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a database table is a set of named columns with zero or more rows composed of cells that contain column values and is part of a database." :lang "en")) (label (literal "database table" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000753") :subclass (iri "http://semanticscience.org/resource/SIO_000602") (object-only (iri "http://semanticscience.org/resource/SIO_000338") (object-or (iri "http://semanticscience.org/resource/SIO_000755") (data-some (iri "http://semanticscience.org/resource/SIO_000300") :RDFS_LITERAL) (data-only (iri "http://semanticscience.org/resource/SIO_000300") :RDFS_LITERAL))) (object-at-least 0 (iri "http://semanticscience.org/resource/SIO_000008") (iri "http://semanticscience.org/resource/SIO_000116")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a column is a vertical sequence of cells in a cellular automata." :lang "en")) (label (literal "column" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000756") :subclass (iri "http://semanticscience.org/resource/SIO_000602") (object-some (iri "http://semanticscience.org/resource/SIO_000093") (iri "http://semanticscience.org/resource/SIO_000750")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A database entry is a single, implicitly structured data item in a table." :lang "en")) (label (literal "database entry" :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "database record" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000755") :subclass (iri "http://semanticscience.org/resource/SIO_000602") (object-some (iri "http://semanticscience.org/resource/SIO_000628") (iri "http://semanticscience.org/resource/SIO_000000")) :annotation (label (literal "cell (informational)" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "The minimal unit of a cellular automaton that can change state and has an associated behavior." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011024") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "manganese atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:18291" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_010300") :subclass (iri "http://semanticscience.org/resource/SIO_000590") (object-some (iri "http://semanticscience.org/resource/SIO_000229") (object-or (iri "http://semanticscience.org/resource/SIO_010009") (object-some (iri "http://semanticscience.org/resource/SIO_010081") (iri "http://semanticscience.org/resource/SIO_010010")))) (object-some (iri "http://semanticscience.org/resource/SIO_000230") (iri "http://semanticscience.org/resource/SIO_010010")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Transcription is the process of creating a complementary RNA copy of a sequence of DNA." :lang "en")) (label (literal "transcription" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011023") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "chromium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:28073" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011026") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "cobalt atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:27638" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011025") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:18248" :type :RDF_PLAIN_LITERAL)) (label (literal "iron atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011020") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "scandium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33330" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011022") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "vanadium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:27698" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011021") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "titanium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33341" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_010308") :subclass (iri "http://semanticscience.org/resource/SIO_010013") :annotation (label (literal "metabolism" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Metabolism is the set of chemical processes that occur within a living organism in order to maintain life." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010307") :subclass (iri "http://semanticscience.org/resource/SIO_010345") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Molecular modification is chemical alteration of a known and previously characterized lead compound for the purpose of enhancing its usefulness as a drug. This could mean enhancing its specificity for a particular body target site, increasing its potency, improving its rate and extent of absorption, modifying to advantage its time course in the body, reducing its toxicity, changing its physical or chemical properties (like solubility) to provide desired features." :lang "en")) (label (literal "molecular modification" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011027") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:28112" :type :RDF_PLAIN_LITERAL)) (label (literal "nickel atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011028") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "copper atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:28694" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011029") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:27363" :type :RDF_PLAIN_LITERAL)) (label (literal "zinc atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010301") :subclass (iri "http://semanticscience.org/resource/SIO_000590") (object-some (iri "http://semanticscience.org/resource/SIO_000230") (iri "http://semanticscience.org/resource/SIO_010009")) (object-some (iri "http://semanticscience.org/resource/SIO_000312") (iri "http://semanticscience.org/resource/SIO_010007")) :annotation (label (literal "translation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Translation is the process of producing a polypeptide from a ribonucleic acid by a ribosome." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000750") :subclass (iri "http://semanticscience.org/resource/SIO_000602") :annotation (label (literal "database" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a database is a set of tables." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000751") :subclass (iri "http://semanticscience.org/resource/SIO_000555") :disjoint (iri "http://semanticscience.org/resource/SIO_000640") :annotation (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "PATO:0002301" :type :RDF_PLAIN_LITERAL)) (label (literal "decreased" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A quality that has a value that is decreased compared to normal or average." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000752") :subclass (iri "http://semanticscience.org/resource/SIO_000602") (object-some (iri "http://semanticscience.org/resource/SIO_000053") (iri "http://semanticscience.org/resource/SIO_000755")) (object-some (iri "http://semanticscience.org/resource/SIO_000671") (iri "http://semanticscience.org/resource/SIO_000115")) :annotation (label (literal "row" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A row represents a single, implicitly structured data item in a table. " :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010309") :subclass (iri "http://semanticscience.org/resource/SIO_010308") :disjoint (iri "http://semanticscience.org/resource/SIO_010310") :annotation (label (literal "catabolism" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Anabolism is the set of metabolic processes that take apart larger chemical entities units into smaller chemical entities." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000748") :subclass (iri "http://semanticscience.org/resource/SIO_000588") (object-some (iri "http://semanticscience.org/resource/SIO_000312") (iri "http://semanticscience.org/resource/SIO_000256")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "predicting is the process of formulating a proposition about a state of affairs which might be realized in the future." :lang "en")) (label (literal "predicting" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000747") :subclass (iri "http://semanticscience.org/resource/SIO_000999") (object-some (iri "http://semanticscience.org/resource/SIO_000312") (iri "http://semanticscience.org/resource/SIO_000776")) (object-some (iri "http://semanticscience.org/resource/SIO_000355") (iri "http://semanticscience.org/resource/SIO_000337")) :annotation (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "study" :type :RDF_PLAIN_LITERAL)) (label (literal "investigation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "investigation is the process of carrying out a plan or procedure so as to discover facts or information about the object of study." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000746") :subclass (iri "http://semanticscience.org/resource/SIO_000588") (object-some (iri "http://semanticscience.org/resource/SIO_000312") (object-or (iri "http://semanticscience.org/resource/SIO_000268") (object-some (iri "http://semanticscience.org/resource/SIO_000218") (iri "http://semanticscience.org/resource/SIO_000256")))) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "reasoning is the agentive process of using knowledge to evaluate the truth value of a proposition." :lang "en")) (label (literal "reasoning" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000745") :subclass (iri "http://semanticscience.org/resource/SIO_000593") (object-or (object-some (iri "http://semanticscience.org/resource/SIO_000355") (iri "http://semanticscience.org/resource/SIO_000722")) (object-some (iri "http://semanticscience.org/resource/SIO_000355") (iri "http://semanticscience.org/resource/SIO_000723"))) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "comparing is the process of examining a set of objects and determining their equality or inequality based on one or more features." :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "comparison" :type :RDF_PLAIN_LITERAL)) (label (literal "comparing" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000744") :subclass (iri "http://semanticscience.org/resource/SIO_000588") (object-some (iri "http://semanticscience.org/resource/SIO_000312") (iri "http://semanticscience.org/resource/SIO_000256")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "learning is the agentive process of acquiring knowledge." :lang "en")) (label (literal "learning" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000743") :subclass (iri "http://semanticscience.org/resource/SIO_000741") :annotation (label (literal "local minimum stationary point" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a local minimum stationary point is a point that has a lower value in  some axis than adjacent points." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000742") :subclass (iri "http://semanticscience.org/resource/SIO_000741") :annotation (label (literal "local maximum stationary point" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a local maximum stationary point is a point that has a higher value in  some axis than adjacent points." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011015") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "sulfur atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:26833" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011014") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:28659" :type :RDF_PLAIN_LITERAL)) (label (literal "phosphorus atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010310") :subclass (iri "http://semanticscience.org/resource/SIO_010308") :disjoint (iri "http://semanticscience.org/resource/SIO_010309") :annotation (label (literal "anabolism" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Anabolism is the set of metabolic processes that construct larger chemical entities units from smaller chemical entities." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011013") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:27573" :type :RDF_PLAIN_LITERAL)) (label (literal "silicon atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011012") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:28984" :type :RDF_PLAIN_LITERAL)) (label (literal "aluminium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011011") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "magnesium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:25107" :type :RDF_PLAIN_LITERAL)))
(annotation-property (iri "http://www.w3.org/2000/01/rdf-schema#comment"))
(owl-class (iri "http://semanticscience.org/resource/SIO_011010") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:26708" :type :RDF_PLAIN_LITERAL)) (label (literal "sodium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011018") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:26216" :type :RDF_PLAIN_LITERAL)) (label (literal "potassium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011019") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "calcium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:22984" :type :RDF_PLAIN_LITERAL)))
(annotation-property (iri "http://semanticscience.org/resource/subset"))
(owl-class (iri "http://semanticscience.org/resource/SIO_011016") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:23116" :type :RDF_PLAIN_LITERAL)) (label (literal "chlorine atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011017") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:49475" :type :RDF_PLAIN_LITERAL)) (label (literal "argon atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000740") :subclass (iri "http://semanticscience.org/resource/SIO_000608") :annotation (label (literal "curve segment" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a curve segment is a part of a curve that consists of at least three points." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000741") :subclass (iri "http://semanticscience.org/resource/SIO_000465") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a stationary point is a point that is part of a curve in which the derivative at that point is zero, and hence its value is at least a local maximum or minimum." :lang "en")) (label (literal "stationary point" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000732") :subclass (iri "http://semanticscience.org/resource/SIO_000728") :annotation (label (literal "molecular identifier" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a molecular identifier is an identifier for a molecular entity." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000731") :subclass (iri "http://semanticscience.org/resource/SIO_000115") :annotation (label (literal "informational entity identifier" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an informational entity identifier is an identifier for an informational entity." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011040") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33344" :type :RDF_PLAIN_LITERAL)) (label (literal "niobium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011042") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "technetium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33353" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000739") :subclass (iri "http://semanticscience.org/resource/SIO_000588") (object-some (iri "http://semanticscience.org/resource/SIO_000312") (object-or (iri "http://semanticscience.org/resource/SIO_000076") (iri "http://semanticscience.org/resource/SIO_000705"))) :annotation (label (literal "planning" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Planning is the agentive process of developing a plan that specifies a set of actions in order to meet a set of goals or objectives." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011041") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:28685" :type :RDF_PLAIN_LITERAL)) (label (literal "molybdemum atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011044") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33359" :type :RDF_PLAIN_LITERAL)) (label (literal "rhodium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011043") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "ruthenium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:30682" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011046") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "silver atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:30512" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011045") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33363" :type :RDF_PLAIN_LITERAL)) (label (literal "palladium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011048") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "indium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:30430" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011047") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "cadmium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:22977" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011049") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:27007" :type :RDF_PLAIN_LITERAL)) (label (literal "tin atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000080") :subclass (iri "http://semanticscience.org/resource/SIO_001194") :disjoint (iri "http://semanticscience.org/resource/SIO_000448") :annotation (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "diagram" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A figure is a graphical entity which consists of a visual (n-dimentional) arrangement of information entities." :lang "en")) (label (literal "figure" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000082") :subclass (iri "http://semanticscience.org/resource/SIO_000081") :annotation (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "photo" :lang "en")) (label (literal "photograph" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A photograph is an image created by light falling on a light-sensitive surface." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000081") :subclass (iri "http://semanticscience.org/resource/SIO_000080") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An image is an affine projection of a visual entity to a two dimensional surface." :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "depiction" :lang "en")) (label (literal "image" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000083") :subclass (iri "http://semanticscience.org/resource/SIO_000904") :annotation (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "chart" :type :RDF_PLAIN_LITERAL)) (label (literal "statistical graph" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A statistical graph is a figure that displays the relationship among numeric data and/or mathematical functions." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000085") :subclass (iri "http://semanticscience.org/resource/SIO_000113") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A question is a linguistic expression used to make a request for information." :lang "en")) (label (literal "question" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000088") :subclass (iri "http://semanticscience.org/resource/SIO_000148") (object-some (iri "http://semanticscience.org/resource/SIO_000673") (iri "http://semanticscience.org/resource/SIO_000115")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A record is a document containing a collection of statements about some entity." :lang "en")) (label (literal "record" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000087") :subclass (iri "http://semanticscience.org/resource/SIO_000148") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A publication is a document that has been made available by a publisher." :lang "en")) (label (literal "publication" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000089") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_000069") (object-only (iri "http://semanticscience.org/resource/SIO_000059") (iri "http://semanticscience.org/resource/SIO_000069"))) :annotation (label (literal "data set" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A dataset is a data item that is a collection of data items." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000730") :subclass (iri "http://semanticscience.org/resource/SIO_000115") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a physical entity identifier is an identifier for a physical entity." :lang "en")) (label (literal "physical entity identifier" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000723") :subclass (iri "http://semanticscience.org/resource/SIO_000724") :annotation (label (literal "to compare" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to compare is the capability to examine in order to note the similarities or differences among a set of objects." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000722") :subclass (iri "http://semanticscience.org/resource/SIO_000725") :annotation (label (literal "to be compared" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to be compared is the capability of an object to be examined in order to note the similarities or differences among a set of objects." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000721") :subclass (iri "http://semanticscience.org/resource/SIO_000678") :disjoint (iri "http://semanticscience.org/resource/SIO_000704") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a comparative role is an abstract role which holds by comparing some attribute of another object of reference." :lang "en")) (label (literal "comparative role" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000720") :subclass (iri "http://semanticscience.org/resource/SIO_000702") (object-some (iri "http://semanticscience.org/resource/SIO_000697") (iri "http://semanticscience.org/resource/SIO_000719")) :disjoint (iri "http://semanticscience.org/resource/SIO_000719") :annotation (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "to be moved" :lang "en")) (label (literal "to be translocated" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to be translocated is the capability to be physically displaced from one location to another" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000727") :subclass (iri "http://semanticscience.org/resource/SIO_000726") :annotation (label (literal "secretary role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a secretary role is the role of an individual that performs administrative tasks to support one or more individuals of the same organization." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000726") :subclass (iri "http://semanticscience.org/resource/SIO_000706") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an administrative role is the role of an individual that performs administrative tasks for some organization." :lang "en")) (label (literal "administrative role" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000725") :subclass (iri "http://semanticscience.org/resource/SIO_000696") :annotation (label (literal "to be examined" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to be examined is the capability of an object to be observed in a detailed manner." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000724") :subclass (iri "http://semanticscience.org/resource/SIO_000353") :annotation (label (literal "to examine" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to examine is the capability to make detailed observation. " :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011033") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "selenium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:27568" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011032") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:27563" :type :RDF_PLAIN_LITERAL)) (label (literal "arsenic atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000729") :subclass (iri "http://semanticscience.org/resource/SIO_000731") (object-some (iri "http://semanticscience.org/resource/SIO_000672") (iri "http://semanticscience.org/resource/SIO_000756")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a record identifier is an identifier for a database entry." :lang "en")) (label (literal "record identifier" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011031") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "germanium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:30441" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000728") :subclass (iri "http://semanticscience.org/resource/SIO_000730") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a chemical identifier is an identifier for a chemical entity" :lang "en")) (label (literal "chemical identifier" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011030") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "gallium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:49631" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011037") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33324" :type :RDF_PLAIN_LITERAL)) (label (literal "strontium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011036") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33322" :type :RDF_PLAIN_LITERAL)) (label (literal "rubidium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011035") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "krypton atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:49696" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011034") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "bromine atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:22927" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000091") :subclass (iri "http://semanticscience.org/resource/SIO_000090") (object-some (iri "http://semanticscience.org/resource/SIO_000338") (iri "http://semanticscience.org/resource/SIO_000006")) (object-some (iri "http://semanticscience.org/resource/SIO_000362") (iri "http://semanticscience.org/resource/SIO_000337")) (object-only (iri "http://semanticscience.org/resource/SIO_000341") (iri "http://semanticscience.org/resource/SIO_000006")) :annotation (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "effective specification" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "An action specification is a specification composed of a sequence of instructions to achieve some objective." :lang "en")) (label (literal "action specification" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000090") :subclass (iri "http://semanticscience.org/resource/SIO_000136") (object-some (iri "http://semanticscience.org/resource/SIO_000338") (iri "http://semanticscience.org/resource/SIO_000000")) (object-some (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_000337")) (object-some (iri "http://semanticscience.org/resource/SIO_000420") (iri "http://semanticscience.org/resource/SIO_000015")) :annotation (label (literal "specification" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A specification is a description of the essential technical attributes/requirements for an object or procedure, and may be used to determine that the object / procedure meets its requirements/attributes." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011038") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "yttrium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33331" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011039") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "zirconium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33342" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000094") :subclass (iri "http://semanticscience.org/resource/SIO_000075") :annotation (label (literal "algorithm" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An algorithm is an effective method expressed as a finite list of well-defined instructions for calculating a function." :lang "en")))

(owl-class (iri "http://semanticscience.org/resource/SIO_000092") :subclass (iri "http://semanticscience.org/resource/SIO_010346") (object-some (iri "http://semanticscience.org/resource/SIO_000273") (object-or (iri "http://semanticscience.org/resource/SIO_000556") (iri "http://semanticscience.org/resource/SIO_010074") (iri "http://semanticscience.org/resource/SIO_010075") (iri "http://semanticscience.org/resource/SIO_010334"))) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A biopolymer is an organic polymer using biological components." :lang "en")) (label (literal "biopolymer" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000099") :subclass (iri "http://semanticscience.org/resource/SIO_000097") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A software module is software composed of a collection of software methods." :lang "en")) (label (literal "software module" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000098") :subclass (iri "http://semanticscience.org/resource/SIO_000097") :annotation (label (literal "software method" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A software method (also called subroutine, subprogram, procedure, method, function, or routine) is software designed to execute a specific task" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000097") :subclass (iri "http://semanticscience.org/resource/SIO_000602") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a software entity is a computational entity that can be interpreted by or directly executed by a processing unit." :lang "en")) (label (literal "software entity" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001197") :subclass (iri "http://semanticscience.org/resource/SIO_000130") :disjoint (iri "http://semanticscience.org/resource/SIO_000131") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a structural motif is a pattern in a structure formed by the spatial arrangement of atoms." :lang "en")) (label (literal "structural motif" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001196") :subclass (iri "http://semanticscience.org/resource/SIO_000136") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "history is a sequence of past events." :lang "en")) (label (literal "history" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001199") :subclass (iri "http://semanticscience.org/resource/SIO_001129") :annotation (label (literal "increased molecular degradation from increased regulation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A process that increases the frequency, rate or extent of process involved in the destruction of a molecule as a result of increased regulation." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001198") :subclass (iri "http://semanticscience.org/resource/SIO_000966") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "consensus is an acceptable resolution, one that can be supported, even if not the preferred outcome for each individual." :lang "en")) (label (literal "consensus" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000309") :subclass (iri "http://semanticscience.org/resource/SIO_000794") :annotation (label (literal "volume number" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "volume number is a count of a sequence of periodicals." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001193") :subclass (iri "http://semanticscience.org/resource/SIO_001192") (object-some (iri "http://semanticscience.org/resource/SIO_000139") (iri "http://semanticscience.org/resource/SIO_001188")) :annotation (annotation (iri "http://semanticscience.org/resource/subset") (literal "sadi" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a SADI web service invocation is the excution of a SADI web service." :type :XSD_ANY_URI)) (label (literal "SADI web service invocation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000308") :subclass (iri "http://semanticscience.org/resource/SIO_000794") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An edition number is count of a literary work edited and published, as by a certain editor or in a certain manner including being printed during some interval of time." :lang "en")) (label (literal "edition number" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001192") :subclass (iri "http://semanticscience.org/resource/SIO_000667") :annotation (label (literal "web service invocation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a web service invocation involves the execution of a web service." :type :XSD_ANY_URI)))
(owl-class (iri "http://semanticscience.org/resource/SIO_001195") :subclass (iri "http://semanticscience.org/resource/SIO_000006") :annotation (annotation (iri "http://semanticscience.org/resource/subset") (literal "behaviour+" :type :RDF_PLAIN_LITERAL)) (label (literal "behaviour" :lang "en")) (annotation (iri "http://semanticscience.org/resource/subset") (literal "core" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "Behaviour is the set of actions and mannerisms made by systems (biological or otherwise) in response to stimuli or inputs, whether internal or external, conscious or subconscious, overt or covert, and voluntary or involuntary." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000307") :subclass (iri "http://semanticscience.org/resource/SIO_000005") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_000554") (iri "http://semanticscience.org/resource/SIO_000555")) :annotation (label (literal "normality" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "normality is the quality in which the value may differ from normal or average" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001194") :subclass (iri "http://semanticscience.org/resource/SIO_000015") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "media are audo/visual/audiovisual modes of communicating information for mass consumption." :lang "en")) (label (literal "media" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000306") :subclass (iri "http://semanticscience.org/resource/SIO_000148") :annotation (label (literal "letter" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A letter is a document that contains a personal communication from one part to another." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000305") :subclass (iri "http://semanticscience.org/resource/SIO_000613") :annotation (label (literal "process number" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "process number is a number associated with a process that denotes its ordinal position in a set of processes." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000304") :subclass (iri "http://semanticscience.org/resource/SIO_000148") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Email message is a digital document that is composed of a header and a body and is transmitted using the SMTP protocol." :lang "en")) (label (literal "email" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001191") :subclass (iri "http://semanticscience.org/resource/SIO_000140") :annotation (label (literal "SOAP web service" :lang "en")) (annotation (iri "http://www.w3.org/2000/01/rdf-schema#seeAlso") (literal "http://en.wikipedia.org/wiki/SOAP" :type :XSD_ANY_URI)) (annotation (iri "http://purl.org/dc/terms/description") (literal "a SOAP web service is a web service that implements Simple Object Access Protocol (SOAP)." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000302") :subclass (iri "http://semanticscience.org/resource/SIO_000148") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A web page is a document that is published according to World Wide Web standards." :lang "en")) (label (literal "web page" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001190") :subclass (iri "http://semanticscience.org/resource/SIO_000140") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a REST web service is a web service that provides functionality according to the Representational State Transfer (REST) specification." :lang "en")) (annotation (iri "http://www.w3.org/2000/01/rdf-schema#seeAlso") (literal "http://en.wikipedia.org/wiki/REST" :type :XSD_ANY_URI)) (label (literal "REST web service" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011069") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33313" :type :RDF_PLAIN_LITERAL)) (label (literal "polonium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000301") :subclass (iri "http://semanticscience.org/resource/SIO_000082") :annotation (label (literal "geographic image" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A geographic image is a photograph of some geographical area." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011067") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:25016" :type :RDF_PLAIN_LITERAL)) (label (literal "lead atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011068") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "bismuth atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33301" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000719") :subclass (iri "http://semanticscience.org/resource/SIO_000701") (object-some (iri "http://semanticscience.org/resource/SIO_000697") (iri "http://semanticscience.org/resource/SIO_000720")) :disjoint (iri "http://semanticscience.org/resource/SIO_000720") :annotation (label (literal "to translocate" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to translocate is the capability to displace oneself from one location to another." :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "to move" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011065") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:25195" :type :RDF_PLAIN_LITERAL)) (label (literal "mercury atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011066") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:49920" :type :RDF_PLAIN_LITERAL)) (label (literal "thallium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000717") :subclass (iri "http://semanticscience.org/resource/SIO_000712") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a dentist role is the role of an individual that that specializes in the diagnosis, prevention, and treatment of diseases and conditions of the oral cavity." :lang "en")) (label (literal "dentist role" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011063") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33364" :type :RDF_PLAIN_LITERAL)) (label (literal "platinum atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011064") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "gold atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:29287" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000715") :subclass (iri "http://semanticscience.org/resource/SIO_000712") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a patient role is the role of an individual that is the recepient of medical care." :lang "en")) (label (literal "patient role" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011061") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "osmium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:30687" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000716") :subclass (iri "http://semanticscience.org/resource/SIO_000498") :annotation (label (literal "medical practitioner" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a medical practioner is an individual that provides medical care." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011062") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:49666" :type :RDF_PLAIN_LITERAL)) (label (literal "iridium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000713") :subclass (iri "http://semanticscience.org/resource/SIO_000712") :annotation (label (literal "doctor role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A doctor role is the role of an individual who practices medicine, which is concerned with promoting, maintaining or restoring human health through the study, diagnosis, and treatment of disease, injury, and other physical and mental impairments." :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "physician" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000714") :subclass (iri "http://semanticscience.org/resource/SIO_000712") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A nurse role is the role of an individual that is involved in the protection, promotion, and optimization of health and abilities, prevention of illness and injury, alleviation of suffering through the diagnosis and treatment of human response, and advocacy in the care of individuals, families, communities, and populations." :lang "en")) (label (literal "nurse role" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011060") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:49882" :type :RDF_PLAIN_LITERAL)) (label (literal "rhenium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000711") :subclass (iri "http://semanticscience.org/resource/SIO_000706") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an academic role is a social role that pertains to the academic institution." :lang "en")) (label (literal "academic role" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000712") :subclass (iri "http://semanticscience.org/resource/SIO_000706") :annotation (label (literal "medical role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a medical role is the role of an individual that is a participant in the delivery of medical care." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000318") :subclass (iri "http://semanticscience.org/resource/SIO_000013") :disjoint (iri "http://semanticscience.org/resource/SIO_000319") :annotation (label (literal "longitude" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Longitude is a geographic position that refers to  the angle east or west of a reference meridian between the two geographical poles to another meridian that passes through an arbitrary point." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000317") :subclass (iri "http://semanticscience.org/resource/SIO_000315") :annotation (label (literal "spatial specification" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A specification for spatial location is an effective specification towards representation spatial position or spatial data." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000319") :subclass (iri "http://semanticscience.org/resource/SIO_000013") :disjoint (iri "http://semanticscience.org/resource/SIO_000318") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Latitude is a geographic coordinate which refers to the angle from a point on the Earth's surface to the equatorial plane" :lang "en")) (label (literal "latitude" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000314") :subclass (iri "http://semanticscience.org/resource/SIO_011125") (object-some (iri "http://semanticscience.org/resource/SIO_000273") (iri "http://semanticscience.org/resource/SIO_000146")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a polymer is a molecule composed of a connected set of monomeric residues." :lang "en")) (label (literal "polymer" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000316") :subclass (iri "http://semanticscience.org/resource/SIO_000315") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A design specification is a specification that provides precise and explicit information about the requirements for a product design." :lang "en")) (label (literal "design specification" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000315") :subclass (iri "http://semanticscience.org/resource/SIO_000090") (object-some (iri "http://semanticscience.org/resource/SIO_000338") (object-or (iri "http://semanticscience.org/resource/SIO_000004") (iri "http://semanticscience.org/resource/SIO_000015"))) :annotation (label (literal "functional specification" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A functional specification is a specification that describes the characteristics of an object." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011056") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "lanthanum atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33336" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011057") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "hafnium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33343" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011058") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "tantalum atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33348" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011059") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "tungsten atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:27998" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000706") :subclass (iri "http://semanticscience.org/resource/SIO_000676") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an occupational role is a social role that pertains to an organizational structure." :lang "en")) (label (literal "occupational role" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011052") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "iodine atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:24859" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000707") :subclass (iri "http://semanticscience.org/resource/SIO_000711") (object-some (iri "http://semanticscience.org/resource/SIO_000227") (iri "http://semanticscience.org/resource/SIO_000405")) :disjoint (iri "http://semanticscience.org/resource/SIO_000708") :annotation (label (literal "student role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a student role is the role of an individual that is enrolled in courses at an academic institution." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011053") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:49957" :type :RDF_PLAIN_LITERAL)) (label (literal "xenon atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000708") :subclass (iri "http://semanticscience.org/resource/SIO_000711") (object-some (iri "http://semanticscience.org/resource/SIO_000227") (iri "http://semanticscience.org/resource/SIO_000404")) (object-some (iri "http://semanticscience.org/resource/SIO_000710") (iri "http://semanticscience.org/resource/SIO_000707")) :disjoint (iri "http://semanticscience.org/resource/SIO_000707") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a professor role is the role of an individual that is involved in teaching of students (undergraduate and/or graduate) at a post-secondary academic institution." :lang "en")) (label (literal "professor role" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011054") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:30514" :type :RDF_PLAIN_LITERAL)) (label (literal "caesium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011055") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:32594" :type :RDF_PLAIN_LITERAL)) (label (literal "barium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000702") :subclass (iri "http://semanticscience.org/resource/SIO_000112") (object-some (iri "http://semanticscience.org/resource/SIO_000668") (iri "http://semanticscience.org/resource/SIO_000000")) (object-some (iri "http://semanticscience.org/resource/SIO_000697") (iri "http://semanticscience.org/resource/SIO_000701")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to be interacted with is the capability of an object to be target of a physical interaction." :lang "en")) (label (literal "to be interacted with" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000703") :subclass (iri "http://semanticscience.org/resource/SIO_000588") (object-some (iri "http://semanticscience.org/resource/SIO_000312") (iri "http://semanticscience.org/resource/SIO_000000")) :annotation (label (literal "evolving" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "evolving is a process that elicits change across successive generations in the inherited characteristics of biological populations." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000704") :subclass (iri "http://semanticscience.org/resource/SIO_000678") :disjoint (iri "http://semanticscience.org/resource/SIO_000721") :annotation (label (literal "positional role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a positional role is an abstract role which holds by comparing position to another object of reference." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011050") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:30513" :type :RDF_PLAIN_LITERAL)) (label (literal "antimony atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000705") :subclass (iri "http://semanticscience.org/resource/SIO_000315") :annotation (label (literal "design" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a specification of an object, manifested by an agent, intended to accomplish goals, in a particular environment, using a set of primitive components, satisfying a set of requirements, subject to constraints." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011051") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:30452" :type :RDF_PLAIN_LITERAL)) (label (literal "tellurium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000700") :subclass (iri "http://semanticscience.org/resource/SIO_000343") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to disassociate is to cease or break association with some thing." :lang "en")) (label (literal "to disassociate" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000701") :subclass (iri "http://semanticscience.org/resource/SIO_000112") (object-some (iri "http://semanticscience.org/resource/SIO_000668") (iri "http://semanticscience.org/resource/SIO_000000")) (object-some (iri "http://semanticscience.org/resource/SIO_000697") (iri "http://semanticscience.org/resource/SIO_000702")) :annotation (label (literal "to interact with" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to interact with is a capabililty that involves another object." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001175") :subclass (iri "http://semanticscience.org/resource/SIO_001174") :annotation (label (literal "positive nucleic acid strand" :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "forward strand" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "the positive nucleic acid strand refers to the strand that is to be read 5' to 3'." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001174") :subclass (iri "http://semanticscience.org/resource/SIO_010008") (object-some (iri "http://semanticscience.org/resource/SIO_000093") (iri "http://semanticscience.org/resource/SIO_001177")) :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_001175") (iri "http://semanticscience.org/resource/SIO_001176")) :annotation (label (literal "nucleic acid strand" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a nucleic acid strand is a single-stranded nucleic acid that is part of a double stranded nucleic acid complex." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001177") :subclass (iri "http://semanticscience.org/resource/SIO_010506") (object-exactly 2 (iri "http://semanticscience.org/resource/SIO_000053") (iri "http://semanticscience.org/resource/SIO_010008")) :annotation (label (literal "double stranded nucleic acid" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "double stranded nucleic acid is a molecular complex composed of two weakly connected nucleic acids" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001176") :subclass (iri "http://semanticscience.org/resource/SIO_001174") :annotation (label (literal "negative nucleic acid strand" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "the negative nucleic acid strand is the strand that is that is complimentary to the forward strand and appears from 3' to 5'." :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "reverse strand" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001179") :subclass (iri "http://semanticscience.org/resource/SIO_000966") :annotation (label (literal "full agreement" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "agreement is the result of consensus decision making when members of the group unanimously agree." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001178") :subclass (iri "http://semanticscience.org/resource/SIO_001177") (object-exactly 2 (iri "http://semanticscience.org/resource/SIO_000053") (iri "http://semanticscience.org/resource/SIO_010009")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "double stranded nucleic acid is a molecular complex composed of two weakly connected ribonucleic acids" :lang "en")) (label (literal "double stranded RNA" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001171") :subclass (iri "http://semanticscience.org/resource/SIO_000897") :annotation (label (literal "database cross-reference" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a database cross-reference is an association between one data item and another" :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "dbxref" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_001170") :subclass (iri "http://semanticscience.org/resource/SIO_001194") :annotation (label (literal "slideshow" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a slideshow is a visual presentation of information contained within a collection of slides." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001173") :subclass (iri "http://semanticscience.org/resource/SIO_001177") (object-exactly 2 (iri "http://semanticscience.org/resource/SIO_000053") (iri "http://semanticscience.org/resource/SIO_010010")) :annotation (label (literal "double stranded DNA" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "double stranded nucleic acid is a molecular complex composed of two weakly connected deoxyribonucleic acids" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001172") :subclass (iri "http://semanticscience.org/resource/SIO_001171") :annotation (label (literal "exact cross-reference" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an exact cross-reference is a database cross-reference in which one entity is equivalent to the other based on all the entitie's attributes (minus the source)" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011087") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "ununhexium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011088") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "ununseptium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011085") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "ununquadium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011086") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "ununpentium atom" :lang "en")))

(owl-class (iri "http://semanticscience.org/resource/SIO_011089") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "ununoctium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011080") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33361" :type :RDF_PLAIN_LITERAL)) (label (literal "meitnerium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011083") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "copernicium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011084") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "unutrium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011081") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "darmstadtium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33367" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011082") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "roentgenium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33368" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_001188") :subclass (iri "http://semanticscience.org/resource/SIO_001189") :annotation (annotation (iri "http://www.w3.org/2000/01/rdf-schema#seeAlso") (literal "http://en.wikipedia.org/wiki/SADI" :type :XSD_ANY_URI)) (label (literal "SADI semantic web service" :lang "en")) (annotation (iri "http://semanticscience.org/resource/subset") (literal "sadi" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a SADI semantic web service is a semantic web service that follows the SADI specification" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001187") :subclass (iri "http://semanticscience.org/resource/SIO_000752") (object-some (iri "http://semanticscience.org/resource/SIO_000093") (iri "http://semanticscience.org/resource/SIO_000754")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a database row is a row that is part of a database table." :lang "en")) (label (literal "database row" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001186") :subclass (iri "http://semanticscience.org/resource/SIO_000959") :annotation (label (literal "hypothetical" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "hypothetical is the quality of an entity that is conjectured to exist." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001185") :subclass (iri "http://semanticscience.org/resource/SIO_000731") :annotation (label (literal "software process identifier" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a software process identifier is an identifier for a software process in some operating system." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001189") :subclass (iri "http://semanticscience.org/resource/SIO_000140") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a semantic web service is a web service that provides a formal, machine understanble description of its functionality." :lang "en")) (label (literal "semantic web service" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001180") :subclass (iri "http://semanticscience.org/resource/SIO_000994") :annotation (label (literal "mass spectrometry experiment" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a mass spectrometry experiment is an experiment that involves the use of a mass spectrometer. " :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001184") :subclass (iri "http://semanticscience.org/resource/SIO_001018") :annotation (label (literal "slope" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a slope or gradient of a line describes its steepness, incline, or grade. A higher slope value indicates a steeper incline. Slope is normally described by the ratio of the \"rise\" divided by the \"run\" between two points on a line." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001183") :subclass (iri "http://semanticscience.org/resource/SIO_000256") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a statement is a proposition that is either (a) a meaningful declarative sentence that is either true or false, or (b) that which a true or false declarative sentence asserts" :lang "en")) (label (literal "statement" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001182") :subclass (iri "http://semanticscience.org/resource/SIO_000790") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a ribosomal RNA gene is a gene that codes for a ribosomal RNA molecule." :lang "en")) (label (literal "ribosomal RNA gene" :lang "en")) (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "http://purl.obolibrary.org/obo/SO_0001637" :type :XSD_ANY_URI)) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "rRNA gene" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_001181") :subclass (iri "http://semanticscience.org/resource/SIO_000967") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "agreement is the result of consensus decision making when members of the group unanimously disagree." :lang "en")) (label (literal "full disagreement" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011074") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33337" :type :RDF_PLAIN_LITERAL)) (label (literal "actinium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011075") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "rutherfordium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33346" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011076") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33349" :type :RDF_PLAIN_LITERAL)) (label (literal "dubnium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011077") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "seaborgium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33351" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011078") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33355" :type :RDF_PLAIN_LITERAL)) (label (literal "bohrium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011079") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "hassium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33357" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011070") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:30415" :type :RDF_PLAIN_LITERAL)) (label (literal "astatine atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011071") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33314" :type :RDF_PLAIN_LITERAL)) (label (literal "radon atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011072") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33323" :type :RDF_PLAIN_LITERAL)) (label (literal "francium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011073") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33325" :type :RDF_PLAIN_LITERAL)) (label (literal "radium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001150") :subclass (iri "http://semanticscience.org/resource/SIO_001145") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A process that modulates the frequency, rate or extent of process involved in the consumption of an object." :lang "en")) (label (literal "regulation of object consumption" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001151") :subclass (iri "http://semanticscience.org/resource/SIO_001145") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "regulation of a participant quantity is the regulation of a process in which the quantity of a selected participant is increased." :lang "en")) (label (literal "regulation of object production" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000026") :subclass (iri "http://semanticscience.org/resource/SIO_000005") (object-some (iri "http://semanticscience.org/resource/SIO_000218") (iri "http://semanticscience.org/resource/SIO_000776")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An object quality is quality of an object." :lang "en")) (label (literal "object quality" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010793") :subclass (iri "http://semanticscience.org/resource/SIO_010786") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "chaoite is an allotrope of carbon that is slightly harder than graphite with a reflection colour of grey to white." :lang "en")) (label (literal "chaoite" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010792") :subclass (iri "http://semanticscience.org/resource/SIO_010786") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "carbon nanofoam is an allotrope of carbon that consists of a low-density cluster-assembly of carbon atoms strung together in a loose three-dimensional web. Each cluster is about 6 nanometers wide and consists of about 4000 carbon atoms linked in graphite-like sheets that are given negative curvature by the inclusion of heptagons among the regular hexagonal pattern." :lang "en")) (label (literal "carbon nanofoam" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010795") :subclass (iri "http://semanticscience.org/resource/SIO_010786") :annotation (label (literal "ionsdaleite" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "ionsdaleite is a hexagonal allotrope of the carbon allotrope diamond." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010794") :subclass (iri "http://semanticscience.org/resource/SIO_010786") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "glassy carbon is an allotrope of carbon which is widely used as an electrode material in electrochemistry, as well as for high temperature crucibles and as a component of some prosthetic devices." :lang "en")) (label (literal "glassy carbon" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000022") :subclass (iri "http://semanticscience.org/resource/SIO_000783") (object-some (iri "http://semanticscience.org/resource/SIO_000096") (iri "http://semanticscience.org/resource/SIO_000004")) :annotation (annotation (iri "http://semanticscience.org/resource/example") (literal "the external surface of the window; the surface of the p52 protein" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A material boundary is the boundary of a material entity which exists as a lower dimensional entity at exactly the location where its parts no longer extend into space. Every material entity has a boundary, and a boundary is the boundary of exactly 1 material entity." :lang "en")) (label (literal "material boundary" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001152") :subclass (iri "http://semanticscience.org/resource/SIO_001151") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "maintenance of quantity of object production is a regulation of object production in which the number of objects produced is held more or less constant." :lang "en")) (label (literal "maintenance of quantity of object production" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001153") :subclass (iri "http://semanticscience.org/resource/SIO_001150") :annotation (label (literal "maintenance of level of object consumption" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "regulation of a participant quantity is the regulation of a process in which the quantity of a selected participant is maintained at a steady level." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010791") :subclass (iri "http://semanticscience.org/resource/SIO_010786") :annotation (label (literal "amorphous carbon" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Amorphous carbon is an allotrope of carbon that does not have any crystalline structure. As with all glassy materials, some short-range order can be observed, but there is no long-range pattern of atomic positions." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010790") :subclass (iri "http://semanticscience.org/resource/SIO_010786") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "aggregate of carbon nanorods is an allotrope of carbon considered to be the least compressible material known, as measured by its isothermal bulk modulus; aggregated diamond nanorods have a modulus of 491 gigapascals (GPa), while a conventional diamond has a modulus of 442 GPa. ADNRs are also 0.3% denser than regular diamond." :lang "en")) (label (literal "aggregated carbon nanorods" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000027") :subclass (iri "http://semanticscience.org/resource/SIO_000005") (object-some (iri "http://semanticscience.org/resource/SIO_000218") (iri "http://semanticscience.org/resource/SIO_000006")) :annotation (label (literal "process quality" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A process quality is quality that is associated with a process." :lang "en")))

(owl-class (iri "http://semanticscience.org/resource/SIO_001161") :subclass (iri "http://semanticscience.org/resource/SIO_000794") :annotation (label (literal "number of objects consumed" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "number of objects consumed is a count of objects that were consumed in some process." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001162") :subclass (iri "http://semanticscience.org/resource/SIO_000794") :annotation (label (literal "difference in number of objects produced" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a difference in number of objects produced is a count of the number of objects produced with respect to a second variable (space, time, etc)" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001160") :subclass (iri "http://semanticscience.org/resource/SIO_000794") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "number of objects produced is a count of objects that were produced in some process." :lang "en")) (label (literal "number of objects produced" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000035") :subclass (iri "http://semanticscience.org/resource/SIO_000033") :disjoint (iri "http://semanticscience.org/resource/SIO_000034") (iri "http://semanticscience.org/resource/SIO_000963") (iri "http://semanticscience.org/resource/SIO_000995") (iri "http://semanticscience.org/resource/SIO_000997") :annotation (label (literal "ongoing" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "ongoing is the status of a process that is not yet complete." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001169") :subclass (iri "http://semanticscience.org/resource/SIO_000159") (object-some (iri "http://semanticscience.org/resource/SIO_000093") (iri "http://semanticscience.org/resource/SIO_000162")) :annotation (label (literal "issue" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an issue is a single instance of a periodically published journal, magazine, or newspaper." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010784") :subclass (iri "http://semanticscience.org/resource/SIO_010674") (object-exactly 1 (iri "http://semanticscience.org/resource/SIO_000273") (iri "http://semanticscience.org/resource/SIO_010457")) (object-exactly 1 (iri "http://semanticscience.org/resource/SIO_000273") (iri "http://semanticscience.org/resource/SIO_010458")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an ionic compound is a mereological maximal sum of weakly connected paired positive and negative ions." :lang "en")) (label (literal "ionic compound" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000034") :subclass (iri "http://semanticscience.org/resource/SIO_000033") :disjoint (iri "http://semanticscience.org/resource/SIO_000035") (iri "http://semanticscience.org/resource/SIO_000963") (iri "http://semanticscience.org/resource/SIO_000995") (iri "http://semanticscience.org/resource/SIO_000997") :annotation (label (literal "completed" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "completed is that status of a process that successfully unfolds." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010783") :subclass (iri "http://semanticscience.org/resource/SIO_010780") :disjoint (iri "http://semanticscience.org/resource/SIO_010782") :annotation (label (literal "homocyclic ring" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A homocyclic ring is a ring where the atoms are of a single type." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000037") :subclass (iri "http://semanticscience.org/resource/SIO_000258") (object-some (iri "http://semanticscience.org/resource/SIO_000011") (iri "http://semanticscience.org/resource/SIO_000776")) (object-some (iri "http://semanticscience.org/resource/SIO_000216") (iri "http://semanticscience.org/resource/SIO_000052")) :annotation (label (literal "spatial quantity" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a spatial quantity is a quantity obtained from measuring the spatial extent of an entity " :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "physical dimensional quantity" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001167") :subclass (iri "http://semanticscience.org/resource/SIO_000256") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a comment is a verbal or written remark often related to an added piece of information, or an observation or statement." :lang "en")) (label (literal "comment" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010782") :subclass (iri "http://semanticscience.org/resource/SIO_010780") :disjoint (iri "http://semanticscience.org/resource/SIO_010783") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a heterocyclic ring is a ring containing a hetero atom." :lang "en")) (label (literal "heterocyclic ring" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000036") :subclass (iri "http://semanticscience.org/resource/SIO_001186") :annotation (label (literal "predicted" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "predicted is the quality of an entity that is thought to exist, as evidenced by some rational procedure." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001168") :subclass (iri "http://semanticscience.org/resource/SIO_001194") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an audio recording is an electrical or mechanical inscription and re-creation of sound waves, such as spoken voice, singing, instrumental music, or sound effects." :lang "en")) (label (literal "audio recording" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010781") :subclass (iri "http://semanticscience.org/resource/SIO_010780") :annotation (label (literal "aromatic ring" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An aromatic ring is a ring in which the electrons are delocalized across all atoms in the ring." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000031") :subclass (iri "http://semanticscience.org/resource/SIO_000418") :annotation (label (literal "start date" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a start date is a time instant pertaining to the date of the beginning of a process." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001165") :subclass (iri "http://semanticscience.org/resource/SIO_000602") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an user account allows a user to authenticate to system services and be granted authorization to access them." :lang "en")) (label (literal "user account" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010780") :subclass (iri "http://semanticscience.org/resource/SIO_000624") (object-at-least 3 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_010044")) :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_010782") (iri "http://semanticscience.org/resource/SIO_010783")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a ring is a submolecule with a circular topology." :lang "en")) (label (literal "ring" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000030") :subclass (iri "http://semanticscience.org/resource/SIO_010014") (object-some (iri "http://semanticscience.org/resource/SIO_000210") (object-or (iri "http://semanticscience.org/resource/SIO_000626") (object-some (iri "http://semanticscience.org/resource/SIO_000011") (iri "http://semanticscience.org/resource/SIO_000092")))) (object-some (iri "http://semanticscience.org/resource/SIO_000563") (iri "http://semanticscience.org/resource/SIO_000092")) (data-some (iri "http://semanticscience.org/resource/SIO_000300") :XSD_STRING) :annotation (label (literal "biopolymer sequence" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A sequence is a primary structure descriptor in which each of the letters in the string represents a monomeric unit (residue) in which adjacent letters represent the connectivity between the monomeric units." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001166") :subclass (iri "http://semanticscience.org/resource/SIO_000136") (object-some (iri "http://semanticscience.org/resource/SIO_000668") (iri "http://semanticscience.org/resource/SIO_000000")) :annotation (label (literal "annotation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An annotation is a written explanatory or critical description, or other in-context information (e.g., pattern, motif, link), that has been associated with data or other types of information." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000033") :subclass (iri "http://semanticscience.org/resource/SIO_000027") (object-some (iri "http://semanticscience.org/resource/SIO_000011") (iri "http://semanticscience.org/resource/SIO_000006")) :annotation (label (literal "process status" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "process status is a process quality that describes the state of a process." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001163") :subclass (iri "http://semanticscience.org/resource/SIO_001162") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an increase in the number of objects produced is the positive value of a difference in number of objects produced." :lang "en")) (label (literal "increase in number of objects produced" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000032") :subclass (iri "http://semanticscience.org/resource/SIO_000418") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an end date is a time instant pertaining to date of the end of a process." :lang "en")) (label (literal "end date" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001164") :subclass (iri "http://semanticscience.org/resource/SIO_001162") :annotation (label (literal "decrease in number of objects produced" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an decrease in the number of objects produced is the negative value of a difference in number of objects produced." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011093") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33373" :type :RDF_PLAIN_LITERAL)) (label (literal "promethium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011092") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33372" :type :RDF_PLAIN_LITERAL)) (label (literal "neodymium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010789") :subclass (iri "http://semanticscience.org/resource/SIO_010786") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Fullerene is a carbon allotrope which take the form of a hollow sphere, ellipsoid, or tube." :lang "en")) (label (literal "fullerene" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011095") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "europium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:32999" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011094") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33374" :type :RDF_PLAIN_LITERAL)) (label (literal "samarium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000038") :subclass (iri "http://semanticscience.org/resource/SIO_000037") :annotation (label (literal "1D extent quantity" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a quantity that extends in single dimension" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010787") :subclass (iri "http://semanticscience.org/resource/SIO_010786") :annotation (label (literal "diamond" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Diamond is a carbon allotrope in which each carbon atom in diamond is covalently bonded to four other carbons in a tetrahedron. These tetrahedrons together form a 3-dimensional network of puckered six-membered rings of atoms." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000039") :subclass (iri "http://semanticscience.org/resource/SIO_000038") :annotation (label (literal "depth" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "depth is the dimensional extent into a plane of a 3D projection of the object." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010788") :subclass (iri "http://semanticscience.org/resource/SIO_010786") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "graphite is an allotrope of carbon which is a conductor, and is the most stable form of solid carbon." :lang "en")) (label (literal "graphite" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010785") :subclass (iri "http://semanticscience.org/resource/SIO_010037") :annotation (label (literal "allotrope" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an allotrope is a structural variant of a chemical element." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011091") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:49828" :type :RDF_PLAIN_LITERAL)) (label (literal "praseodymium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010786") :subclass (iri "http://semanticscience.org/resource/SIO_010785") (object-only (iri "http://semanticscience.org/resource/SIO_000273") (iri "http://semanticscience.org/resource/SIO_011001")) :annotation (label (literal "carbon allotrope" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a carbon allotrope is a chemical substance composed of carbon" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011090") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "cerium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33369" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011097") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "terbium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33376" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011096") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "gadolinium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33375" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011099") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "holmium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:49648" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011098") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "dysprosium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33377" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000000") :annotation (label (literal "entity" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Every thing is an entity." :lang "en")) (annotation (iri "http://semanticscience.org/resource/subset") (literal "core" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_001130") :subclass (iri "http://semanticscience.org/resource/SIO_001126") (object-some (iri "http://semanticscience.org/resource/SIO_000139") (iri "http://semanticscience.org/resource/SIO_010043")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A process mediated by a protein that modulates the frequency, rate or extent of translation." :lang "en")) (label (literal "protein mediated regulation of translation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001131") :subclass (iri "http://semanticscience.org/resource/SIO_001126") (object-some (iri "http://semanticscience.org/resource/SIO_000139") (iri "http://semanticscience.org/resource/SIO_010450")) :annotation (label (literal "rna mediated regulation of translation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A process mediated by rna that modulates the frequency, rate or extent of translation." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001132") :subclass (iri "http://semanticscience.org/resource/SIO_000609") :annotation (label (literal "process maintenance" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "the process of maintaining some the frequency, rate or extent of another process." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001133") :subclass (iri "http://semanticscience.org/resource/SIO_001135") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "the increase of regulation leads to a increased occurence of processes of the target type." :lang "en")) (label (literal "increased frequency of process from increased regulation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001134") :subclass (iri "http://semanticscience.org/resource/SIO_001135") :annotation (label (literal "decreased frequency of process from increased regulation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "the increase of regulation leads to a decreased occurence of processes of the target process type." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000004") :subclass (iri "http://semanticscience.org/resource/SIO_000776") (object-some (iri "http://semanticscience.org/resource/SIO_000008") (iri "http://semanticscience.org/resource/SIO_000279")) (object-only (iri "http://semanticscience.org/resource/SIO_000053") (iri "http://semanticscience.org/resource/SIO_000004")) :annotation (label (literal "material entity" :lang "en")) (annotation (iri "http://semanticscience.org/resource/subset") (literal "core" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "A material entity is a physical entity that is spatially extended, exists as a whole at any point in time and has mass." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001135") :subclass (iri "http://semanticscience.org/resource/SIO_000609") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "regulation of a process duration is a process that modulates the frequency of another process relative to some reference process." :lang "en")) (label (literal "regulation of process frequency" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001136") :subclass (iri "http://semanticscience.org/resource/SIO_000609") :annotation (label (literal "regulation of process duration" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "regulation of a process duration is a process that modulates the duration of another process relative to some reference process." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001137") :subclass (iri "http://semanticscience.org/resource/SIO_001136") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "increased duration of process from increased regulation is a process in which the duration of the target process is increased as a result of increased regulation." :lang "en")) (label (literal "increased duration of process from increased regulation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001139") :subclass (iri "http://semanticscience.org/resource/SIO_000609") :annotation (annotation (iri "http://semanticscience.org/resource/example") (literal "heating the solution causes greater diffusion of a chemical." :lang "en")) (label (literal "regulation of process spatial extent" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "regulation of a process spatial extent is a process that modulates the spatial extent of another process relative to some reference process." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010775") :subclass (iri "http://semanticscience.org/resource/SIO_010455") :annotation (label (literal "stereoisomer" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A stereoisomer is an isomer in which the atomic connectivity is the same, but differs in its spatial arrangement of atoms." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001138") :subclass (iri "http://semanticscience.org/resource/SIO_001136") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "decreased duration of process from increased regulation is a process in which the duration of the target process is decreased as a result of increased regulation." :lang "en")) (label (literal "decreased duration of process from increased regulation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010776") :subclass (iri "http://semanticscience.org/resource/SIO_010775") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A diastereomer is a stereoisomer that is not a mirror image of its isomer." :lang "en")) (label (literal "diastereomer" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000005") :subclass (iri "http://semanticscience.org/resource/SIO_000614") (object-some (iri "http://semanticscience.org/resource/SIO_000218") (iri "http://semanticscience.org/resource/SIO_000000")) :disjoint (iri "http://semanticscience.org/resource/SIO_000340") :annotation (annotation (iri "http://semanticscience.org/resource/subset") (literal "core" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "A quality is an attribute that is intrinsically associated with its bearer (or its parts), but whose presence/absence and observed/measured value may vary." :lang "en")) (label (literal "quality" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010777") :subclass (iri "http://semanticscience.org/resource/SIO_010775") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An enantiomer is a stereoisomer that is a mirror image of its isomer." :lang "en")) (label (literal "enantiomer" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000006") :subclass (iri "http://semanticscience.org/resource/SIO_000000") (object-only (iri "http://semanticscience.org/resource/SIO_000053") (iri "http://semanticscience.org/resource/SIO_000006")) (object-only (iri "http://semanticscience.org/resource/SIO_000687") (iri "http://semanticscience.org/resource/SIO_000417")) :disjoint (iri "http://semanticscience.org/resource/SIO_000614") (iri "http://semanticscience.org/resource/SIO_000776") :annotation (annotation (iri "http://semanticscience.org/resource/subset") (literal "core" :type :RDF_PLAIN_LITERAL)) (label (literal "process" :lang "en")) (annotation (iri "http://semanticscience.org/resource/subset") (literal "process+" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "A process is an entity that is identifiable only through the unfolding of time, has temporal parts, and unless otherwise specified/predicted, cannot be identified from any instant of time in which it exists." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010778") :subclass (iri "http://semanticscience.org/resource/SIO_010775") :annotation (label (literal "optical isomer" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An optical isomer is a stereoisomer that rotates the plane of polarization of a beam of plane polarized light." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010779") :subclass (iri "http://semanticscience.org/resource/SIO_010455") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A structural isomer is an isomer in which the atoms are joined together in different ways." :lang "en")) (label (literal "structural isomer" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000009") :subclass (iri "http://semanticscience.org/resource/SIO_000015") :annotation (label (literal "social entity" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a social entity pertains to the interaction among individuals and groups." :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_001140") :subclass (iri "http://semanticscience.org/resource/SIO_001139") :annotation (label (literal "increased spatial extent of process from increased regulation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "the increase of regulation leads to a increased spatial extent of the target process." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001143") :subclass (iri "http://semanticscience.org/resource/SIO_001136") :annotation (label (literal "maintenance of duration of process" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "maintenance of duration of process is a process that regulates a target process to maintain its duration within an expected interval." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001144") :subclass (iri "http://semanticscience.org/resource/SIO_001135") :annotation (label (literal "maintenance of frequency of process" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "maintenance of frequency of process is a process that regulates the number of occurences of a target process type to a specified number or interval." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001141") :subclass (iri "http://semanticscience.org/resource/SIO_001139") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "the increase of regulation leads to a decreased spatial extent of the target process." :lang "en")) (label (literal "decreased spatial extent of process from decreased regulation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001142") :subclass (iri "http://semanticscience.org/resource/SIO_001139") :annotation (label (literal "maintenance of spatial extent of process" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "maintenance of spatial extent of process is a regulation of a process' spatial extent within some specified parameter." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000010") :subclass (iri "http://semanticscience.org/resource/SIO_000009") (object-only (iri "http://semanticscience.org/resource/SIO_000059") (iri "http://semanticscience.org/resource/SIO_000776")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A social structure is a social entity which consists of relationships between two or more entities." :lang "en")) (label (literal "social structure" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001147") :subclass (iri "http://semanticscience.org/resource/SIO_001151") :annotation (label (literal "decreased object production from increased regulation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "increased regulation leads to a decrease in the number of target objects of a specified type." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000013") :subclass (iri "http://semanticscience.org/resource/SIO_000056") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a geographic position is the coordinate of an entity against some geographic coordinate system." :lang "en")) (label (literal "geographic position" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001148") :subclass (iri "http://semanticscience.org/resource/SIO_001150") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "increased regulation leads to an increase in the consumption of an object of specified type." :lang "en")) (label (literal "increased object consumption from increased regulation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000012") :subclass (iri "http://semanticscience.org/resource/SIO_000620") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An organization is a collective with a complex articulation of tasks, roles and responsibilities." :lang "en")) (label (literal "organization" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001145") :subclass (iri "http://semanticscience.org/resource/SIO_000609") (object-some (iri "http://semanticscience.org/resource/SIO_001154") (iri "http://semanticscience.org/resource/SIO_000052")) :annotation (label (literal "regulation of object quantity" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "regulation of a participant quantity is the regulation of a process in which the quantity of its partcipants is changed." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000015") :subclass (iri "http://semanticscience.org/resource/SIO_000776") (object-only (iri "http://semanticscience.org/resource/SIO_000053") (iri "http://semanticscience.org/resource/SIO_000015")) :annotation (annotation (iri "http://semanticscience.org/resource/subset") (literal "ice+" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://semanticscience.org/resource/subset") (literal "core" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "information content entity is an object that requires some background knowledge or procedure to correctly interpret." :lang "en")) (label (literal "information content entity" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001146") :subclass (iri "http://semanticscience.org/resource/SIO_001151") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "increased regulation leads to an increase in the number of target objects of a specified type." :lang "en")) (label (literal "increased object production from increased regulation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000014") :subclass (iri "http://semanticscience.org/resource/SIO_000112") (object-some (iri "http://semanticscience.org/resource/SIO_000008") (iri "http://semanticscience.org/resource/SIO_000638")) :annotation (annotation (iri "http://semanticscience.org/resource/example") (literal "solubility (to dissolve when put in fluid); fragility (disposition to break when dropped)" :lang "en")) (annotation (iri "http://semanticscience.org/resource/subset") (literal "core" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "A disposition is the tendency of a capability to be exhibited under certain conditions or in response to a certain stimulus (trigger)" :lang "en")) (label (literal "disposition" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000016") :subclass (iri "http://semanticscience.org/resource/SIO_000340") :annotation (label (literal "role" :lang "en")) (annotation (iri "http://semanticscience.org/resource/subset") (literal "core" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "A role is a realizable entity that describes behaviours, rights and obligations of an entity in some particular circumstance." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000017") :subclass (iri "http://semanticscience.org/resource/SIO_000112") :disjoint (iri "http://semanticscience.org/resource/SIO_000354") :annotation (annotation (iri "http://semanticscience.org/resource/subset") (literal "core" :type :RDF_PLAIN_LITERAL)) (label (literal "function" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A function is a capability that satisfies some agentive objective, or (evolutionary) optimization." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001149") :subclass (iri "http://semanticscience.org/resource/SIO_001150") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "increased regulation leads to an decrease in the consumption of an object of specified type." :lang "en")) (label (literal "decreased object consumption from increased regulation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000019") :subclass (iri "http://semanticscience.org/resource/SIO_000370") :annotation (label (literal "site" :lang "en")) (annotation (iri "http://semanticscience.org/resource/example") (literal "a nostril; the interior of the heart valve; the interior of a bottle;" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A site is a spatial region bounded (in part or in whole) by material entities and may be occupied by material entities." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000498") :subclass (iri "http://semanticscience.org/resource/SIO_000485") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A person is a being that has certain capacities or attributes constituting personhood" :lang "en")) (label (literal "person" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000499") :subclass (iri "http://semanticscience.org/resource/SIO_000536") :annotation (label (literal "to decrease the rate of formation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to decrease the rate of formation is to regulate the rate of formation in a manner that decreases this rate relative to a reference process." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000494") :subclass (iri "http://semanticscience.org/resource/SIO_000701") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to actively interact with is the capability to interact with another entity in a way that requires physical contact." :lang "en")) (label (literal "to actively interact with" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000492") :subclass (iri "http://semanticscience.org/resource/SIO_000494") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to consume is the capability to internalize a material entity." :lang "en")) (label (literal "to consume" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000493") :subclass (iri "http://semanticscience.org/resource/SIO_000113") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A clause consists of a subject and a predicate." :lang "en")) (label (literal "clause" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000738") :characteristic :symmetric)
(object-property (iri "http://semanticscience.org/resource/SIO_000737") :domain (iri "http://semanticscience.org/resource/SIO_000052") :range (iri "http://semanticscience.org/resource/SIO_000052") :characteristic :symmetric)
(object-property (iri "http://semanticscience.org/resource/SIO_000736") :characteristic :symmetric)
(object-property (iri "http://semanticscience.org/resource/SIO_000735") :inverse (iri "http://semanticscience.org/resource/SIO_000734"))
(object-property (iri "http://semanticscience.org/resource/SIO_000734") :inverse (iri "http://semanticscience.org/resource/SIO_000735"))
(object-property (iri "http://semanticscience.org/resource/SIO_000733") :inverse (iri "http://semanticscience.org/resource/SIO_000699"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000480") :subclass (iri "http://semanticscience.org/resource/SIO_000478") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an insertion variant role is the role of an sequence that contains a sub-sequence that is considered to be an addition relative to the frame of reference." :lang "en")) (label (literal "insertion variant role" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000485") :subclass (iri "http://semanticscience.org/resource/SIO_010375") :annotation (label (literal "human" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a human is a primates of the family Hominidae and are characterized by having a large brain relative to body size, with a well developed neocortex, prefrontal cortex and temporal lobes, making them capable of abstract reasoning, language, introspection, problem solving and culture through social learning." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000486") :subclass (iri "http://semanticscience.org/resource/SIO_010375") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A mouse is a small mammal belonging to the order of rodents, characteristically having a pointed snout, small rounded ears, and a long naked or almost hairless tail. " :lang "en")) (label (literal "mouse" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000487") :subclass (iri "http://semanticscience.org/resource/SIO_010375") :annotation (label (literal "rat" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a rat is a medium-sized, long-tailed rodent of the superfamily Muroidea." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000488") :subclass (iri "http://semanticscience.org/resource/SIO_010375") :annotation (label (literal "worm" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a worm is a non-arthropod invertebrate animal that typically have a long cylindrical tube-like body and no legs." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000481") :subclass (iri "http://semanticscience.org/resource/SIO_000478") :annotation (label (literal "deletion variant role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a deletion variant role is the role of an sequence that lacks a sub-sequence relative to the frame of reference." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000483") :subclass (iri "http://semanticscience.org/resource/SIO_000078") (object-at-least 2 (iri "http://semanticscience.org/resource/SIO_000273") (iri "http://semanticscience.org/resource/SIO_000114")) :annotation (label (literal "phrase" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A phrase is a group of words functioning as a single unit in the syntax of a sentence." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000489") :subclass (iri "http://semanticscience.org/resource/SIO_010376") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Escherichia coli (e coli) is a Gram-negative, rod-shaped bacterium that is commonly found in the lower intestine of warm-blooded organisms." :lang "en")) (label (literal "e.coli" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000749") :characteristic :symmetric)
(object-property (iri "http://semanticscience.org/resource/SIO_000709") :characteristic :symmetric)
(object-property (iri "http://semanticscience.org/resource/SIO_000710") :characteristic :symmetric)
(owl-class (iri "http://semanticscience.org/resource/SIO_000455") :subclass (iri "http://semanticscience.org/resource/SIO_000450") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_000456") (iri "http://semanticscience.org/resource/SIO_000457")) :disjoint (iri "http://semanticscience.org/resource/SIO_000458") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A category axis is an axis in which the position along the line is \npartioned into categories." :lang "en")) (label (literal "category axis" :lang "en")) (annotation (iri "http://semanticscience.org/resource/example") (literal "The horizontal axis corresponding to months of the year in graph 4 \nof http://tinyurl.com/opwnvm" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000454") :subclass (iri "http://semanticscience.org/resource/SIO_000451") :disjoint (iri "http://semanticscience.org/resource/SIO_000452") :annotation (label (literal "z-axis" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A z-axis is a Cartesian coordinate axis that is spatially oriented \nnormal to the plane formed by the x- and y-axes." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000453") :subclass (iri "http://semanticscience.org/resource/SIO_000451") :disjoint (iri "http://semanticscience.org/resource/SIO_000452") :annotation (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "vertical axis" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "A y-axis is a Cartesian coordinate axis that is spatially oriented \nperpendicular to the x-axis." :lang "en")) (label (literal "y-axis" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000452") :subclass (iri "http://semanticscience.org/resource/SIO_000451") :disjoint (iri "http://semanticscience.org/resource/SIO_000453") (iri "http://semanticscience.org/resource/SIO_000454") :annotation (label (literal "x-axis" :lang "en")) (annotation (iri "http://semanticscience.org/resource/example") (literal "The horizontal axis in http://tinyurl.com/opwnvm" :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "horizontal axis" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "An x-axis is a Cartesian coordinate axis that is aligned with the horizon." :lang "en")) (owl-comment (literal "In most figures, this axis represents categories, such as months, \nmarket segments, or other non-numeric data." :type :RDF_PLAIN_LITERAL)))
(object-property (iri "http://semanticscience.org/resource/SIO_001096") :inverse (iri "http://semanticscience.org/resource/SIO_001097"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000451") :subclass (iri "http://semanticscience.org/resource/SIO_000458") (object-some (iri "http://semanticscience.org/resource/SIO_000362") (iri "http://semanticscience.org/resource/SIO_000321")) :annotation (label (literal "Cartesian coordinate axis" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A Cartesian coordinate axis is an axis whose behavior follows that of a Cartesian coordinate system." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000450") :subclass (iri "http://semanticscience.org/resource/SIO_000521") (object-some (iri "http://semanticscience.org/resource/SIO_000313") (iri "http://semanticscience.org/resource/SIO_000083")) :annotation (annotation (iri "http://semanticscience.org/resource/example") (literal "The left vertical and bottom horizontal lines with tickmarks in \nGraph 1 http://tinyurl.com/opwnvm" :lang "en")) (owl-comment (literal "The value of a plotted geometric objects (e.g. point) can be obtained from the perpendicular projection of the position of the object onto the axis. Axis may also be associated with a textual description of what the values on the axis represents." :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "An axis is a line segment that is part of a statistical graph in which the \nposition along the line corresponds to a numeric or categorical value." :lang "en")) (label (literal "axis" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000458") :subclass (iri "http://semanticscience.org/resource/SIO_000450") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_000459") (iri "http://semanticscience.org/resource/SIO_000460") (iri "http://semanticscience.org/resource/SIO_000902") (iri "http://semanticscience.org/resource/SIO_000903")) :disjoint (iri "http://semanticscience.org/resource/SIO_000455") :annotation (owl-comment (literal "A value axis holds the properties of having a minimum and a \nmaximum value, and is usually associated with tickmarks that indicate \nintervals along the axis." :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "A value axis is an axis in which the position along the line is \npartioned into numeric values." :lang "en")) (annotation (iri "http://semanticscience.org/resource/example") (literal "The value axis that ranges from 3.0 to 7.4 and corresponds to \nbillions of dollars in Graph 1 of http://tinyurl.com/opwnvm" :lang "en")) (label (literal "value axis" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_001098") :inverse (iri "http://semanticscience.org/resource/SIO_001098") :characteristic :symmetric)
(owl-class (iri "http://semanticscience.org/resource/SIO_000459") :subclass (iri "http://semanticscience.org/resource/SIO_000458") :disjoint (iri "http://semanticscience.org/resource/SIO_000460") (iri "http://semanticscience.org/resource/SIO_000902") (iri "http://semanticscience.org/resource/SIO_000903") :annotation (annotation (iri "http://semanticscience.org/resource/example") (literal "The value axis that ranges from 3.0 to 7.4 and corresponds to billions of dollars in Graph 1 of http://tinyurl.com/opwnvm" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A left value axis is a value axis that is spatially positioned to the left of the plot area." :lang "en")) (label (literal "left value axis" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_001097") :inverse (iri "http://semanticscience.org/resource/SIO_001096"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000456") :subclass (iri "http://semanticscience.org/resource/SIO_000455") :disjoint (iri "http://semanticscience.org/resource/SIO_000457") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A primary category axis is a category axis that either defines the sole value range or holds the larger set of categorical values specified by the secondary category axis." :lang "en")) (label (literal "primary category axis" :lang "en")) (annotation (iri "http://semanticscience.org/resource/example") (literal "The category axis that corresponds to years in Graph 1 of \nhttp://tinyurl.com/opwnvm" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000457") :subclass (iri "http://semanticscience.org/resource/SIO_000455") :disjoint (iri "http://semanticscience.org/resource/SIO_000456") :annotation (annotation (iri "http://semanticscience.org/resource/example") (literal "The category axis that corresponds to months in Graph 1 of \nhttp://tinyurl.com/opwnvm" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A secondary category axis is a category axis that defines a finer \ngranular part (or subset) of the value range of the primary category axis." :lang "en")) (label (literal "secondary category axis" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000442") :subclass (iri "http://semanticscience.org/resource/SIO_000083") :annotation (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "line chart" :lang "en")) (label (literal "line graph" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A line graph is a statistical graph in which lines contains the evaluation of functions or individual points connected by line segments." :lang "en")) (annotation (iri "http://semanticscience.org/resource/example") (literal "Graph 1 in http://tinyurl.com/opwnvm" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000441") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_000507") (object-only (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_000402")) (object-exactly 1 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_000402"))) :annotation (label (literal "1D cartesian point" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a 1D cartesian point is a point whose position is specified along a single dimension using Cartesian coordinates." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000444") :subclass (iri "http://semanticscience.org/resource/SIO_000443") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A horizontal bar graph is a bar graph in which the rectangular bars \nare horizontally oriented in space." :lang "en")) (label (literal "horizontal bar graph" :lang "en")) (annotation (iri "http://semanticscience.org/resource/example") (literal "Graph 3 in http://tinyurl.com/opwnvm" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000443") :subclass (iri "http://semanticscience.org/resource/SIO_000083") :annotation (annotation (iri "http://semanticscience.org/resource/example") (literal "Graphs 3,4,5 in http://tinyurl.com/opwnvm" :lang "en")) (label (literal "bar graph" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A bar graph is a statistical graph with rectangular bars of lengths proportional to that value that they represent." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000440") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_000507") (object-exactly 1 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_000400")) (object-exactly 1 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_000401")) (object-exactly 1 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_000402"))) :annotation (label (literal "3D cartesian point" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a 3D cartesian point is a point whose position is specified along three  dimensions using Cartesian coordinates." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000449") :subclass (iri "http://semanticscience.org/resource/SIO_000448") :disjoint (iri "http://semanticscience.org/resource/SIO_000468") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A plot is a part of a figure that corresponds to the spatial region between the set of axes." :lang "en")) (label (literal "plot" :lang "en")) (annotation (iri "http://semanticscience.org/resource/example") (literal "The square portion of the chart bounded by lines that overlap with \nthe two axes in Graph 1 of http://tinyurl.com/opwnvm" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000445") :subclass (iri "http://semanticscience.org/resource/SIO_000443") :annotation (annotation (iri "http://semanticscience.org/resource/example") (literal "Graph 4,5 in http://tinyurl.com/opwnvm" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A vertical bar graph is a bar graph in which the rectangular bars are \nvertically oriented in space." :lang "en")) (label (literal "vertical bar graph" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000446") :subclass (iri "http://semanticscience.org/resource/SIO_000443") :annotation (label (literal "stacked bar graph" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A stacked bar graph is a bar graph in which each rectangular bar is \npartioned by the categorical value of each series of data." :lang "en")) (annotation (iri "http://semanticscience.org/resource/example") (literal "Graphs 6,7 in http://tinyurl.com/opwnvm" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000447") :subclass (iri "http://semanticscience.org/resource/SIO_000083") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A line-bar graph statistical graph that contains both lines and bars." :lang "en")) (label (literal "line-bar graph" :lang "en")) (annotation (iri "http://semanticscience.org/resource/example") (literal "Graph 8 in http://tinyurl.com/opwnvm" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000448") :subclass (iri "http://semanticscience.org/resource/SIO_001194") (object-some (iri "http://semanticscience.org/resource/SIO_000093") (iri "http://semanticscience.org/resource/SIO_000080")) :disjoint (iri "http://semanticscience.org/resource/SIO_000080") :annotation (label (literal "figure part" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a figure part is a part of a figure." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000473") :subclass (iri "http://semanticscience.org/resource/SIO_000470") (object-some (iri "http://semanticscience.org/resource/SIO_000310") (iri "http://semanticscience.org/resource/SIO_000083")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A primary graph title is a primary title that describes a statistical \ngraph." :lang "en")) (annotation (iri "http://semanticscience.org/resource/example") (literal "\"Total value of permits increased slightly in December\" in Graph 1 of http://tinyurl.com/opwnvm" :lang "en")) (label (literal "primary graph title" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000472") :subclass (iri "http://semanticscience.org/resource/SIO_000069") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "scientific data is data obtained from some scientific procedure." :lang "en")) (label (literal "scientific data" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000471") :subclass (iri "http://semanticscience.org/resource/SIO_000185") :annotation (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "subtitle, alternative title" :type :RDF_PLAIN_LITERAL)) (label (literal "secondary title" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A secondary title is a title of lesser importance that should be used after the first title in describing some entity." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000470") :subclass (iri "http://semanticscience.org/resource/SIO_000185") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A primary title is a title that should be first used in describing some entity." :lang "en")) (label (literal "primary title" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000476") :subclass (iri "http://semanticscience.org/resource/SIO_000475") (object-some (iri "http://semanticscience.org/resource/SIO_000218") (iri "http://semanticscience.org/resource/SIO_010001")) :disjoint (iri "http://semanticscience.org/resource/SIO_001014") (iri "http://semanticscience.org/resource/SIO_001015") (iri "http://semanticscience.org/resource/SIO_010029") (iri "http://semanticscience.org/resource/SIO_010056") (iri "http://semanticscience.org/resource/SIO_010057") (iri "http://semanticscience.org/resource/SIO_010299") :annotation (label (literal "cellular quality" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "cellular quality is the quality of a cell" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000475") :subclass (iri "http://semanticscience.org/resource/SIO_000026") :annotation (label (literal "biological quality" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a biological quality is a quality held by a biological entity." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000474") :subclass (iri "http://semanticscience.org/resource/SIO_000470") (object-some (iri "http://semanticscience.org/resource/SIO_000310") (iri "http://semanticscience.org/resource/SIO_000083")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A secondary graph title is a secondary title that describes a statistical graph." :lang "en")) (label (literal "secondary graph title" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000478") :subclass (iri "http://semanticscience.org/resource/SIO_000479") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a sequence variant role is a comparative role in which the composition of characters in a sequence differs when compared to another entity of similar type." :lang "en")) (label (literal "sequence variant role" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000479") :subclass (iri "http://semanticscience.org/resource/SIO_000721") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a variant role is a comparative role in which the value of an attribute differs when compared to another entity" :lang "en")) (label (literal "variant role" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000460") :subclass (iri "http://semanticscience.org/resource/SIO_000458") :disjoint (iri "http://semanticscience.org/resource/SIO_000459") (iri "http://semanticscience.org/resource/SIO_000902") (iri "http://semanticscience.org/resource/SIO_000903") :annotation (label (literal "right value axis" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A right value axis is a value axis that is spatially positioned to the right of the plot area." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000462") :subclass (iri "http://semanticscience.org/resource/SIO_000461") :disjoint (iri "http://semanticscience.org/resource/SIO_000463") :annotation (label (literal "linear value axis" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A linear value axis is a value axis that corresponds to a scaling factor of 1 of the value range." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000461") :subclass (iri "http://semanticscience.org/resource/SIO_000458") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A scaled value axis is a value axis in which the value range was subject to a mathematic transformation." :lang "en")) (label (literal "scaled value axis" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000464") :subclass (iri "http://semanticscience.org/resource/SIO_000150") :annotation (annotation (iri "http://semanticscience.org/resource/example") (literal "Example: The two series that correspond to \"Seasonally adjusted\" and \"Trend\" are composed of the seasonally adjusted value of permits in each month and values from a trend derived from some mathematical tranformation across those values, respectively, in  Graph 1 of http://tinyurl.com/opwnvm" :lang "en")) (label (literal "data series" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A data series is a data set composed of related values displayed in a statistical graph." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000463") :subclass (iri "http://semanticscience.org/resource/SIO_000461") :disjoint (iri "http://semanticscience.org/resource/SIO_000462") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A logarithmic value axis is a scaled value axis that corresponds to a scaling factor of the logarithm of the value range." :lang "en")) (label (literal "logarithmic value axis" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000466") :subclass (iri "http://semanticscience.org/resource/SIO_000742") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A global maximum stationary point is a data point that corresponds to a measurement value is larger than that of all other plotted datapoints." :lang "en")) (label (literal "global maximal stationary point" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000465") :subclass (iri "http://semanticscience.org/resource/SIO_000507") (object-some (iri "http://semanticscience.org/resource/SIO_000020") (iri "http://semanticscience.org/resource/SIO_000000")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A data point is a point that which corresponds to the projection of the values of measurement data against the axes of a statistical graph." :lang "en")) (label (literal "data point" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000467") :subclass (iri "http://semanticscience.org/resource/SIO_000743") :annotation (label (literal "global minimal stationary point" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A global minimum data point is a data point that corresponds to a measurement value is smaller than that of all other plotted datapoints." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000468") :subclass (iri "http://semanticscience.org/resource/SIO_000448") :disjoint (iri "http://semanticscience.org/resource/SIO_000449") :annotation (annotation (iri "http://semanticscience.org/resource/example") (literal "The colored line segments and the adjacent textual descriptions in \nGraph 1 of http://tinyurl.com/opwnvm" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A legend is a part of a figure that associates textual descriptions with symbols pertaining to plotted entities." :lang "en")) (label (literal "legend" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000469") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_000185") (object-some (iri "http://semanticscience.org/resource/SIO_000310") (iri "http://semanticscience.org/resource/SIO_000083"))) :annotation (label (literal "graph title" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A graph title is a title that describes a graph." :lang "en")) (annotation (iri "http://semanticscience.org/resource/example") (literal "Total value of permits increased slightly in December\" in Graph 1 of http://tinyurl.com/opwnvm" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000793") :range (iri "http://semanticscience.org/resource/SIO_000391"))

(object-property (iri "http://semanticscience.org/resource/SIO_000775") :inverse (iri "http://semanticscience.org/resource/SIO_000774"))
(object-property (iri "http://semanticscience.org/resource/SIO_000772") :inverse (iri "http://semanticscience.org/resource/SIO_000773"))
(object-property (iri "http://semanticscience.org/resource/SIO_000773") :inverse (iri "http://semanticscience.org/resource/SIO_000772"))
(object-property (iri "http://semanticscience.org/resource/SIO_000774") :inverse (iri "http://semanticscience.org/resource/SIO_000775"))
(owl-class (iri "http://semanticscience.org/resource/SIO_010499") :subclass (iri "http://semanticscience.org/resource/SIO_011118") :annotation (label (literal "double bond" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a double bond is a covalent bond between a pair of atoms in which two pairs of electrons are shared." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010497") :subclass (iri "http://semanticscience.org/resource/SIO_010506") (object-at-least 2 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_010007")) :annotation (label (literal "protein complex" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a protein complex is a molecular complex composed of at least two polypeptide chains." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010498") :subclass (iri "http://semanticscience.org/resource/SIO_011118") :annotation (label (literal "single bond" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a single bond is a covalent bond between a pair of atoms in which one pair of electrons are shared." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010496") :subclass (iri "http://semanticscience.org/resource/SIO_010005") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an ionic interaction is a weak submolecular interaction between a charged submolecules." :lang "en")) (label (literal "ionic interaction" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000356") :inverse (iri "http://semanticscience.org/resource/SIO_000355"))
(object-property (iri "http://semanticscience.org/resource/SIO_000355") :inverse (iri "http://semanticscience.org/resource/SIO_000356"))
(object-property (iri "http://semanticscience.org/resource/SIO_000352") :inverse (iri "http://semanticscience.org/resource/SIO_000294"))
(object-property (iri "http://semanticscience.org/resource/SIO_000369") :inverse (iri "http://semanticscience.org/resource/SIO_000313"))
(object-property (iri "http://semanticscience.org/resource/SIO_000365") :inverse (iri "http://semanticscience.org/resource/SIO_000364"))
(object-property (iri "http://semanticscience.org/resource/SIO_000364") :inverse (iri "http://semanticscience.org/resource/SIO_000365"))
(object-property (iri "http://semanticscience.org/resource/SIO_000363") :inverse (iri "http://semanticscience.org/resource/SIO_000362"))
(object-property (iri "http://semanticscience.org/resource/SIO_000362") :inverse (iri "http://semanticscience.org/resource/SIO_000363"))
(annotation-property (iri "http://protege.stanford.edu/plugins/owl/protege#defaultLanguage"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000896") :subclass (iri "http://semanticscience.org/resource/SIO_000879") :annotation (label (literal "molecular tracer role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a molecular tracer role is a reactant role of a molecular entity that serves as a marker for the presence, abundance, or location of a molecular target that it associates with." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000897") :subclass (iri "http://semanticscience.org/resource/SIO_000075") (object-at-least 2 (iri "http://semanticscience.org/resource/SIO_000628") (iri "http://semanticscience.org/resource/SIO_000000")) :annotation (label (literal "association" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an assocation is a relationship between two or more entities derived by some informational anlysis." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000898") :subclass (iri "http://semanticscience.org/resource/SIO_000897") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a statistical association is any relationship between two measured quantities that renders them statistically dependent." :lang "en")) (label (literal "statistical association" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000899") :subclass (iri "http://semanticscience.org/resource/SIO_010506") :annotation (label (literal "chromosome" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a chromosome is a molecular complex of circular or linear DNA and bound proteins." :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000322") :characteristic :symmetric)
(object-property (iri "http://semanticscience.org/resource/SIO_000323") :inverse (iri "http://semanticscience.org/resource/SIO_000324"))
(object-property (iri "http://semanticscience.org/resource/SIO_000324") :inverse (iri "http://semanticscience.org/resource/SIO_000323"))
(object-property (iri "http://semanticscience.org/resource/SIO_000325") :characteristic :symmetric :reflexive)
(owl-class (iri "http://semanticscience.org/resource/SIO_011120") :subclass (iri "http://semanticscience.org/resource/SIO_000396") (object-some (iri "http://semanticscience.org/resource/SIO_000028") (iri "http://semanticscience.org/resource/SIO_000072")) (object-some (iri "http://semanticscience.org/resource/SIO_000028") (iri "http://semanticscience.org/resource/SIO_011121")) (object-some (iri "http://semanticscience.org/resource/SIO_000214") (iri "http://semanticscience.org/resource/SIO_011119")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a molecular structure file is a file that contains a description of molecular structure." :lang "en")) (label (literal "molecular structure file" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011121") :subclass (iri "http://semanticscience.org/resource/SIO_011123") (object-some (iri "http://semanticscience.org/resource/SIO_000210") (iri "http://semanticscience.org/resource/SIO_000626")) (object-some (iri "http://semanticscience.org/resource/SIO_000332") (iri "http://semanticscience.org/resource/SIO_011125")) :annotation (label (literal "molecular structure descriptor" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "molecular structure descriptor is data that describes some aspect of the molecular structure (composition) and is about some chemical entity." :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEMINF:000085" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_010443") :subclass (iri "http://semanticscience.org/resource/SIO_010444") (object-some (iri "http://semanticscience.org/resource/SIO_000093") (iri "http://semanticscience.org/resource/SIO_010035")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an intron is a region of a gene that is removed from the final protein open reading frame." :lang "en")) (label (literal "intron" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011123") :subclass (iri "http://semanticscience.org/resource/SIO_000472") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEMINF:000123" :type :RDF_PLAIN_LITERAL)) (label (literal "chemical data" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A chemical datum is a scientific data item which conforms to some specification, either for how it is calculated or for how it is measured, and is commonly used in the domain of chemistry to name and differentiate different numeric properties (both calculated and measured) which are about chemical entities." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010442") :subclass (iri "http://semanticscience.org/resource/SIO_001011") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_000805") (iri "http://semanticscience.org/resource/SIO_000806")) :annotation (label (literal "charge quality" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "charge quality is the quality pertaining to electric charge." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010441") :subclass (iri "http://semanticscience.org/resource/SIO_010020") (object-some (iri "http://semanticscience.org/resource/SIO_000313") (iri "http://semanticscience.org/resource/SIO_011125")) (object-some (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_010044")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a submolecule is a mereological sum of covalently bonded atoms" :lang "en")) (label (literal "submolecule" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010440") :subclass (iri "http://semanticscience.org/resource/SIO_010439") :annotation (label (literal "second messenger" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a second messenger is a molecule that relay signals from receptors on the cell surface to target molecules inside the cell, in the cytoplasm or nucleus. " :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011125") :subclass (iri "http://semanticscience.org/resource/SIO_010341") (object-some (iri "http://semanticscience.org/resource/SIO_000028") (iri "http://semanticscience.org/resource/SIO_010044")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A molecule is the mereological maximal sum of a collection of covalently bonded atoms." :lang "en")) (label (literal "molecule" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:23367" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_010446") :subclass (iri "http://semanticscience.org/resource/SIO_010085") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a gene promoter is a region of DNA that initiates transcription of a particular gene." :lang "en")) (label (literal "gene promoter" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010447") :subclass (iri "http://semanticscience.org/resource/SIO_010095") :disjoint (iri "http://semanticscience.org/resource/SIO_010448") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a start codon is the first codon of a messenger RNA (mRNA) transcript translated by a ribosome. The start codon is almost always preceded by an untranslated region 5' UTR." :lang "en")) (label (literal "start codon" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011126") :subclass (iri "http://semanticscience.org/resource/SIO_010004") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_010462") (iri "http://semanticscience.org/resource/SIO_010463")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A chemical substance is a chemical complex of weakly interacting molecular entities, and may include bulk solvent." :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEMINF:440533" :type :RDF_PLAIN_LITERAL)) (label (literal "chemical substance" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010444") :subclass (iri "http://semanticscience.org/resource/SIO_010335") (object-some (iri "http://semanticscience.org/resource/SIO_000093") (iri "http://semanticscience.org/resource/SIO_010035")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a gene component is a component of a gene" :type :RDF_PLAIN_LITERAL)) (label (literal "gene component" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010445") :subclass (iri "http://semanticscience.org/resource/SIO_010444") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An exon is a nucleotide sequence encoded by a gene that remains present within the final mature RNA product of that gene after introns have been removed by RNA splicing. " :lang "en")) (label (literal "exon" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010060") :subclass (iri "http://semanticscience.org/resource/SIO_001196") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "family history is the systematic narrative and research of past events relating to a specific family, or specific families." :lang "en")) (label (literal "family history" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010061") :subclass (iri "http://semanticscience.org/resource/SIO_000794") :annotation (label (literal "generation number" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "generation number is a count of the number of biological reproduction events elapsed from some starting reference point." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010448") :subclass (iri "http://semanticscience.org/resource/SIO_010095") (object-some (iri "http://semanticscience.org/resource/SIO_000068") (iri "http://semanticscience.org/resource/SIO_010099")) :disjoint (iri "http://semanticscience.org/resource/SIO_010447") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a stop codon (or termination codon) is a nucleotide triplet within messenger RNA that signals a termination of translation." :lang "en")) (label (literal "stop codon" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010064") :subclass (iri "http://semanticscience.org/resource/SIO_010444") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "The five prime untranslated region (5' UTR) is a section of messenger RNA (mRNA) and the DNA that codes for it that starts at the +1 position (where transcription begins) and ends one nucleotide before the start codon (usually AUG) of the coding region." :lang "en")) (label (literal "5' untranslated region" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010065") :subclass (iri "http://semanticscience.org/resource/SIO_010019") :annotation (label (literal "bioinformatic data" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "bioinformatic data is data genereated or used for computer-based investigations of biological phenomena." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000891") :subclass (iri "http://semanticscience.org/resource/SIO_000888") :annotation (label (literal "toxic role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a toxic role is the role of a chemical substance that is poisonous" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000890") :subclass (iri "http://semanticscience.org/resource/SIO_000968") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a toxin role is a toxic role of a chemical substance that is poisonous and  is produced by an organism" :lang "en")) (label (literal "toxin role" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010068") :subclass (iri "http://semanticscience.org/resource/SIO_010066") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a pairwise sequence alignment is the alignment of exactly 2 sequences." :lang "en")) (label (literal "pairwise sequence alignment" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000893") :subclass (iri "http://semanticscience.org/resource/SIO_000888") (object-some (iri "http://semanticscience.org/resource/SIO_000227") (iri "http://semanticscience.org/resource/SIO_010411")) :annotation (label (literal "reagent role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a role of a chemical substance that participates in a chemical reaction as part of some scientific investigation." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010066") :subclass (iri "http://semanticscience.org/resource/SIO_010065") :annotation (label (literal "sequence alignment" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a sequence alignment is the character-based alignment of sequences using some method." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000895") :subclass (iri "http://semanticscience.org/resource/SIO_000894") :annotation (label (literal "to fluoresce" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to fluoresce is to emit light as a result of absorbing light or other electromagnetic radiation." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010067") :subclass (iri "http://semanticscience.org/resource/SIO_010066") :annotation (label (literal "multiple sequence alignment" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a multiple sequence alignment is a sequence alignment involving more than two sequences." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000894") :subclass (iri "http://semanticscience.org/resource/SIO_000692") :annotation (label (literal "to luminesce" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to luminesce is to emit light through cold body radiation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000887") :subclass (iri "http://semanticscience.org/resource/SIO_000888") (object-some (iri "http://semanticscience.org/resource/SIO_000227") (iri "http://semanticscience.org/resource/SIO_010416")) :annotation (label (literal "buffer role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a buffer role is the role of a chemical substance which maintains a pH at a near constant value." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000888") :subclass (iri "http://semanticscience.org/resource/SIO_000795") (object-some (iri "http://semanticscience.org/resource/SIO_000227") (iri "http://semanticscience.org/resource/SIO_011126")) :annotation (label (literal "chemical substance role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a chemical substance role is a chemical entity role held by a chemical substance" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000885") :subclass (iri "http://semanticscience.org/resource/SIO_000884") :annotation (label (literal "publisher role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a publisher role is the role of an individual that prepares and issues creative works." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000886") :subclass (iri "http://semanticscience.org/resource/SIO_000884") :annotation (label (literal "author role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an author role is the role of an individual that creates a creative, written work." :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000311") :inverse (iri "http://semanticscience.org/resource/SIO_000312"))
(object-property (iri "http://semanticscience.org/resource/SIO_000312") :inverse (iri "http://semanticscience.org/resource/SIO_000311"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000889") :subclass (iri "http://semanticscience.org/resource/SIO_000795") (object-some (iri "http://semanticscience.org/resource/SIO_000227") (iri "http://semanticscience.org/resource/SIO_011125")) :annotation (label (literal "molecular entity role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a molecular entity role is a chemical entity role held by a molecule" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000310") :inverse (iri "http://semanticscience.org/resource/SIO_000273"))
(owl-class (iri "http://semanticscience.org/resource/SIO_011110") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33390" :type :RDF_PLAIN_LITERAL)) (label (literal "curium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010450") :subclass (iri "http://semanticscience.org/resource/SIO_010009") (object-some (iri "http://semanticscience.org/resource/SIO_010081") (object-or (iri "http://semanticscience.org/resource/SIO_010010") (object-some (iri "http://semanticscience.org/resource/SIO_000068") (iri "http://semanticscience.org/resource/SIO_010010")))) :annotation (label (literal "RNA transcript" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an RNA transcript is an RNA molecule that is produced from transcription of a nucleic acid template." :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000313") :inverse (iri "http://semanticscience.org/resource/SIO_000369"))
(owl-class (iri "http://semanticscience.org/resource/SIO_011113") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33393" :type :RDF_PLAIN_LITERAL)) (label (literal "einsteinium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010452") :subclass (iri "http://semanticscience.org/resource/SIO_010049") :annotation (label (literal "molecular pocket" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a molecular pocket is a site on a molecule that appears as a depression into the structure." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011114") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "fermium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33394" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_010451") :subclass (iri "http://semanticscience.org/resource/SIO_010095") :annotation (label (literal "splice site" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a splice site is a region required for the excision of an intron and connection to another exon." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011111") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33391" :type :RDF_PLAIN_LITERAL)) (label (literal "berkelium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010454") :subclass (iri "http://semanticscience.org/resource/SIO_010427") :annotation (label (literal "base" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A base is a molecular entity dissolved in a solvent that is capable of accepting a proton (Bronsted base) or forming a covalent bond with a hydron (Lewis base) ." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011112") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33392" :type :RDF_PLAIN_LITERAL)) (label (literal "californium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010453") :subclass (iri "http://semanticscience.org/resource/SIO_010427") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An acid is a molecular entity in solution capable of donating a hydron (Bronsted acid) or capable of forming a covalent bond with an electron pair (Lewis acid)." :lang "en")) (label (literal "acid" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011118") :subclass (iri "http://semanticscience.org/resource/SIO_010047") (object-exactly 2 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_010044")) :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEMINF:000063" :type :RDF_PLAIN_LITERAL)) (label (literal "covalent bond" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a covalent bond is a strong submolecular interaction between atoms." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010455") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_011125") (object-some (iri "http://semanticscience.org/resource/SIO_000272") (iri "http://semanticscience.org/resource/SIO_011125"))) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An isomer is a molecule that is compositionally identical to another molecule as a result of a different atomic connectivity." :lang "en")) (label (literal "isomer" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011117") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33397" :type :RDF_PLAIN_LITERAL)) (label (literal "lawrencium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010456") :subclass (iri "http://semanticscience.org/resource/SIO_010004") :equivalent (object-or (object-or (iri "http://semanticscience.org/resource/SIO_010044") (iri "http://semanticscience.org/resource/SIO_011125")) (object-some (iri "http://semanticscience.org/resource/SIO_000217") (iri "http://semanticscience.org/resource/SIO_010442"))) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An ion is an atom or molecule in which the total number of electrons is not equal to the total number of protons, giving it a net positive or negative electrical charge." :lang "en")) (label (literal "ion" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011116") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "nobelium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33396" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_010457") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_010456") (object-some (iri "http://semanticscience.org/resource/SIO_000217") (iri "http://semanticscience.org/resource/SIO_010461"))) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An anion is an atom or molecule with a net positive electrical charge." :lang "en")) (label (literal "cation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011115") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33395" :type :RDF_PLAIN_LITERAL)) (label (literal "mendelevium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010458") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_010456") (object-some (iri "http://semanticscience.org/resource/SIO_000217") (iri "http://semanticscience.org/resource/SIO_010464"))) :annotation (label (literal "anion" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An anion is an atom or molecule with a net negative electrical charge." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010459") :subclass (iri "http://semanticscience.org/resource/SIO_010417") (object-some (iri "http://semanticscience.org/resource/SIO_000217") (iri "http://semanticscience.org/resource/SIO_001046")) :disjoint (iri "http://semanticscience.org/resource/SIO_010460") :annotation (label (literal "polar solvent" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a polar solvent is a solvent that exhibits a polar quality." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010070") :subclass (iri "http://semanticscience.org/resource/SIO_010444") :annotation (label (literal "3' untranslated region" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a three prime untranslated region (3'-UTR) is the section of messenger RNA (mRNA) that immediately follows the translation termination codon. " :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010071") :subclass (iri "http://semanticscience.org/resource/SIO_010441") (object-or (object-some (iri "http://semanticscience.org/resource/SIO_000028") (iri "http://semanticscience.org/resource/SIO_011001")) (object-some (iri "http://semanticscience.org/resource/SIO_000028") (iri "http://semanticscience.org/resource/SIO_011007"))) (object-some (iri "http://semanticscience.org/resource/SIO_000068") (iri "http://semanticscience.org/resource/SIO_010072")) :annotation (label (literal "organic submolecule" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an organic submolecule is connected region of a molecule." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011119") :subclass (iri "http://semanticscience.org/resource/SIO_011121") (object-some (iri "http://semanticscience.org/resource/SIO_000332") (iri "http://semanticscience.org/resource/SIO_010072")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a biomolecular structure descriptor is structure description for organic compounds." :lang "en")) (label (literal "biomolecular structure descriptor" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010072") :subclass (iri "http://semanticscience.org/resource/SIO_011125") (object-or (object-some (iri "http://semanticscience.org/resource/SIO_000028") (iri "http://semanticscience.org/resource/SIO_011001")) (object-some (iri "http://semanticscience.org/resource/SIO_000028") (iri "http://semanticscience.org/resource/SIO_011002"))) :annotation (label (literal "organic molecule" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An organic molecular entity is a chemical entity composed of organic atoms (at least carbon, hydrogen, and optionally oxygen, phosphorus, nitrogen)" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010073") :subclass (iri "http://semanticscience.org/resource/SIO_010444") (object-or (object-exactly 1 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_010447")) (object-exactly 1 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_010448"))) (object-some (iri "http://semanticscience.org/resource/SIO_010080") (object-or (iri "http://semanticscience.org/resource/SIO_010450") (object-some (iri "http://semanticscience.org/resource/SIO_010082") (iri "http://semanticscience.org/resource/SIO_010007")))) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an open reading frame (ORF) is a part of a gene that encodes a protein but does not contain a stop codon." :lang "en")) (label (literal "open reading frame" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000880") :subclass (iri "http://semanticscience.org/resource/SIO_000889") :annotation (label (literal "regulator role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "the role of a chemical entity that modifies the rate of reaction." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010074") :subclass (iri "http://semanticscience.org/resource/SIO_010471") (object-some (iri "http://semanticscience.org/resource/SIO_000244") (iri "http://semanticscience.org/resource/SIO_001224")) :annotation (label (literal "amino acid residue" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an amino acid residue is a part of a molecule that is derived from an amino acid molecule." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010075") :subclass (iri "http://semanticscience.org/resource/SIO_010335") :annotation (label (literal "nucleotide residue" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a nucleotide residue is a part of a molecule that derives from a nucleotide." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010076") :subclass (iri "http://semanticscience.org/resource/SIO_010038") :annotation (label (literal "poison" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A poison is a drug that is harzardous or toxic to an organism when ingested at a certain quantity." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010077") :subclass (iri "http://semanticscience.org/resource/SIO_010338") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An active ingredient is a molecular entity that exhibits biological activity." :lang "en")) (label (literal "active ingredient" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000884") :subclass (iri "http://semanticscience.org/resource/SIO_000706") :annotation (label (literal "publishing role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a publishing role is the role of an individual that is involved in the preparation and issue of creative works for consumption by a wider audience." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000883") :subclass (iri "http://semanticscience.org/resource/SIO_000881") :annotation (label (literal "subject role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a subject role is the role of an individual that is the target of the study." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000882") :subclass (iri "http://semanticscience.org/resource/SIO_000888") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "the role of an organism in providing resources to maintain the survival and/or reproduction of another organism." :lang "en")) (label (literal "host role" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000881") :subclass (iri "http://semanticscience.org/resource/SIO_000677") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an investigational role is a role held by participants involved in an investigation." :lang "en")) (label (literal "investigational role" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010049") :subclass (iri "http://semanticscience.org/resource/SIO_000019") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A moleclar site is a spatial region bounded (in part or in whole) by a molecule and may be occupied by other material entities (e.g. drugs)." :type :RDF_PLAIN_LITERAL)) (label (literal "molecular site" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010048") :subclass (iri "http://semanticscience.org/resource/SIO_010029") :disjoint (iri "http://semanticscience.org/resource/SIO_000784") (iri "http://semanticscience.org/resource/SIO_010052") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "male is a biological sex of an individual with male sexual organs." :lang "en")) (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "PATO:0000384" :type :RDF_PLAIN_LITERAL)) (label (literal "male" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000341") :inverse (iri "http://semanticscience.org/resource/SIO_000426"))
(owl-class (iri "http://semanticscience.org/resource/SIO_011100") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33379" :type :RDF_PLAIN_LITERAL)) (label (literal "erbium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010465") :subclass (iri "http://semanticscience.org/resource/SIO_010497") :annotation (label (literal "antibody" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An antibody (also known as immunoglobulins, abbreviated Ig) are gamma globulin proteins that are used by the immune system to identify and neutralize foreign objects. They are typically made of two large heavy chains and two small light chains." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011101") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33380" :type :RDF_PLAIN_LITERAL)) (label (literal "thulium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010464") :subclass (iri "http://semanticscience.org/resource/SIO_000810") :disjoint (iri "http://semanticscience.org/resource/SIO_010461") :annotation (label (literal "negative charge" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a negative charge is a charge where the value is negative." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011102") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33381" :type :RDF_PLAIN_LITERAL)) (label (literal "ytterbium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010463") :subclass (iri "http://semanticscience.org/resource/SIO_011126") :disjoint (iri "http://semanticscience.org/resource/SIO_010462") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a homogeneous substance is a substance that is composed of a uniform type of entity." :type :RDF_PLAIN_LITERAL)) (label (literal "homogeneous substance" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011103") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33382" :type :RDF_PLAIN_LITERAL)) (label (literal "lutetium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010462") :subclass (iri "http://semanticscience.org/resource/SIO_000004") (iri "http://semanticscience.org/resource/SIO_011126") :disjoint (iri "http://semanticscience.org/resource/SIO_010463") :annotation (label (literal "heterogeneous substance" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a heterogeneous substance is a chemical substance that is composed of more than one different kind of component." :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_010461") :subclass (iri "http://semanticscience.org/resource/SIO_000810") :disjoint (iri "http://semanticscience.org/resource/SIO_010464") :annotation (label (literal "positive charge" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a positive charge is a charge where the value is positive." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010460") :subclass (iri "http://semanticscience.org/resource/SIO_010417") (object-some (iri "http://semanticscience.org/resource/SIO_000217") (iri "http://semanticscience.org/resource/SIO_001047")) :disjoint (iri "http://semanticscience.org/resource/SIO_010459") :annotation (label (literal "nonpolar solvent" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a non-polar solvent is a solvent that exhibits a non-polar quality." :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_010302") :characteristic :symmetric)
(owl-class (iri "http://semanticscience.org/resource/SIO_011109") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33389" :type :RDF_PLAIN_LITERAL)) (label (literal "americium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011108") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "plutonium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33388" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011105") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33386" :type :RDF_PLAIN_LITERAL)) (label (literal "protactinium atom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010468") :subclass (iri "http://semanticscience.org/resource/SIO_010471") :annotation (label (literal "alpha helix" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an alpha helix is structural region of a protein that is characterized by 3.6 residues per turn,  a translation of 1.5 angstroms along the helical axis in which backbone N-H groups form a hydrogen bond to the backbone carboxyl group of the amino acid four residues prior." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011104") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "thorium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33385" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_010469") :subclass (iri "http://semanticscience.org/resource/SIO_010471") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a beta strand is structural region of a protein that is characterized by a roughly planar sequence of amino acid residues forming hydrogen bonds between the N-O and the C=O  of another part of the peptide\nand having their side chains perpendicular to the planar axis." :lang "en")) (label (literal "beta strand" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011107") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "neptunium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:33387" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_011106") :subclass (iri "http://semanticscience.org/resource/SIO_010044") :annotation (label (literal "uranium atom" :lang "en")) (annotation (iri "http://semanticscience.org/resource/seeAlso") (literal "CHEBI:27214" :type :RDF_PLAIN_LITERAL)))

(owl-class (iri "http://semanticscience.org/resource/SIO_010046") :subclass (iri "http://semanticscience.org/resource/SIO_010462") :annotation (label (literal "biological entity" :lang "en")) (annotation (iri "http://semanticscience.org/resource/subset") (literal "chemical-" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "a biological entity is a heterogeneous substance that contains genomic material or is the product of a biological process." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010047") :subclass (iri "http://semanticscience.org/resource/SIO_010020") :disjoint (iri "http://semanticscience.org/resource/SIO_010005") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a strong submolecular component is a submolecular component that strongly connects submolecular components." :lang "en")) (label (literal "strong submolecular component" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010044") :subclass (iri "http://semanticscience.org/resource/SIO_010004") :annotation (label (literal "atom" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An atom is composed of a core of protons and/or neutrons which may be surrounded by a cloud of electrons." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010045") :subclass (iri "http://semanticscience.org/resource/SIO_010005") :annotation (label (literal "base pair" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a base pair is a weak molecular interaction composed of hydrogen bonds between nucleobases." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010042") :subclass (iri "http://semanticscience.org/resource/SIO_010335") :annotation (label (literal "haplotype" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A haplotype is one of a set of genomic sequence variants." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010043") :subclass (iri "http://semanticscience.org/resource/SIO_010346") (object-some (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_010007")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a protein is an organic polymer that is composed of one or more linear polymers of amino acids." :lang "en")) (label (literal "protein" :lang "en")) (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "CHEBI:36080" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_010040") :subclass (iri "http://semanticscience.org/resource/SIO_010049") :annotation (label (literal "binding site" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A binding site is a molecular site which when occupied with particular ligands leads to structural transformations that initiatiate new moelcular processes. " :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010041") :subclass (iri "http://semanticscience.org/resource/SIO_010049") :annotation (label (literal "active site" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an active site is a molecular site in which a chemical event occurs (structural transformation or conformational change)." :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000334") :characteristic :symmetric)
(object-property (iri "http://semanticscience.org/resource/SIO_000332") :inverse (iri "http://semanticscience.org/resource/SIO_000629"))
(owl-class (iri "http://semanticscience.org/resource/SIO_001006") :subclass (iri "http://semanticscience.org/resource/SIO_001005") (object-at-least 2 (iri "http://semanticscience.org/resource/SIO_000132") (iri "http://semanticscience.org/resource/SIO_010038")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a drug-drug interaction is an interaction in which two drugs interact in such a way to produce a non-additive biological response." :lang "en")) (label (literal "drug drug interaction" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010059") :subclass (iri "http://semanticscience.org/resource/SIO_010057") :disjoint (iri "http://semanticscience.org/resource/SIO_010058") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "dead is the quality of an object in which there is a cessation of all biological functions." :lang "en")) (label (literal "dead" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001007") :subclass (iri "http://semanticscience.org/resource/SIO_000999") (object-some (iri "http://semanticscience.org/resource/SIO_000229") (object-or (object-or (iri "http://semanticscience.org/resource/SIO_000070") (iri "http://semanticscience.org/resource/SIO_000959")) (object-some (iri "http://semanticscience.org/resource/SIO_000011") (iri "http://semanticscience.org/resource/SIO_000000")))) (object-some (iri "http://semanticscience.org/resource/SIO_000230") (iri "http://semanticscience.org/resource/SIO_000776")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An assay is an investigative (analytic) procedure in laboratory medicine, pharmacology, environmental biology, and molecular biology for qualitatively assessing or quantitatively measuring the presence or amount or the functional activity of a target entity (the analyte) which can be a drug or biochemical substance or a cell in an organism or organic sample." :lang "en")) (label (literal "assay" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001008") :subclass (iri "http://semanticscience.org/resource/SIO_001011") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_001009") (iri "http://semanticscience.org/resource/SIO_001010")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "toxicity is the quality of a chemical substance to cause injury to an organism in a dose dependent manner." :lang "en")) (label (literal "toxicity" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001009") :subclass (iri "http://semanticscience.org/resource/SIO_001008") :disjoint (iri "http://semanticscience.org/resource/SIO_001010") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "toxic is the quality of a substance imparing the normal functioning of a  system." :lang "en")) (label (literal "toxic" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000339") :inverse (iri "http://semanticscience.org/resource/SIO_000338"))
(object-property (iri "http://semanticscience.org/resource/SIO_000338") :inverse (iri "http://semanticscience.org/resource/SIO_000339"))
(object-property (iri "http://semanticscience.org/resource/SIO_000335") :characteristic :symmetric)
(owl-class (iri "http://semanticscience.org/resource/SIO_010471") :subclass (iri "http://semanticscience.org/resource/SIO_010071") :annotation (label (literal "protein part" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a protein part is any submolecule of a protein." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010050") :subclass (iri "http://semanticscience.org/resource/SIO_010040") :annotation (label (literal "allosteric site" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an allosteric site is a binding site that when bound to particular ligand changes the conformational state and affects its functionality." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010055") :subclass (iri "http://semanticscience.org/resource/SIO_010000") (object-some (iri "http://semanticscience.org/resource/SIO_000272") (iri "http://semanticscience.org/resource/SIO_010000")) :annotation (label (literal "strain" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A strain is a genetic variant or kind of microorganism." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001003") :subclass (iri "http://semanticscience.org/resource/SIO_001004") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A diagnostic opinion is an opinion resulting from a medical diagnostic procedure." :lang "en")) (label (literal "diagnostic opinion" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010056") :subclass (iri "http://semanticscience.org/resource/SIO_000475") :disjoint (iri "http://semanticscience.org/resource/SIO_000476") (iri "http://semanticscience.org/resource/SIO_001014") (iri "http://semanticscience.org/resource/SIO_001015") (iri "http://semanticscience.org/resource/SIO_010029") (iri "http://semanticscience.org/resource/SIO_010057") (iri "http://semanticscience.org/resource/SIO_010299") :annotation (label (literal "phenotype" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a phenotype is an observable characteristic of an individual." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001002") :subclass (iri "http://semanticscience.org/resource/SIO_001024") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A differential diagnosis (sometimes abbreviated DDx, ddx, DD, D/Dx, or ΔΔ) is a systematic diagnostic method used to identify the presence of an entity where multiple alternatives are possible (and the process may be termed differential diagnostic procedure), and may also refer to any of the included candidate alternatives (which may also be termed candidate condition)." :lang "en")) (label (literal "differential diagnosis" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010057") :subclass (iri "http://semanticscience.org/resource/SIO_000475") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_010058") (iri "http://semanticscience.org/resource/SIO_010059")) :disjoint (iri "http://semanticscience.org/resource/SIO_000476") (iri "http://semanticscience.org/resource/SIO_001014") (iri "http://semanticscience.org/resource/SIO_001015") (iri "http://semanticscience.org/resource/SIO_010029") (iri "http://semanticscience.org/resource/SIO_010056") (iri "http://semanticscience.org/resource/SIO_010299") :annotation (label (literal "life status" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "life status is the quality of whether something is alive or dead." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001005") :subclass (iri "http://semanticscience.org/resource/SIO_010013") (object-some (iri "http://semanticscience.org/resource/SIO_000139") (iri "http://semanticscience.org/resource/SIO_010038")) :annotation (label (literal "drug effect" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A drug effect is a chemical interaction in which a chemical elicits a marked characteristic of a biological system." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001004") :subclass (iri "http://semanticscience.org/resource/SIO_000360") (object-some (iri "http://semanticscience.org/resource/SIO_000311") (iri "http://semanticscience.org/resource/SIO_001001")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an opinion is a belief that is the result of emotion or interpretation of facts. " :lang "en")) (label (literal "opinion" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010058") :subclass (iri "http://semanticscience.org/resource/SIO_010057") :disjoint (iri "http://semanticscience.org/resource/SIO_010059") :annotation (label (literal "alive" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "alive is the state of a biological organism that exhibits biological functions." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010051") :subclass (iri "http://semanticscience.org/resource/SIO_010046") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a biological fluid is a fluid of biological origin." :lang "en")) (label (literal "biological fluid" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010052") :subclass (iri "http://semanticscience.org/resource/SIO_010029") :disjoint (iri "http://semanticscience.org/resource/SIO_000784") (iri "http://semanticscience.org/resource/SIO_010048") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "female is a biological sex of an individual with female sexual organs." :lang "en")) (label (literal "female" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010053") :subclass (iri "http://semanticscience.org/resource/SIO_001196") :annotation (label (literal "evolutionary lineage" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "evolutionary lineage is a sequence of species, that form a line of descent, each new species the direct result of speciation from an immediate ancestral species." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001001") :subclass (iri "http://semanticscience.org/resource/SIO_001024") (object-some (iri "http://semanticscience.org/resource/SIO_000229") (iri "http://semanticscience.org/resource/SIO_001003")) (object-some (iri "http://semanticscience.org/resource/SIO_000230") (object-or (iri "http://semanticscience.org/resource/SIO_010046") (object-some (iri "http://semanticscience.org/resource/SIO_000217") (iri "http://semanticscience.org/resource/SIO_000758")))) :annotation (label (literal "medical diagnosis" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A medical diagnosis (often simply termed diagnosis) refers to the process of attempting to determine or identify a possible disease or disorder." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010054") :subclass (iri "http://semanticscience.org/resource/SIO_010046") :annotation (label (literal "cell line" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A cell line is a collection of genetically identifical cells." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001000") :subclass (iri "http://semanticscience.org/resource/SIO_001048") (object-some (iri "http://semanticscience.org/resource/SIO_000339") (iri "http://semanticscience.org/resource/SIO_001043")) :annotation (label (literal "clinical trial" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a clinical trial is an intervention trial to determine the safety and efficacy of  medical interventions (e.g., drugs, diagnostics, devices, therapy protocols). " :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010028") :subclass (iri "http://semanticscience.org/resource/SIO_010019") :annotation (label (literal "genetic data" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "genetic data is data pertaining to genetics." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000853") :subclass (iri "http://semanticscience.org/resource/SIO_000825") :annotation (label (literal "lust" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "lust is the strong desire for sex." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010029") :subclass (iri "http://semanticscience.org/resource/SIO_000475") :disjoint (iri "http://semanticscience.org/resource/SIO_000476") (iri "http://semanticscience.org/resource/SIO_001014") (iri "http://semanticscience.org/resource/SIO_001015") (iri "http://semanticscience.org/resource/SIO_010056") (iri "http://semanticscience.org/resource/SIO_010057") (iri "http://semanticscience.org/resource/SIO_010299") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "biological sex is the quality of a biological organism based on reproductive function or organs." :lang "en")) (label (literal "biological sex" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000852") :subclass (iri "http://semanticscience.org/resource/SIO_000832") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Loneliness is an unpleasant emotion in which a person feels a strong sense of emptiness, yearning distress and solitude resulting from inadequate quantity or quality of social relationships." :lang "en")) (label (literal "loneliness" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010026") :subclass (iri "http://semanticscience.org/resource/SIO_010335") :annotation (label (literal "genetic polymorphism" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "genetic polymorphism is the description of a difference in genetic composition at some location." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000855") :subclass (iri "http://semanticscience.org/resource/SIO_000837") :annotation (label (literal "panic" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Panic is a sudden emotion of fear which is so strong as to dominate or prevent reason and logical thinking, replacing it with overwhelming feelings of anxiety and frantic agitation consistent with an animalistic fight-or-flight reaction." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010027") :subclass (iri "http://semanticscience.org/resource/SIO_010075") (object-some (iri "http://semanticscience.org/resource/SIO_000272") (iri "http://semanticscience.org/resource/SIO_010075")) :annotation (label (literal "snp" :lang "en")) (annotation (iri "http://purl.org/dc/terms/alternativeName") (literal "single nucleotide polymorphism" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "single nucleotide polymorphism (SNP) is a variation in a single base in the genetic composition between different individuals of the same species." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000854") :subclass (iri "http://semanticscience.org/resource/SIO_000863") :annotation (label (literal "misery" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Misery is a feeling of great unhappiness, suffering and/or pain." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000857") :subclass (iri "http://semanticscience.org/resource/SIO_000832") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Pity is the emotion of sadness or sorrow for another." :lang "en")) (label (literal "pity" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000856") :subclass (iri "http://semanticscience.org/resource/SIO_000825") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "passion is the intense desire for something." :lang "en")) (label (literal "passion" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000859") :subclass (iri "http://semanticscience.org/resource/SIO_000864") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Pride is an emotion of satisfaction of attachment toward one's own or another's choices and actions, or toward a whole group of people, and is a product of praise, independent self-reflection, or a fulfilled feeling of belonging." :lang "en")) (label (literal "pride" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000858") :subclass (iri "http://semanticscience.org/resource/SIO_000840") :annotation (label (literal "pleasure" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "pleasure is an emotion of happy satisfaction and enjoyment." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010020") :subclass (iri "http://semanticscience.org/resource/SIO_010004") (object-some (iri "http://semanticscience.org/resource/SIO_000068") (iri "http://semanticscience.org/resource/SIO_010004")) :disjoint (iri "http://semanticscience.org/resource/SIO_010341") (iri "http://semanticscience.org/resource/SIO_010342") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A submolecular entity is a part of a molecular entity." :lang "en")) (label (literal "submolecular entity" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010025") :subclass (iri "http://semanticscience.org/resource/SIO_010346") (object-at-least 2 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_010334")) :disjoint (iri "http://semanticscience.org/resource/SIO_010007") (iri "http://semanticscience.org/resource/SIO_010008") :annotation (label (literal "oligosaccharide" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an oligosaccharide is an organic polymer composed of monosaccharides joined by glycosidic bonds." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010024") :subclass (iri "http://semanticscience.org/resource/SIO_011119") :annotation (label (literal "quaternary structure" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a quaternary structure descriptor describes topological patterns in a multi-unit biopolymer complex." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010023") :subclass (iri "http://semanticscience.org/resource/SIO_011119") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a tertiary structure descriptor describes 3D topological patterns in  a biopolymer." :lang "en")) (label (literal "tertiary structure descriptor" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000850") :subclass (iri "http://semanticscience.org/resource/SIO_000840") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "joy is an emotion of intense happiness" :lang "en")) (label (literal "joy" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010022") :subclass (iri "http://semanticscience.org/resource/SIO_011119") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a secondary structure descriptor describes local topological patterns in  a biopolymer" :lang "en")) (label (literal "secondary structure descriptor" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000851") :subclass (iri "http://semanticscience.org/resource/SIO_000828") :annotation (label (literal "loathing" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "loathing is an intense dislike or disgust." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000849") :subclass (iri "http://semanticscience.org/resource/SIO_000834") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "jealousy is an emotion and typically refers to the negative thoughts and feelings of insecurity, fear, and anxiety over an anticipated loss of something that the person values, particularly in reference to a human connection" :lang "en")) (label (literal "jealousy" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010410") :subclass (iri "http://semanticscience.org/resource/SIO_000004") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_000004") (object-some (iri "http://semanticscience.org/resource/SIO_000644") (iri "http://semanticscience.org/resource/SIO_000340"))) :annotation (label (literal "specialized material entity" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a specialized material entity is a material entity that is defined by having some quality, role or capability" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010037") :subclass (iri "http://semanticscience.org/resource/SIO_010463") (object-only (iri "http://semanticscience.org/resource/SIO_000273") (iri "http://semanticscience.org/resource/SIO_010044")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a chemical element is a (effectively) homogeneous substance composed of one type of atom." :lang "en")) (label (literal "chemical element" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000844") :subclass (iri "http://semanticscience.org/resource/SIO_000832") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Hostility is the intense negative emotion of being in conflict or opposition to someone or something." :lang "en")) (label (literal "hostility" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010038") :subclass (iri "http://semanticscience.org/resource/SIO_011125") :annotation (label (literal "drug" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A drug is a chemical entity that regulates a biological process." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000843") :subclass (iri "http://semanticscience.org/resource/SIO_000831") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "hope is an emotion of belief in a positive outcome related to events and circumstances in one's life." :lang "en")) (label (literal "hope" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010039") :subclass (iri "http://semanticscience.org/resource/SIO_010411") :annotation (label (literal "pharmaceutical preparation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A pharmaceutical preparation is a chemical substance approved for use in the medical diagnosis, cure, treatment, or prevention of disease." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000842") :subclass (iri "http://semanticscience.org/resource/SIO_000863") :annotation (label (literal "grief" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Grief is an emotion in response to loss, whether physical or abstract including death, unemployment, ill health or the end of a relationship." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000841") :subclass (iri "http://semanticscience.org/resource/SIO_000832") :annotation (label (literal "guilt" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Guilt is the emotion borne from feeling responsible for the commission of an offense and arises out of public humiliation." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000848") :subclass (iri "http://semanticscience.org/resource/SIO_000831") :annotation (label (literal "interest" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "interest is the emotion of wanting to know or learn about something or someone." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000847") :subclass (iri "http://semanticscience.org/resource/SIO_000276") (object-or (object-not (object-some (iri "http://semanticscience.org/resource/SIO_000217") (iri "http://semanticscience.org/resource/SIO_001210"))) (object-not (object-some (iri "http://semanticscience.org/resource/SIO_000217") (iri "http://semanticscience.org/resource/SIO_001211")))) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "indifference is an emotion characterized by lack of interest, concern, or sympathy." :lang "en")) (label (literal "indifference" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000846") :subclass (iri "http://semanticscience.org/resource/SIO_000832") :annotation (label (literal "hysteria" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Hysteria is an unmanageable emotion." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000845") :subclass (iri "http://semanticscience.org/resource/SIO_000832") :annotation (label (literal "hurt" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "hurt is an unpleasant feeling, emotion or sensation." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010030") :subclass (iri "http://semanticscience.org/resource/SIO_010072") :disjoint (iri "http://semanticscience.org/resource/SIO_010011") (iri "http://semanticscience.org/resource/SIO_010346") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a monosaccharide is an organic polymer that consists of a single polyhydroxy aldehyde or ketone group." :lang "en")) (label (literal "monosaccharide" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010419") :subclass (iri "http://semanticscience.org/resource/SIO_011125") :annotation (label (literal "antigen" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An antigen is a chemical entity that can be bound by a major histocompatibility complex (MHC) and presented to a T-cell receptor." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010032") :subclass (iri "http://semanticscience.org/resource/SIO_000729") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A PDB record identifier is an identifier for a PDB generated record." :lang "en")) (label (literal "PDB record identifier" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010031") :subclass (iri "http://semanticscience.org/resource/SIO_000732") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A PDB chain identifier is a alphabetical label to identify a molecule in a structure provided by the Protein DataBank ." :lang "en")) (label (literal "PDB chain identifier" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010034") :subclass (iri "http://semanticscience.org/resource/SIO_010496") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A cation pi interaction is an ionic interaction between the localized negative charge of π orbital electrons, located above and below the plane of an aromatic ring, and a positive charge." :lang "en")) (label (literal "cation pi interaction" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010033") :subclass (iri "http://semanticscience.org/resource/SIO_010005") :annotation (label (literal "hydrogen bond" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a hydrogen bond is a weak submolecular interaction formed between a hydrogen atom and a electronegative atom." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000840") :subclass (iri "http://semanticscience.org/resource/SIO_000831") :annotation (label (literal "happiness" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Happiness is an emotion characterized by positive or pleasant emotions ranging from contentment to intense joy." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010036") :subclass (iri "http://semanticscience.org/resource/SIO_010508") (object-or (iri "http://semanticscience.org/resource/SIO_010508") (object-some (iri "http://semanticscience.org/resource/SIO_000139") (iri "http://semanticscience.org/resource/SIO_010343")) (object-some (iri "http://semanticscience.org/resource/SIO_000291") (iri "http://semanticscience.org/resource/SIO_010362")) (object-some (iri "http://semanticscience.org/resource/SIO_000312") (iri "http://semanticscience.org/resource/SIO_010363"))) :annotation (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "biopax:BiochemicalReaction" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "A biochemical reaction is a biochemical process that involves the conversion of at least one chemical participant (target) into another (product) by an enzyme (agent)." :lang "en")) (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "biopax:Conversion" :type :RDF_PLAIN_LITERAL)) (label (literal "biochemical reaction" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010035") :subclass (iri "http://semanticscience.org/resource/SIO_010335") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A gene is part of a nucleic acid that contains all the necessary elements to encode a functional transcript." :lang "en")) (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "http://purl.obolibrary.org/obo/SO_0000704" :type :XSD_ANY_URI)) (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "biopax:Gene" :type :RDF_PLAIN_LITERAL)) (label (literal "gene" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010412") :subclass (iri "http://semanticscience.org/resource/SIO_001050") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A specimen is a portion of material for use in testing, examination, or study." :lang "en")) (label (literal "specimen" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010411") :subclass (iri "http://semanticscience.org/resource/SIO_010462") :annotation (label (literal "reagent" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A reagent is a substance that is added to a system in order to bring about a chemical reaction, or added to see if a reaction occurs." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010414") :subclass (iri "http://semanticscience.org/resource/SIO_010000") :annotation (label (literal "pathogen" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A pathogen or infectious agent  is a microorganism that causes disease in its host." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010416") :subclass (iri "http://semanticscience.org/resource/SIO_010427") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A buffer is a dissolved chemical substance that resists change in pH upon addition of small amounts of acid or base." :lang "en")) (label (literal "buffer" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010415") :subclass (iri "http://semanticscience.org/resource/SIO_010000") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a host is an organism that harbors a parasite, or a mutual or commensal symbiont, typically providing nourishment and shelter." :lang "en")) (label (literal "host" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010418") :subclass (iri "http://semanticscience.org/resource/SIO_010427") :annotation (label (literal "solute" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a solute is a substance that becomes dissolved in a solvent." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010417") :subclass (iri "http://semanticscience.org/resource/SIO_010427") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A solvent is a substance that can dissolve other substances (solutes)." :lang "en")) (label (literal "solvent" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010420") :subclass (iri "http://semanticscience.org/resource/SIO_010437") :annotation (label (literal "receptor" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a receptor molecule is a molecule that has the capability to bind to a signal and propogate a response to that signal." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000879") :subclass (iri "http://semanticscience.org/resource/SIO_000889") :annotation (label (literal "reactant role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "the role of a chemical entity present at the beginning of a chemical reaction." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000878") :subclass (iri "http://semanticscience.org/resource/SIO_000876") :annotation (label (literal "graduate student advisor role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a graduate student advisor role is the role of an individual employed at an academic organization that is involved in advising graduate students." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010008") :subclass (iri "http://semanticscience.org/resource/SIO_010346") (object-at-least 2 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_010075")) :disjoint (iri "http://semanticscience.org/resource/SIO_010007") (iri "http://semanticscience.org/resource/SIO_010025") :annotation (label (literal "nucleic acid" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a nucleic acid is an organic polymer composed of a sequence of nucleotide residues." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010009") :subclass (iri "http://semanticscience.org/resource/SIO_010008") (object-at-least 2 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_010337")) :disjoint (iri "http://semanticscience.org/resource/SIO_010010") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a ribonucleic acid is an organic polymer composed of a sequence of ribonucleotide residues." :lang "en")) (label (literal "ribonucleic acid" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000875") :subclass (iri "http://semanticscience.org/resource/SIO_000711") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a department chain role is the role of an individual that heads a department at a academic organization." :lang "en")) (label (literal "department chair role" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010007") :subclass (iri "http://semanticscience.org/resource/SIO_010346") (object-at-least 2 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_010074")) :disjoint (iri "http://semanticscience.org/resource/SIO_010008") (iri "http://semanticscience.org/resource/SIO_010025") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a polypeptide is an organic polymer composed of amino acid residues." :lang "en")) (label (literal "polypeptide" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010004") :subclass (iri "http://semanticscience.org/resource/SIO_000004") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A chemical entity is a material entity that pertains to chemistry." :lang "en")) (annotation (iri "http://semanticscience.org/resource/subset") (literal "chemical+" :type :RDF_PLAIN_LITERAL)) (label (literal "chemical entity" :lang "en")) (annotation (iri "http://semanticscience.org/resource/example") (literal "atom, ion, molecule, chemical substance," :lang "en")) (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "CHEBI:23367" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000877") :subclass (iri "http://semanticscience.org/resource/SIO_000876") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an undergraduate student advisor role is the role of an individual employed at an academic organization that is involved in advising undergraduate students." :lang "en")) (label (literal "undergraduate student advisor role" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010005") :subclass (iri "http://semanticscience.org/resource/SIO_010020") :disjoint (iri "http://semanticscience.org/resource/SIO_010047") :annotation (label (literal "weak submolecular component" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a weak submolecular component is a submolecular component that weakly connects submolecular components." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000876") :subclass (iri "http://semanticscience.org/resource/SIO_000711") :annotation (label (literal "student advisor role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a student advisor role is the role of an individual employed at an academic organization that is involved in advising students." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010003") :subclass (iri "http://semanticscience.org/resource/SIO_010046") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an organ is a collection of tissues joined in structural unit to serve a common function." :lang "en")) (label (literal "organ" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000870") :subclass (iri "http://semanticscience.org/resource/SIO_000831") :annotation (label (literal "surprise" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Surprise is a brief emotion experienced as the result of an unexpected event. " :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010002") :subclass (iri "http://semanticscience.org/resource/SIO_010046") (object-some (iri "http://semanticscience.org/resource/SIO_000273") (iri "http://semanticscience.org/resource/SIO_010001")) :annotation (label (literal "tissue" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a tissue is a mereologically maximal collection of cells that together perform some function." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000871") :subclass (iri "http://semanticscience.org/resource/SIO_000829") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "terror is the extreme feeling of fear." :lang "en")) (label (literal "terror" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010001") :subclass (iri "http://semanticscience.org/resource/SIO_010046") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a cell is a biological entity that is contained by a plasma membrane." :lang "en")) (label (literal "cell" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000872") :subclass (iri "http://semanticscience.org/resource/SIO_000870") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Wonder is an emotion of perceiving something very rare or unexpected, but not threatening." :lang "en")) (label (literal "wonder" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010000") :subclass (iri "http://semanticscience.org/resource/SIO_010046") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_010377") (iri "http://semanticscience.org/resource/SIO_010378")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a biological organisn is a biological entity that consists of one or more cells and is capable of genomic replication (independently or not)." :lang "en")) (label (literal "organism" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000873") :subclass (iri "http://semanticscience.org/resource/SIO_000949") :annotation (label (literal "worry" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "worry is the emotion characterized by concer over a real or imaginary issue." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010429") :subclass (iri "http://semanticscience.org/resource/SIO_010462") :annotation (label (literal "placebo" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A placebo is a medically ineffectual treatment for a medical condition intended to deceive the recipient." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010428") :subclass (iri "http://semanticscience.org/resource/SIO_000881") :annotation (label (literal "evaluation role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an evaluation role is a processual role held by an entity during some evaluation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010427") :subclass (iri "http://semanticscience.org/resource/SIO_010462") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a liquid solution component is a part of a liquid solution." :lang "en")) (label (literal "liquid solution component" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010426") :subclass (iri "http://semanticscience.org/resource/SIO_011126") :annotation (label (literal "centrifugation substance" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a centrifugation substance is a substance that is the target or product of centrifugation." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010425") :subclass (iri "http://semanticscience.org/resource/SIO_010426") :disjoint (iri "http://semanticscience.org/resource/SIO_010424") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a supernatent is a liquid substance that remains after centrifugation." :lang "en")) (label (literal "supernatant" :lang "en")))
(annotation-property (iri "http://purl.org/dc/terms/contributor"))
(owl-class (iri "http://semanticscience.org/resource/SIO_010424") :subclass (iri "http://semanticscience.org/resource/SIO_010426") :disjoint (iri "http://semanticscience.org/resource/SIO_010425") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a centrifugation pellet is a solid substance that forms as a result of compaction by a centrifuge." :lang "en")) (label (literal "centrifugation pellet" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010423") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_011125") (object-some (iri "http://semanticscience.org/resource/SIO_000292") (iri "http://semanticscience.org/resource/SIO_000006"))) :annotation (label (literal "target" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010430") :subclass (iri "http://semanticscience.org/resource/SIO_010428") :annotation (label (literal "test role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a test role is the role of an individual that is a participant in the study and is the target of the intervention." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010431") :subclass (iri "http://semanticscience.org/resource/SIO_010428") :annotation (label (literal "control role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a control role is the role of an individual that is part of a study, but is not subject to the intervention that is to be tested." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010432") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_011125") (object-or (object-some (iri "http://semanticscience.org/resource/SIO_000310") (iri "http://semanticscience.org/resource/SIO_010506")) (object-some (iri "http://semanticscience.org/resource/SIO_000335") (iri "http://semanticscience.org/resource/SIO_011125")))) :annotation (label (literal "ligand" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a ligand is a molecule that is part of a complex by weakly interacting with another molecule " :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011131") :subclass (iri "http://semanticscience.org/resource/SIO_011123") (object-some (iri "http://semanticscience.org/resource/SIO_000059") (iri "http://semanticscience.org/resource/SIO_010530")) :annotation (label (literal "collection of 3d molecular structure models" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a collection of 3d molecular structure models is just that." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_011130") :subclass (iri "http://semanticscience.org/resource/SIO_011120") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A PDB file is a molecular structure file specified by the Protein DataBank (PDB)." :lang "en")) (label (literal "PDB file" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010019") :subclass (iri "http://semanticscience.org/resource/SIO_000472") :annotation (label (literal "biological data" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Biological data is scientific data relevant to biology." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000869") :subclass (iri "http://semanticscience.org/resource/SIO_000845") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Suffering is the unpleasant emotion and aversion associated with the perception of harm or threat of harm in an individual." :lang "en")) (label (literal "suffering" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000868") :subclass (iri "http://semanticscience.org/resource/SIO_000863") :annotation (label (literal "sorrow" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Sorrow is the emotion that is characterized by a long term state of intense sadness, distress and a degree of resignation (not accepting)." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000867") :subclass (iri "http://semanticscience.org/resource/SIO_000832") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "shyness is an emotion of apprehension, lack of comfort, or awkwardness experienced when in proximity to, approaching, or being approached by other individuals, especially in new situations or with unfamiliar individuals." :lang "en")) (label (literal "shyness" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010015") :subclass (iri "http://semanticscience.org/resource/SIO_000030") (object-some (iri "http://semanticscience.org/resource/SIO_000011") (iri "http://semanticscience.org/resource/SIO_010007")) (object-some (iri "http://semanticscience.org/resource/SIO_000210") (object-or (iri "http://semanticscience.org/resource/SIO_000626") (object-some (iri "http://semanticscience.org/resource/SIO_000011") (iri "http://semanticscience.org/resource/SIO_010007")))) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a protein acid sequence is the character representation of the molecular structure of a protein." :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "amino acid sequence" :lang "en")) (label (literal "protein sequence" :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "polypeptide sequence" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000866") :subclass (iri "http://semanticscience.org/resource/SIO_000832") :annotation (label (literal "shock" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "shock is an emotion of sudden upset or surprise." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010016") :subclass (iri "http://semanticscience.org/resource/SIO_000030") (object-some (iri "http://semanticscience.org/resource/SIO_000011") (iri "http://semanticscience.org/resource/SIO_010008")) (object-some (iri "http://semanticscience.org/resource/SIO_000210") (object-or (iri "http://semanticscience.org/resource/SIO_000626") (object-some (iri "http://semanticscience.org/resource/SIO_000011") (iri "http://semanticscience.org/resource/SIO_010008")))) :annotation (label (literal "nucleic acid sequence" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a nucleic acid sequence is a symbolic representation of the sequence of nucleic acid residues in a nucleic acid." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000865") :subclass (iri "http://semanticscience.org/resource/SIO_000832") :annotation (label (literal "shame" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "shame is the emotion borne from feeling responsible for the commission of an offense." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010017") :subclass (iri "http://semanticscience.org/resource/SIO_010016") (object-some (iri "http://semanticscience.org/resource/SIO_000332") (iri "http://semanticscience.org/resource/SIO_010009")) :annotation (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "RNA sequence" :lang "en")) (label (literal "ribonucleic acid sequence" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a ribonucleic acid sequence is a symbolic representation of the sequence of ribonucleic acid residues in a ribonucleic acid." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000864") :subclass (iri "http://semanticscience.org/resource/SIO_000822") :annotation (label (literal "satisfaction" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "satisfaction is an emotion of fulfillment of one's wishes, expectations, or needs, or the pleasure derived from this." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010018") :subclass (iri "http://semanticscience.org/resource/SIO_010016") (object-some (iri "http://semanticscience.org/resource/SIO_000332") (iri "http://semanticscience.org/resource/SIO_010010")) :annotation (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "DNA sequence" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a deoxyribonucleic acid sequence is a symbolic representation of the sequence of deoxyribonucleic acid residues in a deoxyribonucleic acid." :lang "en")) (label (literal "deoxyribonucleic acid sequence" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000863") :subclass (iri "http://semanticscience.org/resource/SIO_000832") :annotation (label (literal "sadness" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "sadness is emotional pain associated with, or characterized by feelings of disadvantage, loss, despair, helplessness, sorrow, and rage." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000861") :subclass (iri "http://semanticscience.org/resource/SIO_000873") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "regret is a feeling of sadness, repentance, or disappointment over something that has happened or been done." :lang "en")) (label (literal "regret" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010011") :subclass (iri "http://semanticscience.org/resource/SIO_010072") :disjoint (iri "http://semanticscience.org/resource/SIO_010030") (iri "http://semanticscience.org/resource/SIO_010346") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a lipid is a water-insoluable organic molecule" :lang "en")) (label (literal "lipid" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000862") :subclass (iri "http://semanticscience.org/resource/SIO_000861") :annotation (label (literal "remorse" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "remorse is an emotion of personal regret felt by a person after he or she has committed an act which they deem to be shameful, hurtful, or violent." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010014") :subclass (iri "http://semanticscience.org/resource/SIO_011119") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a primary structure descriptor describes a biomolecular object in terms of a 1D or 2D topology." :lang "en")) (label (literal "primary structure descriptor" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010013") :subclass (iri "http://semanticscience.org/resource/SIO_000593") (object-some (iri "http://semanticscience.org/resource/SIO_000132") (iri "http://semanticscience.org/resource/SIO_010004")) :annotation (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "biopax:Interaction" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "A chemical interaction is a biochemical process in which chemical entities interact through some set of attractive forces." :lang "en")) (label (literal "chemical interaction" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000860") :subclass (iri "http://semanticscience.org/resource/SIO_000410") :annotation (label (literal "rage" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Rage is a feeling of intense anger that is associated with the Fight-or-flight response." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010010") :subclass (iri "http://semanticscience.org/resource/SIO_010008") (object-at-least 2 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_010336")) :disjoint (iri "http://semanticscience.org/resource/SIO_010009") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a deoxyribonucleic acid is an organic polymer composed of a sequence of deoxyribonucleotide residues." :lang "en")) (label (literal "deoxyribonucleic acid" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010438") :subclass (iri "http://semanticscience.org/resource/SIO_011125") :annotation (label (literal "signal" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a signal is an object that initiates a sequence of events." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010437") :subclass (iri "http://semanticscience.org/resource/SIO_011125") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a signal transducer is a molecule that responds to and amplifies a signal in a signalling system." :lang "en")) (label (literal "signal transducer" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010439") :subclass (iri "http://semanticscience.org/resource/SIO_010437") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a mesenger is a molecule involved in either signal detection or signal propagation from receptors on the cell surface to target molecules inside the cell, in the cytoplasm or nucleus. " :lang "en")) (label (literal "messenger" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010434") :subclass (iri "http://semanticscience.org/resource/SIO_010436") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a molecular activator is a molecular regulator that realizes its disposition to conformationally change a target molecule and increase its functionality." :lang "en")) (label (literal "activator" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010433") :subclass (iri "http://semanticscience.org/resource/SIO_010033") :annotation (label (literal "low barrier hydrogen bond" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a low barrier hydrogen bond is a shorter, stronger hydrogen bond that is formed between both heteroatoms." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010436") :subclass (iri "http://semanticscience.org/resource/SIO_011125") (object-some (iri "http://semanticscience.org/resource/SIO_000586") (iri "http://semanticscience.org/resource/SIO_000395")) :annotation (label (literal "molecular regulator" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a molecular regulator is a molecule that regulates the function of another chemical entity." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010435") :subclass (iri "http://semanticscience.org/resource/SIO_010436") :annotation (label (literal "inhibitor" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a molecular inhibitor is a molecular regulator that realizes its disposition to conformationally change a target molecule and decrease its functionality." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000404") :subclass (iri "http://semanticscience.org/resource/SIO_000406") :annotation (label (literal "professor" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a professor is an individual that is a scholarly teacher." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000403") :subclass (iri "http://semanticscience.org/resource/SIO_000620") :annotation (label (literal "study group" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a study group is a group of individuals that are subjects in an observational or intervention study." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000402") :subclass (iri "http://semanticscience.org/resource/SIO_000072") :disjoint (iri "http://semanticscience.org/resource/SIO_000333") (iri "http://semanticscience.org/resource/SIO_000400") (iri "http://semanticscience.org/resource/SIO_000401") :annotation (label (literal "z cartesian coordinate" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a z cartesian coordinate is the coordinate of an object onto the z-axis of a cartesian coordinate system." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000401") :subclass (iri "http://semanticscience.org/resource/SIO_000072") :disjoint (iri "http://semanticscience.org/resource/SIO_000333") (iri "http://semanticscience.org/resource/SIO_000400") (iri "http://semanticscience.org/resource/SIO_000402") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an y cartesian coordinate is the coordinate of an object onto the y-axis of a cartesian coordinate system." :lang "en")) (label (literal "y cartesian coordinate" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001050") :subclass (iri "http://semanticscience.org/resource/SIO_010462") (object-or (object-some (iri "http://semanticscience.org/resource/SIO_000095") (iri "http://semanticscience.org/resource/SIO_000616")) (object-some (iri "http://semanticscience.org/resource/SIO_000244") (iri "http://semanticscience.org/resource/SIO_000776"))) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a sample is a limited quantity of something (e.g. an individual or set of individuals from a population, or a portion of a substance) to be used for testing, analysis, inspection, investigation, demonstration, or trial use." :lang "en")) (label (literal "sample" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000408") :subclass (iri "http://semanticscience.org/resource/SIO_000494") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to investigate is the capability to uncover facts." :lang "en")) (label (literal "to investigate" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000407") :subclass (iri "http://semanticscience.org/resource/SIO_000536") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to increase the rate of formation is to regulate the rate of formation in a manner that increases this rate relative to a reference process." :lang "en")) (label (literal "to increase the rate of formation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001052") :subclass (iri "http://semanticscience.org/resource/SIO_000649") (object-some (iri "http://semanticscience.org/resource/SIO_000312") (iri "http://semanticscience.org/resource/SIO_000069")) :annotation (label (literal "data collection" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "data collection is the process of acquiring information." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000406") :subclass (iri "http://semanticscience.org/resource/SIO_000498") :annotation (label (literal "academic" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an academic is an individual that participates in education and scholarship." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001051") :subclass (iri "http://semanticscience.org/resource/SIO_000649") (object-or (object-some (iri "http://semanticscience.org/resource/SIO_000229") (iri "http://semanticscience.org/resource/SIO_000256")) (object-some (iri "http://semanticscience.org/resource/SIO_000230") (iri "http://semanticscience.org/resource/SIO_000069"))) :annotation (label (literal "data analysis" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "data analysis is a process of inspecting, cleaning, transforming, and modeling data with the goal of highlighting useful information, suggesting conclusions, and supporting decision making." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000405") :subclass (iri "http://semanticscience.org/resource/SIO_000406") :annotation (label (literal "student" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a student is an individual who is attends an educational institution." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001054") :subclass (iri "http://semanticscience.org/resource/SIO_000593") (object-some (iri "http://semanticscience.org/resource/SIO_000229") (iri "http://semanticscience.org/resource/SIO_000070")) (object-some (iri "http://semanticscience.org/resource/SIO_000230") (object-or (iri "http://semanticscience.org/resource/SIO_000005") (iri "http://semanticscience.org/resource/SIO_000006") (iri "http://semanticscience.org/resource/SIO_000776"))) :annotation (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "measurement" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "measuring is the process of determining the size, amount, or degree of (something) by using an instrument or device marked in standard units" :lang "en")) (label (literal "measuring" :lang "en")))
(annotation-property (iri "http://semanticscience.org/resource/similarTo"))
(owl-class (iri "http://semanticscience.org/resource/SIO_001053") :subclass (iri "http://semanticscience.org/resource/SIO_000683") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A reason is a justification that specifies the motive for an action or a determination" :lang "en")) (label (literal "reason" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001056") :subclass (iri "http://semanticscience.org/resource/SIO_000613") (data-only (iri "http://semanticscience.org/resource/SIO_000300") :XSD_INTEGER) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "the ordinal position of a character in a sequence of characters." :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "character offset" :type :RDF_PLAIN_LITERAL)) (label (literal "character position" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000409") :subclass (iri "http://semanticscience.org/resource/SIO_000014") :annotation (label (literal "mutual disposition" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a mutual disposition is a disposition that simulataneously invokes another disposition when realized." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001055") :subclass (iri "http://semanticscience.org/resource/SIO_000593") (object-some (iri "http://semanticscience.org/resource/SIO_000229") (iri "http://semanticscience.org/resource/SIO_000000")) (object-some (iri "http://semanticscience.org/resource/SIO_000230") (iri "http://semanticscience.org/resource/SIO_000000")) :annotation (label (literal "observing" :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "observation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "observing is a process of passive interaction in which one entity makes note of attributes of one or more entities." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001058") :subclass (iri "http://semanticscience.org/resource/SIO_001072") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "word end position is the position of the last character in a word as an offset from the first character of the text in which it is found." :lang "en")) (label (literal "word end position" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001057") :subclass (iri "http://semanticscience.org/resource/SIO_001071") (object-some (iri "http://semanticscience.org/resource/SIO_000068") (iri "http://semanticscience.org/resource/SIO_000651")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "the position of the first character in a word as an offset from the first character of the text in which it is found." :lang "en")) (label (literal "word start position" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001059") :subclass (iri "http://semanticscience.org/resource/SIO_000969") :annotation (label (literal "gesturing" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "gesturing is a form of non-verbal communication in which visible bodily actions communicate particular messages, either in place of speech or together and in parallel with spoken words. Gestures include movement of the hands, face, or other parts of the body." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000810") :subclass (iri "http://semanticscience.org/resource/SIO_000805") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_010461") (iri "http://semanticscience.org/resource/SIO_010464")) :annotation (label (literal "complete charge" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a complete charge is a charge where the value of the charge is a multiple of 1." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000811") :subclass (iri "http://semanticscience.org/resource/SIO_000731") (data-some (iri "http://semanticscience.org/resource/SIO_000300") :XSD_ANY_URI) :annotation (label (literal "URL" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a Uniform Resource Locator or Universal Resource Locator (URL) is a specific character string that constitutes a reference to an Internet resource." :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "Uniform Resource Locator" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000814") :subclass (iri "http://semanticscience.org/resource/SIO_000832") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Annoyance is an unpleasant emtion that is characterized by a abnormal or excessive sensitivity to some external stimulus." :lang "en")) (label (literal "annoyance" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000815") :subclass (iri "http://semanticscience.org/resource/SIO_000949") :annotation (label (literal "anxiety" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "anxiety is an emotion charactersized by intense feeling of fear and concern coupled with a physical response." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000812") :subclass (iri "http://semanticscience.org/resource/SIO_000831") :annotation (label (literal "affection" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "affection is an emotion characterized with a feeling or type of love for another living thing." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000813") :subclass (iri "http://semanticscience.org/resource/SIO_000815") :annotation (label (literal "angst" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "angst is the intense feeling of apprehension, anxiety or inner turmoil." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000818") :subclass (iri "http://semanticscience.org/resource/SIO_000831") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Awe is an emotion produced by that which is grand, sublime or powerful and is characterized by a combination of joy, fear and admiration/reverence/respect. " :lang "en")) (label (literal "awe" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000819") :subclass (iri "http://semanticscience.org/resource/SIO_000831") :annotation (label (literal "boldness" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "boldness is the trait of being willing to undertake things that involve risk or danger." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000816") :subclass (iri "http://semanticscience.org/resource/SIO_000847") :annotation (label (literal "apathy" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "apathy is an emotion characterized by lack of interest, enthusiasm, or concern" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000817") :subclass (iri "http://semanticscience.org/resource/SIO_000831") :annotation (label (literal "arousal" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Arousal is an emotion characterized by state of reactive to stimuli. It involves the activation of the reticular activating system in the brain stem, the autonomic nervous system and the endocrine system, leading to increased heart rate and blood pressure and a condition of sensory alertness, mobility and readiness to respond." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000400") :subclass (iri "http://semanticscience.org/resource/SIO_000072") :disjoint (iri "http://semanticscience.org/resource/SIO_000333") (iri "http://semanticscience.org/resource/SIO_000401") (iri "http://semanticscience.org/resource/SIO_000402") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an x cartesian coordinate is the coordinate of an object onto the x-axis of a cartesian coordinate system." :lang "en")) (label (literal "x cartesian coordinate" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000413") :subclass (iri "http://semanticscience.org/resource/SIO_000414") :annotation (label (literal "geolegal region" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A geolegal region is a geographic region which has causal powers confered by a legal entity." :lang "en")) (annotation (iri "http://semanticscience.org/resource/example") (literal "the 50 kph zones in Ottawa; the geographic region occupied by France." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000412") :subclass (iri "http://semanticscience.org/resource/SIO_000831") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Love is an emotion of a strong affection and personal attachment." :lang "en")) (label (literal "love" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000415") :subclass (iri "http://semanticscience.org/resource/SIO_000413") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a geopolitical region is a geographic region recognized by social or legal convention." :lang "en")) (label (literal "geopolitical region" :lang "en")) (annotation (iri "http://semanticscience.org/resource/example") (literal "the geographic region bounded by Canada; the spatial region occupied by the US embassy in Ottawa" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000414") :subclass (iri "http://semanticscience.org/resource/SIO_000370") :annotation (annotation (iri "http://semanticscience.org/resource/example") (literal "the spatial region occupied by the province of ontario; the spatial region occupied by a lake." :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a geographic region is a spatial region whose boundaries are typically defined against some material frame of reference (like the earth)." :lang "en")) (label (literal "geographic region" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001063") :subclass (iri "http://semanticscience.org/resource/SIO_000620") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a group of people affiliated by consanguinity, affinity, or co-residence." :lang "en")) (label (literal "family" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000417") :subclass (iri "http://semanticscience.org/resource/SIO_000391") :annotation (label (literal "time interval" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a time internval is a contiguous temporal region having some duration." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001062") :subclass (iri "http://semanticscience.org/resource/SIO_001061") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a human population refers to a collection of human beings." :lang "en")) (label (literal "human population" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001061") :subclass (iri "http://semanticscience.org/resource/SIO_000620") :annotation (label (literal "population" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A population is all the organisms that both belong to the same group or species and live in the same geographical area." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000419") :subclass (iri "http://semanticscience.org/resource/SIO_000080") :annotation (label (literal "table" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A table is a figure that consists of an ordered arrangement of columns and rows." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001060") :subclass (iri "http://semanticscience.org/resource/SIO_000963") :annotation (label (literal "planned" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "planned is a process status for a process that has not yet started, but is referred to in a plan." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000418") :subclass (iri "http://semanticscience.org/resource/SIO_000391") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a time instant is a temporal region which occurs instantaneously e.g. having no duration." :lang "en")) (label (literal "time instant" :lang "en")) (annotation (iri "http://semanticscience.org/resource/example") (literal "at this moment; the moment at which a finger is detached in an industrial accident; the moment at which a child is born; the moment of death" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001067") :subclass (iri "http://semanticscience.org/resource/SIO_000976") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "In a controlled observational cohort study, two groups of subjects are selected from two populations that are thought to differ in only one characteristic. The groups of subjects are studied for a specific period and contrasted at the end of the study period." :lang "en")) (label (literal "controlled observational cohort study" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001066") :subclass (iri "http://semanticscience.org/resource/SIO_000747") (object-some (iri "http://semanticscience.org/resource/SIO_000355") (iri "http://semanticscience.org/resource/SIO_000337")) (object-some (iri "http://semanticscience.org/resource/SIO_000426") (iri "http://semanticscience.org/resource/SIO_001041")) :annotation (label (literal "study" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a study is a process that realizes the steps of a study design." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001065") :subclass (iri "http://semanticscience.org/resource/SIO_001004") :annotation (label (literal "speculation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "speculation is an opinion based on incomplete evidence" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001064") :subclass (iri "http://semanticscience.org/resource/SIO_000620") :annotation (label (literal "community" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a community is a sizeable social unit that shares common values." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001069") :subclass (iri "http://semanticscience.org/resource/SIO_000403") :annotation (label (literal "intervention group" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An intervention group is a group of individuals that are subject to an intervention." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001068") :subclass (iri "http://semanticscience.org/resource/SIO_000403") :annotation (label (literal "control group" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a control group is a group of individuals that are not subject to an intervention of interest, but rather serve as a baseline to compare the outcomes in the intervention group." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000800") :subclass (iri "http://semanticscience.org/resource/SIO_000797") (iri "http://semanticscience.org/resource/SIO_000799") :annotation (label (literal "co-enzyme role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a co-factor role in which the chemical entity is modified during catalysis and must be regenerated." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000801") :subclass (iri "http://semanticscience.org/resource/SIO_000800") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a coenzyme role of a chemical entity that is covalently bonded to the  enzyme." :lang "en")) (label (literal "prosthetic group role" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000802") :subclass (iri "http://semanticscience.org/resource/SIO_000800") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a co-enzyme role of a chemical entity that is transiently associated, and is regenerated in a separate reaction." :lang "en")) (label (literal "co-substrate role" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000803") :subclass (iri "http://semanticscience.org/resource/SIO_000880") :annotation (label (literal "inhibitor role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "the role of a chemical entity that reduces the rate of reaction." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000804") :subclass (iri "http://semanticscience.org/resource/SIO_000880") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "the role of a chemical entity that increases the rate of reaction." :lang "en")) (label (literal "activator role" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000805") :subclass (iri "http://semanticscience.org/resource/SIO_010442") :disjoint (iri "http://semanticscience.org/resource/SIO_000806") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "The quality of having a charge" :lang "en")) (label (literal "charged" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000806") :subclass (iri "http://semanticscience.org/resource/SIO_010442") :disjoint (iri "http://semanticscience.org/resource/SIO_000805") :annotation (label (literal "uncharged" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "the quality of not having a charge" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000807") :subclass (iri "http://semanticscience.org/resource/SIO_000809") :disjoint (iri "http://semanticscience.org/resource/SIO_000808") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a partial negative charge is a negative charge where the value of the charge is negative." :lang "en")) (label (literal "partial positive charge" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000808") :subclass (iri "http://semanticscience.org/resource/SIO_000809") :disjoint (iri "http://semanticscience.org/resource/SIO_000807") :annotation (label (literal "partial negative charge" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a partial positive charge is a partial charge where the value of the charge is positive." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000809") :subclass (iri "http://semanticscience.org/resource/SIO_000805") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_000807") (iri "http://semanticscience.org/resource/SIO_000808")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "the quality of having a charge that is not a full multiple of 1 unit charge." :lang "en")) (label (literal "partial charge" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000410") :subclass (iri "http://semanticscience.org/resource/SIO_000828") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "anger is disgust directed toward an equal status individual." :lang "en")) (label (literal "anger" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000411") :subclass (iri "http://semanticscience.org/resource/SIO_000828") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Hate is a deep and emotional extreme dislike, directed against a certain object or class of objects. " :lang "en")) (label (literal "hate" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001072") :subclass (iri "http://semanticscience.org/resource/SIO_000953") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "text span end position is the position (offset) of the last character of a text span in relation the text it is from." :type :RDF_PLAIN_LITERAL)) (label (literal "text span end position" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001071") :subclass (iri "http://semanticscience.org/resource/SIO_000943") :annotation (label (literal "text span start position" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "text span start position is the position (offset) of the first character of a text span in relation the text it is from." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000429") :subclass (iri "http://semanticscience.org/resource/SIO_000417") :disjoint (iri "http://semanticscience.org/resource/SIO_000428") (iri "http://semanticscience.org/resource/SIO_000430") (iri "http://semanticscience.org/resource/SIO_000431") (iri "http://semanticscience.org/resource/SIO_000432") (iri "http://semanticscience.org/resource/SIO_000433") (iri "http://semanticscience.org/resource/SIO_000434") (iri "http://semanticscience.org/resource/SIO_000435") :annotation (label (literal "month" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a month is a period of time that divides the year." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001074") :subclass (iri "http://semanticscience.org/resource/SIO_001018") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a t-statistic is a ratio of the departure of an estimated parameter from its notional value and its standard error. " :lang "en")) (label (literal "t-statistic" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000428") :subclass (iri "http://semanticscience.org/resource/SIO_000417") :disjoint (iri "http://semanticscience.org/resource/SIO_000429") (iri "http://semanticscience.org/resource/SIO_000430") (iri "http://semanticscience.org/resource/SIO_000431") (iri "http://semanticscience.org/resource/SIO_000432") (iri "http://semanticscience.org/resource/SIO_000433") (iri "http://semanticscience.org/resource/SIO_000434") (iri "http://semanticscience.org/resource/SIO_000435") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a year is a period of time taken by a planet to make one revolution around the sun." :lang "en")) (label (literal "year" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001073") :subclass (iri "http://semanticscience.org/resource/SIO_000651") (object-or (object-some (iri "http://semanticscience.org/resource/SIO_000008") (iri "http://semanticscience.org/resource/SIO_001071")) (object-some (iri "http://semanticscience.org/resource/SIO_000008") (iri "http://semanticscience.org/resource/SIO_001072"))) :annotation (label (literal "text span" :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "selector" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "a text span is a subset of contiguous sequence of characters of a textual entity." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001070") :subclass (iri "http://semanticscience.org/resource/SIO_000367") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A control variable that is believed to alter the dependent or independent variables, but may not actually be the focus of the experiment. So that variable will be kept constant or monitored to try to minimise its effect on the experiment." :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "extraneous variable" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "controlled variable" :type :RDF_PLAIN_LITERAL)) (label (literal "control variable" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000423") :subclass (iri "http://semanticscience.org/resource/SIO_000083") :annotation (label (literal "scatterplot" :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "scatter diagram" :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "scatter graph" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A scatterplot is a statistical graph which uses Cartesian coordinates to display values for two variables for a set of data. The data is displayed as a collection of points, each having the value of one variable determining the position on the horizontal axis and the value of the other variable determining the position on the vertical axis." :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "scatter chart" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001079") :subclass (iri "http://semanticscience.org/resource/SIO_000315") :annotation (label (literal "genotype" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a genotype is a functional specification of a biological entity in terms of its genetic composition (or lack thereof)." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001076") :subclass (iri "http://semanticscience.org/resource/SIO_000994") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a microarray experiment is an experiment that involves a microarray device to measure the expression of one or more genes." :lang "en")) (label (literal "microarray experiment" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001075") :subclass (iri "http://semanticscience.org/resource/SIO_000732") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a microarray probe set identifier is an identifier for a set of probe pairs selected to represent expressed sequences on an array. " :lang "en")) (label (literal "microarray probe set identifier" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001078") :subclass (iri "http://semanticscience.org/resource/SIO_001018") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a differential gene expression ratio is the ratio of gene expression values from a test sample compared to a control sample." :lang "en")) (label (literal "differential gene expression ratio" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001077") :subclass (iri "http://semanticscience.org/resource/SIO_000258") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a gene expression value is a measured value obtained from a gene expression experiment." :lang "en")) (label (literal "gene expression value" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000836") :subclass (iri "http://semanticscience.org/resource/SIO_000831") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "excitement is a positive emotion of feeling great enthusiasm and eagerness." :lang "en")) (label (literal "excitement" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000837") :subclass (iri "http://semanticscience.org/resource/SIO_000949") :annotation (label (literal "fear" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Fear is a negative emotion induced by a perceived threat that induces one to hide or move quickly away from the location of the perceived threat." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000834") :subclass (iri "http://semanticscience.org/resource/SIO_000832") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "envy is an emotion that occurs when a person lacks another's (perceived) superior quality, achievement or possession and wishes that the other lacked it." :lang "en")) (label (literal "envy" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000835") :subclass (iri "http://semanticscience.org/resource/SIO_000840") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "euphoria is an emotion characterized by intense feelings of well-being, elation, happiness, ecstasy, excitement, and joy." :lang "en")) (label (literal "euphoria" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000832") :subclass (iri "http://semanticscience.org/resource/SIO_000276") (object-some (iri "http://semanticscience.org/resource/SIO_000217") (iri "http://semanticscience.org/resource/SIO_001211")) :annotation (label (literal "negative emotion" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "negative emotion is an emotion that does not feel good." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000833") :subclass (iri "http://semanticscience.org/resource/SIO_000832") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Embarrassment is the emotion of intense discomfort with oneself, experienced upon having a socially unacceptable act or condition witnessed by or revealed to other." :lang "en")) (label (literal "embarassment" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000830") :subclass (iri "http://semanticscience.org/resource/SIO_000831") :annotation (label (literal "ecstasy" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "ecstacy is an emotion characterized by a heightened state of consciousness with total involvement of a subject." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000831") :subclass (iri "http://semanticscience.org/resource/SIO_000276") (object-some (iri "http://semanticscience.org/resource/SIO_000217") (iri "http://semanticscience.org/resource/SIO_001210")) :annotation (label (literal "positive emotion" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a positive emotion is an emotion that feels good." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000838") :subclass (iri "http://semanticscience.org/resource/SIO_000814") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Frustration is an emotion that arises from the perceived resistance to the fulfillment of individual will. " :lang "en")) (label (literal "frustration" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000839") :subclass (iri "http://semanticscience.org/resource/SIO_000831") :annotation (label (literal "gratitude" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Gratitude, thankfulness, gratefulness, or appreciation is a feeling, emotion or attitude in acknowledgment of a benefit that one has received or will receive." :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "gratefulness" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "appreciation" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "thankfullness" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_001085") :subclass (iri "http://semanticscience.org/resource/SIO_010340") :annotation (label (literal "to remove a covalent bond" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to remove a covalent bond is the capability to covalently modify a chemical entity by removing a covalent bond." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000439") :subclass (iri "http://semanticscience.org/resource/SIO_000056") :annotation (label (literal "center of mass" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "the center of mass (aka barycenter) is the weighted average location of all the mass in a body or group of bodies." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001084") :subclass (iri "http://semanticscience.org/resource/SIO_010462") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a liquid solution is a heterogeneous substance in a liquid state." :lang "en")) (label (literal "liquid solution" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000438") :subclass (iri "http://semanticscience.org/resource/SIO_000056") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Altitude is a distance above sea level." :lang "en")) (label (literal "altitude" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001083") :subclass (iri "http://semanticscience.org/resource/SIO_000418") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a date of database submission refers to the moment in time in which some information was submitted/received to a database system." :lang "en")) (label (literal "date of database submission" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001082") :subclass (iri "http://semanticscience.org/resource/SIO_001078") (object-some (iri "http://semanticscience.org/resource/SIO_000008") (object-or (iri "http://semanticscience.org/resource/SIO_001074") (data-some (iri "http://semanticscience.org/resource/SIO_000300") (span < 0.0)))) :annotation (label (literal "t-statistic based decreased differential gene expression" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a t-statistic based decreased differential gene expression is a differential gene expression ratio in which the t-statistic is less than zero." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001081") :subclass (iri "http://semanticscience.org/resource/SIO_001078") (object-some (iri "http://semanticscience.org/resource/SIO_000008") (object-or (iri "http://semanticscience.org/resource/SIO_001074") (data-some (iri "http://semanticscience.org/resource/SIO_000300") (span > 0.0)))) :annotation (label (literal "t-statistic based increased differential gene expression" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a t-statistic based increased differential gene expression is a differential gene expression ratio in which the t-statistic is greater than zero." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000435") :subclass (iri "http://semanticscience.org/resource/SIO_000417") :disjoint (iri "http://semanticscience.org/resource/SIO_000428") (iri "http://semanticscience.org/resource/SIO_000429") (iri "http://semanticscience.org/resource/SIO_000430") (iri "http://semanticscience.org/resource/SIO_000431") (iri "http://semanticscience.org/resource/SIO_000432") (iri "http://semanticscience.org/resource/SIO_000433") (iri "http://semanticscience.org/resource/SIO_000434") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a second (symbol: s) is the base unit of time in the International System of Units (SI) and is the second division of the hour by sixty, the first division by 60 being the minute." :lang "en")) (label (literal "second" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001080") :subclass (iri "http://semanticscience.org/resource/SIO_000078") (iri "http://semanticscience.org/resource/SIO_000616") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a vocabulary is a collection of terms." :lang "en")) (label (literal "vocabulary" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000434") :subclass (iri "http://semanticscience.org/resource/SIO_000417") :disjoint (iri "http://semanticscience.org/resource/SIO_000428") (iri "http://semanticscience.org/resource/SIO_000429") (iri "http://semanticscience.org/resource/SIO_000430") (iri "http://semanticscience.org/resource/SIO_000431") (iri "http://semanticscience.org/resource/SIO_000432") (iri "http://semanticscience.org/resource/SIO_000433") (iri "http://semanticscience.org/resource/SIO_000435") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a minute is a period of 60 seconds." :lang "en")) (label (literal "minute" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000437") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_000507") (object-only (iri "http://semanticscience.org/resource/SIO_000369") (object-or (iri "http://semanticscience.org/resource/SIO_000400") (iri "http://semanticscience.org/resource/SIO_000401"))) (object-exactly 1 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_000400")) (object-exactly 1 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_000401"))) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a 2D cartesian point is a point whose position is specified along two  dimensions using Cartesian coordinates." :lang "en")) (label (literal "2D cartesian point" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000436") :subclass (iri "http://semanticscience.org/resource/SIO_000005") (object-some (iri "http://semanticscience.org/resource/SIO_000218") (iri "http://semanticscience.org/resource/SIO_000015")) :annotation (label (literal "informational quality" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an informational quality is a quality that pertains to information." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001089") :subclass (iri "http://semanticscience.org/resource/SIO_000257") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "pH is a measure of the activity of the (solvated) hydrogen ion. " :lang "en")) (owl-comment (literal "pH is defined as the decimal logarithm of the reciprocal of the hydrogen ion activity, aH+, in a solution." :type :RDF_PLAIN_LITERAL)) (label (literal "pH" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001088") :subclass (iri "http://semanticscience.org/resource/SIO_000048") (object-some (iri "http://semanticscience.org/resource/SIO_000011") (object-or (iri "http://semanticscience.org/resource/SIO_010462") (object-some (iri "http://semanticscience.org/resource/SIO_000093") (iri "http://semanticscience.org/resource/SIO_011126")))) :annotation (label (literal "concentration" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "concentration is the quantity of a constituent divided by the total volume of a mixture." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001087") :subclass (iri "http://semanticscience.org/resource/SIO_000385") :annotation (label (literal "to modify electronically" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to modify electronically is the capability to change the electronic properties of an object." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001086") :subclass (iri "http://semanticscience.org/resource/SIO_010340") :annotation (label (literal "to add a covalent bond" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to add a covalent bond is the capability to covalently modify a chemical entity by adding a covalent bond." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000823") :subclass (iri "http://semanticscience.org/resource/SIO_000825") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "curiosity is the strong desire to know or learn something." :lang "en")) (label (literal "curiosity" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000824") :subclass (iri "http://semanticscience.org/resource/SIO_000863") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "depression is an unpleasant emotion linked to aversion to activity that can affect a person's thoughts, behavior, feelings and physical well-being. Depressed individuals may feel sad, anxious, empty, hopeless, worried, helpless, worthless, guilty, irritable, or restless." :lang "en")) (label (literal "depression" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000825") :subclass (iri "http://semanticscience.org/resource/SIO_000848") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Desire is a strong emotion of wanting to have something or wishing for something to happen." :lang "en")) (label (literal "desire" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000826") :subclass (iri "http://semanticscience.org/resource/SIO_000863") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "despair is depression, hopelessness or lack of hope" :lang "en")) (label (literal "despair" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000820") :subclass (iri "http://semanticscience.org/resource/SIO_000832") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "boredom is the emotion experience by those not interested in their surroundings or available activities." :lang "en")) (label (literal "boredom" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000821") :subclass (iri "http://semanticscience.org/resource/SIO_000828") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "contempt is disgust towards a lower status individual." :lang "en")) (label (literal "contempt" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000822") :subclass (iri "http://semanticscience.org/resource/SIO_000840") :annotation (label (literal "contentment" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "contentment is an emotion characterized by acknowledgement and satisfaction of the current state of affairs." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000430") :subclass (iri "http://semanticscience.org/resource/SIO_000417") :disjoint (iri "http://semanticscience.org/resource/SIO_000428") (iri "http://semanticscience.org/resource/SIO_000429") (iri "http://semanticscience.org/resource/SIO_000431") (iri "http://semanticscience.org/resource/SIO_000432") (iri "http://semanticscience.org/resource/SIO_000433") (iri "http://semanticscience.org/resource/SIO_000434") (iri "http://semanticscience.org/resource/SIO_000435") :annotation (label (literal "day" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A day is a period of 24 hours." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000431") :subclass (iri "http://semanticscience.org/resource/SIO_000417") :disjoint (iri "http://semanticscience.org/resource/SIO_000428") (iri "http://semanticscience.org/resource/SIO_000429") (iri "http://semanticscience.org/resource/SIO_000430") (iri "http://semanticscience.org/resource/SIO_000432") (iri "http://semanticscience.org/resource/SIO_000433") (iri "http://semanticscience.org/resource/SIO_000434") (iri "http://semanticscience.org/resource/SIO_000435") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a century is a period of one hundred years." :lang "en")) (label (literal "century" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000432") :subclass (iri "http://semanticscience.org/resource/SIO_000417") :disjoint (iri "http://semanticscience.org/resource/SIO_000428") (iri "http://semanticscience.org/resource/SIO_000429") (iri "http://semanticscience.org/resource/SIO_000430") (iri "http://semanticscience.org/resource/SIO_000431") (iri "http://semanticscience.org/resource/SIO_000433") (iri "http://semanticscience.org/resource/SIO_000434") (iri "http://semanticscience.org/resource/SIO_000435") :annotation (label (literal "millenium" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a millenium is a period of 1000 years" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000433") :subclass (iri "http://semanticscience.org/resource/SIO_000417") :disjoint (iri "http://semanticscience.org/resource/SIO_000428") (iri "http://semanticscience.org/resource/SIO_000429") (iri "http://semanticscience.org/resource/SIO_000430") (iri "http://semanticscience.org/resource/SIO_000431") (iri "http://semanticscience.org/resource/SIO_000432") (iri "http://semanticscience.org/resource/SIO_000434") (iri "http://semanticscience.org/resource/SIO_000435") :annotation (label (literal "hour" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an hour is a period of 60 minutes." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000827") :subclass (iri "http://semanticscience.org/resource/SIO_000832") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Disappointment is the feeling of dissatisfaction that follows the failure of expectations or hopes to manifest" :lang "en")) (label (literal "disappointment" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000828") :subclass (iri "http://semanticscience.org/resource/SIO_000844") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Disgust is a feeling of revulsion or profound disapproval aroused by something unpleasant or offensive." :lang "en")) (label (literal "disgust" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000829") :subclass (iri "http://semanticscience.org/resource/SIO_000837") :annotation (label (literal "dread" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "dread is the instense negative emotion that induces fear and apprehension." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001010") :subclass (iri "http://semanticscience.org/resource/SIO_001008") :disjoint (iri "http://semanticscience.org/resource/SIO_001009") :annotation (label (literal "non toxic" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "toxic is the quality of a substance having no damaging effect to a system." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001011") :subclass (iri "http://semanticscience.org/resource/SIO_000026") :annotation (label (literal "chemical quality" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "chemical quality is the quality of a chemical entity." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001012") :subclass (iri "http://semanticscience.org/resource/SIO_010058") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "healthy is an organismal state of complete physical, mental and social well-being." :lang "en")) (label (literal "healthy" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001013") :subclass (iri "http://semanticscience.org/resource/SIO_000794") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "age is the length of time that a person has lived or a thing has existed." :lang "en")) (label (literal "age" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001014") :subclass (iri "http://semanticscience.org/resource/SIO_000475") :disjoint (iri "http://semanticscience.org/resource/SIO_000476") (iri "http://semanticscience.org/resource/SIO_001015") (iri "http://semanticscience.org/resource/SIO_010029") (iri "http://semanticscience.org/resource/SIO_010056") (iri "http://semanticscience.org/resource/SIO_010057") (iri "http://semanticscience.org/resource/SIO_010299") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "ethnicity is the biological quality of membership in a social group based on a common heritage." :lang "en")) (label (literal "ethnicity" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001015") :subclass (iri "http://semanticscience.org/resource/SIO_000475") :disjoint (iri "http://semanticscience.org/resource/SIO_000476") (iri "http://semanticscience.org/resource/SIO_001014") (iri "http://semanticscience.org/resource/SIO_010029") (iri "http://semanticscience.org/resource/SIO_010056") (iri "http://semanticscience.org/resource/SIO_010057") (iri "http://semanticscience.org/resource/SIO_010299") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "race is a characteristic of an individual by heritable phenotypic characteristics, geographic ancestry, physical appearance, ethnicity, and social status." :lang "en")) (label (literal "race" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001016") :subclass (iri "http://semanticscience.org/resource/SIO_001062") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an ethnic group is a group of people whose members identify with each other through a common heritage, consisting of a common culture, including a shared language or dialect. " :lang "en")) (label (literal "ethnic group" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001018") :subclass (iri "http://semanticscience.org/resource/SIO_000257") :annotation (label (literal "ratio" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a ratio is a relationship between two numbers of the same kind expressed arithmetically as a dimensionless quotient of the two which explicitly indicates how many times the first number contains the second." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001017") :subclass (iri "http://semanticscience.org/resource/SIO_000136") :annotation (label (literal "syndrome" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A syndrome is composed of a set of several clinically recognizable features, signs (observed by someone other than the patient), symptoms (reported by the patient), phenomena or characteristics that often occur together." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001019") :subclass (iri "http://semanticscience.org/resource/SIO_000258") :annotation (label (literal "dose" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A dose is the quantity of a chemical substance administered to a biological system." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001022") :subclass (iri "http://semanticscience.org/resource/SIO_001024") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A diagnostic test is a procedure performed to confirm, or determine the presence of disease in an individual suspected of having the disease, usually following the report of symptoms, or based on the results of other medical tests." :lang "en")) (label (literal "diagnostic test" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001023") :subclass (iri "http://semanticscience.org/resource/SIO_001024") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A medical screening is a medical test or series used to detect or predict the presence of disease in individuals at risk for disease within a defined group, such as a population, family, or workforce" :lang "en")) (label (literal "medical screening" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001020") :subclass (iri "http://semanticscience.org/resource/SIO_001019") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "effective dose is the amount of a substance required to produce an effect on a predefined percentage of a population." :lang "en")) (label (literal "effective dose" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001021") :subclass (iri "http://semanticscience.org/resource/SIO_000638") :annotation (label (literal "expected value" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an expected value (or e-value) is the weighted average of all possible values that a random variable can take on." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001026") :subclass (iri "http://semanticscience.org/resource/SIO_000148") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A report is a textual document made that present focused, salient content to a specific audience." :lang "en")) (label (literal "report" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001027") :subclass (iri "http://semanticscience.org/resource/SIO_000088") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A medical health record is a record of a single patient's medical history." :lang "en")) (label (literal "medical health record" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001024") :subclass (iri "http://semanticscience.org/resource/SIO_000999") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a medical procedure is a procedure to identify, examine, alleviate or eliminate an undesirable biological disease or disorder." :lang "en")) (label (literal "medical procedure" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001025") :subclass (iri "http://semanticscience.org/resource/SIO_000256") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A prognosis is a proposition about the likely course of a disease, the chance of recovery or recurrence." :lang "en")) (label (literal "prognosis" :lang "en")))
(datatype-property (iri "http://semanticscience.org/resource/SIO_000300") :characteristic :functional)
(owl-class (iri "http://semanticscience.org/resource/SIO_001029") :subclass (iri "http://semanticscience.org/resource/SIO_000154") (object-some (iri "http://semanticscience.org/resource/SIO_000217") (iri "http://semanticscience.org/resource/SIO_001035")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a peer reviewed article is an article that has undergone peer-review and deemed acceptable for publication." :lang "en")) (label (literal "peer reviewed article" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001028") :subclass (iri "http://semanticscience.org/resource/SIO_001026") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a medical report is a report prepared by a health care practioner about test outcomes or health status of an individual." :lang "en")) (label (literal "medical report" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010089") :subclass (iri "http://semanticscience.org/resource/SIO_010088") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to serve as a template for protein synthesis is the capability of a chemical entity to provide the necessary information or scaffold by which a protein may be produced." :lang "en")) (label (literal "to serve as a template for protein synthesis" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001035") :subclass (iri "http://semanticscience.org/resource/SIO_001034") :disjoint (iri "http://semanticscience.org/resource/SIO_001038") :annotation (label (literal "peer-reviewed" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "reviewed is the quality of a textual entity that has been examined and commented by a peer expert reviewer." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010088") :subclass (iri "http://semanticscience.org/resource/SIO_000542") :annotation (label (literal "to serve as a template for molecular synthesis" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to serve as a template for molecular synthesis is the capability of a chemical entity to provide the necessary information or scaffold by which another molecule may be produced." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001036") :subclass (iri "http://semanticscience.org/resource/SIO_001039") :annotation (label (literal "draft" :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "drafted" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "draft is the quality of text that has not yet complete." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001037") :subclass (iri "http://semanticscience.org/resource/SIO_001039") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "finalized is the quality of a textual entity that is in its final form." :lang "en")) (label (literal "finalized" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001038") :subclass (iri "http://semanticscience.org/resource/SIO_001034") :disjoint (iri "http://semanticscience.org/resource/SIO_001035") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "reviewed is the quality of a textual entity that has been examined and commented on by an editor." :lang "en")) (label (literal "editor reviewed" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010085") :subclass (iri "http://semanticscience.org/resource/SIO_010444") (object-some (iri "http://semanticscience.org/resource/SIO_000225") (iri "http://semanticscience.org/resource/SIO_000395")) :annotation (label (literal "gene regulatory component" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a gene regulatory component is a gene component that exerts a regulatory function." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001031") :subclass (iri "http://semanticscience.org/resource/SIO_000654") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a minor version number is a version of a software that exhibits minor features or significant fix from a prior version." :lang "en")) (label (literal "minor version number" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010084") :subclass (iri "http://semanticscience.org/resource/SIO_010335") (object-some (iri "http://semanticscience.org/resource/SIO_000093") (iri "http://semanticscience.org/resource/SIO_010010")) (object-some (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_010035")) (object-some (iri "http://semanticscience.org/resource/SIO_010080") (iri "http://semanticscience.org/resource/SIO_010450")) :annotation (label (literal "operon" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An operon is a collection of contiguous genes transcribed as a single (polycistronic) mRNA." :lang "en")) (annotation (iri "http://semanticscience.org/resource/similarTo") (literal "SO:0000178" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_001032") :subclass (iri "http://semanticscience.org/resource/SIO_000654") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a revision number is a version of a software in which bugs have been fixed from a prior version." :lang "en")) (label (literal "revision number" :lang "en")))
(annotation-property (iri "http://purl.org/dc/terms/description"))
(owl-class (iri "http://semanticscience.org/resource/SIO_010087") :subclass (iri "http://semanticscience.org/resource/SIO_010338") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Aninactive ingredient is a molecular entity that does not exhibit biological activity." :lang "en")) (label (literal "inactive ingredient" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001033") :subclass (iri "http://semanticscience.org/resource/SIO_000026") (object-some (iri "http://semanticscience.org/resource/SIO_000218") (iri "http://semanticscience.org/resource/SIO_000651")) :annotation (label (literal "text quality" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "text quality is the quality of a textual entity." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010086") :subclass (iri "http://semanticscience.org/resource/SIO_010085") :annotation (label (literal "gene enhancer" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a gene enhancer is a short region of DNA that can be bound with proteins to enhance transcription levels of genes in a gene cluster." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001034") :subclass (iri "http://semanticscience.org/resource/SIO_001039") :annotation (label (literal "reviewed" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "reviewed is the quality of a textual entity that has been examined and commented on by another party." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001030") :subclass (iri "http://semanticscience.org/resource/SIO_000654") :annotation (label (literal "major version number" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a major version number is a version of a software that exhibits a significant change in functionalilty from a prior version." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001039") :subclass (iri "http://semanticscience.org/resource/SIO_001033") :annotation (label (literal "written" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "written is the quality of information that is embodied as visual glyphs in some material form." :lang "en")))
(annotation-property (iri "http://purl.org/dc/terms/title"))
(owl-class (iri "http://semanticscience.org/resource/SIO_001048") :subclass (iri "http://semanticscience.org/resource/SIO_000994") :annotation (label (literal "intervention study" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an intervention study has the objective of improving the condition of an individual or a group of individuals, and demonstrates the magnitude of that capability by comparing it to a control group." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001049") :subclass (iri "http://semanticscience.org/resource/SIO_000593") (object-or (object-some (iri "http://semanticscience.org/resource/SIO_000229") (iri "http://semanticscience.org/resource/SIO_001050")) (object-some (iri "http://semanticscience.org/resource/SIO_000230") (iri "http://semanticscience.org/resource/SIO_000776"))) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "sampling is the act of obtaining a sample, whether through selection, collection or preparation." :lang "en")) (label (literal "sampling" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001046") :subclass (iri "http://semanticscience.org/resource/SIO_001045") :disjoint (iri "http://semanticscience.org/resource/SIO_001047") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "polar is the quality of having a dipole." :lang "en")) (label (literal "polar" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010099") :subclass (iri "http://semanticscience.org/resource/SIO_010450") (object-some (iri "http://semanticscience.org/resource/SIO_010078") (iri "http://semanticscience.org/resource/SIO_010043")) :annotation (label (literal "messenger RNA" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a messenger RNA is a ribonucleic acid that contains an untranslated region (UTR) and protein coding sequence and lacks introns." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001047") :subclass (iri "http://semanticscience.org/resource/SIO_001045") :disjoint (iri "http://semanticscience.org/resource/SIO_001046") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "non-polar is the quality of not having a dipole." :lang "en")) (label (literal "non-polar" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010098") :subclass (iri "http://semanticscience.org/resource/SIO_010099") (object-some (iri "http://semanticscience.org/resource/SIO_000244") (object-or (iri "http://semanticscience.org/resource/SIO_010099") (object-some (iri "http://semanticscience.org/resource/SIO_000273") (iri "http://semanticscience.org/resource/SIO_010451")))) :annotation (label (literal "mRNA splice variant" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an mRNA splice variant is an mRNA molecule that varies from another mRNA molecule of the same gene origin but having a different final sequence due to differences in its assembly from splice sites." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001044") :subclass (iri "http://semanticscience.org/resource/SIO_010378") :annotation (label (literal "viroid" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a viroid is a molecule of RNA that does not code for and is not protected by a protein coat." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010097") :subclass (iri "http://semanticscience.org/resource/SIO_010099") (object-some (iri "http://semanticscience.org/resource/SIO_000245") (iri "http://semanticscience.org/resource/SIO_010096")) :annotation (label (literal "pre-mRNA" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Precursor mRNA (pre-mRNA) is a single strand of messenger ribonucleic acid (mRNA) that is synthesized from a DNA template throught transcription." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001045") :subclass (iri "http://semanticscience.org/resource/SIO_001011") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_001046") (iri "http://semanticscience.org/resource/SIO_001047")) :annotation (label (literal "polar quality" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "the quality of being polar or not polar." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010096") :subclass (iri "http://semanticscience.org/resource/SIO_010099") (object-not (object-some (iri "http://semanticscience.org/resource/SIO_000053") (iri "http://semanticscience.org/resource/SIO_010443"))) (object-not (object-some (iri "http://semanticscience.org/resource/SIO_000245") (iri "http://semanticscience.org/resource/SIO_010450"))) (object-some (iri "http://semanticscience.org/resource/SIO_000244") (iri "http://semanticscience.org/resource/SIO_010450")) (object-some (iri "http://semanticscience.org/resource/SIO_010082") (iri "http://semanticscience.org/resource/SIO_010043")) :annotation (label (literal "mature mRNA" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a messenger RNA is a ribonucleic acid that contains an untranslated region (UTR) and protein coding sequence and lacks introns." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001042") :subclass (iri "http://semanticscience.org/resource/SIO_000091") :annotation (label (literal "recipe" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A recipe is a set of instructions that describe how to prepare or make something." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010095") :subclass (iri "http://semanticscience.org/resource/SIO_010335") (object-some (iri "http://semanticscience.org/resource/SIO_000068") (iri "http://semanticscience.org/resource/SIO_010099")) (object-some (iri "http://semanticscience.org/resource/SIO_000093") (iri "http://semanticscience.org/resource/SIO_010450")) :annotation (label (literal "RNA transcript component" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an RNA transcript component is a region of an RNA transcript. " :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001043") :subclass (iri "http://semanticscience.org/resource/SIO_000091") :annotation (label (literal "experimental protocol" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an experimental protocol is an action specification with respect to the design and implementation of experiments. In addition to providing a detailed set of procedures and lists of required equipment and instruments, experimental protocols often include information on safety precautions, the calculation of results and reporting standards, including statistical analysis and rules for predefining and documenting excluded data to avoid bias." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010094") :subclass (iri "http://semanticscience.org/resource/SIO_000542") :annotation (label (literal "to serve as a primer for DNA synthesis" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to serve as a primer for DNA synthesis is the capability of a short nucleic acid to bind to the 5' end of single strand of DNA template and help initiate DNA replication." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001040") :subclass (iri "http://semanticscience.org/resource/SIO_000078") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a morpheme is the smallest semantically meaningful unit in a language" :lang "en")) (label (literal "morpheme" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010093") :subclass (iri "http://semanticscience.org/resource/SIO_000779") (iri "http://semanticscience.org/resource/SIO_010010") (object-some (iri "http://semanticscience.org/resource/SIO_000225") (iri "http://semanticscience.org/resource/SIO_010091")) :annotation (label (literal "deoxyribonucleic acid primer" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a deoxyribonucleic acid primer is a deoxyribonucleic acid that enables the synthesis of a complement strand of DNA by binding to it and acting as a point of transcription initiation." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001041") :subclass (iri "http://semanticscience.org/resource/SIO_001043") (object-only (iri "http://semanticscience.org/resource/SIO_000341") (object-some (iri "http://semanticscience.org/resource/SIO_000068") (iri "http://semanticscience.org/resource/SIO_000747"))) :annotation (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "study protocol" :type :RDF_PLAIN_LITERAL)) (label (literal "study design" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A study design is a protocol for the proper execution of a study which normally requires a carefullly crafted research question or hypothesis and at least one variable under observation and observed values for that variable." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010092") :subclass (iri "http://semanticscience.org/resource/SIO_010010") (object-some (iri "http://semanticscience.org/resource/SIO_000225") (object-or (iri "http://semanticscience.org/resource/SIO_010090") (iri "http://semanticscience.org/resource/SIO_010091"))) :annotation (label (literal "deoxyribonucleic acid template" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a deoxyribonucleic acid template is a deoxyribonucleic acid that provides the template to synthesize a complementary strand of DNA through transcription." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010091") :subclass (iri "http://semanticscience.org/resource/SIO_010088") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to serve as a template for DNA synthesis is the capability of a chemical entity to provide the necessary information or scaffold by which a DNA molecule may be produced." :lang "en")) (label (literal "to serve as a template for DNA synthesis" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010090") :subclass (iri "http://semanticscience.org/resource/SIO_010088") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to serve as a template for RNA synthesis is the capability of a chemical entity to provide the necessary information or scaffold by which an RNA molecule may be produced." :lang "en")) (label (literal "to serve as a template for RNA synthesis" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000117") :subclass (iri "http://semanticscience.org/resource/SIO_000116") :annotation (label (literal "preferred name" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a preferred name is the name that is generally used by some organization. " :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000118") :subclass (iri "http://semanticscience.org/resource/SIO_000116") :annotation (label (literal "common name" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a common name is a name that is commonly used." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000115") :subclass (iri "http://semanticscience.org/resource/SIO_000179") (object-some (iri "http://semanticscience.org/resource/SIO_000672") (iri "http://semanticscience.org/resource/SIO_000000")) :annotation (label (literal "identifier" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An identifier is a label that specifically refers to (identifies) an entity (instance/type)." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000116") :subclass (iri "http://semanticscience.org/resource/SIO_000179") (data-some (iri "http://semanticscience.org/resource/SIO_000300") :XSD_STRING) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a name is a label used to identify an entity." :lang "en")) (label (literal "name" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000119") :subclass (iri "http://semanticscience.org/resource/SIO_000116") :annotation (label (literal "brand name" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a brand name is a trademarked and marketed name of a product." :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000095") :inverse (iri "http://semanticscience.org/resource/SIO_000059"))
(object-property (iri "http://semanticscience.org/resource/SIO_000093") :inverse (iri "http://semanticscience.org/resource/SIO_000053") :characteristic :asymmetric :irreflexive)
(object-property (iri "http://semanticscience.org/resource/SIO_000096") :inverse (iri "http://semanticscience.org/resource/SIO_000054"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000110") :subclass (iri "http://semanticscience.org/resource/SIO_000651") (object-some (iri "http://semanticscience.org/resource/SIO_000273") (iri "http://semanticscience.org/resource/SIO_000113")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A paragraph is a self-contained unit of written discourse consisting of one or more sentences." :lang "en")) (label (literal "paragraph" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000114") :subclass (iri "http://semanticscience.org/resource/SIO_000078") (object-some (iri "http://semanticscience.org/resource/SIO_000028") (iri "http://semanticscience.org/resource/SIO_001040")) (object-some (iri "http://semanticscience.org/resource/SIO_000273") (iri "http://semanticscience.org/resource/SIO_000108")) :annotation (label (literal "word" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A word is the smallest free form (an item that may be expressed in isolation with semantic or pragmatic content) in a language." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000113") :subclass (iri "http://semanticscience.org/resource/SIO_000483") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A sentence is a grammatical unit consisting of one or more words that bear minimal syntactic relation to the words that precede or follow it" :lang "en")) (label (literal "sentence" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000112") :subclass (iri "http://semanticscience.org/resource/SIO_000340") (object-some (iri "http://semanticscience.org/resource/SIO_000011") (object-some (iri "http://semanticscience.org/resource/SIO_000063") (object-or (iri "http://semanticscience.org/resource/SIO_000006") (hasself (iri "http://semanticscience.org/resource/SIO_000355"))))) (object-some (iri "http://semanticscience.org/resource/SIO_000641") (iri "http://semanticscience.org/resource/SIO_000005")) (object-only (iri "http://semanticscience.org/resource/SIO_000635") (iri "http://semanticscience.org/resource/SIO_000006")) :annotation (annotation (iri "http://semanticscience.org/resource/subset") (literal "core" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://semanticscience.org/resource/subset") (literal "capability+" :type :RDF_PLAIN_LITERAL)) (label (literal "capability" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A capability is a realizable entity whose basis lies in one or more parts or qualities and reflects possility of an entity to act in a specified way under certain conditions or in response to a certain stimulus (trigger)." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000111") :subclass (iri "http://semanticscience.org/resource/SIO_000171") (object-some (iri "http://semanticscience.org/resource/SIO_000093") (iri "http://semanticscience.org/resource/SIO_000148")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a document section is a component of a document." :lang "en")) (label (literal "document section" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000104") :subclass (iri "http://semanticscience.org/resource/SIO_000078") :annotation (label (literal "language" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Language is a language entity which is the result of encoding and decoding information through systematic creation and usage of systems of symbols, each pairing a specific sign with an intended meaning, established through social conventions" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000105") :subclass (iri "http://semanticscience.org/resource/SIO_000612") (object-some (iri "http://semanticscience.org/resource/SIO_000210") (iri "http://semanticscience.org/resource/SIO_000000")) (object-some (iri "http://semanticscience.org/resource/SIO_000332") (iri "http://semanticscience.org/resource/SIO_000000")) :annotation (label (literal "symbol" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A symbol is a proposition about what an entity represents." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000106") :subclass (iri "http://semanticscience.org/resource/SIO_000087") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A book is a publication composed of a large number of entries." :lang "en")) (label (literal "book" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000107") :subclass (iri "http://semanticscience.org/resource/SIO_000111") :annotation (label (literal "chapter" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A chapter is a document section of a book or thesis." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000108") :subclass (iri "http://semanticscience.org/resource/SIO_000078") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A character is a language symbol used to construct words." :lang "en")) (label (literal "character" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000109") :subclass (iri "http://semanticscience.org/resource/SIO_000087") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A novel is a fictitious prose narrative of book length, typically representing character and action with some degree of realism." :lang "en")) (label (literal "novel" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000101") :subclass (iri "http://semanticscience.org/resource/SIO_000097") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A software application is software that can be directly executed by some processing unit." :lang "en")) (label (literal "software application" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000100") :subclass (iri "http://semanticscience.org/resource/SIO_000097") :annotation (label (literal "software library" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A software library is software composed of a collection of software modules and/or software methods in a form that can be statically or dynamically linked to some software application." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000103") :subclass (iri "http://semanticscience.org/resource/SIO_000097") :annotation (label (literal "software script" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A software script is software whose instructions can be executed using a software interpreter." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000102") :subclass (iri "http://semanticscience.org/resource/SIO_000101") :annotation (label (literal "software interpreter" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A software interpreter is a software application that executes some specified input software." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000902") :subclass (iri "http://semanticscience.org/resource/SIO_000458") :disjoint (iri "http://semanticscience.org/resource/SIO_000459") (iri "http://semanticscience.org/resource/SIO_000460") (iri "http://semanticscience.org/resource/SIO_000903") :annotation (label (literal "top value axis" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A top value axis is a value axis that is spatially positioned to the top of the plot area." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000903") :subclass (iri "http://semanticscience.org/resource/SIO_000458") :disjoint (iri "http://semanticscience.org/resource/SIO_000459") (iri "http://semanticscience.org/resource/SIO_000460") (iri "http://semanticscience.org/resource/SIO_000902") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A bottom value axis is a value axis that is spatially positioned to the bottom of the plot area." :lang "en")) (label (literal "bottom value axis" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000908") :subclass (iri "http://semanticscience.org/resource/SIO_000934") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a steamgraph is a multi-line stacked graph that yields the appearance of continuous y-values across the x-axis." :lang "en")) (label (literal "steamgraph" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000909") :subclass (iri "http://semanticscience.org/resource/SIO_000447") :annotation (label (literal "boxplot" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A boxplot (box-and-whisker diagram) is a convenient way of graphically depicting groups of numerical data through their five-number summaries: the smallest observation (sample minimum), lower quartile (Q1), median (Q2), upper quartile (Q3), and largest observation (sample maximum)." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000906") :subclass (iri "http://semanticscience.org/resource/SIO_000904") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A map is a a visual representation of an area that depicts the relationship between elements of that space." :lang "en")) (label (literal "map" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000907") :subclass (iri "http://semanticscience.org/resource/SIO_000904") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A heatmap is a graphical representation of data where the individual values contained in a matrix are represented as colors." :lang "en")) (label (literal "heatmap" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000904") :subclass (iri "http://semanticscience.org/resource/SIO_000080") :annotation (label (literal "chart" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A chart is a figure that displays the relationship among tabular numeric data, functions or some kinds of qualitative structures." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000911") :subclass (iri "http://semanticscience.org/resource/SIO_000904") :annotation (label (literal "histogram" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a histogram is a graphical representation of data which consists of tabular frequencies, shown as adjacent rectangles, over discrete intervals (bins) , with an area equal to the frequency of the observations in the interval." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000912") :subclass (iri "http://semanticscience.org/resource/SIO_000315") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a measurement scale is a functional specification that specifies an allowed range of categories or values." :lang "en")) (label (literal "measurement scale" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000913") :subclass (iri "http://semanticscience.org/resource/SIO_000912") :disjoint (iri "http://semanticscience.org/resource/SIO_000914") (iri "http://semanticscience.org/resource/SIO_000915") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A nominal scale of measurement only specifies a limited set of categories." :lang "en")) (label (literal "nomimal scale" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000914") :subclass (iri "http://semanticscience.org/resource/SIO_000912") :disjoint (iri "http://semanticscience.org/resource/SIO_000913") (iri "http://semanticscience.org/resource/SIO_000915") :annotation (label (literal "binary scale" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a binary scale is a measurement scale that specifies a choice between two values." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000910") :subclass (iri "http://semanticscience.org/resource/SIO_000907") :annotation (label (literal "geographic heatmap" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A geographic heatmap is a graphical representation of data over a geographic region where individual values are represented as colors." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000919") :subclass (iri "http://semanticscience.org/resource/SIO_000588") (object-or (object-some (iri "http://semanticscience.org/resource/SIO_000230") (iri "http://semanticscience.org/resource/SIO_000776")) (object-some (iri "http://semanticscience.org/resource/SIO_000312") (iri "http://semanticscience.org/resource/SIO_000776"))) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "reproducing is a process characterized by creation of an entity that is similar or exactly the same as the template from which it is derived." :lang "en")) (label (literal "reproducing" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000915") :subclass (iri "http://semanticscience.org/resource/SIO_000912") (object-some (iri "http://semanticscience.org/resource/SIO_000338") (object-or (iri "http://semanticscience.org/resource/SIO_000000") (data-some (iri "http://semanticscience.org/resource/SIO_000300") :RDFS_LITERAL))) :disjoint (iri "http://semanticscience.org/resource/SIO_000913") (iri "http://semanticscience.org/resource/SIO_000914") :annotation (label (literal "numeric scale" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a numeric scale of measurement is one that only specifies numeric values" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000916") :subclass (iri "http://semanticscience.org/resource/SIO_000915") (object-some (iri "http://semanticscience.org/resource/SIO_000338") (object-or (iri "http://semanticscience.org/resource/SIO_000000") (data-some (iri "http://semanticscience.org/resource/SIO_000300") :XSD_DECIMAL))) :annotation (label (literal "decimal scale" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a decimal scale of measurement is one that only specifies decimal values" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000917") :subclass (iri "http://semanticscience.org/resource/SIO_000915") (object-some (iri "http://semanticscience.org/resource/SIO_000338") (object-or (iri "http://semanticscience.org/resource/SIO_000000") (data-some (iri "http://semanticscience.org/resource/SIO_000300") :XSD_INTEGER))) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an integer scale of measurement is one that only specifies integer values." :lang "en")) (label (literal "integer scale" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000918") :subclass (iri "http://semanticscience.org/resource/SIO_000593") (object-some (iri "http://semanticscience.org/resource/SIO_000229") (iri "http://semanticscience.org/resource/SIO_000776")) (object-some (iri "http://semanticscience.org/resource/SIO_000291") (iri "http://semanticscience.org/resource/SIO_000776")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "modifying is the process by which an entity gains or loses parts, qualities, roles, dispositions, functions, etc, but maintains their identity through these changes." :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "modification" :lang "en")) (label (literal "modifying" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000892") :inverse (iri "http://semanticscience.org/resource/SIO_000668"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000929") :subclass (iri "http://semanticscience.org/resource/SIO_000940") :annotation (label (literal "pie chart" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A pie chart is a circular chart divided into sectors each of whose length  is proportional to the quantity it represents." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000928") :subclass (iri "http://semanticscience.org/resource/SIO_000956") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a radar is an object-detection system which uses radio waves to determine the range, altitude, direction, or speed of objects." :lang "en")) (label (literal "radar" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000927") :subclass (iri "http://semanticscience.org/resource/SIO_000957") :annotation (label (literal "telephone" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "The telephone is a communications device that transmits and receives sounds, and are minimally composed of a microphone to speak into, a speaker'which reproduces the voice of the other person and a ringer which makes a sound to alert the owner when a call is coming in." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000926") :subclass (iri "http://semanticscience.org/resource/SIO_000957") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A radio receiver is a communication device that receives its input from an antenna, uses electronic filters to separate a wanted radio signal from all other signals picked up by this antenna, amplifies it to a level suitable for further processing, and finally converts through demodulation and decoding the signal into a form usable for the consumer, such as sound, pictures, digital data, measurement values, navigational positions." :lang "en")) (label (literal "radio receiver" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000921") :subclass (iri "http://semanticscience.org/resource/SIO_000367") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A dependent variable is one whose value changes as a consequence of changes in other values in the system" :lang "en")) (label (literal "dependent variable" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000920") :subclass (iri "http://semanticscience.org/resource/SIO_000367") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an independent variable is a variable that may take on different values independent of other elements in a system." :lang "en")) (label (literal "independent variable" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000159") :subclass (iri "http://semanticscience.org/resource/SIO_000087") :annotation (label (literal "edited publication" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An edited publication is a publication that has been examined and potentially changed by an editor." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000924") :subclass (iri "http://semanticscience.org/resource/SIO_001194") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a television program is a audiovisual media that is produced and broadcast using a television." :lang "en")) (label (literal "television program" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000923") :subclass (iri "http://semanticscience.org/resource/SIO_000898") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a correlation is a statistical relationship involving dependence between two random variables or datasets." :lang "en")) (label (literal "correlation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000922") :subclass (iri "http://semanticscience.org/resource/SIO_000904") :annotation (label (literal "Gantt chart" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A Gantt chart is a bar chart that illustrates a project schedule." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000153") :subclass (iri "http://semanticscience.org/resource/SIO_000148") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A patent is an information entity granted by a patent issuing authority which confers upon the patenter the sole right to make, use and sell an invention for a set period of time." :lang "en")) (label (literal "patent" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000154") :subclass (iri "http://semanticscience.org/resource/SIO_000087") :annotation (label (literal "article" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An article is a publication that is stand-alone section of a larger work." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000151") :subclass (iri "http://semanticscience.org/resource/SIO_000148") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A manuscript is a document prior to publication." :lang "en")) (label (literal "manuscript" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000152") :subclass (iri "http://semanticscience.org/resource/SIO_000148") :annotation (label (literal "note" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A note is a brief document." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000157") :subclass (iri "http://semanticscience.org/resource/SIO_000106") :annotation (label (literal "conference proceedings" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A conference proceedings is a book composed of papers presented at a conference." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000158") :subclass (iri "http://semanticscience.org/resource/SIO_000295") :annotation (label (literal "book series" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A book series is a collection of books that have been sequentially published." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000155") :subclass (iri "http://semanticscience.org/resource/SIO_000087") :annotation (label (literal "blog" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A blog is a publication accessible at some website and is typically about various experiences." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000156") :subclass (iri "http://semanticscience.org/resource/SIO_000106") :annotation (label (literal "book volume" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A book volume is a book that is part of a collection." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000150") :subclass (iri "http://semanticscience.org/resource/SIO_000075") (object-some (iri "http://semanticscience.org/resource/SIO_000059") (iri "http://semanticscience.org/resource/SIO_000000")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a list is any enumeration of a set of items." :lang "en")) (label (literal "list" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000938") :subclass (iri "http://semanticscience.org/resource/SIO_000937") :annotation (label (literal "tag cloud" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a tag cloud is a visualization of word frequencies." :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "word cloud" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000937") :subclass (iri "http://semanticscience.org/resource/SIO_000904") (object-some (iri "http://semanticscience.org/resource/SIO_000273") (iri "http://semanticscience.org/resource/SIO_000651")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a textual chart is a chart containing text" :lang "en")) (label (literal "textual chart" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000939") :subclass (iri "http://semanticscience.org/resource/SIO_000937") :annotation (label (literal "phrase net diagram" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A phrase net diagram illustrates the relationship between different words used in a text." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000930") :subclass (iri "http://semanticscience.org/resource/SIO_000904") :annotation (label (literal "matrix chart" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A matrix chart summarizes a multidimensional data set in a grid." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000148") :subclass (iri "http://semanticscience.org/resource/SIO_000651") :annotation (label (literal "document" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A document is a bounded physical or digital representation of a body of information designed with the capacity (and usually intent) to communicate." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000932") :subclass (iri "http://semanticscience.org/resource/SIO_000911") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A block histogram contains an x-axis that is divided into bins which correspond to value ranges. Each item in the data set is drawn as a rectangular block, and the blocks are piled into the bins to show how many values in each range." :lang "en")) (label (literal "block histogram" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000931") :subclass (iri "http://semanticscience.org/resource/SIO_000904") :annotation (label (literal "network diagram" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A network diagram consists of a set of vertices connected by edges." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000934") :subclass (iri "http://semanticscience.org/resource/SIO_000083") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A stack graph is a statistical graph which presents multiple series in which the distance between one series and another indicates the relative contribution to the total for any x-value." :lang "en")) (label (literal "stack graph" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000933") :subclass (iri "http://semanticscience.org/resource/SIO_000904") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A bubble chart contains circles whose area corresponds to a value. " :lang "en")) (label (literal "bubble chart" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000936") :subclass (iri "http://semanticscience.org/resource/SIO_000937") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a word tree is a chart that links phrases with contexts through a tree-like branching structure." :lang "en")) (label (literal "word tree" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000935") :subclass (iri "http://semanticscience.org/resource/SIO_000940") :annotation (label (literal "treemap" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a treemap is a chart that fully partitions the area into a set of rectangles whose area represents its relative value." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000140") :subclass (iri "http://semanticscience.org/resource/SIO_000101") :annotation (label (literal "web service" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A web service is a software application that can be accessed over a network, such as the Internet, and executed on a remote system hosting the requested services." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000141") :subclass (iri "http://semanticscience.org/resource/SIO_000316") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A criterion is a specification to describe properties used for evaluation." :lang "en")) (label (literal "criterion" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000142") :subclass (iri "http://semanticscience.org/resource/SIO_000141") :disjoint (iri "http://semanticscience.org/resource/SIO_000143") :annotation (label (literal "inclusion criterion" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An inclusion criterion is a criterion that must be present to satisfy some objective." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000143") :subclass (iri "http://semanticscience.org/resource/SIO_000141") :disjoint (iri "http://semanticscience.org/resource/SIO_000142") :annotation (label (literal "exclusion criterion" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An exclusion criterion is a criterion that must be absent to satistify the objective." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000144") :subclass (iri "http://semanticscience.org/resource/SIO_000920") :annotation (label (literal "parameter" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A parameter is variable whose value changes the characteristics of a system or a function." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000146") :subclass (iri "http://semanticscience.org/resource/SIO_010441") (object-some (iri "http://semanticscience.org/resource/SIO_000310") (iri "http://semanticscience.org/resource/SIO_000092")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A monomer is a submolecule that is proper part of some polymer, and is a building block for such polymer." :lang "en")) (label (literal "monomer" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000147") :subclass (iri "http://semanticscience.org/resource/SIO_000133") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A keyword is a descriptor in which the association of the word with the entity facilitates information retrieval." :lang "en")) (label (literal "keyword" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000949") :subclass (iri "http://semanticscience.org/resource/SIO_000832") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "apprehension is the negative emotion that something unpleasant will occur." :lang "en")) (label (literal "apprehension" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000948") :subclass (iri "http://semanticscience.org/resource/SIO_000945") :annotation (label (literal "dendrogram" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A dendrogram is a tree diagram used to illustrate the arrangement of the clusters produced by hierarchical clustering." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000947") :subclass (iri "http://semanticscience.org/resource/SIO_000904") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A Venn diagram is a chart that illustrates all possible logical relations between a finite collection of sets as overlapping circles." :lang "en")) (label (literal "venn diagram" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000946") :subclass (iri "http://semanticscience.org/resource/SIO_000904") :annotation (label (literal "flowchart" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A flowchart is a diagram that represents an algorithm or process, showing the steps as boxes of various kinds, and their order by connecting these with arrows." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000945") :subclass (iri "http://semanticscience.org/resource/SIO_000931") :annotation (label (literal "tree diagram" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A tree diagram is a hierarchical network diagram in which a root vertex is connected to one or more other vertices through a directed edge, which in turn may be connected to other vertices." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000944") :subclass (iri "http://semanticscience.org/resource/SIO_000075") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an interval is a set of real numbers that includes all numbers between any two numbers in the set." :lang "en")) (label (literal "interval" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000943") :subclass (iri "http://semanticscience.org/resource/SIO_000788") :annotation (label (literal "start position" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a start position is the proximal position of an object relative to an origin in a linear system." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000942") :subclass (iri "http://semanticscience.org/resource/SIO_000179") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a numeric label is a number used as a label." :lang "en")) (label (literal "numeric label" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000941") :subclass (iri "http://semanticscience.org/resource/SIO_000969") :annotation (label (literal "conversing" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "conversing a form of interactive, spontaneous communication between two or more agents who are following rules of etiquette." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000138") :subclass (iri "http://semanticscience.org/resource/SIO_000289") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A class is a collection of sets which can be unambiguously defined by a property that all its members share." :lang "en")) (label (literal "class" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000940") :subclass (iri "http://semanticscience.org/resource/SIO_000904") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a mereological chart is a chart that illustrates the parts in the context of the whole." :lang "en")) (label (literal "mereological chart" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000137") :subclass (iri "http://semanticscience.org/resource/SIO_000326") :annotation (label (literal "category" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a category is a class of entities having particular shared characteristics." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000135") :subclass (iri "http://semanticscience.org/resource/SIO_000136") :annotation (label (literal "definition" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A definition is a description that succintly characterizes an entity." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000136") :subclass (iri "http://semanticscience.org/resource/SIO_000078") (object-only (iri "http://semanticscience.org/resource/SIO_000563") (iri "http://semanticscience.org/resource/SIO_000000")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a description is language entity in which elements of a language (formal or natural) are used to characterize an entity." :lang "en")) (label (literal "description" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000133") :subclass (iri "http://semanticscience.org/resource/SIO_000275") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A descriptor (index term, subject term, subject heading) is a term that captures the essence of the topic of a document." :lang "en")) (label (literal "descriptor" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000131") :subclass (iri "http://semanticscience.org/resource/SIO_000130") :disjoint (iri "http://semanticscience.org/resource/SIO_001197") :annotation (label (literal "sequence motif" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a sequence motif is a pattern of nucleotides in a DNA sequence or amino acids in a protein" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000130") :subclass (iri "http://semanticscience.org/resource/SIO_000075") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A pattern is a generalized representation of some repeatable concrete or informational item." :lang "en")) (label (literal "pattern" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000959") :subclass (iri "http://semanticscience.org/resource/SIO_000005") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "existence quality is the quality of an entity that describe in what environment it is known to exist." :lang "en")) (label (literal "existence quality" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000956") :subclass (iri "http://semanticscience.org/resource/SIO_010462") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a device is usually a constructed tool" :lang "en")) (label (literal "device" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000955") :subclass (iri "http://semanticscience.org/resource/SIO_000414") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an environment is a geographic region that hosts certain processes or objects." :type :RDF_PLAIN_LITERAL)) (label (literal "environment" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000957") :subclass (iri "http://semanticscience.org/resource/SIO_000956") :annotation (label (literal "communication device" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a communication device is a device that facilitates the transmission of information through encoded in an audio or digital signal between a sender and a receiver." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000952") :subclass (iri "http://semanticscience.org/resource/SIO_000144") :annotation (label (literal "default parameter" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a default parameter is a parameter which has a default value." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000127") :subclass (iri "http://semanticscience.org/resource/SIO_000094") :annotation (label (literal "workflow" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A workflow is an algorithm that is is a depiction of a sequence of operations to achieve one or more objectives." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000951") :subclass (iri "http://semanticscience.org/resource/SIO_000845") :annotation (label (literal "pain" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Pain is an unpleasant sensory and emotional experience associated with actual or potential tissue damage, or described in terms of such damage" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000126") :subclass (iri "http://semanticscience.org/resource/SIO_000342") (object-some (iri "http://semanticscience.org/resource/SIO_000495") (iri "http://semanticscience.org/resource/SIO_000275")) :annotation (label (literal "homonym" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A homonym is a word that sounds the same but has different meaning." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000954") :subclass (iri "http://semanticscience.org/resource/SIO_010058") :annotation (label (literal "sick" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "sick is the status of a living organism that is behaving at a sub-optimal level." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000129") :subclass (iri "http://semanticscience.org/resource/SIO_000148") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an ontology document is a document that contains an ontology." :lang "en")) (label (literal "ontology document" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000953") :subclass (iri "http://semanticscience.org/resource/SIO_000788") :annotation (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "stop position" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "an end position is the distal position of an object relative to an origin in a linear system." :lang "en")) (label (literal "end position" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000122") :subclass (iri "http://semanticscience.org/resource/SIO_000342") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_000342") (object-some (iri "http://semanticscience.org/resource/SIO_000283") (iri "http://semanticscience.org/resource/SIO_000275"))) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A synonym is a word with the same or very similar meanings." :lang "en")) (label (literal "synonym" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000123") :subclass (iri "http://semanticscience.org/resource/SIO_000342") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_000342") (object-some (iri "http://semanticscience.org/resource/SIO_000496") (iri "http://semanticscience.org/resource/SIO_000275"))) :annotation (label (literal "antonym" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An antonym is a word with opposite or nearly opposite meaning." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000124") :subclass (iri "http://semanticscience.org/resource/SIO_000342") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_000342") (object-some (iri "http://semanticscience.org/resource/SIO_000477") (iri "http://semanticscience.org/resource/SIO_000275"))) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A hypernym is a term with a broader meaning." :lang "en")) (label (literal "hypernym" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000950") :subclass (iri "http://semanticscience.org/resource/SIO_000828") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "resentment is disgust directed toward a higher status individual." :lang "en")) (label (literal "resentment" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000125") :subclass (iri "http://semanticscience.org/resource/SIO_000342") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_000342") (object-some (iri "http://semanticscience.org/resource/SIO_000427") (iri "http://semanticscience.org/resource/SIO_000275"))) :annotation (label (literal "hyponym" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A hyponym is a term with a narrower meaning." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000120") :subclass (iri "http://semanticscience.org/resource/SIO_000116") :annotation (label (literal "scientific name" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a scientific name is a name given through scientific nomenclature." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000121") :subclass (iri "http://semanticscience.org/resource/SIO_000162") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A magazine is a periodical that typically contains essays, stories, poems, etc., by many writers, and often photographs and drawings, frequently specializing in a particular subject or area, as hobbies, news, or sports." :lang "en")) (label (literal "magazine" :lang "en")) (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "http://purl.org/ontology/bibo/Magazine" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000589") :subclass (iri "http://semanticscience.org/resource/SIO_000593") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_001132") (iri "http://semanticscience.org/resource/SIO_010295") (iri "http://semanticscience.org/resource/SIO_010296")) :annotation (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "regulation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "regulating is a process that modulates the attributes of an object or process." :lang "en")) (label (literal "regulating" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000588") :subclass (iri "http://semanticscience.org/resource/SIO_000593") (object-some (iri "http://semanticscience.org/resource/SIO_000312") (iri "http://semanticscience.org/resource/SIO_000776")) :annotation (label (literal "creating" :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "development" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "synthesis" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "production" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "creating is the process in which an entity comes into existence." :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "formulation" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "creation" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000190") :subclass (iri "http://semanticscience.org/resource/SIO_000111") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An author contribution section is a document section that describes the contribution of the authors." :lang "en")) (label (literal "author contribution section" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000011") :inverse (iri "http://semanticscience.org/resource/SIO_000008"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000192") :subclass (iri "http://semanticscience.org/resource/SIO_000111") :annotation (label (literal "bibliography section" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A bibliography section is a document section that is composed of a list of references used in the development of the work." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000191") :subclass (iri "http://semanticscience.org/resource/SIO_000111") :annotation (label (literal "author section" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An author section is a document section that lists the contributing authors." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000194") :subclass (iri "http://semanticscience.org/resource/SIO_000111") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A correspondence section is a document section that contains the details for contacting the corresponding author." :lang "en")) (label (literal "correspondence section" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000193") :subclass (iri "http://semanticscience.org/resource/SIO_000111") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A copyright section is a document section that contains a notice of copyright." :lang "en")) (label (literal "copyright section" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000196") :subclass (iri "http://semanticscience.org/resource/SIO_000111") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An introduction section is a document section that generally provides background, motivation and goals of the work." :lang "en")) (label (literal "introduction section" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000195") :subclass (iri "http://semanticscience.org/resource/SIO_000111") :annotation (label (literal "discussion section" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "The discussion section is a document section containing a summary of the findings, a reflection on the significance of findings, comparison with related work, among others." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000198") :subclass (iri "http://semanticscience.org/resource/SIO_000111") :annotation (label (literal "materials section" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "The materials section is a document section containing a description of the materials used in the study." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000197") :subclass (iri "http://semanticscience.org/resource/SIO_000111") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "The materials and methods section is a document section containing a description of the materials and methods used in the study." :lang "en")) (label (literal "materials and methods section" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000199") :subclass (iri "http://semanticscience.org/resource/SIO_000111") :annotation (label (literal "methods section" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "The methods section is a document section containing a description of the methods used in the study." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000961") :subclass (iri "http://semanticscience.org/resource/SIO_000959") :disjoint (iri "http://semanticscience.org/resource/SIO_000960") :annotation (label (literal "fictional" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "fictional is the quality of an entity that exists only in a creative work of fiction." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000960") :subclass (iri "http://semanticscience.org/resource/SIO_000959") :disjoint (iri "http://semanticscience.org/resource/SIO_000961") (iri "http://semanticscience.org/resource/SIO_000962") :annotation (label (literal "real" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "real is the quality of an entity that exists in real space and time." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000962") :subclass (iri "http://semanticscience.org/resource/SIO_000959") :disjoint (iri "http://semanticscience.org/resource/SIO_000960") :annotation (label (literal "virtual" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "virtual is the quality of an entity that exists only in a virtual setting such as a simulation or game environment." :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_001155") :inverse (iri "http://semanticscience.org/resource/SIO_001154"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000963") :subclass (iri "http://semanticscience.org/resource/SIO_000033") :disjoint (iri "http://semanticscience.org/resource/SIO_000034") (iri "http://semanticscience.org/resource/SIO_000035") (iri "http://semanticscience.org/resource/SIO_000995") (iri "http://semanticscience.org/resource/SIO_000997") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "not started is the status of a process that is predicted to exist but has not yet begun." :lang "en")) (label (literal "not started" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_001154") :inverse (iri "http://semanticscience.org/resource/SIO_001155"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000964") :subclass (iri "http://semanticscience.org/resource/SIO_001043") :annotation (label (literal "standard operating procedure" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a standard operating procedure is a specification approved for use in specific environments." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000965") :subclass (iri "http://semanticscience.org/resource/SIO_000436") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_000966") (iri "http://semanticscience.org/resource/SIO_000967")) :annotation (label (literal "agreement quality" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "agreement quality is a quality that exhibits the degree of consensus for some set of assertions." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000966") :subclass (iri "http://semanticscience.org/resource/SIO_000965") :disjoint (iri "http://semanticscience.org/resource/SIO_000967") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "agreement is the result of consensus decision making when members of the group agree." :lang "en")) (label (literal "agreement" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_001159") :inverse (iri "http://semanticscience.org/resource/SIO_001158"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000967") :subclass (iri "http://semanticscience.org/resource/SIO_000965") :disjoint (iri "http://semanticscience.org/resource/SIO_000966") :annotation (label (literal "disagreement" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "agreement is the result of consensus decision making when members of the group do not all agree." :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_001158") :inverse (iri "http://semanticscience.org/resource/SIO_001159"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000968") :subclass (iri "http://semanticscience.org/resource/SIO_000891") (object-some (iri "http://semanticscience.org/resource/SIO_000227") (iri "http://semanticscience.org/resource/SIO_010076")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a poison role is the role of a substance that causes some negative disturbance in an organism." :lang "en")) (label (literal "poison role" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_001157"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000969") :subclass (iri "http://semanticscience.org/resource/SIO_000593") :annotation (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "communication" :type :RDF_PLAIN_LITERAL)) (label (literal "communicating" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "communicating is the process of conveying information through the exchange of thoughts, messages, or information, as by speech, visuals, signals, writing, or behaviour." :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_001156"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000580") :subclass (iri "http://semanticscience.org/resource/SIO_000578") :disjoint (iri "http://semanticscience.org/resource/SIO_000579") :annotation (label (literal "antiport enabled secondary active transport" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "antiport enabled secondary active transport is a secondary active transfort in which both ion and molecule are transported in opposite directions simultaneously." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000581") :subclass (iri "http://semanticscience.org/resource/SIO_000574") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "The self-propelled movement of an object." :lang "en")) (label (literal "locomotion" :lang "en")) (annotation (iri "http://semanticscience.org/resource/broaderThan") (literal "GO:0040011" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000582") :subclass (iri "http://semanticscience.org/resource/SIO_000588") (object-some (iri "http://semanticscience.org/resource/SIO_000312") (iri "http://semanticscience.org/resource/SIO_010046")) :annotation (label (literal "birthing" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "brirthing is the process by which a biological organism is brought into existence." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000583") :subclass (iri "http://semanticscience.org/resource/SIO_000591") (object-some (iri "http://semanticscience.org/resource/SIO_000905") (iri "http://semanticscience.org/resource/SIO_010046")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "dying is a process in which a biological entity ceases to exist." :lang "en")) (label (literal "dying" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000585") :subclass (iri "http://semanticscience.org/resource/SIO_000256") :annotation (label (literal "idea" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An idea is a proposition about some object of conceptual thought." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000587") :subclass (iri "http://semanticscience.org/resource/SIO_000919") :annotation (label (literal "biological reproduction" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Biological reproduction is the biological process by which one or more biological organisms are produced from their \"parents\". " :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000020") :inverse (iri "http://semanticscience.org/resource/SIO_000060"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000183") :subclass (iri "http://semanticscience.org/resource/SIO_000116") :annotation (label (literal "personal name" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A personal name is a name to identify an individual person and usually comprises of a first name and a last name." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000182") :subclass (iri "http://semanticscience.org/resource/SIO_000116") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A last name (surname) is a name added to a given name and is part of a personal name and is often the family name." :lang "en")) (label (literal "last name" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000181") :subclass (iri "http://semanticscience.org/resource/SIO_000116") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A first name is a name that denotes a specific individual between members of a group of individuals, whose members usually share the same surname." :lang "en")) (label (literal "first name" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000180") :subclass (iri "http://semanticscience.org/resource/SIO_000179") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A language label is a label that denotes the language of a textual entity." :lang "en")) (label (literal "language label" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000186") :subclass (iri "http://semanticscience.org/resource/SIO_000653") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A document version is a version of a work in some sequence of derivative works." :lang "en")) (label (literal "document version" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000029") :domain (iri "http://semanticscience.org/resource/SIO_000418") :inverse (iri "http://semanticscience.org/resource/SIO_000679"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000185") :subclass (iri "http://semanticscience.org/resource/SIO_000179") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A title is a textual entity that summarily describes some entity." :lang "en")) (label (literal "title" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000028") :inverse (iri "http://semanticscience.org/resource/SIO_000068") :characteristic :transitive :reflexive)
(owl-class (iri "http://semanticscience.org/resource/SIO_000184") :subclass (iri "http://semanticscience.org/resource/SIO_000183") :annotation (label (literal "legal name" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A legal name is a name given at birth, or which appears on their birth certificate, marriage certificate, or change of name certificate." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000189") :subclass (iri "http://semanticscience.org/resource/SIO_000111") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An acknowledgements section is a document section that identifies individuals, groups or organizations for their support in the development of the work." :lang "en")) (label (literal "acknowledgements section" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000188") :subclass (iri "http://semanticscience.org/resource/SIO_000111") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An abstract section is a document section that provides brief summary of a document that explains the main argument(s), topic(s) or findings." :lang "en")) (label (literal "abstract section" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000976") :subclass (iri "http://semanticscience.org/resource/SIO_000994") (object-some (iri "http://semanticscience.org/resource/SIO_000132") (iri "http://semanticscience.org/resource/SIO_000284")) (object-some (iri "http://semanticscience.org/resource/SIO_000338") (object-or (iri "http://semanticscience.org/resource/SIO_000268") (object-some (iri "http://semanticscience.org/resource/SIO_000218") (iri "http://semanticscience.org/resource/SIO_000284")))) :annotation (label (literal "observational study" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "observational study draws inferences about the possible effect of a treatment on subjects, where the assignment of subjects into a treated group versus a control group is outside the control of the investigator" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000979") :subclass (iri "http://semanticscience.org/resource/SIO_000786") :annotation (label (literal "vowel" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a vowel is a verbal entity of language that is pronounced with an open vocal tract so that there is no build-up of air pressure at any point above the glottis." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000590") :subclass (iri "http://semanticscience.org/resource/SIO_000559") :annotation (label (literal "biosynthesis" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Biosynthesis is the synthesis of an organic compound in a living organism, usually aided by enzymes." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000977") :subclass (iri "http://semanticscience.org/resource/SIO_000786") :annotation (label (literal "syllable" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A syllable is a verbal entity of language having one vowel sound, with or without surrounding consonants, forming the whole or a part of a word." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000978") :subclass (iri "http://semanticscience.org/resource/SIO_000786") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a consonant is a verbal entity of language that is articulated with complete or partial closure of the vocal tract." :lang "en")) (label (literal "consonant" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000593") :subclass (iri "http://semanticscience.org/resource/SIO_000006") (object-or (object-at-least 2 (iri "http://semanticscience.org/resource/SIO_000355") (iri "http://semanticscience.org/resource/SIO_000701")) (object-at-least 2 (iri "http://semanticscience.org/resource/SIO_000355") (iri "http://semanticscience.org/resource/SIO_000702"))) (object-some (iri "http://semanticscience.org/resource/SIO_000132") (iri "http://semanticscience.org/resource/SIO_000776")) :annotation (annotation (iri "http://semanticscience.org/resource/subset") (literal "core" :type :RDF_PLAIN_LITERAL)) (label (literal "interacting" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "interacting is a process characterized by the interaction between two or more entities." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000594") :subclass (iri "http://semanticscience.org/resource/SIO_000649") (object-some (iri "http://semanticscience.org/resource/SIO_000229") (iri "http://semanticscience.org/resource/SIO_000069")) (object-some (iri "http://semanticscience.org/resource/SIO_000230") (iri "http://semanticscience.org/resource/SIO_000069")) :annotation (label (literal "data transformation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "data transformation is the process of applying an algorithmic procedure to some input data and producing some output data." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000591") :subclass (iri "http://semanticscience.org/resource/SIO_000593") (object-some (iri "http://semanticscience.org/resource/SIO_000905") (iri "http://semanticscience.org/resource/SIO_000776")) :annotation (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "destruction" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "destroying is a process in which something is broken down and/or ceases to exist." :lang "en")) (label (literal "destroying" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000592") :subclass (iri "http://semanticscience.org/resource/SIO_000591") (object-some (iri "http://semanticscience.org/resource/SIO_000291") (iri "http://semanticscience.org/resource/SIO_010004")) :annotation (label (literal "chemical destruction" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Chemical destruction is destruction of a chemical entity to its chemical constituents through one ormore chemical interactions or reactions." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000597") :subclass (iri "http://semanticscience.org/resource/SIO_000598") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A solid-state drive (SSD) is a data storage device that uses solid-state memory to store persistent data" :lang "en")) (label (literal "solid state hard drive" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000598") :subclass (iri "http://semanticscience.org/resource/SIO_000596") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A hard disk drive (HDD) is a non-volatile, random access device for digital data. It features rotating rigid platters on a motor-driven spindle within a protective enclosure. Data is magnetically read and written on the platter by read/write heads that float on a film of air above the platters." :lang "en")) (label (literal "hard disk drive" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000595") :subclass (iri "http://semanticscience.org/resource/SIO_000594") (object-some (iri "http://semanticscience.org/resource/SIO_000552") (iri "http://semanticscience.org/resource/SIO_000144")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a parameterized data transformation is a data transformation whose behaviour may be modified by one or more parameters." :lang "en")) (label (literal "parameterized data transformation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000596") :subclass (iri "http://semanticscience.org/resource/SIO_000956") :annotation (label (literal "data storage device" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a data storage device is a device that is capable of storing information." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000170") :subclass (iri "http://semanticscience.org/resource/SIO_000148") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A diary is a document which describes day-to-day experiences." :lang "en")) (label (literal "diary" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000172") :subclass (iri "http://semanticscience.org/resource/SIO_000328") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An address is a position that indicates the physical location of some entity using a social convention." :lang "en")) (label (literal "address" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000171") :subclass (iri "http://semanticscience.org/resource/SIO_000651") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A bibliographic attribute is an attribute related to publications." :lang "en")) (label (literal "document component" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000567") :subclass (iri "http://semanticscience.org/resource/SIO_000569") :annotation (label (literal "ordinary differential equation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An ordinary differential equation (ODE) is a differential equation in which the unknown function (also known as the dependent variable) is a function of a single independent variable." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000566") :subclass (iri "http://semanticscience.org/resource/SIO_000368") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a movement equation describes the displacement of an object in space over time." :lang "en")) (label (literal "movement equation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000569") :subclass (iri "http://semanticscience.org/resource/SIO_000368") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A differential equation is a mathematical equation for an unknown function of one or several variables that relates the values of the function itself and its derivatives of various orders." :lang "en")) (label (literal "differential equation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000568") :subclass (iri "http://semanticscience.org/resource/SIO_000569") :annotation (label (literal "partial differential equation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A partial differential equation (PDE) is a differential equation in which the unknown function is a function of multiple independent variables and the equation involves its partial derivatives." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000981") :subclass (iri "http://semanticscience.org/resource/SIO_000104") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a verbal language is a language that uses sounds to communicate." :lang "en")) (label (literal "verbal language" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000178") :subclass (iri "http://semanticscience.org/resource/SIO_000794") :annotation (label (literal "page total" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A page total is a textual entity that is about the number of pages in some informational entity." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000980") :subclass (iri "http://semanticscience.org/resource/SIO_000104") :annotation (label (literal "sign language" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a sign language (also signed language) is a language that involves manual communication and body language to convey meaning. This can involve simultaneously combining hand shapes, orientation and movement of the hands, arms or body, and facial expressions to fluidly express a speaker's thoughts." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000177") :subclass (iri "http://semanticscience.org/resource/SIO_000944") :annotation (label (literal "page range" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A page range denotes the start and end page in some document." :lang "en")))

(owl-class (iri "http://semanticscience.org/resource/SIO_000983") :subclass (iri "http://semanticscience.org/resource/SIO_000897") (object-some (iri "http://semanticscience.org/resource/SIO_000628") (iri "http://semanticscience.org/resource/SIO_010035")) (object-some (iri "http://semanticscience.org/resource/SIO_000628") (iri "http://semanticscience.org/resource/SIO_010299")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a gene-disease association is an association between a gene and a disease" :lang "en")) (label (literal "gene-disease association" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000982") :subclass (iri "http://semanticscience.org/resource/SIO_000104") :annotation (label (literal "written language" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "written language is a language that is communicated through a writing system." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000179") :subclass (iri "http://semanticscience.org/resource/SIO_000179") (iri "http://semanticscience.org/resource/SIO_000651") :annotation (label (literal "label" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a label is a term that is associated with some entity" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000174") :subclass (iri "http://semanticscience.org/resource/SIO_000171") :annotation (label (literal "citation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A citation is a textual entity which denotes a source described in the bibliography or reference section of a document." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000173") :subclass (iri "http://semanticscience.org/resource/SIO_000287") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An affiliation is a social relation which indicates the partnership between two or more entities." :lang "en")) (label (literal "affiliation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000176") :subclass (iri "http://semanticscience.org/resource/SIO_000171") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A reference is a textual entity that describes a single source used in the preparation or development of the work." :lang "en")) (label (literal "reference" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000175") :subclass (iri "http://semanticscience.org/resource/SIO_000185") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A document title is a  textual entity that summarizes the topic of the document in one sentence." :lang "en")) (label (literal "document title" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000988") :subclass (iri "http://semanticscience.org/resource/SIO_010335") :annotation (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "http://purl.obolibrary.org/obo/SO_0000336" :type :XSD_ANY_URI)) (label (literal "pseudogene" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a pseudo gene is a region of a nucleic acid that either cannot be transcribed, or its rna transcript cannot be translated." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000989") :subclass (iri "http://semanticscience.org/resource/SIO_000030") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a sequence assembly is a sequence that is produced as by the alignment of two or more sequences." :lang "en")) (label (literal "sequence assembly" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000984") :subclass (iri "http://semanticscience.org/resource/SIO_010046") :annotation (label (literal "genome" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a genome is a collection of nucleic acids." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000985") :subclass (iri "http://semanticscience.org/resource/SIO_010035") :annotation (label (literal "protein coding gene" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a gene that contains an open reading frame which codes for a protein." :lang "en")) (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "http://purl.obolibrary.org/obo/SO_0001217" :type :XSD_ANY_URI)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000986") :subclass (iri "http://semanticscience.org/resource/SIO_010035") :annotation (label (literal "functional rna coding gene" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a gene that codes for a functional RNA molecule" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000987") :subclass (iri "http://semanticscience.org/resource/SIO_010035") (object-some (iri "http://semanticscience.org/resource/SIO_000008") (iri "http://semanticscience.org/resource/SIO_000036")) :annotation (label (literal "predicted gene" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a predicted gene is a gene that was identified through computational method but has not been experimentally validated." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000562") :subclass (iri "http://semanticscience.org/resource/SIO_000576") :disjoint (iri "http://semanticscience.org/resource/SIO_010284") :annotation (label (literal "passive transport" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Passive transport is the movement of a substance across a membrane and does not require chemical energy." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000564") :subclass (iri "http://semanticscience.org/resource/SIO_000573") :annotation (label (literal "diffusion" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Diffusion is motion of particles at temperatures above absolute zero." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000565") :subclass (iri "http://semanticscience.org/resource/SIO_000566") (object-some (iri "http://semanticscience.org/resource/SIO_000338") (iri "http://semanticscience.org/resource/SIO_000564")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A diffusion equation describes density fluctuations in a material undergoing diffusion." :lang "en")) (label (literal "diffusion equation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000561") :subclass (iri "http://semanticscience.org/resource/SIO_011121") :annotation (label (literal "molecular orbitral" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a molecular orbital (or MO) is a mathematical function describing the wave-like behavior of an electron in a molecule" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000161") :subclass (iri "http://semanticscience.org/resource/SIO_000087") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A manual is a document that instructs on the usage of a device." :lang "en")) (label (literal "manual" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000160") :subclass (iri "http://semanticscience.org/resource/SIO_000162") :annotation (label (literal "journal" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A journal is a a peer-reviewed periodical in which scholarship relating to a particular academic discipline is published." :lang "en")) (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "http://purl.org/ontology/bibo/Journal" :type :XSD_ANY_URI)))
(object-property (iri "http://semanticscience.org/resource/SIO_000001") :characteristic :symmetric)
(owl-class (iri "http://semanticscience.org/resource/SIO_000579") :subclass (iri "http://semanticscience.org/resource/SIO_000578") :disjoint (iri "http://semanticscience.org/resource/SIO_000580") :annotation (label (literal "symport enabled secondary active transport" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "symport enabled secondary active transport is a secondary active transfort in which both ion and molecule are transported in the same direction simultaneously." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000578") :subclass (iri "http://semanticscience.org/resource/SIO_010284") :disjoint (iri "http://semanticscience.org/resource/SIO_000577") :annotation (label (literal "secondary active transport" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "secondary active transport or co-transport uses electrochemical potential difference created by pumping ions out of the cell to transport molecules across a membrane." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000577") :subclass (iri "http://semanticscience.org/resource/SIO_010284") :disjoint (iri "http://semanticscience.org/resource/SIO_000578") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Primary active transport, also called direct active transport, directly uses energy to transport molecules across a membrane." :lang "en")) (label (literal "primary active transport" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000994") :subclass (iri "http://semanticscience.org/resource/SIO_000747") :annotation (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "study" :type :RDF_PLAIN_LITERAL)) (label (literal "experiment" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An experiment is an investigation that has the goal of verifying, falsifying, or establishing the validity of a hypothesis. " :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000169") :subclass (iri "http://semanticscience.org/resource/SIO_000148") :annotation (label (literal "booklet" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A booklet is a document that lacks a named publisher or sponsoring institution." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000993") :subclass (iri "http://semanticscience.org/resource/SIO_000897") (object-or (object-some (iri "http://semanticscience.org/resource/SIO_000628") (iri "http://semanticscience.org/resource/SIO_010004")) (object-some (iri "http://semanticscience.org/resource/SIO_000628") (iri "http://semanticscience.org/resource/SIO_010299"))) :annotation (label (literal "chemical-disease association" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a chemical-disease association is an association between a chemical and a disease." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000168") :subclass (iri "http://semanticscience.org/resource/SIO_000165") :disjoint (iri "http://semanticscience.org/resource/SIO_000166") (iri "http://semanticscience.org/resource/SIO_000167") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A PhD thesis is a thesis prepared as a requirement for a doctoral degree." :lang "en")) (label (literal "phd thesis" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000992") :subclass (iri "http://semanticscience.org/resource/SIO_000959") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "unsupported is an existence quality in which there is no evidence to support the existence of the entity in any world (real or hypothetical)" :lang "en")) (label (literal "unsupported" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000167") :subclass (iri "http://semanticscience.org/resource/SIO_000165") :disjoint (iri "http://semanticscience.org/resource/SIO_000166") (iri "http://semanticscience.org/resource/SIO_000168") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A Master's thesis is a thesis prepared as a requirement for a Master's degree." :lang "en")) (label (literal "master's thesis" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000991") :subclass (iri "http://semanticscience.org/resource/SIO_010035") (object-some (iri "http://semanticscience.org/resource/SIO_000008") (iri "http://semanticscience.org/resource/SIO_000960")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an experimentally validated gene is a gene whose existence has been demonstrated through experimental methods." :lang "en")) (label (literal "validated gene" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000166") :subclass (iri "http://semanticscience.org/resource/SIO_000165") :disjoint (iri "http://semanticscience.org/resource/SIO_000167") (iri "http://semanticscience.org/resource/SIO_000168") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An honor's thesis is a thesis prepared as a requirement for an honor's undergraduate degree." :lang "en")) (label (literal "honor's thesis" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000165") :subclass (iri "http://semanticscience.org/resource/SIO_000087") :annotation (label (literal "thesis document" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A tehsis document is the written research component of a post-secondary institution  that contains a statement supported by arguments." :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000008") :inverse (iri "http://semanticscience.org/resource/SIO_000011"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000164") :subclass (iri "http://semanticscience.org/resource/SIO_000087") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A technical report is a publication published by a school or other institution, usually numbered within a series." :lang "en")) (label (literal "technical report" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000163") :subclass (iri "http://semanticscience.org/resource/SIO_000162") :annotation (label (literal "newspaper" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a newspaper is a periodical publication containing news regarding current events, informative articles, diverse features, editorials, and advertising." :lang "en")) (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "http://purl.org/ontology/bibo/Newspaper" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000162") :subclass (iri "http://semanticscience.org/resource/SIO_000295") :annotation (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "http://purl.org/ontology/bibo/Periodical" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "A periodical is a publication that appears on a regular schedule." :lang "en")) (label (literal "periodical" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000421") :inverse (iri "http://semanticscience.org/resource/SIO_000420"))
(object-property (iri "http://semanticscience.org/resource/SIO_000422") :domain (iri "http://semanticscience.org/resource/SIO_000275") :range (iri "http://semanticscience.org/resource/SIO_000275") :inverse (iri "http://semanticscience.org/resource/SIO_000424") :characteristic :transitive)
(owl-class (iri "http://semanticscience.org/resource/SIO_000999") :subclass (iri "http://semanticscience.org/resource/SIO_000006") (object-some (iri "http://semanticscience.org/resource/SIO_000426") (iri "http://semanticscience.org/resource/SIO_000091")) (object-only (iri "http://semanticscience.org/resource/SIO_000355") (object-or (iri "http://semanticscience.org/resource/SIO_000112") (iri "http://semanticscience.org/resource/SIO_000337"))) :annotation (label (literal "procedure" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a procedure is a process that attempts to achieve one or more objectives by following an established set of actions." :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000420") :inverse (iri "http://semanticscience.org/resource/SIO_000421"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000997") :subclass (iri "http://semanticscience.org/resource/SIO_000033") :disjoint (iri "http://semanticscience.org/resource/SIO_000034") (iri "http://semanticscience.org/resource/SIO_000035") (iri "http://semanticscience.org/resource/SIO_000963") (iri "http://semanticscience.org/resource/SIO_000995") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "aborted is a process status in which a started process will not complete as intended." :lang "en")) (label (literal "aborted" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000998") :subclass (iri "http://semanticscience.org/resource/SIO_000649") (object-some (iri "http://semanticscience.org/resource/SIO_000229") (iri "http://semanticscience.org/resource/SIO_000483")) (object-some (iri "http://semanticscience.org/resource/SIO_000230") (iri "http://semanticscience.org/resource/SIO_000148")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "literature curation is the process of an agent selecting and extracting terms and phrases from a document." :lang "en")) (label (literal "literature curation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000995") :subclass (iri "http://semanticscience.org/resource/SIO_000033") :disjoint (iri "http://semanticscience.org/resource/SIO_000034") (iri "http://semanticscience.org/resource/SIO_000035") (iri "http://semanticscience.org/resource/SIO_000963") (iri "http://semanticscience.org/resource/SIO_000997") :annotation (label (literal "suspended" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "suspended is the status of a process that is no longer progressing towards completion." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000996") :subclass (iri "http://semanticscience.org/resource/SIO_000963") :annotation (label (literal "cancelled" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "cancelled is a process status in which the process, while planned to occur, will not occur." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000575") :subclass (iri "http://semanticscience.org/resource/SIO_000593") (object-or (object-some (iri "http://semanticscience.org/resource/SIO_000355") (iri "http://semanticscience.org/resource/SIO_000390")) (object-some (iri "http://semanticscience.org/resource/SIO_000355") (iri "http://semanticscience.org/resource/SIO_010368"))) :annotation (label (literal "transporting" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "transporting is a  process in which one object physically moves another object from one location to another." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000576") :subclass (iri "http://semanticscience.org/resource/SIO_010283") :annotation (label (literal "membrane transport" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "membrane transport is the movement of molecules across a membrane." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000573") :subclass (iri "http://semanticscience.org/resource/SIO_000570") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Passive movement is the process in which an object is spatially displaced without an expenditure of energy contained in molecular bonds." :type :RDF_PLAIN_LITERAL)) (label (literal "passive movement" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000427") :inverse (iri "http://semanticscience.org/resource/SIO_000477"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000574") :subclass (iri "http://semanticscience.org/resource/SIO_000570") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Active movement is the process in which an object is spatially displaced using some chemical energy." :lang "en")) (label (literal "active movement" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000571") :subclass (iri "http://semanticscience.org/resource/SIO_000564") :annotation (label (literal "brownian motion" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Brownian motion is the seemlingly random movement of particles suspended in a fluid." :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000425"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000572") :subclass (iri "http://semanticscience.org/resource/SIO_000564") :annotation (label (literal "osmosis" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Osmosis is the movement of water molecules through a selectively-permeable membrane down a water potential gradient." :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000426") :inverse (iri "http://semanticscience.org/resource/SIO_000341"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000570") :subclass (iri "http://semanticscience.org/resource/SIO_000006") :annotation (label (literal "movement" :lang "en")) (annotation (iri "http://semanticscience.org/resource/subset") (literal "core" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "Movement is the process in which an object is spatially displaced." :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000424") :domain (iri "http://semanticscience.org/resource/SIO_000275") :range (iri "http://semanticscience.org/resource/SIO_000275") :inverse (iri "http://semanticscience.org/resource/SIO_000422") :characteristic :transitive)
(object-property (iri "http://semanticscience.org/resource/SIO_000053") :inverse (iri "http://semanticscience.org/resource/SIO_000093") :characteristic :asymmetric :irreflexive)
(object-property (iri "http://semanticscience.org/resource/SIO_000054") :inverse (iri "http://semanticscience.org/resource/SIO_000096"))
(object-property (iri "http://semanticscience.org/resource/SIO_000059") :inverse (iri "http://semanticscience.org/resource/SIO_000095") :characteristic :irreflexive)
(object-property (iri "http://semanticscience.org/resource/SIO_000066") :inverse (iri "http://semanticscience.org/resource/SIO_000064"))
(object-property (iri "http://semanticscience.org/resource/SIO_000063") :inverse (iri "http://semanticscience.org/resource/SIO_000139"))
(object-property (iri "http://semanticscience.org/resource/SIO_000064") :inverse (iri "http://semanticscience.org/resource/SIO_000066"))
(object-property (iri "http://semanticscience.org/resource/SIO_000068") :inverse (iri "http://semanticscience.org/resource/SIO_000028") :characteristic :transitive :reflexive)
(object-property (iri "http://semanticscience.org/resource/SIO_000062") :range (iri "http://semanticscience.org/resource/SIO_000006") :inverse (iri "http://semanticscience.org/resource/SIO_000132"))
(object-property (iri "http://semanticscience.org/resource/SIO_000061") :inverse (iri "http://semanticscience.org/resource/SIO_000145") :characteristic :transitive)
(object-property (iri "http://semanticscience.org/resource/SIO_000060") :inverse (iri "http://semanticscience.org/resource/SIO_000020"))
(object-property (iri "http://semanticscience.org/resource/SIO_001101") :characteristic :symmetric)
(object-property (iri "http://semanticscience.org/resource/SIO_010083") :range (object-or (iri "http://semanticscience.org/resource/SIO_010009") (object-some (iri "http://semanticscience.org/resource/SIO_000068") (iri "http://semanticscience.org/resource/SIO_010009"))) :inverse (iri "http://semanticscience.org/resource/SIO_010082"))
(object-property (iri "http://semanticscience.org/resource/SIO_010082") :domain (object-or (iri "http://semanticscience.org/resource/SIO_010009") (object-some (iri "http://semanticscience.org/resource/SIO_000068") (iri "http://semanticscience.org/resource/SIO_010009"))) :range (iri "http://semanticscience.org/resource/SIO_010007") :inverse (iri "http://semanticscience.org/resource/SIO_010083"))
(object-property (iri "http://semanticscience.org/resource/SIO_010081") :domain (object-or (iri "http://semanticscience.org/resource/SIO_010009") (object-some (iri "http://semanticscience.org/resource/SIO_000068") (iri "http://semanticscience.org/resource/SIO_010009"))) :range (object-or (iri "http://semanticscience.org/resource/SIO_010010") (object-some (iri "http://semanticscience.org/resource/SIO_000068") (iri "http://semanticscience.org/resource/SIO_010010"))) :inverse (iri "http://semanticscience.org/resource/SIO_010080"))
(object-property (iri "http://semanticscience.org/resource/SIO_010080") :domain (object-or (iri "http://semanticscience.org/resource/SIO_010010") (object-some (iri "http://semanticscience.org/resource/SIO_000068") (iri "http://semanticscience.org/resource/SIO_010010"))) :range (object-or (iri "http://semanticscience.org/resource/SIO_010009") (object-some (iri "http://semanticscience.org/resource/SIO_000068") (iri "http://semanticscience.org/resource/SIO_010009"))) :inverse (iri "http://semanticscience.org/resource/SIO_010081"))
(owl-class (iri "http://semanticscience.org/resource/SIO_010100") :subclass (iri "http://semanticscience.org/resource/SIO_010035") (object-some (iri "http://semanticscience.org/resource/SIO_000093") (iri "http://semanticscience.org/resource/SIO_010010")) :disjoint (iri "http://semanticscience.org/resource/SIO_010101") :annotation (label (literal "dna gene" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a gene that is located on DNA." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010101") :subclass (iri "http://semanticscience.org/resource/SIO_010035") (object-some (iri "http://semanticscience.org/resource/SIO_000093") (iri "http://semanticscience.org/resource/SIO_010009")) :disjoint (iri "http://semanticscience.org/resource/SIO_010100") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a gene that is located on RNA" :lang "en")) (label (literal "rna gene" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_010078") :domain (object-or (iri "http://semanticscience.org/resource/SIO_010010") (object-some (iri "http://semanticscience.org/resource/SIO_000068") (iri "http://semanticscience.org/resource/SIO_010010"))) :range (object-or (iri "http://semanticscience.org/resource/SIO_010009") (iri "http://semanticscience.org/resource/SIO_010011") (iri "http://semanticscience.org/resource/SIO_010043") (object-some (iri "http://semanticscience.org/resource/SIO_000068") (iri "http://semanticscience.org/resource/SIO_010009")) (object-some (iri "http://semanticscience.org/resource/SIO_000068") (iri "http://semanticscience.org/resource/SIO_010011")) (object-some (iri "http://semanticscience.org/resource/SIO_000068") (iri "http://semanticscience.org/resource/SIO_010043"))) :inverse (iri "http://semanticscience.org/resource/SIO_010079"))
(object-property (iri "http://semanticscience.org/resource/SIO_010079") :inverse (iri "http://semanticscience.org/resource/SIO_010078"))
(object-property (iri "http://semanticscience.org/resource/SIO_000482") :domain (iri "http://semanticscience.org/resource/SIO_000275") :range (iri "http://semanticscience.org/resource/SIO_000275") :characteristic :symmetric)
(object-property (iri "http://semanticscience.org/resource/SIO_000484") :characteristic :symmetric)
(owl-class (iri "http://semanticscience.org/resource/SIO_000510") :subclass (iri "http://semanticscience.org/resource/SIO_000612") (object-some (iri "http://semanticscience.org/resource/SIO_000210") (iri "http://semanticscience.org/resource/SIO_000000")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A model is a representation of some thing." :lang "en")) (label (literal "model" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000516") :subclass (iri "http://semanticscience.org/resource/SIO_000511") :disjoint (iri "http://semanticscience.org/resource/SIO_000512") (iri "http://semanticscience.org/resource/SIO_000539") :annotation (label (literal "ray" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A ray is a line which that is bounded by a startpoint and extends outwards infinitely along one dimension." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000515") :subclass (iri "http://semanticscience.org/resource/SIO_000513") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A minor tick mark is a tick mark that indicates the position of a specific numeric value but has no adjacent value label, or is one of a pair of tick marks that delineates the boundary of a categorical value but has no adjacent category label on the categorical axis." :lang "en")) (label (literal "minor tick mark" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000518") :subclass (iri "http://semanticscience.org/resource/SIO_000517") :annotation (label (literal "rectangle" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A rectangle is a quadrilateral in which one pair of line segments are  parallel and the other pair are perpendicular to the first pair." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000517") :subclass (iri "http://semanticscience.org/resource/SIO_000505") :annotation (label (literal "quadrilateral" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A quadrilateral is a polygon with composed of four points and four line segments, in which each point is fully connected to two other points." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000512") :subclass (iri "http://semanticscience.org/resource/SIO_000511") (object-exactly 2 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_000532")) :disjoint (iri "http://semanticscience.org/resource/SIO_000516") (iri "http://semanticscience.org/resource/SIO_000539") :annotation (label (literal "line segment" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A line segment is a line and a part of a curve that is (inclusively) bounded by two terminal points." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000511") :subclass (iri "http://semanticscience.org/resource/SIO_000608") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_000512") (iri "http://semanticscience.org/resource/SIO_000516") (iri "http://semanticscience.org/resource/SIO_000539")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A line is curve that extends in a single dimension (e.g. straight line; exhibits no curvature), and is composed of at least two fully connected points." :lang "en")) (label (literal "line" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000514") :subclass (iri "http://semanticscience.org/resource/SIO_000513") :annotation (label (literal "major tick mark" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A major tick mark is a tick mark that indicates the position of a \nspecific numeric value and is adjacent to its value label on the value \naxis, or is one of a pair of tick marks that delineates the boundary of a \ncategorical value indicated by an adjacent category label on the \ncategorical axis." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000513") :subclass (iri "http://semanticscience.org/resource/SIO_000512") :annotation (label (literal "tick mark" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A tick mark is a line segment that is spatially positioned perpendicular to the axis of a statistical graph and indicates the position of a specific numeric value (which may be indicated by an adjacent value label) on a value axis, or is one of a pair of tick marks that delineates the boundary of a categorical value (which may be indicated by an adjacent category label) on the categorical axis." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000519") :subclass (iri "http://semanticscience.org/resource/SIO_000518") :annotation (label (literal "bar" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A bar is a rectangle that is located in the plot of a statistical graph in which its length is proportional to the values that it represents." :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000477") :inverse (iri "http://semanticscience.org/resource/SIO_000427"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000507") :subclass (iri "http://semanticscience.org/resource/SIO_000506") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A point is a geometric entity that is located in a zero-dimensional spatial region and whose position is defined by its coordinates in some coordinate system." :lang "en")) (label (literal "point" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000506") :subclass (iri "http://semanticscience.org/resource/SIO_000015") :annotation (annotation (iri "http://semanticscience.org/resource/subset") (literal "geometry+" :type :RDF_PLAIN_LITERAL)) (label (literal "geometric entity" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a geometric entity is an information content entity that pertains to the structure and topology of a space." :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000505") :subclass (iri "http://semanticscience.org/resource/SIO_000506") :annotation (label (literal "polygon" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A polygon is a planar entity that is bounded by a closed path or circuit, composed of a finite connected sequence3 of straight line segments." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000504") :subclass (iri "http://semanticscience.org/resource/SIO_000506") (object-some (iri "http://semanticscience.org/resource/SIO_000028") (iri "http://semanticscience.org/resource/SIO_000503")) :annotation (label (literal "polyhedral surface" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A polyhedral surface is composed of polygonal faces." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000503") :subclass (iri "http://semanticscience.org/resource/SIO_000506") (object-some (iri "http://semanticscience.org/resource/SIO_000068") (iri "http://semanticscience.org/resource/SIO_000505")) :annotation (label (literal "polygonal face" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A polygonal face is a polygon bounded by a circuit of polygon edges, and includes the flat (plane) region inside the boundary." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000502") :subclass (iri "http://semanticscience.org/resource/SIO_000506") (object-some (iri "http://semanticscience.org/resource/SIO_000273") (iri "http://semanticscience.org/resource/SIO_000501")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A polyhedral skeleton is a collection of polygon edges." :lang "en")) (label (literal "polyhedral skeleton" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000501") :subclass (iri "http://semanticscience.org/resource/SIO_000512") (object-some (iri "http://semanticscience.org/resource/SIO_000068") (iri "http://semanticscience.org/resource/SIO_000505")) (object-exactly 2 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_000500")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A polygon edge is a line segment joining two polygon vertices." :lang "en")) (label (literal "polygon edge" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000500") :subclass (iri "http://semanticscience.org/resource/SIO_000532") (object-at-least 2 (iri "http://semanticscience.org/resource/SIO_000313") (iri "http://semanticscience.org/resource/SIO_000501")) (object-exactly 1 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_000541")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A polygon vertex is a terminal point at which two polygon edges meet and are part of a polygon." :lang "en")) (label (literal "polygon vertex" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000509") :subclass (iri "http://semanticscience.org/resource/SIO_000532") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A start point is a terminal point which is the first of an ordered \npair of points." :lang "en")) (label (literal "start point" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000508") :subclass (iri "http://semanticscience.org/resource/SIO_000532") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An endpoint is a terminal point that is the last of an ordered \npair of points." :lang "en")) (label (literal "endpoint" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010523") :subclass (iri "http://semanticscience.org/resource/SIO_010519") :annotation (label (literal "electrophilic addition reaction" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an electrophilic addition reaction is a polar addition reaction where a pi bond is removed by the creation of two new covalent bonds." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010522") :subclass (iri "http://semanticscience.org/resource/SIO_010519") :annotation (label (literal "nucleophilic addition reaction" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A nucleophilic addition reaction is an addition reaction where a pi bond is removed by the creation of two new covalent bonds by the addition from a nucleophile." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010521") :subclass (iri "http://semanticscience.org/resource/SIO_010520") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A free radical addition is a non-polar addition reaction involving free radicals." :lang "en")) (label (literal "free radical addition" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010528") :subclass (iri "http://semanticscience.org/resource/SIO_010526") :annotation (label (literal "chemical degradation pathway" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a chemical degradation pathway is a pathway involved in the disassembly of a chemical." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010527") :subclass (iri "http://semanticscience.org/resource/SIO_010526") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a chemical synthesis pathway is a pathway involved in the assembly of a chemical." :lang "en")) (label (literal "chemical synthesis pathway" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010526") :subclass (iri "http://semanticscience.org/resource/SIO_001107") (object-some (iri "http://semanticscience.org/resource/SIO_000338") (object-some (iri "http://semanticscience.org/resource/SIO_000053") (iri "http://semanticscience.org/resource/SIO_010345"))) (object-some (iri "http://semanticscience.org/resource/SIO_000632") (iri "http://semanticscience.org/resource/SIO_000006")) (object-only (iri "http://semanticscience.org/resource/SIO_000059") (iri "http://semanticscience.org/resource/SIO_010345")) :annotation (label (literal "chemical reaction pathway" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a chemical reaction pathway specifies a series of chemical reactions towards producing some chemical product." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010525") :subclass (iri "http://semanticscience.org/resource/SIO_010526") :annotation (label (literal "biochemical pathway" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a biochemical pathway specifies a series of biochemical modifications and transformations towards achieving some biological outcome." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010520") :subclass (iri "http://semanticscience.org/resource/SIO_010518") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a non-polar addition reaction is an addition reaction involving non-polar residues." :lang "en")) (label (literal "non-polar addition reaction" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010533") :subclass (iri "http://semanticscience.org/resource/SIO_010525") :disjoint (iri "http://semanticscience.org/resource/SIO_010532") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a regulatory pathway is a series of biochemical reactions that lead to the increase or decrease of activity of participating molecular components." :lang "en")) (label (literal "regulatory pathway" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010532") :subclass (iri "http://semanticscience.org/resource/SIO_010525") :disjoint (iri "http://semanticscience.org/resource/SIO_010533") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a metabolic pathway is a series of biochemical reactions that begins with one or more substrates and ends with one or more products." :lang "en")) (label (literal "metabolic pathway" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000495") :characteristic :symmetric)
(object-property (iri "http://semanticscience.org/resource/SIO_000496") :characteristic :symmetric)
(object-property (iri "http://semanticscience.org/resource/SIO_000497") :characteristic :transitive :symmetric)
(owl-class (iri "http://semanticscience.org/resource/SIO_001300") :subclass (iri "http://semanticscience.org/resource/SIO_000602") :annotation (label (literal "ovopub" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an ovopub is an information content entity that contains and links to one or more resources and/or statements, including those describing its provenance, and is itself a dereferenceable resource." :lang "en")) (annotation (iri "http://semanticscience.org/resource/subset") (literal "ovopub+" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_001301") :subclass (iri "http://semanticscience.org/resource/SIO_001300") :annotation (label (literal "assertion ovopub" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001302") :subclass (iri "http://semanticscience.org/resource/SIO_001300") :annotation (label (literal "record ovopub" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001303") :subclass (iri "http://semanticscience.org/resource/SIO_001300") :annotation (label (literal "dataset ovopub" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000491") :characteristic :symmetric)
(object-property (iri "http://semanticscience.org/resource/SIO_000490") :characteristic :symmetric)
(owl-class (iri "http://semanticscience.org/resource/SIO_010530") :subclass (iri "http://semanticscience.org/resource/SIO_010023") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a 3D structure model is a representation of the spatial arrangement of one or more chemical entities." :lang "en")) (label (literal "3d structure model" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010531") :subclass (iri "http://semanticscience.org/resource/SIO_010065") :annotation (label (literal "sequence profile" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a sequence profile is provides the preference for a character at each position of an abstracted sequence." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000551") :subclass (iri "http://semanticscience.org/resource/SIO_000385") :annotation (label (literal "to change the activation energy" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to change the activation energy is to change the amount of energy required to form or break a chemical bond." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000554") :subclass (iri "http://semanticscience.org/resource/SIO_000307") :disjoint (iri "http://semanticscience.org/resource/SIO_000555") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A quality that has a value that is normal or average." :lang "en")) (label (literal "normal" :lang "en")) (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "PATO:0000461" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000550") :subclass (iri "http://semanticscience.org/resource/SIO_000551") :disjoint (iri "http://semanticscience.org/resource/SIO_000549") :annotation (label (literal "to increase the activation energy" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to increase the activation energy is to require a larger amount of energy in order to form or break a chemical bond." :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "to inhibit" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000559") :subclass (iri "http://semanticscience.org/resource/SIO_000588") (object-some (iri "http://semanticscience.org/resource/SIO_000139") (iri "http://semanticscience.org/resource/SIO_010343")) (object-some (iri "http://semanticscience.org/resource/SIO_000312") (iri "http://semanticscience.org/resource/SIO_010004")) :annotation (label (literal "chemical synthesis" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Chemical synthesis is synthesis of a chemical entity from physical precursors through one or more chemical interactions or reactions." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000555") :subclass (iri "http://semanticscience.org/resource/SIO_000307") :disjoint (iri "http://semanticscience.org/resource/SIO_000554") :annotation (label (literal "abnormal" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A quality that has a value that is outside normal or average." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000556") :subclass (iri "http://semanticscience.org/resource/SIO_010071") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a lipid residue is a part of an organic molecule that was derived from a lipid molecule." :lang "en")) (label (literal "lipid residue" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000543") :subclass (iri "http://semanticscience.org/resource/SIO_000542") (object-some (iri "http://semanticscience.org/resource/SIO_000646") (iri "http://semanticscience.org/resource/SIO_010415")) :annotation (label (literal "to serve as a host" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to serve as host is the capability to act in a manner that provides hospitality, serves to harbour an organism in or on itself." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000542") :subclass (iri "http://semanticscience.org/resource/SIO_000494") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to serve as is the capability to act in a manner corresponding to some role." :lang "en")) (label (literal "to serve as" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000541") :subclass (iri "http://semanticscience.org/resource/SIO_000540") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A vertext normal is the normalized average of the surface normals of the faces that contain that vertex." :lang "en")) (label (literal "vertex normal" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000540") :subclass (iri "http://semanticscience.org/resource/SIO_000516") :annotation (label (literal "vector" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A ray is a line which that is bounded by a startpoint and extends outwards along one dimension." :lang "en")))
(annotation-property (iri "http://semanticscience.org/resource/example"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000549") :subclass (iri "http://semanticscience.org/resource/SIO_000551") :disjoint (iri "http://semanticscience.org/resource/SIO_000550") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to reduce the activation energy is to require a smaller amount of energy in order to form or break a chemical bond." :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "to activate" :type :RDF_PLAIN_LITERAL)) (label (literal "to reduce the activation energy" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000546") :subclass (iri "http://semanticscience.org/resource/SIO_000506") (iri "http://semanticscience.org/resource/SIO_000616") (object-only (iri "http://semanticscience.org/resource/SIO_000059") (iri "http://semanticscience.org/resource/SIO_000507")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a collection of points is a geometric entity that contains a non-zero set of geometric points. " :lang "en")) (label (literal "collection of points" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000547") :subclass (iri "http://semanticscience.org/resource/SIO_000376") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to cause disease is the capability to materially change a biological object in that it functions abnormally." :lang "en")) (label (literal "to cause disease" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000544") :subclass (iri "http://semanticscience.org/resource/SIO_000372") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "To infect is the capability to administer a disease-causing organism into some object." :lang "en")) (label (literal "to infect" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000545") :subclass (iri "http://semanticscience.org/resource/SIO_000506") (object-at-least 2 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_000512")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A polyline is a connected sequence of line segments." :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "polygonal chain, polygonal curve, polygonal path, piecewise linear curve" :type :RDF_PLAIN_LITERAL)) (label (literal "polyline" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000530") :subclass (iri "http://semanticscience.org/resource/SIO_000527") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An plateau line is a line segment in which the startpoint and endpoint are ordered along one dimension and the difference of values in a second dimension is zero." :lang "en")) (label (literal "plateau line" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000532") :subclass (iri "http://semanticscience.org/resource/SIO_000507") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A terminal point is a point that defines the finite extension of a line." :lang "en")) (label (literal "terminal point" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000531") :subclass (iri "http://semanticscience.org/resource/SIO_000535") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A drop line is a statistical graph line that vertically or horizontally connects a data series line with a value axis in a statistical graph." :lang "en")) (label (literal "drop line" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000533") :subclass (iri "http://semanticscience.org/resource/SIO_000540") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A surface normal is a vector that is perpendicular to a flat surface." :lang "en")) (label (literal "surface normal" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000534") :subclass (iri "http://semanticscience.org/resource/SIO_000511") :annotation (label (literal "positionally oriented line" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a positionally oriented line is a line that is positioned against some axis of reference." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000535") :subclass (iri "http://semanticscience.org/resource/SIO_000511") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A statistical graph line is a line used in a statistical graph to communicate some trend or feature of the embedded data." :lang "en")) (label (literal "statistical graph line" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000536") :subclass (iri "http://semanticscience.org/resource/SIO_000395") :annotation (label (literal "to regulate the rate of formation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to regulate the rate of formation is to modify the rate at which an object is formed." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000537") :subclass (iri "http://semanticscience.org/resource/SIO_000055") :annotation (label (literal "curvature" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "curvature is a quality of a bearer that relates to the presence of curves, bends, or angles." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000538") :subclass (iri "http://semanticscience.org/resource/SIO_000537") :disjoint (iri "http://semanticscience.org/resource/SIO_001094") (iri "http://semanticscience.org/resource/SIO_001095") :annotation (annotation (iri "http://www.w3.org/2000/01/rdf-schema#seeAlso") (literal "PATO:0002180 [for material entities]" :type :RDF_PLAIN_LITERAL)) (label (literal "straight" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "shape is a quality of a bearer that is free of curves, bends, or angles." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000539") :subclass (iri "http://semanticscience.org/resource/SIO_000511") :disjoint (iri "http://semanticscience.org/resource/SIO_000512") (iri "http://semanticscience.org/resource/SIO_000516") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An infinite line is a line that extends outwards in both directions of a single dimensional and is not bounded by terminal points." :lang "en")) (label (literal "infinite line" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000521") :subclass (iri "http://semanticscience.org/resource/SIO_000512") (object-exactly 1 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_000508")) (object-exactly 1 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_000509")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A directed line segment is a line segment that is contained by an ordered pair \nof endpoints (a start point and an endpoint)." :lang "en")) (label (literal "directed line segment" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000520") :subclass (iri "http://semanticscience.org/resource/SIO_000505") :annotation (label (literal "triangle" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A triangle is a polygon composed of three points and three line segments, in which each point is fully connected to another point along through the line segment." :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000900"))
(object-property (iri "http://semanticscience.org/resource/SIO_000901"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000524") :subclass (iri "http://semanticscience.org/resource/SIO_000522") (object-exactly 2 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_000520")) :disjoint (iri "http://semanticscience.org/resource/SIO_000523") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A double arrowed line is an arrowed line in which both terminal points are  tangentially part of different triangles that bisect the line." :lang "en")) (label (literal "double arrowed line segment" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000525") :subclass (iri "http://semanticscience.org/resource/SIO_000534") :annotation (label (literal "horizontal line" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A vertical line is a line that is positionally oriented with the horizon." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000522") :subclass (iri "http://semanticscience.org/resource/SIO_000521") (object-some (iri "http://semanticscience.org/resource/SIO_000028") (iri "http://semanticscience.org/resource/SIO_000520")) (object-at-most 2 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_000520")) :annotation (label (literal "arrowed line segment" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An arrowed line is a directed line segment in which one or both endpoints is tangentially part of a triangle that bisects the line." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000523") :subclass (iri "http://semanticscience.org/resource/SIO_000522") (object-exactly 1 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_000520")) :disjoint (iri "http://semanticscience.org/resource/SIO_000524") :annotation (label (literal "single arrowed line segment" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A single arrowed line is directed line in which the endpoint is tangentially part of a triangle that bisects the line." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000528") :subclass (iri "http://semanticscience.org/resource/SIO_000527") :annotation (label (literal "increasing line" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An increasing line is a line segment in which the startpoint and endpoint are ordered along one dimension and the difference of values in a second dimension is positive." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000529") :subclass (iri "http://semanticscience.org/resource/SIO_000527") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An decreasing line is a line segment in which the startpoint and endpoint are ordered along one dimension and the difference of values in a second dimension is negative." :lang "en")) (label (literal "decreasing line" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000526") :subclass (iri "http://semanticscience.org/resource/SIO_000534") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A vertical line is a line that is positionally oriented perpendicular to the horizon." :lang "en")) (label (literal "vertical line" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000527") :subclass (iri "http://semanticscience.org/resource/SIO_000535") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A trend line is a line, line segment or ray that is part of a statistical graph which indicates a statistical or visual direction across categorical or value data." :lang "en")) (label (literal "trend line" :lang "en")))
(annotation-property (iri "http://www.w3.org/2000/01/rdf-schema#seeAlso"))
(annotation-property (iri "http://semanticscience.org/resource/broaderThan"))
(owl-class (iri "http://semanticscience.org/resource/SIO_010507") :subclass (iri "http://semanticscience.org/resource/SIO_010345") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an acid-base reaction is a chemical reaction between an acid and a base." :lang "en")) (label (literal "acid-base reaction" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010508") :subclass (iri "http://semanticscience.org/resource/SIO_010345") (object-some (iri "http://semanticscience.org/resource/SIO_000139") (iri "http://semanticscience.org/resource/SIO_010344")) :annotation (label (literal "catalyzed reaction" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a catalyzed reaction is a chemical reaction that is facilitated by a catalyst." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010509") :subclass (iri "http://semanticscience.org/resource/SIO_010345") (object-or (object-some (iri "http://semanticscience.org/resource/SIO_000355") (object-or (iri "http://semanticscience.org/resource/SIO_010358") (object-some (iri "http://semanticscience.org/resource/SIO_000236") (iri "http://semanticscience.org/resource/SIO_011125")))) (object-some (iri "http://semanticscience.org/resource/SIO_000355") (object-or (iri "http://semanticscience.org/resource/SIO_010359") (object-some (iri "http://semanticscience.org/resource/SIO_000236") (iri "http://semanticscience.org/resource/SIO_011125"))))) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a redox reaction is a chemical reaction in which there is a net movement of electrons from one reactant to another." :lang "en")) (label (literal "redox reaction" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010503") :subclass (iri "http://semanticscience.org/resource/SIO_010005") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a dipole-dipole interaction is a weak submolecular interaction between strongly electronegative atoms." :lang "en")) (label (literal "dipole-dipole interaction" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010504") :subclass (iri "http://semanticscience.org/resource/SIO_010005") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "van der Waals' interaction is an a weak submolecular interaction between an instantaneous dipole and induced dipole." :lang "en")) (label (literal "van der Waals interaction" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010505") :subclass (iri "http://semanticscience.org/resource/SIO_010005") :annotation (label (literal "base stack" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a base stack is a stabilizing interaction of DNA and RNA between spatially adjacent nucleotides and possibly involving London dispersion, hydrophobic and electrostatic forces." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010506") :subclass (iri "http://semanticscience.org/resource/SIO_010004") (object-or (object-some (iri "http://semanticscience.org/resource/SIO_000273") (iri "http://semanticscience.org/resource/SIO_010506")) (object-at-least 2 (iri "http://semanticscience.org/resource/SIO_000273") (iri "http://semanticscience.org/resource/SIO_011125"))) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a molecular complex is a chemical complex composed of weakly interacting molecular entities, and excludes bulk solvent." :lang "en")) (label (literal "molecular complex" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010500") :subclass (iri "http://semanticscience.org/resource/SIO_011118") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a triple bond is a covalent bond between a pair of atoms in which three pairs of electrons are shared." :lang "en")) (label (literal "triple bond" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010501") :subclass (iri "http://semanticscience.org/resource/SIO_011118") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an aromatic bond is an interaction between a set of atoms across which pairs of electrons are shared." :lang "en")) (label (literal "aromatic bond" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010502") :subclass (iri "http://semanticscience.org/resource/SIO_010498") :annotation (label (literal "disulfide bond" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a disulfide bond is a bond between two sulfur atoms." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010518") :subclass (iri "http://semanticscience.org/resource/SIO_010516") :annotation (label (literal "addition reaction" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An addition reaction is an organic reaction where two or more molecules combine to form a larger one. Addition reactions are limited to chemical compounds that have multiply-bonded atoms:\n    * Molecules with carbon-carbon double bonds or triple bonds\n    * Molecules with carbon - hetero double bonds like C=O or C=N" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010519") :subclass (iri "http://semanticscience.org/resource/SIO_010518") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a polar addition reaction is an addition reaction involving polar residues." :lang "en")) (label (literal "polar addition reaction" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010516") :subclass (iri "http://semanticscience.org/resource/SIO_010345") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An organic reaction is a chemical reaction involving at least one organic molecule." :lang "en")) (label (literal "organic reaction" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010517") :subclass (iri "http://semanticscience.org/resource/SIO_010345") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An isomerization reaction is a chemical reaction in which a molecule is converted into its isomer." :lang "en")) (label (literal "isomerization reaction" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010514") :subclass (iri "http://semanticscience.org/resource/SIO_010512") :annotation (label (literal "single displacement reaction" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A single displacement reaction where one atom is transferred out of one molecule and into another." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010515") :subclass (iri "http://semanticscience.org/resource/SIO_010510") :annotation (label (literal "synthesis reaction" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A synthesis reaction is an inorganic reaction in which two or more molecules are chemically bonded together to produce a single product." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010512") :subclass (iri "http://semanticscience.org/resource/SIO_010510") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A displacement reaction is an inorganic reaction in which a elementary substance displaces and sets free a constituent atom from a molecule." :lang "en")) (label (literal "displacement reaction" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010513") :subclass (iri "http://semanticscience.org/resource/SIO_010512") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A double displacement reaction is a displacement reaction in which two molecules swap ions, effectively displacing each other to form two new molecules." :lang "en")) (label (literal "double displacement reaction" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010510") :subclass (iri "http://semanticscience.org/resource/SIO_010345") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An inorganic reaction is a chemical reaction that involves the transformation of inorganic molecules." :lang "en")) (label (literal "inorganic reaction" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010511") :subclass (iri "http://semanticscience.org/resource/SIO_010510") :annotation (label (literal "decomposition reaction" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A decomposition reaction is an inorganic reaction in which molecule is fragmented into submolecules or atoms." :lang "en")))
(annotation-property (iri "http://semanticscience.org/resource/seeAlso"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000200") :subclass (iri "http://semanticscience.org/resource/SIO_000111") :annotation (label (literal "results section" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "The results section is a document section describing the main findings of the study." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000201") :subclass (iri "http://semanticscience.org/resource/SIO_000111") :annotation (label (literal "table of contents" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "The table of contents is a document section that lists all sections (and optionally subsections) in a sequential order along with their page number." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000238") :subclass (iri "http://semanticscience.org/resource/SIO_000075") :annotation (label (literal "logical operator" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a logical operator is a unary or binary relation to construct logical expressions." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000239") :subclass (iri "http://semanticscience.org/resource/SIO_000238") :annotation (label (literal "conjunction (and)" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "AND is a logical operator that has the value true if both of its operands are true, otherwise a value of false." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000237") :subclass (iri "http://semanticscience.org/resource/SIO_000179") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A namespace label is a short name for a namespace." :lang "en")) (label (literal "namespace label" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000220") :subclass (iri "http://semanticscience.org/resource/SIO_000238") :annotation (label (literal "implies (->)" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "implication is a logical operator that holds between a set T of propositions and a proposition B, when every model (or interpretation or valuation) of T is also a model of B." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000259") :subclass (iri "http://semanticscience.org/resource/SIO_000256") (object-or (object-some (iri "http://semanticscience.org/resource/SIO_000053") (iri "http://semanticscience.org/resource/SIO_000261")) (object-some (iri "http://semanticscience.org/resource/SIO_000053") (iri "http://semanticscience.org/resource/SIO_000262"))) :annotation (label (literal "argument" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An argument is a set of one or more declarative sentences (or propositions) known as the premises along with another declarative sentence (or proposition) known as the conclusion." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000258") :subclass (iri "http://semanticscience.org/resource/SIO_000052") (object-some (iri "http://semanticscience.org/resource/SIO_000221") (iri "http://semanticscience.org/resource/SIO_000074")) :disjoint (iri "http://semanticscience.org/resource/SIO_000257") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A dimensional quantity is a quantity that has an associated unit." :lang "en")) (label (literal "dimensional quantity" :lang "en")))
(annotation-property (iri "http://semanticscience.org/resource/hasSynonym"))

(owl-class (iri "http://semanticscience.org/resource/SIO_000256") :subclass (iri "http://semanticscience.org/resource/SIO_000136") (object-some (iri "http://semanticscience.org/resource/SIO_000217") (iri "http://semanticscience.org/resource/SIO_000268")) (object-some (iri "http://semanticscience.org/resource/SIO_000332") (iri "http://semanticscience.org/resource/SIO_000000")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A proposition is a sentence expressing something true or false." :lang "en")) (label (literal "proposition" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000257") :subclass (iri "http://semanticscience.org/resource/SIO_000052") (object-not (object-some (iri "http://semanticscience.org/resource/SIO_000221") (iri "http://semanticscience.org/resource/SIO_000074"))) :disjoint (iri "http://semanticscience.org/resource/SIO_000258") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A dimensionless quantity is a quantity that has no associated unit." :lang "en")) (label (literal "dimensionless quantity" :lang "en")))


(annotation-property (iri "http://purl.org/dc/terms/alternativeName"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000270") :subclass (iri "http://semanticscience.org/resource/SIO_000268") (data-has-value (iri "http://semanticscience.org/resource/SIO_000300") (literal "false" :type :XSD_BOOLEAN)) :disjoint (iri "http://semanticscience.org/resource/SIO_000269") :annotation (label (literal "false" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "false is a truth value in that indicates that it is not true." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000275") :subclass (iri "http://semanticscience.org/resource/SIO_000483") (object-or (iri "http://semanticscience.org/resource/SIO_000114") (iri "http://semanticscience.org/resource/SIO_000483")) :annotation (label (literal "term" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A term is a word or phrase used to denote one or more entities." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000279") :subclass (iri "http://semanticscience.org/resource/SIO_000037") (object-some (iri "http://semanticscience.org/resource/SIO_000011") (iri "http://semanticscience.org/resource/SIO_000004")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "mass is the quality of the amount of substance." :lang "en")) (label (literal "mass" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000276") :subclass (iri "http://semanticscience.org/resource/SIO_001195") :annotation (annotation (iri "http://semanticscience.org/resource/subset") (literal "emotion++" :type :RDF_PLAIN_LITERAL)) (label (literal "emotion" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An emotion is a process (experience) that arises internally or from an involuntary physiological response to a stimulus." :lang "en")))
(annotation-property (iri "http://purl.org/dc/terms/creator"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000269") :subclass (iri "http://semanticscience.org/resource/SIO_000268") (data-has-value (iri "http://semanticscience.org/resource/SIO_000300") (literal "true" :type :XSD_BOOLEAN)) :disjoint (iri "http://semanticscience.org/resource/SIO_000270") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "true is a truth value that indicates that it holds under all possible worlds." :lang "en")) (label (literal "true" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000261") :subclass (iri "http://semanticscience.org/resource/SIO_000256") :annotation (label (literal "premise" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A premise is a proposition of an argument from which the conclusion is drawn." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000262") :subclass (iri "http://semanticscience.org/resource/SIO_000256") :annotation (label (literal "conclusion" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A conclusion is a proposition which is reached after considering the evidence, arguments or premises." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000263") :subclass (iri "http://semanticscience.org/resource/SIO_000259") :annotation (label (literal "deductive argument" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A deductive argument is an argument that asserts that the truth of the conclusion is a logical consequence of the premises." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000264") :subclass (iri "http://semanticscience.org/resource/SIO_000259") :annotation (label (literal "inductive argument" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An inductive argument is an argument that asserts that the truth of the conclusion is supported by the premises." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000265") :subclass (iri "http://semanticscience.org/resource/SIO_000266") (object-some (iri "http://semanticscience.org/resource/SIO_000053") (object-or (iri "http://semanticscience.org/resource/SIO_000261") (object-some (iri "http://semanticscience.org/resource/SIO_000217") (iri "http://semanticscience.org/resource/SIO_000269")))) :annotation (label (literal "sound argument" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A sound argument is a valid argument with true premises." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000266") :subclass (iri "http://semanticscience.org/resource/SIO_000259") (object-some (iri "http://semanticscience.org/resource/SIO_000053") (object-or (iri "http://semanticscience.org/resource/SIO_000262") (object-some (iri "http://semanticscience.org/resource/SIO_000217") (iri "http://semanticscience.org/resource/SIO_000270")))) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A valid argument is an argument where the truth of the conclusion is a logical consequence of the premises and (consequently) its corresponding conditional is a necessary truth." :lang "en")) (label (literal "valid argument" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000267") :subclass (iri "http://semanticscience.org/resource/SIO_000259") (object-some (iri "http://semanticscience.org/resource/SIO_000053") (object-or (iri "http://semanticscience.org/resource/SIO_000262") (object-some (iri "http://semanticscience.org/resource/SIO_000217") (iri "http://semanticscience.org/resource/SIO_000270")))) :annotation (label (literal "invalid argument" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An invalid argument is an argument where the truth of the conclusion is false because it is not a logical consequence of the premises." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000268") :subclass (iri "http://semanticscience.org/resource/SIO_000436") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_000269") (iri "http://semanticscience.org/resource/SIO_000270")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "truth value is a quality of information that is claimed/verified to be true or false." :lang "en")) (label (literal "truth value" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000299") :subclass (iri "http://semanticscience.org/resource/SIO_000298") (object-some (iri "http://semanticscience.org/resource/SIO_000244") (iri "http://semanticscience.org/resource/SIO_000651")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A quote is a excerpt that is attributed to a particular source." :lang "en")) (label (literal "quote" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000298") :subclass (iri "http://semanticscience.org/resource/SIO_000651") (object-some (iri "http://semanticscience.org/resource/SIO_000068") (iri "http://semanticscience.org/resource/SIO_000651")) :annotation (label (literal "excerpt" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An excerpt is a contiguous or discontiguous portion of a document." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000295") :subclass (iri "http://semanticscience.org/resource/SIO_000616") (object-at-least 2 (iri "http://semanticscience.org/resource/SIO_000369") (iri "http://semanticscience.org/resource/SIO_000148")) :annotation (label (literal "collection of documents" :lang "en")) (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "http://purl.org/ontology/bibo/Collection" :type :RDF_PLAIN_LITERAL)) (annotation (iri "http://purl.org/dc/terms/description") (literal "a collection of documents is a non-zero set of documents." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000297") :subclass (iri "http://semanticscience.org/resource/SIO_001194") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A movie is a series of images that are displayed in rapid succession  to give the impression of movement." :lang "en")) (label (literal "movie" :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "film" :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "moving pictures" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000296") :subclass (iri "http://semanticscience.org/resource/SIO_000295") (object-some (iri "http://semanticscience.org/resource/SIO_000273") (iri "http://semanticscience.org/resource/SIO_000302")) :annotation (label (literal "website" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A website is a collection of documents published on the World Wide Web." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000290") :subclass (iri "http://semanticscience.org/resource/SIO_000285") :annotation (label (literal "university" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A university is an institution of higher education and research which grants academic degrees in a variety of subjects and provides both undergraduate education and postgraduate education. " :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000688") :subclass (iri "http://semanticscience.org/resource/SIO_000012") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "institute is a society or organization having a object or common factor, and is normally applied to those with a scientific, educational, or social objective." :lang "en")) (label (literal "institute" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000689") :subclass (iri "http://semanticscience.org/resource/SIO_010367") :annotation (label (literal "to be a part of" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to be a part of is the capability to be assembled into a larger structure that persists in time." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000683") :subclass (iri "http://semanticscience.org/resource/SIO_000256") :annotation (label (literal "justification" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A justification is a proposition that defends, explains or excuses some argument." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000686") :subclass (iri "http://semanticscience.org/resource/SIO_000285") :annotation (label (literal "academic department" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An academic department is a division of a university or school faculty devoted to a particular academic discipline." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000289") :subclass (iri "http://semanticscience.org/resource/SIO_000075") (object-only (iri "http://semanticscience.org/resource/SIO_000059") (iri "http://semanticscience.org/resource/SIO_000000")) :annotation (label (literal "set" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a set is a collection of entities, for which there may be zero members." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000287") :subclass (iri "http://semanticscience.org/resource/SIO_000009") :annotation (label (literal "social relation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a social relation is a social entity that describes a relationship  between two or more individuals or groups. " :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000285") :subclass (iri "http://semanticscience.org/resource/SIO_000012") :annotation (label (literal "academic organization" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an academic organization is a lawfully recognized organization that confers diplomas, degrees and other forms of recognition of academic achievement." :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_000128") :inverse (iri "http://semanticscience.org/resource/SIO_000202") :characteristic :transitive)
(owl-class (iri "http://semanticscience.org/resource/SIO_000284") :subclass (iri "http://semanticscience.org/resource/SIO_000256") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a hypothesis is a proposed explanation for a phenomenon." :lang "en")) (label (literal "hypothesis" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000282") :subclass (iri "http://semanticscience.org/resource/SIO_000280") :annotation (label (literal "exclusive disjunction (xor)" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "XOR, also called exclusive disjunction or (symbolized XOR, EOR, EXOR, or ⊕), is a type of logical disjunction on two operands that results in a value of true if exactly one of the operands has a value of true." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000281") :subclass (iri "http://semanticscience.org/resource/SIO_000238") :annotation (label (literal "negation (not)" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "NOT is a logical operator in that has the value true if its operand is false." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000280") :subclass (iri "http://semanticscience.org/resource/SIO_000238") :annotation (label (literal "disjunction (or)" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "OR is a logical operator that results in true whenever one or more of its operands are true." :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000698") :subclass (iri "http://semanticscience.org/resource/SIO_000376") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to disassemble is to physically separate the parts of an object." :lang "en")) (label (literal "to disassemble" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000696") :subclass (iri "http://semanticscience.org/resource/SIO_000694") (object-some (iri "http://semanticscience.org/resource/SIO_000697") (iri "http://semanticscience.org/resource/SIO_000353")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to be observed is the capability of an object to be perceived." :lang "en")) (label (literal "to be observed" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000694") :subclass (iri "http://semanticscience.org/resource/SIO_000702") (object-some (iri "http://semanticscience.org/resource/SIO_000709") (iri "http://semanticscience.org/resource/SIO_000639")) :disjoint (iri "http://semanticscience.org/resource/SIO_000692") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to be passively interacted with is the capability of an object to be observed." :lang "en")) (label (literal "to be passively interacted with" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000695") :subclass (iri "http://semanticscience.org/resource/SIO_000696") (object-some (iri "http://semanticscience.org/resource/SIO_000697") (iri "http://semanticscience.org/resource/SIO_000344")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to be recorded is the capability of an object to be observed in such a way that information about it can be transcribed in a specified format on some physical medium." :lang "en")) (label (literal "to be recorded" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000692") :subclass (iri "http://semanticscience.org/resource/SIO_000702") (object-some (iri "http://semanticscience.org/resource/SIO_000709") (iri "http://semanticscience.org/resource/SIO_000494")) :disjoint (iri "http://semanticscience.org/resource/SIO_000694") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to be actively interacted with is the capability to be manipulated by some device or agent." :lang "en")) (label (literal "to be actively interacted with" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000693") :subclass (iri "http://semanticscience.org/resource/SIO_000012") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A corporation is an organization that is granted a charter recognizing it as a separate legal entity." :lang "en")) (label (literal "corporation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000690") :subclass (iri "http://semanticscience.org/resource/SIO_000494") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "To associate is the capability to physically interact with another object." :lang "en")) (label (literal "to associate" :lang "en")))
(object-property (iri "http://semanticscience.org/resource/SIO_001247") :characteristic :transitive :symmetric)
(object-property (iri "http://semanticscience.org/resource/SIO_000139") :inverse (iri "http://semanticscience.org/resource/SIO_000063"))
(object-property (iri "http://semanticscience.org/resource/SIO_000132") :domain (iri "http://semanticscience.org/resource/SIO_000006") :inverse (iri "http://semanticscience.org/resource/SIO_000062"))
(object-property (iri "http://semanticscience.org/resource/SIO_000145") :inverse (iri "http://semanticscience.org/resource/SIO_000061") :characteristic :transitive)
(object-property (iri "http://semanticscience.org/resource/SIO_000905"))
(object-property (iri "http://semanticscience.org/resource/SIO_000971") :inverse (iri "http://semanticscience.org/resource/SIO_000970"))
(object-property (iri "http://semanticscience.org/resource/SIO_000972") :inverse (iri "http://semanticscience.org/resource/SIO_000973"))
(object-property (iri "http://semanticscience.org/resource/SIO_000970") :inverse (iri "http://semanticscience.org/resource/SIO_000971"))
(object-property (iri "http://semanticscience.org/resource/SIO_000975"))
(object-property (iri "http://semanticscience.org/resource/SIO_000973") :inverse (iri "http://semanticscience.org/resource/SIO_000972"))
(object-property (iri "http://semanticscience.org/resource/SIO_000974"))
(object-property (iri "http://semanticscience.org/resource/SIO_000586") :range (iri "http://semanticscience.org/resource/SIO_000112") :inverse (iri "http://semanticscience.org/resource/SIO_000646") :characteristic :inversefunctional)
(object-property (iri "http://semanticscience.org/resource/SIO_000552") :inverse (iri "http://semanticscience.org/resource/SIO_000553"))
(object-property (iri "http://semanticscience.org/resource/SIO_000553") :inverse (iri "http://semanticscience.org/resource/SIO_000552"))
(object-property (iri "http://semanticscience.org/resource/SIO_000558") :characteristic :symmetric)
(object-property (iri "http://semanticscience.org/resource/SIO_000557") :inverse (iri "http://semanticscience.org/resource/SIO_000563"))
(object-property (iri "http://semanticscience.org/resource/SIO_000563") :inverse (iri "http://semanticscience.org/resource/SIO_000557"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000619") :subclass (iri "http://semanticscience.org/resource/SIO_000012") :annotation (label (literal "regulatory authority" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A regulatory authority is an organization responsible for  exercising regulatory or supervisory capacity in some area of human activity." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000618") :subclass (iri "http://semanticscience.org/resource/SIO_000090") (object-some (iri "http://semanticscience.org/resource/SIO_000217") (iri "http://semanticscience.org/resource/SIO_000966")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a standard is a socially-agreed upon specification." :lang "en")) (label (literal "standard" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000611") :subclass (iri "http://semanticscience.org/resource/SIO_000610") (object-some (iri "http://semanticscience.org/resource/SIO_001154") (iri "http://semanticscience.org/resource/SIO_000376")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "the regulation of the enzymatic activity." :lang "en")) (label (literal "regulation of catalytic capability" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000610") :subclass (iri "http://semanticscience.org/resource/SIO_000589") (object-some (iri "http://semanticscience.org/resource/SIO_001158") (iri "http://semanticscience.org/resource/SIO_000112")) :annotation (label (literal "regulation of capability" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "regulation of capability is the regulation of the ability of one party by another." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000613") :subclass (iri "http://semanticscience.org/resource/SIO_000788") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A ordinal position is a number that designates the position of an entity from the first entity in an ordered sequence of entities." :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "offset" :type :RDF_PLAIN_LITERAL)) (label (literal "ordinal position" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000612") :subclass (iri "http://semanticscience.org/resource/SIO_000015") (object-some (iri "http://semanticscience.org/resource/SIO_000632") (iri "http://semanticscience.org/resource/SIO_000000")) :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_000015") (object-only (iri "http://semanticscience.org/resource/SIO_000210") (iri "http://semanticscience.org/resource/SIO_000000"))) :annotation (label (literal "representation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A representation is a entity that in some way represents another entity (or attribute thereof)." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000614") :subclass (iri "http://semanticscience.org/resource/SIO_000000") (object-some (iri "http://semanticscience.org/resource/SIO_000011") (iri "http://semanticscience.org/resource/SIO_000000")) :disjoint (iri "http://semanticscience.org/resource/SIO_000006") (iri "http://semanticscience.org/resource/SIO_000776") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an attribute is a characteristic of some entity." :lang "en")) (annotation (iri "http://semanticscience.org/resource/subset") (literal "core" :type :RDF_PLAIN_LITERAL)) (label (literal "attribute" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000617") :subclass (iri "http://semanticscience.org/resource/SIO_000289") (object-exactly 0 (iri "http://semanticscience.org/resource/SIO_000059") (iri "http://semanticscience.org/resource/SIO_000000")) :annotation (label (literal "empty set" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "An empty set is a set for which there are exactly 0 members." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000616") :subclass (iri "http://semanticscience.org/resource/SIO_000289") (object-some (iri "http://semanticscience.org/resource/SIO_000059") (iri "http://semanticscience.org/resource/SIO_000000")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A collection is a set for which there exists at least one member, although any member need not to exist at any point in the collection's existence." :lang "en")) (label (literal "collection" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010278") :subclass (iri "http://semanticscience.org/resource/SIO_000476") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Ploidy is the cellular quality relating to the amount of DNA contained in a cell." :lang "en")) (label (literal "ploidy" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010277") :subclass (iri "http://semanticscience.org/resource/SIO_010035") (object-some (iri "http://semanticscience.org/resource/SIO_000272") (iri "http://semanticscience.org/resource/SIO_010035")) :annotation (label (literal "allele" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an allele is one of a set of sequence variants of a gene." :lang "en")))
(annotation-property (iri "http://purl.org/dc/terms/license"))
(owl-class (iri "http://semanticscience.org/resource/SIO_000609") :subclass (iri "http://semanticscience.org/resource/SIO_000589") (object-some (iri "http://semanticscience.org/resource/SIO_001154") (iri "http://semanticscience.org/resource/SIO_000006")) :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_001135") (iri "http://semanticscience.org/resource/SIO_001136") (iri "http://semanticscience.org/resource/SIO_001139") (iri "http://semanticscience.org/resource/SIO_001145")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "regulation of a process is a process that modulates the duration, frequency, spatial extent of a target process." :lang "en")) (label (literal "regulation of process" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000608") :subclass (iri "http://semanticscience.org/resource/SIO_000506") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A curve is a geometric entity that may be located in n-dimensional spatial region whose extension may be n-dimensional,  is composed of at least two fully connected points and does not intersect itself." :lang "en")) (label (literal "curve" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000602") :subclass (iri "http://semanticscience.org/resource/SIO_000015") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a computational entity is an information content entity operated on using some computational system." :lang "en")) (label (literal "computational entity" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000600") :subclass (iri "http://semanticscience.org/resource/SIO_000315") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "structure is the specification that refers to the composition and arrangement of parts of an object." :lang "en")) (label (literal "structure" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000605") :subclass (iri "http://semanticscience.org/resource/SIO_000650") :annotation (label (literal "sound wave" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a sound wave is a mechanical wave that is an oscillation of pressure transmitted through a solid, liquid, or gas, composed of frequencies within the range of hearing." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000639") :subclass (iri "http://semanticscience.org/resource/SIO_000701") :annotation (label (literal "to passively interact with" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to passively interact with is the capability to interact with another entity in a way that does not require physical contact." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000638") :subclass (iri "http://semanticscience.org/resource/SIO_000257") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a probability measure is quantity of how likely it is that some event will occur." :lang "en")) (label (literal "probability measure" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001200") :subclass (iri "http://semanticscience.org/resource/SIO_001129") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A process that decreases the frequency, rate or extent of process involved in the destruction of a molecule as a result of decreased regulation." :lang "en")) (label (literal "decreased molecular degradation from decreased regulation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001201") :subclass (iri "http://semanticscience.org/resource/SIO_001129") :annotation (label (literal "increased molecular degradation from decreased regulation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A process that increases the frequency, rate or extent of process involved in the destruction of a molecule as a result of decreased regulation." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000620") :subclass (iri "http://semanticscience.org/resource/SIO_000010") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A collective is a group of entities that share or are motivated by at least one common issue or interest, or work together on a specific project(s) to achieve a common objective." :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "group" :type :RDF_PLAIN_LITERAL)) (label (literal "collective" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001202") :subclass (iri "http://semanticscience.org/resource/SIO_001129") (object-some (iri "http://semanticscience.org/resource/SIO_000217") (iri "http://semanticscience.org/resource/SIO_000640")) (object-some (iri "http://semanticscience.org/resource/SIO_001156") (object-or (iri "http://semanticscience.org/resource/SIO_000592") (object-some (iri "http://semanticscience.org/resource/SIO_000217") (iri "http://semanticscience.org/resource/SIO_000751")))) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A process that decreases the frequency, rate or extent of process involved in the destruction of a molecule as a result of increased regulation." :lang "en")) (label (literal "decreased molecular degradation from increased regulation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001203") :subclass (iri "http://semanticscience.org/resource/SIO_001128") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A process that increases the frequency, rate or extent of process involved in the production of a molecule as a result of increased regulation." :lang "en")) (label (literal "increased molecular production from increased regulation" :lang "en")))
(annotation-property (iri "http://www.w3.org/2002/07/owl#versionInfo"))
(owl-class (iri "http://semanticscience.org/resource/SIO_010673") :subclass (iri "http://semanticscience.org/resource/SIO_001196") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a medical history is a record of the events of a recipient of medical care." :lang "en")) (label (literal "medical history" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010674") :subclass (iri "http://semanticscience.org/resource/SIO_011126") (object-exactly 2 (iri "http://semanticscience.org/resource/SIO_000273") (iri "http://semanticscience.org/resource/SIO_011125")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a binary compound is a mereological maximum sum of two kinds of weakly connected entities." :lang "en")) (label (literal "binary compound" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001209") :subclass (iri "http://semanticscience.org/resource/SIO_000005") :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_001210") (iri "http://semanticscience.org/resource/SIO_001211")) :annotation (label (literal "assertional qualifier" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an assertional qualifier is the quality of affirmation, either being positive or negative." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001208") :subclass (iri "http://semanticscience.org/resource/SIO_000592") (object-some (iri "http://semanticscience.org/resource/SIO_000008") (object-or (iri "http://semanticscience.org/resource/SIO_000794") (object-some (iri "http://semanticscience.org/resource/SIO_000734") (object-or (iri "http://semanticscience.org/resource/SIO_000794") (object-some (iri "http://semanticscience.org/resource/SIO_000011") (iri "http://semanticscience.org/resource/SIO_000592")))))) (object-some (iri "http://semanticscience.org/resource/SIO_000217") (iri "http://semanticscience.org/resource/SIO_000640")) (object-some (iri "http://semanticscience.org/resource/SIO_000668") (iri "http://semanticscience.org/resource/SIO_000592")) :annotation (label (literal "decreased chemical destruction" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "decreased chemical destruction is a process in which there is a decrease in the amount of chemical destroyed relative to some reference process" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000626") :subclass (iri "http://semanticscience.org/resource/SIO_000625") :annotation (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "molecular geometry" :type :RDF_PLAIN_LITERAL)) (label (literal "molecular structure" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "Molecular structure is the spatial arrangement of atoms in a molecule and the chemical bonds that hold the atoms together." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000625") :subclass (iri "http://semanticscience.org/resource/SIO_000600") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "chemical structure is the structure of a chemical entity in terms of its molecular geometry and electronic structure." :lang "en")) (label (literal "chemical structure" :lang "en")))
(annotation-property (iri "http://purl.org/dc/terms/rights"))
(owl-class (iri "http://semanticscience.org/resource/SIO_001205") :subclass (iri "http://semanticscience.org/resource/SIO_001128") :annotation (label (literal "increased molecular production from decreased regulation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A process that increases the frequency, rate or extent of process involved in the production of a molecule as a result of decreased regulation." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000624") :subclass (iri "http://semanticscience.org/resource/SIO_010441") :annotation (label (literal "chemical functional group" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a chemical functional group is a covalently connected part of a molecule which normally confer specific chemical properties." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001204") :subclass (iri "http://semanticscience.org/resource/SIO_001128") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A process that decreases the frequency, rate or extent of process involved in the production of a molecule as a result of increased regulation." :lang "en")) (label (literal "decreased molecular production from increased regulation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000623") :subclass (iri "http://semanticscience.org/resource/SIO_000129") :annotation (label (literal "OBO ontology" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "an OBO ontology is an ontology document as specified by the Open Biological Ontology community." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001207") :subclass (iri "http://semanticscience.org/resource/SIO_000592") (object-some (iri "http://semanticscience.org/resource/SIO_000008") (object-or (iri "http://semanticscience.org/resource/SIO_000794") (object-some (iri "http://semanticscience.org/resource/SIO_000734") (object-or (iri "http://semanticscience.org/resource/SIO_000794") (object-some (iri "http://semanticscience.org/resource/SIO_000011") (iri "http://semanticscience.org/resource/SIO_000592")))))) (object-some (iri "http://semanticscience.org/resource/SIO_000217") (iri "http://semanticscience.org/resource/SIO_000640")) :annotation (label (literal "increased chemical destruction" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "increased chemical destruction is a process in which there is an increase in the amount of chemical destroyed relative to some reference process" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000622") :subclass (iri "http://semanticscience.org/resource/SIO_000129") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "An RDFS ontology is an ontology that conforms to the syntax and semantics of the Resource Description Framework Schema (RDFS)" :lang "en")) (label (literal "RDFS ontology" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001206") :subclass (iri "http://semanticscience.org/resource/SIO_001128") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A process that decreases the frequency, rate or extent of process involved in the production of a molecule as a result of decreased regulation." :lang "en")) (label (literal "decreased molecular production from decreased regulation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000621") :subclass (iri "http://semanticscience.org/resource/SIO_000315") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A formal specification is a mathematical description of software or hardware that may be used to develop an implementation." :lang "en")) (label (literal "formal specification" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001210") :subclass (iri "http://semanticscience.org/resource/SIO_001209") :disjoint (iri "http://semanticscience.org/resource/SIO_001211") :annotation (label (literal "positive" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "positive is an assertional qualifier that expresses the validity or truth of a basic assertion." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001214") :subclass (iri "http://semanticscience.org/resource/SIO_001212") :disjoint (iri "http://semanticscience.org/resource/SIO_001213") (iri "http://semanticscience.org/resource/SIO_001215") (iri "http://semanticscience.org/resource/SIO_001216") (iri "http://semanticscience.org/resource/SIO_001217") (iri "http://semanticscience.org/resource/SIO_001218") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "moderate is a qualitative intensity value that is more intense than mild, but less intense than strong." :lang "en")) (label (literal "moderate" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000651") :subclass (iri "http://semanticscience.org/resource/SIO_000079") :annotation (label (literal "textual entity" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A textual entity is language entity that is manifested as one or more distinct characters." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001213") :subclass (iri "http://semanticscience.org/resource/SIO_001212") :disjoint (iri "http://semanticscience.org/resource/SIO_001214") (iri "http://semanticscience.org/resource/SIO_001215") (iri "http://semanticscience.org/resource/SIO_001216") (iri "http://semanticscience.org/resource/SIO_001217") (iri "http://semanticscience.org/resource/SIO_001218") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "mild is a qualitative intensity value that is more intense than weak, but less intense than moderate." :lang "en")) (label (literal "mild" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000650") :subclass (iri "http://semanticscience.org/resource/SIO_010462") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A wave is a physical entity that travels through space and time, consist of oscillations or vibrations and may be accompanied by the transfer of energy." :lang "en")) (label (literal "wave" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001212") :subclass (iri "http://semanticscience.org/resource/SIO_000005") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "intensity is a quality that represents the strength or degree of something." :lang "en")) (label (literal "intensity" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000653") :subclass (iri "http://semanticscience.org/resource/SIO_000115") (object-some (iri "http://semanticscience.org/resource/SIO_000672") (object-some (iri "http://semanticscience.org/resource/SIO_000272") (iri "http://semanticscience.org/resource/SIO_000000"))) :annotation (label (literal "version label" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a version label is a label for a particular form or variation of an earlier or original type." :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_001211") :subclass (iri "http://semanticscience.org/resource/SIO_001209") :disjoint (iri "http://semanticscience.org/resource/SIO_001210") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "negative is an assertional qualifier that expresses the falsity or lack of truth of a basic assertion." :lang "en")) (label (literal "negative" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001217") :subclass (iri "http://semanticscience.org/resource/SIO_001212") :disjoint (iri "http://semanticscience.org/resource/SIO_001213") (iri "http://semanticscience.org/resource/SIO_001214") (iri "http://semanticscience.org/resource/SIO_001215") (iri "http://semanticscience.org/resource/SIO_001216") (iri "http://semanticscience.org/resource/SIO_001218") :annotation (label (literal "strong" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "strong is a qualitative intensity value that is more intense than moderate, but less intense than severe." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000654") :subclass (iri "http://semanticscience.org/resource/SIO_000653") (object-some (iri "http://semanticscience.org/resource/SIO_000672") (iri "http://semanticscience.org/resource/SIO_000097")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a software version label is a version label for a piece of software." :lang "en")) (label (literal "software version label" :lang "en")) (annotation (iri "http://semanticscience.org/resource/example") (literal "major.minor[.build[.revision]]" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001218") :subclass (iri "http://semanticscience.org/resource/SIO_001212") :disjoint (iri "http://semanticscience.org/resource/SIO_001213") (iri "http://semanticscience.org/resource/SIO_001214") (iri "http://semanticscience.org/resource/SIO_001215") (iri "http://semanticscience.org/resource/SIO_001216") (iri "http://semanticscience.org/resource/SIO_001217") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "weak is a qualitative intensity value that is more intense than none, but less intense than mild." :lang "en")) (label (literal "weak" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001215") :subclass (iri "http://semanticscience.org/resource/SIO_001212") :disjoint (iri "http://semanticscience.org/resource/SIO_001213") (iri "http://semanticscience.org/resource/SIO_001214") (iri "http://semanticscience.org/resource/SIO_001216") (iri "http://semanticscience.org/resource/SIO_001217") (iri "http://semanticscience.org/resource/SIO_001218") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "severe is a qualitative intensity value that is more intense than strong, but less intense than fatal." :lang "en")) (label (literal "severe" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001216") :subclass (iri "http://semanticscience.org/resource/SIO_001212") :disjoint (iri "http://semanticscience.org/resource/SIO_001213") (iri "http://semanticscience.org/resource/SIO_001214") (iri "http://semanticscience.org/resource/SIO_001215") (iri "http://semanticscience.org/resource/SIO_001217") (iri "http://semanticscience.org/resource/SIO_001218") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "fatal is a qualitative intensity value that is more intense than severe, leading to the death/non-functioning of a system." :lang "en")) (label (literal "fatal" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001219") :subclass (iri "http://semanticscience.org/resource/SIO_000724") :annotation (label (literal "to test a hypothesis" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to test a hypothesis is the capability to evaluate the truth value of a proposition based on gathered evidence." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001221") :subclass (iri "http://semanticscience.org/resource/SIO_000639") :annotation (label (literal "to describe" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "to describe is the capabilty to communicate facts about an entity." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001220") :subclass (iri "http://semanticscience.org/resource/SIO_001221") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to characterize is the capability to classify the attributes or features of an entity against a reference classification." :lang "en")) (label (literal "to characterize" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001223") :subclass (iri "http://semanticscience.org/resource/SIO_010451") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "the 3' splice site is the terminal region of an exon that is 3' to the intron that is to be excised." :lang "en")) (label (literal "3' splice site" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001222") :subclass (iri "http://semanticscience.org/resource/SIO_010451") :annotation (label (literal "5' splice site" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "the 5' splice site is the terminal region of an exon that is 5' to the intron that is to be excised." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001225") :subclass (iri "http://semanticscience.org/resource/SIO_010335") :annotation (label (literal "cis regulatory element" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A cisregulatory element is a DNA sequence located on the same DNA strand or chromosome as the gene whose expression it affects. " :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000640") :subclass (iri "http://semanticscience.org/resource/SIO_000555") :disjoint (iri "http://semanticscience.org/resource/SIO_000751") :annotation (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "PATO:0002300" :type :RDF_PLAIN_LITERAL)) (label (literal "increased" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A quality that has a value that is increased compared to normal or average." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001224") :subclass (iri "http://semanticscience.org/resource/SIO_010072") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an amino acid is an organic molecule composed of a carbon bonded to four different groups: a carboxyl group, an amino group, an R group, and a hydrogen atom. In the case of glycine, the R group is another hydrogen atom." :lang "en")) (label (literal "amino acid" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001226") :subclass (iri "http://semanticscience.org/resource/SIO_010335") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A trans-regulatory element is a DNA sequence associated with the regulation of a gene located outside the genomic region supporting the corresponding structural DNA region of the trans-regulatory element (i.e., a different DNA strand or different chromosome)." :lang "en")) (label (literal "trans-regulatory element" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001227") :subclass (iri "http://semanticscience.org/resource/SIO_000790") (object-some (iri "http://semanticscience.org/resource/SIO_010078") (iri "http://semanticscience.org/resource/SIO_001231")) :annotation (label (literal "small cytoplasmic RNA (scRNA) gene" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a small cytoplasmic RNA (scRNA) gene is a gene that encodes a small (7S; 129 nucleotides) RNA molecule found in the cytosol and rough endoplasmic reticulum that are normally associated with proteins that are involved in specific selection and transport of other proteins." :lang "en")) (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "http://purl.obolibrary.org/obo/SO_0001266" :type :XSD_ANY_URI)))
(owl-class (iri "http://semanticscience.org/resource/SIO_001228") :subclass (iri "http://semanticscience.org/resource/SIO_000790") (object-some (iri "http://semanticscience.org/resource/SIO_010078") (iri "http://semanticscience.org/resource/SIO_001233")) :annotation (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "http://purl.obolibrary.org/obo/SO_0001268" :type :XSD_ANY_URI)) (label (literal "small nuclear RNA (snRNA) gene" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a small nuclear RNA (snRNA) gene is a gene that encodes a small niuclear RNA molecule." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001229") :subclass (iri "http://semanticscience.org/resource/SIO_000790") (object-some (iri "http://semanticscience.org/resource/SIO_010078") (iri "http://semanticscience.org/resource/SIO_001234")) :annotation (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "http://purl.obolibrary.org/obo/SO_0001267" :type :XSD_ANY_URI)) (label (literal "small nucleolar RNA (snoRNA) gene" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A small nucleolar RNA (snoRNA) gene is a gene that encodes a small RNA that are associated with the eukaryotic nucleus as components of small nucleolar ribonucleoproteins." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000649") :subclass (iri "http://semanticscience.org/resource/SIO_000999") :annotation (label (literal "information processing" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "information processing is a process that involves the generation or use of information." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000647") :subclass (iri "http://semanticscience.org/resource/SIO_000510") (object-some (iri "http://semanticscience.org/resource/SIO_000632") (iri "http://semanticscience.org/resource/SIO_000006")) :disjoint (iri "http://semanticscience.org/resource/SIO_000648") :annotation (label (literal "process model" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a process model is a representation of some process." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000648") :subclass (iri "http://semanticscience.org/resource/SIO_000510") :disjoint (iri "http://semanticscience.org/resource/SIO_000647") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an object model is a representation of an object." :lang "en")) (label (literal "object model" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010288") :subclass (iri "http://semanticscience.org/resource/SIO_000611") (object-some (iri "http://semanticscience.org/resource/SIO_000355") (iri "http://semanticscience.org/resource/SIO_000499")) :disjoint (iri "http://semanticscience.org/resource/SIO_010289") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Biochemical activation is a molecular interaction that increases the catalytic rate of the target enzyme." :lang "en")) (label (literal "biochemical activation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001236") :subclass (iri "http://semanticscience.org/resource/SIO_000956") :annotation (label (literal "data collection device" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a data collection device is a device that collects information about one or more objects." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010289") :subclass (iri "http://semanticscience.org/resource/SIO_000611") (object-some (iri "http://semanticscience.org/resource/SIO_000355") (iri "http://semanticscience.org/resource/SIO_000550")) :disjoint (iri "http://semanticscience.org/resource/SIO_010288") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Biochemical inhibition is a molecular interaction that decreases the catalytic rate of the target enzyme." :lang "en")) (label (literal "biochemical inhibition" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001235") :subclass (iri "http://semanticscience.org/resource/SIO_010450") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a non-protein coding RNA (ncRNA) is a RNA molecular that cannot be used as a template for generating a protein product." :lang "en")) (label (literal "non-protein coding RNA (ncRNA)" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010286") :subclass (iri "http://semanticscience.org/resource/SIO_000592") (object-some (iri "http://semanticscience.org/resource/SIO_000291") (iri "http://semanticscience.org/resource/SIO_010506")) :annotation (label (literal "molecular complex dissociation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "molecular complex disassociation is the process of dissambly of a molecular complex into its constitutent parts." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001234") :subclass (iri "http://semanticscience.org/resource/SIO_001235") :annotation (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "snoRNA" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A small nucleolar RNA (snoRNA) is a small RNA that are associated with the eukaryotic nucleus as components of small nucleolar ribonucleoproteins." :lang "en")) (label (literal "small nucleolar RNA (snoRNA)" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000675") :subclass (iri "http://semanticscience.org/resource/SIO_000115") (object-some (iri "http://semanticscience.org/resource/SIO_000674") (iri "http://semanticscience.org/resource/SIO_000000")) :equivalent (object-or (iri "http://semanticscience.org/resource/SIO_000115") (object-some (iri "http://semanticscience.org/resource/SIO_000674") (iri "http://semanticscience.org/resource/SIO_000000"))) :annotation (label (literal "unique identifier" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a unique identifier is an identifier that uniquely identifies some thing." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001233") :subclass (iri "http://semanticscience.org/resource/SIO_001235") :annotation (label (literal "small nuclear RNA (snRNA)" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a small nuclear RNA (snRNA) is a small RNA molecule that is located in the nucleus of a cell." :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "snRNA" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010287") :subclass (iri "http://semanticscience.org/resource/SIO_000609") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "regulation of biochemical process is a process that changes the frequency, rate or extent of a target biochemical process." :lang "en")) (label (literal "regulation of biochemical process" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001232") :subclass (iri "http://semanticscience.org/resource/SIO_001235") :annotation (label (literal "transfer RNA (tRNA)" :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "tRNA" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A transfer RNA (tRNA) is an RNA molecule that aids in the translation of a messenger RNA (mRNA) to produce a protein product." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010284") :subclass (iri "http://semanticscience.org/resource/SIO_000576") :disjoint (iri "http://semanticscience.org/resource/SIO_000562") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Active transport is the movement of a substance across a membrane against its concentration gradient (from low to high concentration) and requires chemical energy." :lang "en")) (label (literal "active transport" :lang "en")) (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "biopax:TransportWithBiochemicalReaction" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_010285") :subclass (iri "http://semanticscience.org/resource/SIO_000559") (object-some (iri "http://semanticscience.org/resource/SIO_000312") (iri "http://semanticscience.org/resource/SIO_010506")) :annotation (label (literal "molecular complex formation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "molecular complex formation is the process of forming a molecular complex from its constituent parts." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001231") :subclass (iri "http://semanticscience.org/resource/SIO_001235") (object-some (iri "http://semanticscience.org/resource/SIO_010079") (iri "http://semanticscience.org/resource/SIO_001227")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a small cytoplasmic RNA (scRNA) molecule is a small (7S; 129 nucleotides) RNA molecule found in the cytosol and rough endoplasmic reticulum that are normally associated with proteins that are involved in specific selection and transport of other proteins." :lang "en")) (label (literal "small cytoplasmic RNA (scRNA)" :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "scRNA" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001230") :subclass (iri "http://semanticscience.org/resource/SIO_000790") (object-some (iri "http://semanticscience.org/resource/SIO_010078") (iri "http://semanticscience.org/resource/SIO_001232")) :annotation (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "tRNA gene" :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "solube RNA (sRNA) gene" :lang "en")) (label (literal "transfer RNA (tRNA) gene" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A transfer RNA (tRNA) gene is a gene that codes for a tRNA used in the translation of a messenger RNA (mRNA) to produce a protein product." :lang "en")) (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "http://purl.obolibrary.org/obo/SO_0001272" :type :XSD_ANY_URI)))
(owl-class (iri "http://semanticscience.org/resource/SIO_010283") :subclass (iri "http://semanticscience.org/resource/SIO_000575") (object-some (iri "http://semanticscience.org/resource/SIO_000132") (iri "http://semanticscience.org/resource/SIO_010004")) :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "Chemical transport is the directed movement of a chemical entity by some agent (e.g. transporter)." :lang "en")) (label (literal "chemical transport" :lang "en")) (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "biopax:Transport" :type :RDF_PLAIN_LITERAL)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000670") :subclass (iri "http://semanticscience.org/resource/SIO_000418") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a end time is a time instant pertaining to the time at which a process ends." :lang "en")) (label (literal "end time" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001239") :subclass (iri "http://semanticscience.org/resource/SIO_000408") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "to identify is the capability to determine the identity of something." :lang "en")) (label (literal "to identify" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000676") :subclass (iri "http://semanticscience.org/resource/SIO_000016") :annotation (label (literal "social role" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a social role is a role that is ascribed to individuals in a community." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000677") :subclass (iri "http://semanticscience.org/resource/SIO_000016") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a processual role is a role that can only be realized in a process." :lang "en")) (label (literal "processual role" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001237") :subclass (iri "http://semanticscience.org/resource/SIO_001236") :annotation (annotation (iri "http://semanticscience.org/resource/similarTo") (literal "http://purl.obolibrary.org/obo/OBI_0000049" :type :XSD_ANY_URI)) (label (literal "mass spectrometer" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a mass spectrometer is a device that identifies ions based on their mass to charge ratio using an electromagnetic field." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000678") :subclass (iri "http://semanticscience.org/resource/SIO_000016") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "an abstract role is a role whose basis lies in spatial/temporal or comparative relations. " :lang "en")) (label (literal "abstract role" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001238") :subclass (iri "http://semanticscience.org/resource/SIO_001236") :annotation (label (literal "microarray device" :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "microarray platform" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a microarray device is a device that identifies the binding of a target substance to a physically immobile substrate placed in an array or lattice." :lang "en")) (annotation (iri "http://semanticscience.org/resource/similarTo") (literal "http://purl.obolibrary.org/obo/OBI_0000052" :type :XSD_ANY_URI)))
(owl-class (iri "http://semanticscience.org/resource/SIO_000664") :subclass (iri "http://semanticscience.org/resource/SIO_000415") :annotation (label (literal "country" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A country is a region legally identified as a distinct entity in political geography. " :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010298") :subclass (iri "http://semanticscience.org/resource/SIO_010019") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "medical data is data of interest to medicine." :lang "en")) (label (literal "medical data" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000663") :subclass (iri "http://semanticscience.org/resource/SIO_000415") :annotation (label (literal "territory" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a territory is a non-sovereign geographic region." :lang "en")))
(annotation-property (iri "http://www.w3.org/2000/01/rdf-schema#label"))
(owl-class (iri "http://semanticscience.org/resource/SIO_010299") :subclass (iri "http://semanticscience.org/resource/SIO_000475") (object-some (iri "http://semanticscience.org/resource/SIO_000218") (object-or (iri "http://semanticscience.org/resource/SIO_000004") (object-some (iri "http://semanticscience.org/resource/SIO_000217") (iri "http://semanticscience.org/resource/SIO_000555")))) :disjoint (iri "http://semanticscience.org/resource/SIO_000476") (iri "http://semanticscience.org/resource/SIO_001014") (iri "http://semanticscience.org/resource/SIO_001015") (iri "http://semanticscience.org/resource/SIO_010029") (iri "http://semanticscience.org/resource/SIO_010056") (iri "http://semanticscience.org/resource/SIO_010057") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "disease is the outward manifestation of one or more disorders." :lang "en")) (label (literal "disease" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000662") :subclass (iri "http://semanticscience.org/resource/SIO_000415") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a state is a set of governing and supportive institutions that have sovereignty over a definite territory and population." :lang "en")) (label (literal "state" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000661") :subclass (iri "http://semanticscience.org/resource/SIO_000415") (object-some (iri "http://semanticscience.org/resource/SIO_000093") (iri "http://semanticscience.org/resource/SIO_000664")) :annotation (label (literal "province" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "A province is a territorial unit, almost always an administrative division, within a country or state." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000660") :subclass (iri "http://semanticscience.org/resource/SIO_000019") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a hole is a site that is opening into or through something." :lang "en")) (label (literal "hole" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_001240") :subclass (iri "http://semanticscience.org/resource/SIO_001236") :annotation (annotation (iri "http://semanticscience.org/resource/equivalentTo") (literal "http://purl.obolibrary.org/obo/OBI_0000566" :type :XSD_ANY_URI)) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "nuclear magnetic resonance device" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a nuclear magnetic resonance (NMR) device is a device that applies a magnetic field to perturb nuclei with an odd number of protons and/or of neutrons in order to hav them absort and re-emit electromagnetic radiation. " :lang "en")) (label (literal "nmr device" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010295") :subclass (iri "http://semanticscience.org/resource/SIO_000609") :disjoint (iri "http://semanticscience.org/resource/SIO_010296") :annotation (label (literal "process up-regulation" :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "positive regulation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "process up-regulation is a process that increases the frequency, rate or extent of one or more processes in relation to a reference state." :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_010296") :subclass (iri "http://semanticscience.org/resource/SIO_000609") :disjoint (iri "http://semanticscience.org/resource/SIO_010295") :annotation (label (literal "process down-regulation" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "process down-regulation is a process that decreases the frequency, rate or extent of one or more processes in relation to a reference state." :lang "en")) (annotation (iri "http://semanticscience.org/resource/hasSynonym") (literal "negative regulation" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000669") :subclass (iri "http://semanticscience.org/resource/SIO_000418") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "a start time is a time instant pertaining to the time at which a process begins." :lang "en")) (label (literal "start time" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000667") :subclass (iri "http://semanticscience.org/resource/SIO_000649") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "software execution is the process of executing software on a computing device." :lang "en")) (label (literal "sofware execution" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000665") :subclass (iri "http://semanticscience.org/resource/SIO_000415") :annotation (annotation (iri "http://purl.org/dc/terms/description") (literal "A city is a relatively large and permanent settlement." :lang "en")) (label (literal "city" :lang "en")))
(owl-class (iri "http://semanticscience.org/resource/SIO_000666") :subclass (iri "http://semanticscience.org/resource/SIO_000415") :annotation (label (literal "township" :lang "en")) (annotation (iri "http://purl.org/dc/terms/description") (literal "a township is a rural or sub-urban settlement." :lang "en")))
