(ns tawny.temp4
  (:use [tawny.owl])
  (:require [tawny.reasoner :as r])
  )

(r/reasoner-factory :hermit)
(defontology ind)

(defclass X)
(defoproperty r)

(defclass A :equivalent (owlsome r X))

(defclass B :equivalent (only r X))

(defindividual iX :type X)

(defclass C :equivalent (hasvalue r iX))


(defindividual i
  :fact (fact r iX))

;; i is an A
(r/instances A)
;; not a b - because of open world
(r/instances B)
;; not sure why it's not a C
(r/instances C)


(defindividual iM)

(defindividual iN
  :type B
  :fact (fact r iM))

;; iX is an instance because we said it is directly while iM is because iN is
;; of type B, so the only relationship enforces it.
(r/instances X)
