(println)
(println)
(println "Start")

(def
  ^{:dynamic true}
  cache nil)


(defn calc-cache []
  (println "calc cache")
  true)

(defn call-with-cache []
  (println "cache:" cache)
  (binding [cache (or cache
                      (calc-cache))]
    (println "call-with-cache")))


(println "First call")
(call-with-cache)

(println "Second call")
(binding [cache true]
  (call-with-cache))

(println "third call")
(binding [cache (calc-cache)]
  (println "inside first binding")
  (binding [cache (or cache (calc-cache))]
    (println "inside second binding")))



(defmacro remap [f c]
  `(map ~f ~c))

(defmacro remap2 [f c]
  (list 'map f c))

(remap identity (range 1 10))
(remap2 identity (range 1 10))

(defmacro remap3 [f & c]
  `(map ~f ~@c))

(defmacro remap4 [f & c]
  (list* 'map f c))

(let [map (fn [f & c]
            (println "evil")
            (apply f c))]
  (remap3 identity (range 1 10)))

(remap3 identity (range 1 10))
(remap4 identity (range 1 10))

(let [map (fn [f & c]
            (println "evil")
            (apply f c))]
  (remap4 identity (range 1 10)))



(let [o 'Object]
  (class o)
  (class (eval o)))

(let [o `Object]
  (println o)
  (class o)
  (class (eval o)))
