(ns tawny.temp
  (:use [tawny.owl]))



(defn x
  "Doc is here"
  []
  )

(reset-meta! #'x 
             (assoc (meta #'x)
               :doc "Is not"
               ))

(defn temp [n]
  (println n))



(alter-var-root
 (var temp)
 (fn [f]
   (fn [& arg]
     (if (seq arg)
       (apply f arg)
       (f "default string")))))

;;(temp)
;;(temp "no default string")

(defmacro defnn [name & body]
  `(alter-var-root
    (defn ~name ~@body)
    (fn [f#]
      (fn [& args#]
        (if (string? (first args#))
          (apply f# args#)
          (apply f# "hello" args#))))))

(defnn testdefnn
  [string number]
  (println "string:" string
           "number:" number))

;;(testdefnn 1)
;;(testdefnn "goodbye" 2)

(defmacro defnwithfn [name function & body]
  `(alter-var-root
    (defn ~name ~@body)
    (fn [f#]
      (fn [& args#]
        (apply ~function f# args#)))))


(defn defaultstring
  [f & args]
  (if (string? (first args))
    (apply f args)
    (apply f "default" args)))

(defnwithfn testdefn2n #'defaultstring
  [string number]
  (println "string:" string
           "number:" number))


(testdefn2n 1)
(testdefn2n "goodbye" 2)

(defmacro defwithdefaultstring [name & body]
  `(defnwithfn ~name #'defaultstring
     ~@body))


(defwithdefaultstring testdefn3n
  [string number]
  (println "string:" string
           "number:" number))

(testdefn3n 1)
(testdefn3n "nodefault" 2)



(defmacro deftransform
  "Generate a form like 'defn', but which applies the 'transform' function
automatically. transform takes the defined function as a first argument, and
then all the rest. transform must itself call the defined function."
  [name transform]
  (let [mname (gensym "mname")
        body (gensym "body")]
    `(defmacro ~name [~mname & ~body]
       '`
       (defnwithfn ~name ~transform ~body))))

(deftransform defwithanotherdefaultstring #'defaultstring)

(defwithanotherdefaultstring testdefn5n
  [string number]
  (println "string:" string)
  (println "number:" number))


(defmacro defnwithfn [name function & body]
  `(let [vr# (defn ~name ~@body)]
     (alter-var-root
      vr#
      (fn [f#]
        (fn [& args#]
          (apply ~function f# args#))))
     vr#))


(defnwithfn hello #(apply %1 %&)
  [x]
  x)

(hello 10)



(def f
  (fn [x]
    (throw (Exception.))))

(f 10)
