(ns tawny.temp
  (:use [tawny.owl]))

(defontology temp
  :iri "http://iri")

(defclass A)

(as-disjoint-subclasses
 A
 (defclass B)
 )

(clojure.walk/macroexpand-all
 '
 (as-disjoint-subclasses
  B
  (defclass C)
  (as-disjoint-subclasses
   C
   (defclass D)
   )
  ))

(defclass E)
(macroexpand '(defclass F))


(macroexpand
 '(as-disjoint-subclasses
   B
   (defclass C)))


(defmacro hello
  [& body]
  `(def ~(first body) ~(second body)))

(defmacro hello2
  [& body]
  `(intern *ns*
           (quote ~(first body))
           ~(second body)))

(macroexpand '(hello x 1))
(macroexpand '(hello2 y 1))

(defmacro nothing
  [& body]
  `(do ~@body)
  )

(hello x 1)
(hello2 y 2)

(nothing
 (println "hello"))

(nothing
 (hello x 1)
 x)

(nothing
 (hello2 z 2)
 z
 )


(nothing
 (hello2 a 3)
 a)

(defn test1 []
  (def x 1)
  x)

(test1)

(defn test2 []
  (declare y)
  (intern *ns* "y" 2)
  y)

(test2)

(defn test3 []
  (intern *ns* (symbol "z") 3)
  z)

(defn test4 []
  (intern *ns* (symbol "xx") 4)
  (defonce xx 1)
  xx
  )
(test4)

(macroexpand '(is (= 3 (o/defclass a))))


(defmacro defthing
  [name val]
  (let [valn# (identity val)]
    `(def
       ~(vary-meta
         name
         merge
         {:owl true
          :val valn#})
       ~valn#)
     ))

(macroexpand '(defthing a 1))
(defthing a 1)
(meta (var a))


(macroexpand '(defthing a (Object.)))

(meta (var a))

(defmacro defthing2
  [name val]
  (let [valn# (identity val)]
    `(do
       (def
         ~(vary-meta
           name
           merge
           {:owl true
            :val valn#})
         ~valn#))
     ))

(defthing2 b (Object.))
(meta (var b)) {:ns #<Namespace user>, :name b, :file "NO_SOURCE_PATH", :column 1, :line 1, :val #<Object java.lang.Object@6a712a2e>, :owl true}
b #<Object java.lang.Object@f3c3750>

(defthing2 c (Object.))
c #<Object java.lang.Object@108d02eb>
(meta (var c))


(defthing d (Object.))
d#<Object java.lang.Object@160d227f>
(= (:val  (meta (var d)))
   d
   )
