(ns owl.test
  (:import (java.io File)
           (java.net URL)
           (org.semanticweb.owlapi.model IRI OWLNamedObject))
  (:use [owl.owl])
  (:require
   [owl.reasoner]
   [owl.read]
   [owl.render :as render]
   [clojure.string]
   [clojure.pprint]))


(def obi
  (owl.read/read
   ;; something that the OWL API can interpret. This includes a stream, so
   ;; it's totally generic. clojure.java.io/resource returns a URL. 
   (IRI/create (clojure.java.io/resource "obi.owl"))
   ;; the prefix that you want to use in this case
   :prefix "obo"
   ;; normally only things from this IRI will be imported
   :iri "http://purl.obolibrary.org/obo/obi.owl"
   :version-iri "http://purl.obolibrary.org/obo/obi/2012-07-01/obi.owl"
   ;; but OBO ontologies are wierd, so pass in a filter function
   :filter
   (fn [e]
     (and (instance? OWLNamedObject e)
          (.startsWith
           (.toString (.getIRI e))
           "http://purl.obolibrary.org/obo/IAO"
           ))
     )
   :transform
   ;; fix the space problem
   (fn [e]
     (clojure.string/replace
      ;; with luck these will always be literals, so we can do this
      ;; although not true in general
      (.getLiteral 
       ;; get the value of the annotation
       (.getValue
        (first
         ;; filter for annotations which are labels
         ;; is lazy, so doesn't eval all
         (filter
          #(.. % (getProperty) (isLabel))
          ;; get the annotations
          (.getAnnotations e
                           (get-current-jontology))))))
            #" " "_"
            ))
   
   ))

;;(owl.reasoner/reasoner-factory :hermit)
;;(owl.reasoner/reasoner-factory :elk)

;; (owl.reasoner/consistent?)

;; (owl.reasoner/coherent?)


;; (defclass a
;;   :subclass length_measurement_datum)




