

(ns owl.test
  (:use [owl.owl])
  (:require [owl.render :as render]
            [clojure.pprint]))


(defontology testontology
  :file "test.omn"
  :iri "http://iri/"
  :prefix "tst:"
  )



(clojure.pprint/pprint
 '(defclass a
    :subclass b
    (owlsome hasPart b)
    :equivalent c
    (owlor hasPart c)
    ))


(defclass a)
(defclass b :subclass a)
(defoproperty hasPart)
(defclass d
  :equivalent "h"
  :subclass a
  (owlsome hasPart b)
  (owlor a (owlsome hasPart b)))

(defclass e)
(disjointclasses d e)

(defclass f
  :subclass
  (exactly 2 hasPart b))


(render/text  (.getDisjointClasses (:entity  d) (get-current-jontology)))

(str (.getFragment (.getIRI (:entity  d))))

(println "Final Printout:\n" (render/as-text d))

(clojure.pprint/pprint (render/as-form f))
(clojure.pprint/pprint (render/as-form d))
(clojure.pprint/pprint (render/as-form b))


;; get all public stuff
(ns-publics 'owl.owl)


(var-get #'owl.test2/test2d)

;; so how to turn this backward map-invert in clojure.set
;; this one applies a func to every val
;; we should be able to get the comprehension to test whether the val is a OWLClass or whatever also.
(defn fmap [m f]
  (into {} (for [[k v] m] [k (f v)])))


(foo {:a 1 :b 2} #(+ 1 %))

;; returns a map with symbols to variables
(apply merge
       (map
        (fn [x]
          (ns-publics x))
        (keys @owl.owl/ontology-for-namespace)))

(map
 (fn [x]
   (ns-publics x))
 (keys @owl.owl/ontology-for-namespace))




({test2d #'owl.test2/test2d, test2b #'owl.test2/test2b, test2c #'owl.test2/test2c, test2a #'owl.test2/test2a, testontology2 #'owl.test2/testontology2} {e #'owl.test/e, d #'owl.test/d, f #'owl.test/f, b #'owl.test/b, testontology #'owl.test/testontology, a #'owl.test/a, hasPart #'owl.test/hasPart})


{e #'owl.test/e, d #'owl.test/d, f #'owl.test/f, b #'owl.test/b, testontology #'owl.test/testontology, a #'owl.test/a, hasPart #'owl.test/hasPart}

