

(ns owl.test
  (:use [owl.owl])
  (:require [owl.render :as render]
            [clojure.pprint]))


(defontology testontology
  :file "test.omn"
  :iri "http://iri/"
  :prefix "tst:"
  )



(clojure.pprint/pprint
 '(defclass a
    :subclass b
    (owlsome hasPart b)
    :equivalent c
    (owlor hasPart c)
    ))


(defclass a)
(defclass b :subclass a)
(defoproperty hasPart)
(defclass d
  :equivalent "h"
  :subclass a
  (owlsome hasPart b)
  (owlor a (owlsome hasPart b)))

(defclass e)
(disjointclasses d e)

(defclass f
  :subclass
  (exactly 2 hasPart b))


(render/text  (.getDisjointClasses (:entity  d) (get-current-jontology)))

(str (.getFragment (.getIRI (:entity  d))))

(println "Final Printout:\n" (render/as-text d))

(clojure.pprint/pprint (render/as-form f))
(clojure.pprint/pprint (render/as-form d))
(clojure.pprint/pprint (render/as-form b))


(apply list '( 1 2 3))

(list '( 1 2 3))