(ns uk.me.rkd.heap)

(defn rank [heap]
  (if (empty? heap)
    0
    (first heap)))

(defn makeT [x a b]
  (if (>= (rank a) (rank b))
    [(inc (rank b)) x a b]
    [(inc (rank a)) x b a]))


(defn newheap [x]
  (makeT x [] []))


(defn merge [[_ x a1 b1 :as heap1] [_ y a2 b2 :as heap2]]
  (cond
   (empty? heap1) heap2
   (empty? heap2) heap1
   (<= x y) (makeT x a1 (merge b1 heap2))
   :else (makeT y a2 (merge heap1 b2))))

(defn insert [val heap]
  (merge (newheap val) heap))

(defn findMin [[_ x _ _ :as heap]]
  x)

(defn deleteMin [[_ x a b :as heap]]
  (merge a b))
