/*
 * Decompiled with CFR 0.152.
 */
package incanter;

import cern.jet.random.tdouble.AbstractContinousDoubleDistribution;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;

public class Weibull
extends AbstractContinousDoubleDistribution {
    protected double scale;
    protected double shape;
    protected static Weibull shared = new Weibull(1.0, 1.5, Weibull.makeDefaultGenerator());

    public Weibull(double a, double b, DoubleRandomEngine randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.scale = a;
        this.shape = b;
    }

    public double cdf(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return 1.0 - Math.exp(-Math.pow(x / this.scale, this.shape));
    }

    public double nextDouble() {
        return this.scale * Math.pow(-Math.log(1.0 - this.randomGenerator.raw()), 1.0 / this.shape);
    }

    public double nextDouble(double a, double b) {
        return a * Math.pow(-Math.log(1.0 - this.randomGenerator.raw()), 1.0 / b);
    }

    public double pdf(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return this.shape / this.scale * Math.pow(x / this.scale, this.shape - 1.0) * Math.exp(-Math.pow(x / this.scale, this.shape));
    }

    public void setState(double a, double b) {
        this.scale = a;
        this.shape = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double a, double b) {
        Weibull weibull = shared;
        synchronized (weibull) {
            return shared.nextDouble(a, b);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "(" + this.scale + ", " + this.shape + ")";
    }
}

