/*
 * Decompiled with CFR 0.152.
 */
package uk.co.forward.clojure.incanter;

import incanter.Matrix;
import org.jblas.DoubleMatrix;
import org.jblas.MatrixFunctions;
import uk.co.forward.clojure.incanter.DoubleDoubleFunction;
import uk.co.forward.clojure.incanter.DoubleFunction;
import uk.co.forward.clojure.incanter.ScalarFunction;
import uk.co.forward.clojure.incanter.ScalarScalarFunction;

public class DoubleFunctions {
    public static DoubleFunction abs() {
        return new DoubleFunction(){

            public DoubleMatrix apply(DoubleMatrix argument) {
                return MatrixFunctions.absi((DoubleMatrix)argument);
            }
        };
    }

    public static DoubleFunction acos() {
        return new DoubleFunction(){

            public DoubleMatrix apply(DoubleMatrix argument) {
                return MatrixFunctions.acosi((DoubleMatrix)argument);
            }
        };
    }

    public static DoubleFunction asin() {
        return new DoubleFunction(){

            public DoubleMatrix apply(DoubleMatrix argument) {
                return MatrixFunctions.asini((DoubleMatrix)argument);
            }
        };
    }

    public static DoubleFunction atan() {
        return new DoubleFunction(){

            public DoubleMatrix apply(DoubleMatrix argument) {
                return MatrixFunctions.atani((DoubleMatrix)argument);
            }
        };
    }

    public static DoubleDoubleFunction atan2() {
        return new DoubleDoubleFunction(){

            public DoubleMatrix apply(DoubleMatrix x, DoubleMatrix y) {
                ScalarScalarFunction atan22 = new ScalarScalarFunction(){

                    public double apply(double x, double y) {
                        return Math.atan2(x, y);
                    }
                };
                Matrix.applyi(x, y, atan22);
                return x;
            }
        };
    }

    public static DoubleDoubleFunction compare() {
        return new DoubleDoubleFunction(){

            public DoubleMatrix apply(DoubleMatrix x, DoubleMatrix y) {
                ScalarScalarFunction compare = new ScalarScalarFunction(){

                    public double apply(double x, double y) {
                        if (x < y) {
                            return 1.0;
                        }
                        if (x > y) {
                            return -1.0;
                        }
                        return 0.0;
                    }
                };
                Matrix.applyi(x, y, compare);
                return x;
            }
        };
    }

    public static DoubleFunction ceil() {
        return new DoubleFunction(){

            public DoubleMatrix apply(DoubleMatrix argument) {
                double y = 0.0;
                ScalarFunction ceil = new ScalarFunction(){

                    public double apply(double x) {
                        return Math.ceil(x);
                    }
                };
                Matrix.applyi(argument, ceil);
                return argument;
            }
        };
    }

    public static DoubleFunction cos() {
        return new DoubleFunction(){

            public DoubleMatrix apply(DoubleMatrix argument) {
                return MatrixFunctions.cosi((DoubleMatrix)argument);
            }
        };
    }

    public static DoubleFunction sin() {
        return new DoubleFunction(){

            public DoubleMatrix apply(DoubleMatrix argument) {
                return MatrixFunctions.sini((DoubleMatrix)argument);
            }
        };
    }

    public static DoubleFunction tan() {
        return new DoubleFunction(){

            public DoubleMatrix apply(DoubleMatrix argument) {
                return MatrixFunctions.tani((DoubleMatrix)argument);
            }
        };
    }

    public static DoubleDoubleFunction div() {
        return new DoubleDoubleFunction(){

            public DoubleMatrix apply(DoubleMatrix argument, DoubleMatrix y) {
                return argument.divi(y);
            }
        };
    }

    public static DoubleDoubleFunction plus() {
        return new DoubleDoubleFunction(){

            public DoubleMatrix apply(DoubleMatrix argument, DoubleMatrix y) {
                argument = argument.addi(y);
                return argument;
            }
        };
    }

    public static DoubleDoubleFunction minus() {
        return new DoubleDoubleFunction(){

            public DoubleMatrix apply(DoubleMatrix argument, DoubleMatrix y) {
                return argument.subi(y);
            }
        };
    }

    public static DoubleDoubleFunction mult() {
        return new DoubleDoubleFunction(){

            public DoubleMatrix apply(DoubleMatrix argument, DoubleMatrix y) {
                return argument.muli(y);
            }
        };
    }

    public static DoubleDoubleFunction pow() {
        return new DoubleDoubleFunction(){

            public DoubleMatrix apply(DoubleMatrix argument, DoubleMatrix y) {
                return MatrixFunctions.powi((DoubleMatrix)argument, (DoubleMatrix)y);
            }
        };
    }

    public static DoubleFunction sqrt() {
        return new DoubleFunction(){

            public DoubleMatrix apply(DoubleMatrix argument) {
                return MatrixFunctions.sqrti((DoubleMatrix)argument);
            }
        };
    }

    public static DoubleFunction log() {
        return new DoubleFunction(){

            public DoubleMatrix apply(DoubleMatrix argument) {
                return MatrixFunctions.logi((DoubleMatrix)argument);
            }
        };
    }

    public static DoubleFunction log2() {
        return new DoubleFunction(){

            public DoubleMatrix apply(DoubleMatrix argument) {
                double y = 0.0;
                ScalarFunction ceil = new ScalarFunction(){

                    public double apply(double x) {
                        return Math.log(x) / Math.log(2.0);
                    }
                };
                Matrix.applyi(argument, ceil);
                return argument;
            }
        };
    }

    public static DoubleFunction log10() {
        return new DoubleFunction(){

            public DoubleMatrix apply(DoubleMatrix argument) {
                return MatrixFunctions.log10i((DoubleMatrix)argument);
            }
        };
    }

    public static DoubleFunction exp() {
        return new DoubleFunction(){

            public DoubleMatrix apply(DoubleMatrix argument) {
                return MatrixFunctions.expi((DoubleMatrix)argument);
            }
        };
    }
}

