/*
 * Decompiled with CFR 0.152.
 */
package incanter;

import clojure.lang.Counted;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.Seqable;
import clojure.lang.Sequential;
import java.util.Iterator;
import org.jblas.Decompose;
import org.jblas.DoubleMatrix;
import org.jblas.Eigen;
import org.jblas.Singular;
import org.jblas.Solve;
import uk.co.forward.clojure.incanter.DoubleDoubleFunction;
import uk.co.forward.clojure.incanter.DoubleFunction;
import uk.co.forward.clojure.incanter.ScalarFunction;
import uk.co.forward.clojure.incanter.ScalarScalarFunction;

public class Matrix
implements Sequential,
ISeq,
Counted,
IObj {
    public boolean oneDimensional = false;
    IPersistentMap meta;
    protected DoubleMatrix matrix;

    public Matrix(Matrix wrapper) {
        this(wrapper.matrix);
    }

    public Matrix(int nrow2, int ncol2) {
        this(nrow2, ncol2, (Number)0);
    }

    public Matrix(int nrow2, int ncol2, Number initValue) {
        this.matrix = new DoubleMatrix(nrow2, ncol2);
        this.meta = null;
        for (int i = 0; i < nrow2; ++i) {
            for (int j = 0; j < ncol2; ++j) {
                this.matrix.put(i, j, initValue.doubleValue());
            }
        }
        if (this.matrix.rows == 1 || this.matrix.columns == 1) {
            this.oneDimensional = true;
        }
    }

    public Matrix(double[] data) {
        this.matrix = new DoubleMatrix(data);
        this.oneDimensional = true;
    }

    public Matrix(double[] data, int ncol2) {
        this.matrix = new DoubleMatrix(data.length / ncol2, ncol2);
        this.meta = null;
        if (this.matrix.rows == 1 || this.matrix.columns == 1) {
            this.oneDimensional = true;
        }
        for (int i = 0; i < this.matrix.rows; ++i) {
            for (int j = 0; j < this.matrix.columns; ++j) {
                this.matrix.put(i, j, data[i * ncol2 + j]);
            }
        }
    }

    public Matrix(double[][] data) {
        this.matrix = new DoubleMatrix(data);
        this.meta = null;
        if (this.matrix.rows == 1 || this.matrix.columns == 1) {
            this.oneDimensional = true;
        }
    }

    public Matrix(IPersistentMap meta, double[][] data) {
        this(data);
        this.meta = meta;
    }

    public Matrix(DoubleMatrix mat) {
        this(mat.rows, mat.columns);
        this.assign(mat);
    }

    public Matrix(int rows, int columns, double[] elements, boolean oneDimensional) {
        this(rows, columns);
        int inserted = 0;
        for (int i = 0; i < this.matrix.columns; ++i) {
            for (int j = 0; j < this.matrix.rows && inserted < elements.length; ++inserted, ++j) {
                this.matrix.put(i, j, this.matrix.data[i * this.matrix.rows + j]);
            }
            if (inserted == elements.length) break;
        }
        this.meta = null;
        this.oneDimensional = oneDimensional;
    }

    public Matrix(Seqable coll, int rows, int columns) {
        this(rows, columns);
        this.meta = null;
        ISeq seq = coll.seq();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                this.matrix.put(i, j, ((Number)seq.first()).doubleValue());
                seq = seq.next();
            }
        }
        if (rows == 1 && columns == 1) {
            this.oneDimensional = true;
        }
    }

    public int rows() {
        return this.matrix.rows;
    }

    public int columns() {
        return this.matrix.columns;
    }

    public void assign(DoubleMatrix matrix2) {
        this.matrix = matrix2.dup();
        if (matrix2.columns == 1 || matrix2.rows == 1) {
            this.oneDimensional = true;
        }
    }

    public Matrix assign(DoubleFunction f) {
        this.matrix = f.apply(this.matrix);
        return this;
    }

    public Matrix assign(Matrix matrix2, DoubleDoubleFunction f) {
        f.apply(this.matrix, matrix2.matrix);
        return this;
    }

    public Matrix mmul(Matrix m) {
        return Matrix.wrap(this.matrix.mmul(m.matrix));
    }

    public DoubleMatrix apply(ScalarFunction f) {
        DoubleMatrix transformed = DoubleMatrix.zeros((int)this.matrix.rows, (int)this.matrix.columns);
        Matrix.applyi(transformed, f);
        return transformed;
    }

    public static void applyi(DoubleMatrix transformed, ScalarFunction f) {
        for (int i = 0; i < transformed.rows; ++i) {
            for (int j = 0; j < transformed.columns; ++j) {
                double val = transformed.get(i, j);
                double result = f.apply(val);
                transformed.put(i, j, result);
            }
        }
    }

    public static void applyi(DoubleMatrix x, DoubleMatrix y, ScalarScalarFunction f) {
        for (int i = 0; i < x.rows; ++i) {
            for (int j = 0; j < x.columns; ++j) {
                double valx = x.get(i, j);
                double valy = y.get(i, j);
                double result = f.apply(valx, valy);
                x.put(i, j, result);
            }
        }
    }

    public DoubleMatrix wrapped() {
        return this.matrix;
    }

    public Matrix copy() {
        return Matrix.wrap(this.matrix);
    }

    public Matrix transpose() {
        return Matrix.wrap(this.matrix.transpose());
    }

    public Matrix viewSelection(int[] rows, int[] columns) {
        Matrix mat = new Matrix(this.matrix.get(rows, columns));
        if (rows.length == 1 || columns.length == 1) {
            mat.oneDimensional = true;
        }
        return mat;
    }

    public Matrix like(int rows, int columns) {
        return new Matrix(rows, columns);
    }

    public static Matrix wrap(Object otherMatrix) {
        if (otherMatrix instanceof Matrix) {
            return (Matrix)otherMatrix;
        }
        if (otherMatrix instanceof DoubleMatrix) {
            Matrix wrapper = new Matrix(0, 0);
            wrapper.matrix = ((DoubleMatrix)otherMatrix).dup();
            if (wrapper.matrix.columns == 1 || wrapper.matrix.rows == 1) {
                wrapper.oneDimensional = true;
            }
            return wrapper;
        }
        return null;
    }

    public double getQuick(int r, int c) {
        return this.matrix.get(r, c);
    }

    public void set(int r, int c, double val) {
        this.matrix.put(r, c, val);
    }

    public Matrix viewDice() {
        Matrix m = Matrix.wrap(this.matrix.transpose());
        return m;
    }

    public double det() {
        Decompose.LUDecomposition lup = Decompose.lu((DoubleMatrix)this.matrix);
        return -((DoubleMatrix)lup.u).diag().prod();
    }

    public double trace() {
        return this.matrix.diag().sum();
    }

    public Matrix diag() {
        if (this.matrix.columns == this.matrix.rows) {
            Matrix m = Matrix.wrap(this.matrix.diag());
            return m;
        }
        if (this.matrix.columns == 1 || this.matrix.rows == 1) {
            double[] values = this.matrix.toArray();
            DoubleMatrix toInsert = DoubleMatrix.zeros((int)Math.max(this.matrix.rows, this.matrix.columns), (int)Math.max(this.matrix.rows, this.matrix.columns));
            for (int i = 0; i < values.length; ++i) {
                toInsert.put(i, i, values[i]);
            }
            Matrix m = Matrix.wrap(toInsert);
            return m;
        }
        int min = Math.min(this.matrix.columns, this.matrix.rows);
        int[] indices = new int[min];
        for (int i = 0; i < min; ++i) {
            indices[i] = i;
        }
        Matrix m = new Matrix(this.matrix.get(indices, indices).diag());
        return m;
    }

    public static Matrix cholesky(Matrix matrix2) {
        return new Matrix(Decompose.cholesky((DoubleMatrix)matrix2.matrix));
    }

    public static DoubleMatrix[] fullsvd(Matrix matrix2) {
        return Singular.fullSVD((DoubleMatrix)matrix2.matrix);
    }

    public static DoubleMatrix[] sparsesvd(Matrix matrix2) {
        return Singular.sparseSVD((DoubleMatrix)matrix2.matrix);
    }

    public static DoubleMatrix eig(Matrix matrix2) {
        return Eigen.eigenvalues((DoubleMatrix)matrix2.matrix).getReal();
    }

    public static DoubleMatrix[] symEig(Matrix matrix2) {
        return Eigen.symmetricEigenvectors((DoubleMatrix)matrix2.matrix);
    }

    public static DoubleMatrix[] decompLU(Matrix matrix2) {
        Decompose.LUDecomposition lup = Decompose.lu((DoubleMatrix)matrix2.matrix);
        DoubleMatrix[] result = new DoubleMatrix[]{(DoubleMatrix)lup.l, ((DoubleMatrix)lup.u).rows < matrix2.matrix.rows ? DoubleMatrix.concatVertically((DoubleMatrix)((DoubleMatrix)lup.u), (DoubleMatrix)DoubleMatrix.zeros((int)(matrix2.matrix.rows - ((DoubleMatrix)lup.u).rows), (int)((DoubleMatrix)lup.u).columns)) : (DoubleMatrix)lup.u};
        return result;
    }

    public static int rank(Matrix matrix2) {
        DoubleMatrix[] suv = Matrix.fullsvd(matrix2);
        DoubleMatrix evs = suv[1].diag();
        int counter = 0;
        for (int i = 0; i < evs.columns; ++i) {
            if (!(evs.get(i, i) > 0.0)) continue;
            ++counter;
        }
        return counter;
    }

    public Matrix solve(DoubleMatrix other) {
        DoubleMatrix sol = Solve.solve((DoubleMatrix)this.matrix, (DoubleMatrix)other);
        return Matrix.wrap(sol);
    }

    public double[][] toArray() {
        return this.matrix.toArray2();
    }

    public double[] toArray1() {
        return this.matrix.toArray();
    }

    public Object first() {
        if (this.matrix.rows == 0 || this.matrix.columns == 0) {
            return null;
        }
        if (this.oneDimensional && (this.matrix.columns == 1 || this.matrix.rows == 1)) {
            return this.matrix.get(0, 0);
        }
        int[] subset = new int[this.matrix.columns];
        for (int i = 0; i < subset.length; ++i) {
            subset[i] = i;
        }
        return new Matrix(this.matrix.get(0, subset));
    }

    public ISeq next() {
        if (this.matrix.rows == 0 || this.matrix.columns == 0) {
            return null;
        }
        if (!this.oneDimensional && this.matrix.rows == 1) {
            return null;
        }
        if (this.oneDimensional && (this.matrix.columns == 1 || this.matrix.rows == 1)) {
            if (this.matrix.rows > 1) {
                int[] subsetColumns = new int[this.matrix.columns];
                for (int i = 0; i < this.matrix.columns; ++i) {
                    subsetColumns[i] = i;
                }
                int[] subsetRows = new int[this.matrix.rows - 1];
                for (int i = 0; i < this.matrix.rows - 1; ++i) {
                    subsetRows[i] = i + 1;
                }
                return new Matrix(this.matrix.get(subsetRows, subsetColumns));
            }
            if (this.matrix.columns > 1) {
                int[] subsetColumns = new int[this.matrix.columns - 1];
                for (int i = 0; i < this.matrix.columns - 1; ++i) {
                    subsetColumns[i] = i + 1;
                }
                int[] subsetRows = new int[this.matrix.rows];
                for (int i = 0; i < this.matrix.rows; ++i) {
                    subsetRows[i] = i;
                }
                return new Matrix(this.matrix.get(subsetRows, subsetColumns));
            }
            return null;
        }
        int[] subsetColumns = new int[this.matrix.columns];
        for (int i = 0; i < this.matrix.columns; ++i) {
            subsetColumns[i] = i;
        }
        int[] subsetRows = new int[this.matrix.rows - 1];
        for (int i = 0; i < this.matrix.rows - 1; ++i) {
            subsetRows[i] = i + 1;
        }
        Matrix m = new Matrix(this.matrix.get(subsetRows, subsetColumns));
        m.oneDimensional = false;
        return m;
    }

    public ISeq more() {
        ISeq result = this.next();
        if (result != null) {
            return result;
        }
        return new Matrix(0, 0, (Number)0);
    }

    public Matrix cons(Object o) {
        if (o instanceof Matrix) {
            int j;
            int i;
            Matrix m = (Matrix)o;
            double[][] newData = new double[this.matrix.rows + m.matrix.rows][this.matrix.columns];
            for (i = 0; i < this.matrix.rows; ++i) {
                for (j = 0; j < this.matrix.columns; ++j) {
                    newData[i][j] = this.matrix.get(i, j);
                }
            }
            for (i = 0; i < m.matrix.rows; ++i) {
                for (j = 0; j < this.matrix.columns; ++j) {
                    newData[this.matrix.rows + i][j] = m.matrix.get(i, j);
                }
            }
            return new Matrix(newData);
        }
        if (o instanceof Seqable) {
            ISeq v = ((Seqable)o).seq();
            double[][] newData = new double[this.matrix.rows + 1][this.matrix.columns];
            for (int i = 0; i < this.matrix.rows; ++i) {
                for (int j = 0; j < this.matrix.columns; ++j) {
                    newData[i][j] = this.matrix.get(i, j);
                }
            }
            ISeq restObj = v;
            for (int cols = 0; cols < this.matrix.columns; ++cols) {
                newData[this.matrix.rows][cols] = ((Number)restObj.first()).doubleValue();
                restObj = restObj.next();
            }
            return new Matrix(newData);
        }
        return null;
    }

    public int count() {
        if (this.oneDimensional) {
            return this.matrix.columns * this.matrix.rows;
        }
        return this.matrix.rows;
    }

    public Matrix seq() {
        if (this.matrix.columns * this.matrix.rows > 0) {
            return this;
        }
        return null;
    }

    public IPersistentCollection empty() {
        return new Matrix(0, 0);
    }

    public boolean equiv(DoubleMatrix obj) {
        return this.equals(obj);
    }

    public boolean equiv(Matrix obj) {
        return this.matrix.equals((Object)obj.matrix);
    }

    public boolean equiv(double[] obj) {
        return this.equals(new Matrix(obj));
    }

    public boolean equiv(double[][] obj) {
        return this.equals(new Matrix(obj));
    }

    public boolean equiv(Seqable coll) {
        ISeq otherSeq;
        Matrix thisSeq = this.seq();
        for (otherSeq = coll.seq(); thisSeq != null || otherSeq != null; thisSeq = thisSeq.next(), otherSeq = otherSeq.next()) {
            Object thisFirst = thisSeq.first();
            Object otherFirst = otherSeq.first();
            boolean isEqual = thisFirst instanceof Double ? (otherFirst instanceof Long ? ((Double)thisFirst).doubleValue() == ((Long)otherFirst).doubleValue() : (otherFirst instanceof Float ? ((Double)thisFirst).doubleValue() == ((Float)otherFirst).doubleValue() : (otherFirst instanceof Integer ? ((Double)thisFirst).doubleValue() == ((Integer)otherFirst).doubleValue() : (otherFirst instanceof Short ? ((Double)thisFirst).doubleValue() == ((Short)otherFirst).doubleValue() : (otherFirst instanceof Double ? ((Double)thisFirst).doubleValue() == ((Double)otherFirst).doubleValue() : false))))) : thisFirst.equals(otherFirst);
            if (isEqual) {
                continue;
            }
            return false;
        }
        return thisSeq == null && otherSeq == null;
    }

    public boolean equiv(Iterable obj) {
        Matrix thisSeq;
        Iterator it = obj.iterator();
        for (thisSeq = this.seq(); it.hasNext() || thisSeq != null; thisSeq = thisSeq.next()) {
            Object thisFirst = thisSeq.first();
            Object otherFirst = it.next();
            boolean isEqual = thisFirst instanceof Double ? (otherFirst instanceof Long ? ((Double)thisFirst).doubleValue() == ((Long)otherFirst).doubleValue() : (otherFirst instanceof Float ? ((Double)thisFirst).doubleValue() == ((Float)otherFirst).doubleValue() : (otherFirst instanceof Integer ? ((Double)thisFirst).doubleValue() == ((Integer)otherFirst).doubleValue() : (otherFirst instanceof Short ? ((Double)thisFirst).doubleValue() == ((Short)otherFirst).doubleValue() : (otherFirst instanceof Double ? ((Double)thisFirst).doubleValue() == ((Double)otherFirst).doubleValue() : false))))) : thisFirst.equals(otherFirst);
            if (isEqual) {
                continue;
            }
            return false;
        }
        return thisSeq == null && !it.hasNext();
    }

    public boolean equiv(Object obj) {
        if (obj instanceof Matrix) {
            return this.equiv((Matrix)obj);
        }
        if (obj instanceof DoubleMatrix) {
            return this.equiv((DoubleMatrix)obj);
        }
        if (obj instanceof Seqable) {
            return this.equiv((Seqable)obj);
        }
        if (obj instanceof Iterable) {
            return this.equiv((Iterable)obj);
        }
        return this.equals(obj);
    }

    public String toString() {
        return this.matrix.toString().replace(";", "\n");
    }

    public IPersistentMap meta() {
        return this.meta;
    }

    public Matrix withMeta(IPersistentMap meta) {
        return new Matrix(meta, this.matrix.toArray2());
    }
}

