(ns gilded-rose.core (:gen-class) (:require [clojure.string :refer [starts-with?]]))

(defn update-item [item]
  (defn is-backstage-pass? [] (= "Backstage passes to a TAFKAL80ETC concert" (:name item)))
  (defn is-aged-brie? [] (= "Aged Brie" (:name item)))
  (defn is-sulfuras? [] (= "Sulfuras, Hand of Ragnaros" (:name item)))
  (defn is-elixir-monoose? [] (= "Elixir of the Mongoose" (:name item)))
  (defn is-dex-vest? [] (= "+5 Dexterity Vest" (:name item)))
  (defn is-conjured? [] (starts-with? (:name item) "Conjured"))

  (defn should-decrease-sell-in? [] (not (is-sulfuras?)))

  (defn new-quality []
    (def quality-change 
      (cond
        (is-sulfuras?) 0
        (and (<= (:sell-in item) 0) (is-backstage-pass?)) (-(:quality item))
        (or (is-aged-brie?) (is-backstage-pass?))
          (if (and (is-backstage-pass?) (>= (:sell-in item) 0) (<= (:sell-in item) 5))
            3
            (if (and (is-backstage-pass?) (> (:sell-in item) 5) (<= (:sell-in item) 10)) 2 1))
        (<= (:sell-in item) 0) -2
        :else -1
      ))

    (def q-change (if (is-conjured?) (* 2 quality-change) quality-change))
    (def new-q (+ (:quality item) q-change))
    (if (is-sulfuras?) (:quality item) (if (< new-q 0) 0 (if (> new-q 50) 50 new-q)))
  )

  (defn new-sell-in [] (if (should-decrease-sell-in?)
        (dec (:sell-in item))
        (:sell-in item)))

  (merge item {:quality (new-quality) :sell-in (new-sell-in)})
)

(defn update-quality [items] (map update-item items))
  
(defn item [item-name, sell-in, quality]
  {:name item-name, :sell-in sell-in, :quality quality})

(defn update-current-inventory[]
  (let [inventory 
    [
      (item "+5 Dexterity Vest" 10 20)
      (item "Aged Brie" 2 0)
      (item "Elixir of the Mongoose" 5 7)
      (item "Sulfuras, Hand Of Ragnaros" 0 80)
      (item "Backstage passes to a TAFKAL80ETC concert" 15 20)
    ]]
    (update-quality inventory)
    ))

(defn -main [& args] 
  (doseq [item (update-current-inventory)] (println item)))
