/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.waiter.courier;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.twosigma.waiter.courier.Authenticator;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;

public class HealthCheckServer {
    private static final Logger LOGGER = Logger.getLogger(HealthCheckServer.class.getName());

    void start(int port, boolean authenticateRequests) throws IOException {
        LOGGER.info("starting health check server on port " + port);
        InetSocketAddress address = new InetSocketAddress(port);
        HttpServer server = HttpServer.create(address, 0);
        server.createContext("/status", new HealthCheckHandler(authenticateRequests));
        server.setExecutor(null);
        server.start();
        LOGGER.info("health check server started, listening on " + port);
    }

    private static class HealthCheckHandler
    implements HttpHandler {
        private final Authenticator authenticator;

        public HealthCheckHandler(boolean authenticateRequests) {
            if (authenticateRequests) {
                String username = System.getenv("WAITER_USERNAME");
                if (username == null || username.isEmpty()) {
                    throw new IllegalStateException("Cannot enable authentication when WAITER_USERNAME is missing!");
                }
                String password = System.getenv("WAITER_PASSWORD");
                if (password == null || password.isEmpty()) {
                    throw new IllegalStateException("Cannot enable authentication when WAITER_PASSWORD is missing!");
                }
                this.authenticator = new Authenticator.BasicAuthenticator(username, password);
            } else {
                this.authenticator = new Authenticator.DisabledAuthenticator();
            }
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            int responseStatus;
            String responseBody;
            boolean authSuccessful;
            String correlationId = httpExchange.getRequestHeaders().getFirst("x-cid");
            LOGGER.info(correlationId + " received health check request");
            Headers responseHeaders = httpExchange.getResponseHeaders();
            responseHeaders.add("content-type", "text/plain");
            responseHeaders.add("server", "courier-health-check/jdk" + System.getProperty("java.version"));
            if (correlationId != null) {
                responseHeaders.add("x-cid", correlationId);
            }
            if (authSuccessful = this.authenticator.authenticate(httpExchange.getRequestHeaders())) {
                responseBody = "OK";
                responseStatus = 200;
            } else {
                responseBody = "Unauthorized";
                responseStatus = 401;
            }
            httpExchange.sendResponseHeaders(responseStatus, responseBody.getBytes(StandardCharsets.UTF_8).length);
            OutputStream os = httpExchange.getResponseBody();
            os.write(responseBody.getBytes(StandardCharsets.UTF_8));
            os.close();
            LOGGER.info(correlationId + " responded with " + responseStatus + " " + responseBody);
        }
    }
}

