/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.waiter.courier;

import com.sun.net.httpserver.Headers;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.logging.Logger;

public interface Authenticator {
    public boolean authenticate(Headers var1);

    public static class DisabledAuthenticator
    implements Authenticator {
        @Override
        public boolean authenticate(Headers requestHeaders) {
            return true;
        }
    }

    public static class BasicAuthenticator
    implements Authenticator {
        private static final Logger LOGGER = Logger.getLogger(BasicAuthenticator.class.getName());
        private final String expectedAuthorization;

        public BasicAuthenticator(String username, String password) {
            String auth = username + ":" + password;
            byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes(StandardCharsets.UTF_8));
            this.expectedAuthorization = "Basic " + new String(encodedAuth);
        }

        @Override
        public boolean authenticate(Headers requestHeaders) {
            String authorization = requestHeaders.getFirst("authorization");
            if (authorization == null) {
                LOGGER.info("No authorization header provided");
                return false;
            }
            if (!this.expectedAuthorization.equals(authorization)) {
                LOGGER.info("Invalid authorization header: " + authorization);
                return false;
            }
            LOGGER.info("Successfully authenticated request");
            return true;
        }
    }
}

