/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.waiter.courier;

import com.twosigma.waiter.courier.CourierGrpc;
import com.twosigma.waiter.courier.CourierReply;
import com.twosigma.waiter.courier.CourierRequest;
import com.twosigma.waiter.courier.CourierSummary;
import com.twosigma.waiter.courier.GrpcServer;
import com.twosigma.waiter.courier.LoggingConfig;
import com.twosigma.waiter.courier.StateReply;
import com.twosigma.waiter.courier.StateRequest;
import com.twosigma.waiter.courier.Variant;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.Context;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class GrpcClient {
    private static final Logger LOGGER = Logger.getLogger(GrpcServer.class.getName());
    private final Function<String, Void> logFunction;
    private final String host;
    private final int port;

    private static Variant retrieveVariant(String id) {
        if (id.contains("SEND_ERROR")) {
            return Variant.SEND_ERROR;
        }
        if (id.contains("EXIT_PRE_RESPONSE")) {
            return Variant.EXIT_PRE_RESPONSE;
        }
        if (id.contains("EXIT_POST_RESPONSE")) {
            return Variant.EXIT_POST_RESPONSE;
        }
        return Variant.NORMAL;
    }

    public GrpcClient(String host, int port) {
        this(host, port, new Function<String, Void>(){

            @Override
            public Void apply(String message) {
                LOGGER.info(message);
                return null;
            }
        });
    }

    public GrpcClient(String host, int port, Function<String, Void> logFunction) {
        this.host = host;
        this.port = port;
        this.logFunction = logFunction;
    }

    private ManagedChannel initializeChannel() {
        this.logFunction.apply("initializing plaintext client at " + this.host + ":" + this.port);
        return ManagedChannelBuilder.forAddress((String)this.host, (int)this.port).usePlaintext().build();
    }

    private void shutdownChannel(ManagedChannel channel) {
        this.logFunction.apply("shutting down channel");
        try {
            channel.shutdown().awaitTermination(1L, TimeUnit.SECONDS);
            if (channel.isShutdown()) {
                this.logFunction.apply("channel shutdown successfully");
            } else {
                this.logFunction.apply("channel shutdown timed out!");
            }
        }
        catch (Exception ex) {
            this.logFunction.apply("error in channel shutdown: " + ex.getMessage());
        }
    }

    private Metadata createRequestHeadersMetadata(Map<String, Object> headers) {
        Metadata headerMetadata = new Metadata();
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            String key = entry.getKey();
            String value = String.valueOf(entry.getValue());
            headerMetadata.put(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)value);
        }
        return headerMetadata;
    }

    private Channel wrapResponseLogger(ManagedChannel channel) {
        return ClientInterceptors.intercept((Channel)channel, (ClientInterceptor[])new ClientInterceptor[]{new ClientInterceptor(){

            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                    public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                        super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                            public void onHeaders(Metadata headers) {
                                GrpcClient.this.logFunction.apply("headers received from server:" + headers);
                                super.onHeaders(headers);
                            }

                            public void onClose(Status status, Metadata trailers) {
                                GrpcClient.this.logFunction.apply("status received from server:" + status);
                                GrpcClient.this.logFunction.apply("trailers received from server:" + trailers);
                                super.onClose(status, trailers);
                            }
                        }, headers);
                    }
                };
            }
        }});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RpcResult<StateReply> retrieveState(Map<String, Object> headers, String correlationId) {
        ManagedChannel channel = this.initializeChannel();
        try {
            StateReply reply;
            Channel wrappedChannel = this.wrapResponseLogger(channel);
            Metadata headerMetadata = this.createRequestHeadersMetadata(headers);
            CourierGrpc.CourierFutureStub rawStub = CourierGrpc.newFutureStub(wrappedChannel);
            CourierGrpc.CourierFutureStub futureStub = (CourierGrpc.CourierFutureStub)MetadataUtils.attachHeaders((AbstractStub)rawStub, (Metadata)headerMetadata);
            this.logFunction.apply("will try to retrieve state for " + correlationId + " ...");
            StateRequest request = StateRequest.newBuilder().setCid(correlationId).build();
            AtomicReference<Status> status = new AtomicReference<Status>();
            AtomicReference<StateReply> response = new AtomicReference<StateReply>();
            try {
                reply = (StateReply)futureStub.retrieveState(request).get();
                status.set(Status.OK);
                response.set(reply);
            }
            catch (StatusRuntimeException ex) {
                Status errorStatus = ex.getStatus();
                this.logFunction.apply("RPC failed, status: " + errorStatus);
                status.set(errorStatus);
            }
            catch (ExecutionException ex) {
                Status errorStatus = Status.fromThrowable((Throwable)ex.getCause());
                this.logFunction.apply("RPC execution failed: " + errorStatus);
                status.set(errorStatus);
            }
            catch (Throwable th) {
                this.logFunction.apply("RPC failed, message: " + th.getMessage());
                status.set(Status.UNKNOWN.withDescription(th.getMessage()));
            }
            if (response.get() != null) {
                reply = (StateReply)response.get();
                this.logFunction.apply("received response StateReply{cid=" + reply.getCid() + ", response=" + reply.getStateList() + "}");
            }
            RpcResult<StateReply> rpcResult = new RpcResult<StateReply>(response.get(), (Status)status.get());
            return rpcResult;
        }
        finally {
            this.shutdownChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RpcResult<CourierReply> sendPackage(Map<String, Object> headers, String id, String from, String message, long sleepDurationMillis, long deadlineDurationMillis) {
        ManagedChannel channel = this.initializeChannel();
        try {
            Status errorStatus;
            CourierReply reply;
            Channel wrappedChannel = this.wrapResponseLogger(channel);
            Metadata headerMetadata = this.createRequestHeadersMetadata(headers);
            CourierGrpc.CourierFutureStub rawStub = (CourierGrpc.CourierFutureStub)CourierGrpc.newFutureStub(wrappedChannel).withDeadlineAfter(deadlineDurationMillis, TimeUnit.MILLISECONDS);
            CourierGrpc.CourierFutureStub futureStub = (CourierGrpc.CourierFutureStub)MetadataUtils.attachHeaders((AbstractStub)rawStub, (Metadata)headerMetadata);
            this.logFunction.apply("will try to send package from " + from + " ...");
            CourierRequest request = CourierRequest.newBuilder().setId(id).setFrom(from).setMessage(message).setVariant(GrpcClient.retrieveVariant(id)).setSleepDurationMillis(sleepDurationMillis).build();
            AtomicReference<Status> status = new AtomicReference<Status>();
            AtomicReference<CourierReply> response = new AtomicReference<CourierReply>();
            try {
                reply = (CourierReply)futureStub.sendPackage(request).get();
                status.set(Status.OK);
                response.set(reply);
            }
            catch (StatusRuntimeException ex) {
                errorStatus = ex.getStatus();
                this.logFunction.apply("RPC failed, status: " + errorStatus);
                status.set(errorStatus);
            }
            catch (ExecutionException ex) {
                errorStatus = Status.fromThrowable((Throwable)ex.getCause());
                this.logFunction.apply("RPC execution failed: " + errorStatus);
                status.set(errorStatus);
            }
            catch (Throwable th) {
                this.logFunction.apply("RPC failed, message: " + th.getMessage());
                status.set(Status.UNKNOWN.withDescription(th.getMessage()));
            }
            reply = (CourierReply)response.get();
            if (reply != null) {
                this.logFunction.apply("received response CourierReply{id=" + reply.getId() + ", response=" + reply.getResponse() + ", message.length=" + reply.getMessage().length() + "}");
                this.logFunction.apply("messages equal = " + message.equals(reply.getMessage()));
            }
            RpcResult<CourierReply> rpcResult = new RpcResult<CourierReply>(reply, (Status)status.get());
            return rpcResult;
        }
        finally {
            this.shutdownChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RpcResult<List<CourierSummary>> collectPackages(Map<String, Object> headers, List<String> ids, String from, List<String> messages, int interMessageSleepMs, final boolean lockStepMode, int cancelThreshold, CancellationPolicy cancellationPolicy, long deadlineDurationMillis) {
        ManagedChannel channel = this.initializeChannel();
        AtomicBoolean awaitChannelTermination = new AtomicBoolean(true);
        Context.CancellableContext cancellableContext = Context.current().withCancellation();
        try {
            final Semaphore lockStep = new Semaphore(1);
            final AtomicBoolean errorSignal = new AtomicBoolean(false);
            Channel wrappedChannel = this.wrapResponseLogger(channel);
            Metadata headerMetadata = this.createRequestHeadersMetadata(headers);
            CourierGrpc.CourierStub rawStub = (CourierGrpc.CourierStub)CourierGrpc.newStub(wrappedChannel).withDeadlineAfter(deadlineDurationMillis, TimeUnit.MILLISECONDS);
            CourierGrpc.CourierStub futureStub = (CourierGrpc.CourierStub)MetadataUtils.attachHeaders((AbstractStub)rawStub, (Metadata)headerMetadata);
            this.logFunction.apply("will try to send package from " + from + " ...");
            final AtomicReference observer = new AtomicReference();
            final AtomicReference status = new AtomicReference();
            AtomicReference response = new AtomicReference();
            cancellableContext.run(() -> {
                final CompletableFuture responsePromise = new CompletableFuture();
                try {
                    final ArrayList resultList = new ArrayList();
                    StreamObserver<CourierRequest> collector = futureStub.collectPackages((StreamObserver<CourierSummary>)new ClientResponseObserver<CourierRequest, CourierSummary>(){

                        public void beforeStart(ClientCallStreamObserver<CourierRequest> requestStream) {
                            observer.set(requestStream);
                        }

                        public void onNext(CourierSummary response) {
                            GrpcClient.this.logFunction.apply("received response CourierSummary{count=" + response.getNumMessages() + ", length=" + response.getTotalLength() + "}");
                            resultList.add(response);
                            if (lockStepMode) {
                                GrpcClient.this.logFunction.apply("releasing semaphore after receiving response");
                                lockStep.release();
                            }
                        }

                        public void onError(Throwable th) {
                            GrpcClient.this.logFunction.apply("error in collecting summaries " + th);
                            errorSignal.compareAndSet(false, true);
                            if (lockStepMode) {
                                GrpcClient.this.logFunction.apply("releasing semaphore after receiving error");
                                lockStep.release();
                            }
                            if (th instanceof StatusRuntimeException) {
                                StatusRuntimeException exception = (StatusRuntimeException)th;
                                status.set(exception.getStatus());
                            } else {
                                status.set(Status.UNKNOWN.withDescription(th.getMessage()));
                            }
                            this.resolveResponsePromise();
                        }

                        public void onCompleted() {
                            GrpcClient.this.logFunction.apply("completed collecting summaries");
                            status.set(Status.OK);
                            this.resolveResponsePromise();
                        }

                        private void resolveResponsePromise() {
                            GrpcClient.this.logFunction.apply("client result has " + resultList.size() + " entries");
                            responsePromise.complete(resultList);
                        }
                    });
                    try {
                        for (int i = 0; i < messages.size(); ++i) {
                            if (i >= cancelThreshold) {
                                this.logFunction.apply("cancelling sending messages");
                                awaitChannelTermination.set(false);
                                String cancellationMessage = "Cancel threshold reached: " + cancelThreshold + " -> " + (Object)((Object)cancellationPolicy);
                                cancellationPolicy.apply(cancellableContext, (ClientCallStreamObserver)observer.get(), cancellationMessage);
                            }
                            if (errorSignal.get()) {
                                this.logFunction.apply("aborting sending messages as error was discovered");
                                break;
                            }
                            String requestId = (String)ids.get(i);
                            if (lockStepMode) {
                                this.logFunction.apply("acquiring semaphore before sending request " + requestId);
                                lockStep.acquire();
                            }
                            CourierRequest request = CourierRequest.newBuilder().setId(requestId).setFrom(from).setMessage((String)messages.get(i)).setVariant(GrpcClient.retrieveVariant(requestId)).build();
                            this.logFunction.apply("sending message CourierRequest{id=" + request.getId() + ", from=" + request.getFrom() + ", message.length=" + request.getMessage().length() + "}");
                            collector.onNext((Object)request);
                            Thread.sleep(interMessageSleepMs);
                        }
                        this.logFunction.apply("completed sending packages");
                        collector.onCompleted();
                    }
                    catch (Throwable th) {
                        this.logFunction.apply("client threw exception, result has " + resultList.size() + " entries");
                        Thread.sleep(interMessageSleepMs);
                        responsePromise.complete(resultList);
                        throw th;
                    }
                    finally {
                        response.set(responsePromise.get());
                    }
                }
                catch (StatusRuntimeException ex) {
                    this.logFunction.apply("RPC failed, status: " + ex.getStatus());
                    status.set(ex.getStatus());
                }
                catch (Exception ex) {
                    this.logFunction.apply("RPC failed, message: " + ex.getMessage());
                    status.set(Status.UNKNOWN.withDescription(ex.getMessage()));
                }
            });
            RpcResult<List<CourierSummary>> rpcResult = new RpcResult<List<CourierSummary>>(response.get(), (Status)status.get());
            return rpcResult;
        }
        finally {
            if (awaitChannelTermination.get()) {
                this.shutdownChannel(channel);
            } else {
                channel.shutdownNow();
            }
            cancellableContext.cancel(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RpcResult<CourierSummary> aggregatePackages(Map<String, Object> headers, List<String> ids, String from, List<String> messages, int interMessageSleepMs, int cancelThreshold, CancellationPolicy cancellationPolicy, long deadlineDurationMillis) {
        ManagedChannel channel = this.initializeChannel();
        AtomicBoolean awaitChannelTermination = new AtomicBoolean(true);
        Context.CancellableContext cancellableContext = Context.current().withCancellation();
        try {
            final AtomicBoolean errorSignal = new AtomicBoolean(false);
            Channel wrappedChannel = this.wrapResponseLogger(channel);
            Metadata headerMetadata = this.createRequestHeadersMetadata(headers);
            CourierGrpc.CourierStub rawStub = (CourierGrpc.CourierStub)CourierGrpc.newStub(wrappedChannel).withDeadlineAfter(deadlineDurationMillis, TimeUnit.MILLISECONDS);
            CourierGrpc.CourierStub futureStub = (CourierGrpc.CourierStub)MetadataUtils.attachHeaders((AbstractStub)rawStub, (Metadata)headerMetadata);
            this.logFunction.apply("will try to aggregate package from " + from + " ...");
            final AtomicReference observer = new AtomicReference();
            final AtomicReference status = new AtomicReference();
            final AtomicReference response = new AtomicReference();
            cancellableContext.run(() -> {
                final CompletableFuture responsePromise = new CompletableFuture();
                try {
                    StreamObserver<CourierRequest> collector = futureStub.aggregatePackages((StreamObserver<CourierSummary>)new ClientResponseObserver<CourierRequest, CourierSummary>(){

                        public void beforeStart(ClientCallStreamObserver<CourierRequest> requestStream) {
                            observer.set(requestStream);
                        }

                        public void onNext(CourierSummary summary) {
                            GrpcClient.this.logFunction.apply("received response CourierSummary{count=" + summary.getNumMessages() + ", length=" + summary.getTotalLength() + "}");
                            response.set(summary);
                        }

                        public void onError(Throwable th) {
                            GrpcClient.this.logFunction.apply("error in aggregating summaries " + th);
                            errorSignal.compareAndSet(false, true);
                            if (th instanceof StatusRuntimeException) {
                                StatusRuntimeException exception = (StatusRuntimeException)th;
                                status.set(exception.getStatus());
                            } else {
                                status.set(Status.UNKNOWN.withDescription(th.getMessage()));
                            }
                            this.resolveResponsePromise();
                        }

                        public void onCompleted() {
                            GrpcClient.this.logFunction.apply("completed aggregating summaries");
                            status.set(Status.OK);
                            this.resolveResponsePromise();
                        }

                        private void resolveResponsePromise() {
                            CourierSummary courierSummary = (CourierSummary)response.get();
                            GrpcClient.this.logFunction.apply("client result: " + courierSummary);
                            responsePromise.complete(courierSummary);
                        }
                    });
                    for (int i = 0; i < messages.size(); ++i) {
                        if (i >= cancelThreshold) {
                            this.logFunction.apply("cancelling sending messages");
                            awaitChannelTermination.set(false);
                            String cancellationMessage = "Cancel threshold reached: " + cancelThreshold + " -> " + (Object)((Object)cancellationPolicy);
                            cancellationPolicy.apply(cancellableContext, (ClientCallStreamObserver)observer.get(), cancellationMessage);
                        }
                        if (errorSignal.get()) {
                            this.logFunction.apply("aborting sending messages as error was discovered");
                            break;
                        }
                        String requestId = (String)ids.get(i);
                        CourierRequest request = CourierRequest.newBuilder().setId(requestId).setFrom(from).setMessage((String)messages.get(i)).setVariant(GrpcClient.retrieveVariant(requestId)).build();
                        this.logFunction.apply("sending message CourierRequest{id=" + request.getId() + ", from=" + request.getFrom() + ", message.length=" + request.getMessage().length() + "}");
                        collector.onNext((Object)request);
                        Thread.sleep(interMessageSleepMs);
                    }
                    this.logFunction.apply("completed sending packages");
                    collector.onCompleted();
                    responsePromise.get();
                }
                catch (StatusRuntimeException ex) {
                    this.logFunction.apply("RPC failed, status: " + ex.getStatus());
                    status.set(ex.getStatus());
                }
                catch (Exception ex) {
                    this.logFunction.apply("RPC failed, message: " + ex.getMessage());
                    status.set(Status.UNKNOWN.withDescription(ex.getMessage()));
                }
            });
            RpcResult<CourierSummary> rpcResult = new RpcResult<CourierSummary>(response.get(), (Status)status.get());
            return rpcResult;
        }
        finally {
            if (awaitChannelTermination.get()) {
                this.shutdownChannel(channel);
            } else {
                channel.shutdownNow();
            }
            this.logFunction.apply("close the context and trigger notification of listeners");
            cancellableContext.cancel(null);
        }
    }

    public static void main(String ... args) throws Exception {
        String host = args.length > 0 ? args[0] : "localhost";
        int port = args.length > 1 ? Integer.parseInt(args[1]) : 8080;
        String methodName = args.length > 2 ? args[2] : "runCollectPackagesClientCancelObserver";
        String correlationId = args.length > 3 ? args[3] : "courier-request-" + System.nanoTime();
        System.out.println("host = " + host);
        System.out.println("port = " + port);
        System.out.println("correlationId = " + correlationId);
        System.out.println("methodName = " + methodName);
        LoggingConfig.initializeLogging();
        GrpcClient client = new GrpcClient(host, port);
        switch (methodName) {
            case "runAggregatePackagesClientContext": {
                GrpcClient.runAggregatePackagesClientContext(client, correlationId);
                break;
            }
            case "runAggregatePackagesClientCancelException": {
                GrpcClient.runAggregatePackagesClientCancelException(client, correlationId);
                break;
            }
            case "runAggregatePackagesClientCancelObserver": {
                GrpcClient.runAggregatePackagesClientCancelObserver(client, correlationId);
                break;
            }
            case "runAggregatePackagesExitPreResponse": {
                GrpcClient.runAggregatePackagesExitPreResponse(client, correlationId);
                break;
            }
            case "runAggregatePackagesSendError": {
                GrpcClient.runAggregatePackagesSendError(client, correlationId);
                break;
            }
            case "runAggregatePackagesSuccess": {
                GrpcClient.runAggregatePackagesSuccess(client, correlationId);
                break;
            }
            case "runCollectPackagesClientCancelContext": {
                GrpcClient.runCollectPackagesClientCancelContext(client, correlationId);
                break;
            }
            case "runCollectPackagesClientCancelException": {
                GrpcClient.runCollectPackagesClientCancelException(client, correlationId);
                break;
            }
            case "runCollectPackagesClientCancelObserver": {
                GrpcClient.runCollectPackagesClientCancelObserver(client, correlationId);
                break;
            }
            case "runCollectPackagesExitPostResponse": {
                GrpcClient.runCollectPackagesExitPostResponse(client, correlationId);
                break;
            }
            case "runCollectPackagesExitPreResponse": {
                GrpcClient.runCollectPackagesExitPreResponse(client, correlationId);
                break;
            }
            case "runCollectPackagesSendError": {
                GrpcClient.runCollectPackagesSendError(client, correlationId);
                break;
            }
            case "runCollectPackagesSuccess": {
                GrpcClient.runCollectPackagesSuccess(client, correlationId);
                break;
            }
            case "runSendPackageSendError": {
                GrpcClient.runSendPackageSendError(client, correlationId);
                break;
            }
            case "runSendPackageSuccess": {
                GrpcClient.runSendPackageSuccess(client, correlationId);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported method: " + methodName);
            }
        }
    }

    private static void retrieveStateForCid(GrpcClient client, Map<String, Object> headers, String correlationId) {
        String retrieveCid = "cid-retrieve-state." + System.currentTimeMillis();
        headers.put("x-cid", retrieveCid);
        RpcResult<StateReply> rpcStateResult = client.retrieveState(headers, correlationId);
        StateReply stateReply = rpcStateResult.result();
        client.logFunction.apply("retrieveState response = " + stateReply);
        Status retrieveStatus = rpcStateResult.status();
        client.logFunction.apply("retrieveState status = " + retrieveStatus);
    }

    private static void runSendPackageSuccess(GrpcClient client, String correlationId) {
        String id = UUID.randomUUID().toString();
        String user = "Jim";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 100000; ++i) {
            sb.append("a");
            if (i % 1000 != 0) continue;
            sb.append(".");
        }
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("x-cid", correlationId);
        RpcResult<CourierReply> rpcResult = client.sendPackage(headers, id, "Jim", sb.toString(), 10L, 1000L);
        CourierReply courierReply = rpcResult.result();
        client.logFunction.apply("sendPackage response = " + courierReply);
        Status status = rpcResult.status();
        client.logFunction.apply("sendPackage status = " + status);
        GrpcClient.retrieveStateForCid(client, headers, correlationId);
    }

    private static void runSendPackageSendError(GrpcClient client, String correlationId) {
        String id = UUID.randomUUID().toString() + ".SEND_ERROR";
        String user = "Jim";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 100000; ++i) {
            sb.append("a");
            if (i % 1000 != 0) continue;
            sb.append(".");
        }
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("x-cid", correlationId);
        RpcResult<CourierReply> rpcResult = client.sendPackage(headers, id, "Jim", sb.toString(), 10L, 1000L);
        CourierReply courierReply = rpcResult.result();
        client.logFunction.apply("sendPackage response = " + courierReply);
        Status status = rpcResult.status();
        client.logFunction.apply("sendPackage status = " + status);
        GrpcClient.retrieveStateForCid(client, headers, correlationId);
    }

    private static void runCollectPackagesSuccess(GrpcClient client, String correlationId) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("x-cid", correlationId);
        List<String> ids = IntStream.range(0, 10).mapToObj(i -> "id-" + i).collect(Collectors.toList());
        List<String> messages = IntStream.range(0, 10).mapToObj(i -> "message-" + i).collect(Collectors.toList());
        RpcResult<List<CourierSummary>> rpcResult = client.collectPackages(headers, ids, "User", messages, 100, true, messages.size() + 1, CancellationPolicy.NONE, 10000L);
        List<CourierSummary> courierSummaries = rpcResult.result();
        client.logFunction.apply("collectPackages[success] summary = " + courierSummaries);
        Status status = rpcResult.status();
        client.logFunction.apply("collectPackages[success] status = " + status);
    }

    private static void runCollectPackagesClientCancelContext(GrpcClient client, String correlationId) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("x-cid", correlationId);
        List<String> ids = IntStream.range(0, 10).mapToObj(i -> "id-" + i).collect(Collectors.toList());
        ids.set(5, (String)ids.get(5) + ".SEND_ERROR");
        List<String> messages = IntStream.range(0, 10).mapToObj(i -> "message-" + i).collect(Collectors.toList());
        RpcResult<List<CourierSummary>> rpcResult = client.collectPackages(headers, ids, "User", messages, 100, true, messages.size() / 2, CancellationPolicy.CONTEXT, 10000L);
        List<CourierSummary> courierSummaries = rpcResult.result();
        client.logFunction.apply("collectPackages[cancel] summary = " + courierSummaries);
        Status status = rpcResult.status();
        client.logFunction.apply("collectPackages[cancel] status = " + status);
        GrpcClient.retrieveStateForCid(client, headers, correlationId);
    }

    private static void runCollectPackagesClientCancelException(GrpcClient client, String correlationId) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("x-cid", correlationId);
        List<String> ids = IntStream.range(0, 10).mapToObj(i -> "id-" + i).collect(Collectors.toList());
        ids.set(5, (String)ids.get(5) + ".SEND_ERROR");
        List<String> messages = IntStream.range(0, 10).mapToObj(i -> "message-" + i).collect(Collectors.toList());
        RpcResult<List<CourierSummary>> rpcResult = client.collectPackages(headers, ids, "User", messages, 100, true, messages.size() / 2, CancellationPolicy.EXCEPTION, 10000L);
        List<CourierSummary> courierSummaries = rpcResult.result();
        client.logFunction.apply("collectPackages[cancel] summary = " + courierSummaries);
        Status status = rpcResult.status();
        client.logFunction.apply("collectPackages[cancel] status = " + status);
        GrpcClient.retrieveStateForCid(client, headers, correlationId);
    }

    private static void runCollectPackagesClientCancelObserver(GrpcClient client, String correlationId) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("x-cid", correlationId);
        List<String> ids = IntStream.range(0, 10).mapToObj(i -> "id-" + i).collect(Collectors.toList());
        ids.set(5, (String)ids.get(5) + ".SEND_ERROR");
        List<String> messages = IntStream.range(0, 10).mapToObj(i -> "message-" + i).collect(Collectors.toList());
        RpcResult<List<CourierSummary>> rpcResult = client.collectPackages(headers, ids, "User", messages, 100, true, messages.size() / 2, CancellationPolicy.OBSERVER, 10000L);
        List<CourierSummary> courierSummaries = rpcResult.result();
        client.logFunction.apply("collectPackages[cancel] summary = " + courierSummaries);
        Status status = rpcResult.status();
        client.logFunction.apply("collectPackages[cancel] status = " + status);
        GrpcClient.retrieveStateForCid(client, headers, correlationId);
    }

    private static void runCollectPackagesSendError(GrpcClient client, String correlationId) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("x-cid", correlationId);
        List<String> ids = IntStream.range(0, 10).mapToObj(i -> "id-" + i).collect(Collectors.toList());
        ids.set(5, (String)ids.get(5) + ".SEND_ERROR");
        List<String> messages = IntStream.range(0, 10).mapToObj(i -> "message-" + i).collect(Collectors.toList());
        RpcResult<List<CourierSummary>> rpcResult = client.collectPackages(headers, ids, "User", messages, 100, true, messages.size() + 1, CancellationPolicy.EXCEPTION, 10000L);
        List<CourierSummary> courierSummaries = rpcResult.result();
        client.logFunction.apply("collectPackages[cancel] summary = " + courierSummaries);
        Status status = rpcResult.status();
        client.logFunction.apply("collectPackages[cancel] status = " + status);
    }

    private static void runCollectPackagesExitPreResponse(GrpcClient client, String correlationId) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("x-cid", correlationId);
        List<String> ids = IntStream.range(0, 10).mapToObj(i -> "id-" + i).collect(Collectors.toList());
        ids.set(5, (String)ids.get(5) + ".EXIT_PRE_RESPONSE");
        List<String> messages = IntStream.range(0, 10).mapToObj(i -> "message-" + i).collect(Collectors.toList());
        RpcResult<List<CourierSummary>> rpcResult = client.collectPackages(headers, ids, "User", messages, 100, true, messages.size() + 1, CancellationPolicy.EXCEPTION, 10000L);
        List<CourierSummary> courierSummaries = rpcResult.result();
        client.logFunction.apply("collectPackages[cancel] summary = " + courierSummaries);
        Status status = rpcResult.status();
        client.logFunction.apply("collectPackages[cancel] status = " + status);
    }

    private static void runCollectPackagesExitPostResponse(GrpcClient client, String correlationId) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("x-cid", correlationId);
        List<String> ids = IntStream.range(0, 10).mapToObj(i -> "id-" + i).collect(Collectors.toList());
        ids.set(5, (String)ids.get(5) + ".EXIT_POST_RESPONSE");
        List<String> messages = IntStream.range(0, 10).mapToObj(i -> "message-" + i).collect(Collectors.toList());
        RpcResult<List<CourierSummary>> rpcResult = client.collectPackages(headers, ids, "User", messages, 100, true, messages.size() + 1, CancellationPolicy.EXCEPTION, 10000L);
        List<CourierSummary> courierSummaries = rpcResult.result();
        client.logFunction.apply("collectPackages[cancel] summary = " + courierSummaries);
        Status status = rpcResult.status();
        client.logFunction.apply("collectPackages[cancel] status = " + status);
    }

    private static void runAggregatePackagesSuccess(GrpcClient client, String correlationId) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("x-cid", correlationId);
        List<String> ids = IntStream.range(0, 10).mapToObj(i -> "id-" + i).collect(Collectors.toList());
        List<String> messages = IntStream.range(0, 10).mapToObj(i -> "message-" + i).collect(Collectors.toList());
        RpcResult<CourierSummary> rpcResult = client.aggregatePackages(headers, ids, "User", messages, 100, messages.size() + 1, CancellationPolicy.EXCEPTION, 10000L);
        CourierSummary courierSummary = rpcResult.result();
        client.logFunction.apply("aggregatePackages[success] summary = " + courierSummary);
        Status status = rpcResult.status();
        client.logFunction.apply("aggregatePackages[success] status = " + status);
    }

    private static void runAggregatePackagesClientContext(GrpcClient client, String correlationId) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("x-cid", correlationId);
        List<String> ids = IntStream.range(0, 10).mapToObj(i -> "id-" + i).collect(Collectors.toList());
        List<String> messages = IntStream.range(0, 10).mapToObj(i -> "message-" + i).collect(Collectors.toList());
        RpcResult<CourierSummary> rpcResult = client.aggregatePackages(headers, ids, "User", messages, 100, messages.size() / 2, CancellationPolicy.CONTEXT, 10000L);
        CourierSummary courierSummary = rpcResult.result();
        client.logFunction.apply("aggregatePackages[success] summary = " + courierSummary);
        Status status = rpcResult.status();
        client.logFunction.apply("aggregatePackages[success] status = " + status);
        GrpcClient.retrieveStateForCid(client, headers, correlationId);
    }

    private static void runAggregatePackagesClientCancelException(GrpcClient client, String correlationId) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("x-cid", correlationId);
        List<String> ids = IntStream.range(0, 10).mapToObj(i -> "id-" + i).collect(Collectors.toList());
        List<String> messages = IntStream.range(0, 10).mapToObj(i -> "message-" + i).collect(Collectors.toList());
        RpcResult<CourierSummary> rpcResult = client.aggregatePackages(headers, ids, "User", messages, 100, messages.size() / 2, CancellationPolicy.EXCEPTION, 10000L);
        CourierSummary courierSummary = rpcResult.result();
        client.logFunction.apply("aggregatePackages[success] summary = " + courierSummary);
        Status status = rpcResult.status();
        client.logFunction.apply("aggregatePackages[success] status = " + status);
        GrpcClient.retrieveStateForCid(client, headers, correlationId);
    }

    private static void runAggregatePackagesClientCancelObserver(GrpcClient client, String correlationId) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("x-cid", correlationId);
        List<String> ids = IntStream.range(0, 10).mapToObj(i -> "id-" + i).collect(Collectors.toList());
        List<String> messages = IntStream.range(0, 10).mapToObj(i -> "message-" + i).collect(Collectors.toList());
        RpcResult<CourierSummary> rpcResult = client.aggregatePackages(headers, ids, "User", messages, 100, messages.size() / 2, CancellationPolicy.OBSERVER, 10000L);
        CourierSummary courierSummary = rpcResult.result();
        client.logFunction.apply("aggregatePackages[success] summary = " + courierSummary);
        Status status = rpcResult.status();
        client.logFunction.apply("aggregatePackages[success] status = " + status);
        GrpcClient.retrieveStateForCid(client, headers, correlationId);
    }

    private static void runAggregatePackagesSendError(GrpcClient client, String correlationId) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("x-cid", correlationId);
        List<String> ids = IntStream.range(0, 10).mapToObj(i -> "id-" + i).collect(Collectors.toList());
        ids.set(5, (String)ids.get(5) + ".SEND_ERROR");
        List<String> messages = IntStream.range(0, 10).mapToObj(i -> "message-" + i).collect(Collectors.toList());
        RpcResult<CourierSummary> rpcResult = client.aggregatePackages(headers, ids, "User", messages, 100, messages.size() + 1, CancellationPolicy.EXCEPTION, 10000L);
        CourierSummary courierSummary = rpcResult.result();
        client.logFunction.apply("aggregatePackages[cancel] summary = " + courierSummary);
        Status status = rpcResult.status();
        client.logFunction.apply("aggregatePackages[cancel] status = " + status);
    }

    private static void runAggregatePackagesExitPreResponse(GrpcClient client, String correlationId) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("x-cid", correlationId);
        List<String> ids = IntStream.range(0, 10).mapToObj(i -> "id-" + i).collect(Collectors.toList());
        ids.set(5, (String)ids.get(5) + ".EXIT_PRE_RESPONSE");
        List<String> messages = IntStream.range(0, 10).mapToObj(i -> "message-" + i).collect(Collectors.toList());
        RpcResult<CourierSummary> rpcResult = client.aggregatePackages(headers, ids, "User", messages, 100, messages.size() + 1, CancellationPolicy.EXCEPTION, 10000L);
        CourierSummary courierSummary = rpcResult.result();
        client.logFunction.apply("aggregatePackages[cancel] summary = " + courierSummary);
        Status status = rpcResult.status();
        client.logFunction.apply("aggregatePackages[cancel] status = " + status);
    }

    public static enum CancellationPolicy {
        CONTEXT{

            @Override
            public void apply(Context.CancellableContext cancellableContext, ClientCallStreamObserver<?> observer, String message) {
                cancellableContext.cancel((Throwable)new RuntimeException(message));
            }
        }
        ,
        EXCEPTION{

            @Override
            public void apply(Context.CancellableContext cancellableContext, ClientCallStreamObserver<?> observer, String message) {
                throw new CancellationException(message);
            }
        }
        ,
        EXIT{

            @Override
            public void apply(Context.CancellableContext cancellableContext, ClientCallStreamObserver<?> observer, String message) {
                System.exit(1);
            }
        }
        ,
        NONE{

            @Override
            public void apply(Context.CancellableContext cancellableContext, ClientCallStreamObserver<?> observer, String message) {
            }
        }
        ,
        OBSERVER{

            @Override
            public void apply(Context.CancellableContext cancellableContext, ClientCallStreamObserver<?> observer, String message) {
                if (observer == null) {
                    throw new IllegalStateException("Cannot cancel when stream observer is missing!");
                }
                StatusRuntimeException error = Status.CANCELLED.withDescription("Observer: " + message).asRuntimeException();
                observer.cancel(message, (Throwable)error);
            }
        };


        public abstract void apply(Context.CancellableContext var1, ClientCallStreamObserver<?> var2, String var3);
    }

    public static final class RpcResult<Result> {
        private final Result result;
        private final Status status;

        private RpcResult(Result result, Status status) {
            this.result = result;
            this.status = status;
        }

        public Result result() {
            return this.result;
        }

        public Status status() {
            return this.status;
        }
    }
}

