/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.waiter.courier;

import com.twosigma.waiter.courier.CourierGrpc;
import com.twosigma.waiter.courier.CourierReply;
import com.twosigma.waiter.courier.CourierRequest;
import com.twosigma.waiter.courier.CourierSummary;
import com.twosigma.waiter.courier.StateRequest;
import com.twosigma.waiter.courier.StateResponse;
import io.grpc.BindableService;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class GrpcServer {
    private static final Logger LOGGER = Logger.getLogger(GrpcServer.class.getName());
    private static final int MAX_STATES_TRACKED = 100;
    private static final Map<String, Map<Long, List<String>>> requestCidToStateList = new LinkedHashMap<String, Map<Long, List<String>>>(101, 0.75f, true){

        @Override
        public boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 100;
        }
    };
    private Server server;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> trackState(String correlationId, long timestamp, String state) {
        if (correlationId != null) {
            Map<String, Map<Long, List<String>>> map = requestCidToStateList;
            synchronized (map) {
                List<Object> stateList;
                if (requestCidToStateList.containsKey(correlationId)) {
                    Map<Long, List<String>> stateEntries = requestCidToStateList.get(correlationId);
                    if (!stateEntries.containsKey(timestamp)) {
                        stateEntries.put(timestamp, new ArrayList());
                    }
                    stateList = stateEntries.get(timestamp);
                } else {
                    stateList = new ArrayList();
                    HashMap stateEntries = new HashMap();
                    stateEntries.put(timestamp, stateList);
                    requestCidToStateList.put(correlationId, stateEntries);
                }
                stateList.add(state);
                return stateList;
            }
        }
        return new ArrayList<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> trackState(String correlationId) {
        Map<String, Map<Long, List<String>>> map = requestCidToStateList;
        synchronized (map) {
            Map<Long, List<String>> stateEntries = requestCidToStateList.get(correlationId);
            if (stateEntries != null && !stateEntries.isEmpty()) {
                ArrayList<Long> timestamps = new ArrayList<Long>(stateEntries.keySet());
                Collections.sort(timestamps);
                Long requestTime = (Long)timestamps.get(0);
                return stateEntries.get(requestTime);
            }
            return new ArrayList<String>();
        }
    }

    void start(int port) throws IOException {
        LOGGER.info("starting gRPC server on port " + port);
        this.server = ServerBuilder.forPort((int)port).addService((BindableService)new CourierImpl()).intercept((ServerInterceptor)new GrpcServerInterceptor()).build().start();
        LOGGER.info("gRPC server started, listening on " + port);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.err.println("*** shutting down gRPC server since JVM is shutting down");
            this.stop();
            System.err.println("*** server shut down");
        }));
    }

    private void stop() {
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
    }

    private static class GrpcServerInterceptor
    implements ServerInterceptor {
        private GrpcServerInterceptor() {
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, final Metadata requestMetadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
            this.logMetadata(requestMetadata, "request");
            final Metadata.Key xCidKey = Metadata.Key.of((String)"x-cid", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
            final String correlationId = (String)requestMetadata.get(xCidKey);
            final long timestamp = System.nanoTime();
            GrpcServer.trackState(correlationId, timestamp, "INIT");
            ForwardingServerCall.SimpleForwardingServerCall wrapperCall = new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(serverCall){

                public void sendHeaders(Metadata responseHeaders) {
                    this.logMetadata(requestMetadata, "response");
                    if (correlationId != null) {
                        LOGGER.info("response linked to cid: " + correlationId);
                        responseHeaders.put(xCidKey, (Object)correlationId);
                        GrpcServer.trackState(correlationId, timestamp, "SEND_HEADERS");
                    }
                    super.sendHeaders(responseHeaders);
                }

                public void sendMessage(RespT response) {
                    GrpcServer.trackState(correlationId, timestamp, "SEND_MESSAGE");
                    super.sendMessage(response);
                }

                public void close(Status status, Metadata trailers) {
                    LOGGER.info("GrpcServerInterceptor.close: " + status + ", " + trailers);
                    GrpcServer.trackState(correlationId, timestamp, "CLOSE");
                    super.close(status, trailers);
                }
            };
            final ServerCall.Listener listener = serverCallHandler.startCall((ServerCall)wrapperCall, requestMetadata);
            return new ServerCall.Listener<ReqT>(){

                public void onMessage(ReqT message) {
                    LOGGER.info("GrpcServerInterceptor.onMessage[cid=" + correlationId + "]");
                    GrpcServer.trackState(correlationId, timestamp, "RECEIVE_MESSAGE");
                    listener.onMessage(message);
                }

                public void onHalfClose() {
                    LOGGER.info("GrpcServerInterceptor.onHalfClose[cid=" + correlationId + "]");
                    GrpcServer.trackState(correlationId, timestamp, "HALF_CLOSE");
                    listener.onHalfClose();
                }

                public void onCancel() {
                    LOGGER.info("GrpcServerInterceptor.onCancel[cid=" + correlationId + "]");
                    List stateList = GrpcServer.trackState(correlationId, timestamp, "CANCEL");
                    listener.onCancel();
                    LOGGER.info(correlationId + " states: " + stateList);
                }

                public void onComplete() {
                    LOGGER.info("GrpcServerInterceptor.onComplete[cid=" + correlationId + "]");
                    List stateList = GrpcServer.trackState(correlationId, timestamp, "COMPLETE");
                    listener.onComplete();
                    LOGGER.info(correlationId + " states: " + stateList);
                }

                public void onReady() {
                    LOGGER.info("GrpcServerInterceptor.onReady[cid=" + correlationId + "]");
                    GrpcServer.trackState(correlationId, timestamp, "READY");
                    listener.onReady();
                }
            };
        }

        private void logMetadata(Metadata metadata, String label) {
            Set metadataKeys = metadata.keys();
            LOGGER.info(label + "@" + metadata.hashCode() + " metadata keys = " + metadataKeys);
            for (String key : metadataKeys) {
                String value = (String)metadata.get(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                LOGGER.info(label + " metadata " + key + " = " + value);
            }
        }
    }

    private static class CourierImpl
    extends CourierGrpc.CourierImplBase {
        private CourierImpl() {
        }

        @Override
        public void sendPackage(CourierRequest request, StreamObserver<CourierReply> responseObserver) {
            LOGGER.info("received CourierRequest{id=" + request.getId() + ", from=" + request.getFrom() + ", message.length=" + request.getMessage().length() + "}");
            if (responseObserver instanceof ServerCallStreamObserver) {
                ((ServerCallStreamObserver)responseObserver).setOnCancelHandler(() -> LOGGER.info("CancelHandler:sendPackage CourierRequest{id=" + request.getId() + "} was cancelled"));
            }
            if (request.getId().contains("SEND_ERROR")) {
                StatusRuntimeException error = Status.CANCELLED.withCause((Throwable)new RuntimeException(request.getId())).withDescription(request.getMessage()).asRuntimeException();
                responseObserver.onError((Throwable)error);
            } else {
                CourierReply reply = CourierReply.newBuilder().setId(request.getId()).setMessage(request.getMessage()).setResponse("received").build();
                LOGGER.info("Sending CourierReply for id=" + reply.getId());
                responseObserver.onNext((Object)reply);
                responseObserver.onCompleted();
            }
        }

        @Override
        public void retrieveState(StateRequest request, StreamObserver<StateResponse> responseObserver) {
            String correlationId = request.getCid();
            LOGGER.info("received StateRequest{cid=" + correlationId + "}");
            if (responseObserver instanceof ServerCallStreamObserver) {
                ((ServerCallStreamObserver)responseObserver).setOnCancelHandler(() -> LOGGER.info("CancelHandler:retrieveState StateRequest{cid=" + correlationId + "} was cancelled"));
            }
            StateResponse.Builder builder = StateResponse.newBuilder().setCid(correlationId);
            List stateList = GrpcServer.trackState(correlationId);
            LOGGER.info("cid " + correlationId + " has states: " + stateList);
            if (stateList != null) {
                for (String state : stateList) {
                    builder.addState(state);
                }
            }
            StateResponse reply = builder.build();
            LOGGER.info("Sending StateResponse for cid=" + reply.getCid());
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }

        @Override
        public StreamObserver<CourierRequest> collectPackages(final StreamObserver<CourierSummary> responseObserver) {
            if (responseObserver instanceof ServerCallStreamObserver) {
                ((ServerCallStreamObserver)responseObserver).setOnCancelHandler(() -> LOGGER.info("CancelHandler:collectPackages() was cancelled"));
            }
            return new StreamObserver<CourierRequest>(){
                private long numMessages = 0L;
                private long totalLength = 0L;

                public void onNext(CourierRequest courierRequest) {
                    LOGGER.info("Received CourierRequest id=" + courierRequest.getId());
                    ++this.numMessages;
                    this.totalLength += (long)courierRequest.getMessage().length();
                    LOGGER.severe("Summary of collected packages: numMessages=" + this.numMessages + " with totalLength=" + this.totalLength);
                    if (courierRequest.getId().contains("EXIT_PRE_RESPONSE")) {
                        this.sleep(1000);
                        LOGGER.info("Exiting server abruptly");
                        System.exit(1);
                    } else if (courierRequest.getId().contains("SEND_ERROR")) {
                        StatusRuntimeException error = Status.CANCELLED.withCause((Throwable)new RuntimeException(courierRequest.getId())).withDescription(courierRequest.getMessage()).asRuntimeException();
                        responseObserver.onError((Throwable)error);
                    } else {
                        CourierSummary courierSummary = CourierSummary.newBuilder().setNumMessages(this.numMessages).setTotalLength(this.totalLength).build();
                        LOGGER.info("Sending CourierSummary for id=" + courierRequest.getId());
                        responseObserver.onNext((Object)courierSummary);
                    }
                    if (courierRequest.getId().contains("EXIT_POST_RESPONSE")) {
                        this.sleep(1000);
                        LOGGER.info("Exiting server abruptly");
                        System.exit(1);
                    }
                }

                private void sleep(int durationMillis) {
                    try {
                        Thread.sleep(durationMillis);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void onError(Throwable throwable) {
                    LOGGER.severe("Error in collecting packages: " + throwable.getMessage());
                    responseObserver.onError(throwable);
                }

                public void onCompleted() {
                    LOGGER.severe("Completed collecting packages");
                    responseObserver.onCompleted();
                }
            };
        }
    }
}

