/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.waiter.courier;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.logging.Logger;

public class HealthCheckServer {
    private static final Logger LOGGER = Logger.getLogger(HealthCheckServer.class.getName());

    void start(int port) throws IOException {
        LOGGER.info("starting health check server on port " + port);
        InetSocketAddress address = new InetSocketAddress(port);
        HttpServer server = HttpServer.create(address, 0);
        server.createContext("/status", new HealthCheckHandler());
        server.setExecutor(null);
        server.start();
        LOGGER.info("health check server started, listening on " + port);
    }

    private static class HealthCheckHandler
    implements HttpHandler {
        private HealthCheckHandler() {
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            String correlationId = httpExchange.getRequestHeaders().getFirst("x-cid");
            LOGGER.info(correlationId + " received health check request");
            Headers responseHeaders = httpExchange.getResponseHeaders();
            responseHeaders.add("content-type", "text/plain");
            responseHeaders.add("server", "courier-health-check/jdk" + System.getProperty("java.version"));
            if (correlationId != null) {
                responseHeaders.add("x-cid", correlationId);
            }
            String response = "OK";
            httpExchange.sendResponseHeaders(200, "OK".length());
            OutputStream os = httpExchange.getResponseBody();
            os.write("OK".getBytes());
            os.close();
            LOGGER.info(correlationId + " responded with 200 OK");
        }
    }
}

