/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.waiter.courier;

import com.twosigma.waiter.courier.CourierGrpc;
import com.twosigma.waiter.courier.CourierReply;
import com.twosigma.waiter.courier.CourierRequest;
import com.twosigma.waiter.courier.CourierSummary;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class GrpcClient {
    private static final Logger LOGGER = Logger.getLogger(GrpcClient.class.getName());

    private static ManagedChannel initializeChannel(String host, int port) {
        LOGGER.info("initializing plaintext client at " + host + ":" + port);
        return ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build();
    }

    private static void shutdownChannel(ManagedChannel channel) throws InterruptedException {
        LOGGER.info("shutting down channel");
        channel.shutdown().awaitTermination(1L, TimeUnit.SECONDS);
        LOGGER.info("channel shutdown successfully");
    }

    private static Metadata attachRequestHeaders(Map<String, Object> headers) {
        Metadata headerMetadata = new Metadata();
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            String key = entry.getKey();
            String value = String.valueOf(entry.getValue());
            headerMetadata.put(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)value);
        }
        return headerMetadata;
    }

    private static Channel wrapResponseLogger(ManagedChannel channel) {
        return ClientInterceptors.intercept((Channel)channel, (ClientInterceptor[])new ClientInterceptor[]{new ClientInterceptor(){

            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                    public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                        super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                            public void onHeaders(Metadata headers) {
                                this.logMetadata(headers, "headers");
                                super.onHeaders(headers);
                            }

                            public void onClose(Status status, Metadata trailers) {
                                LOGGER.info("status received from server:" + status);
                                this.logMetadata(trailers, "trailers");
                                super.onClose(status, trailers);
                            }

                            private void logMetadata(Metadata metadata, String label) {
                                Set metadataKeys = metadata.keys();
                                LOGGER.info(label + " metadata keys = " + metadataKeys);
                                for (String key : metadataKeys) {
                                    String value = (String)metadata.get(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                                    LOGGER.info(label + " metadata " + key + " = " + value);
                                }
                            }
                        }, headers);
                    }
                };
            }
        }});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static CourierReply sendPackage(String host, int port, Map<String, Object> headers, String id, String from, String message) throws InterruptedException {
        ManagedChannel channel = GrpcClient.initializeChannel(host, port);
        try {
            CourierReply response;
            Channel wrappedChannel = GrpcClient.wrapResponseLogger(channel);
            Metadata headerMetadata = GrpcClient.attachRequestHeaders(headers);
            CourierGrpc.CourierFutureStub rawStub = CourierGrpc.newFutureStub(wrappedChannel);
            CourierGrpc.CourierFutureStub futureStub = (CourierGrpc.CourierFutureStub)MetadataUtils.attachHeaders((AbstractStub)rawStub, (Metadata)headerMetadata);
            LOGGER.info("will try to send package from " + from + " ...");
            CourierRequest request = CourierRequest.newBuilder().setId(id).setFrom(from).setMessage(message).build();
            try {
                response = (CourierReply)futureStub.sendPackage(request).get();
            }
            catch (StatusRuntimeException e) {
                LOGGER.log(Level.WARNING, "RPC failed, status: {0}", e.getStatus());
                CourierReply courierReply = null;
                GrpcClient.shutdownChannel(channel);
                return courierReply;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "RPC failed, message: {0}", e.getMessage());
                CourierReply courierReply = null;
                GrpcClient.shutdownChannel(channel);
                return courierReply;
            }
            LOGGER.info("received response CourierReply{id=" + response.getId() + ", response=" + response.getResponse() + ", message.length=" + response.getMessage().length() + "}");
            LOGGER.info("messages equal = " + message.equals(response.getMessage()));
            CourierReply courierReply = response;
            return courierReply;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            GrpcClient.shutdownChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static CourierSummary collectPackages(String host, int port, Map<String, Object> headers, String idPrefix, String from, List<String> messages, int interMessageSleepMs) throws InterruptedException {
        ManagedChannel channel = GrpcClient.initializeChannel(host, port);
        try {
            Channel wrappedChannel = GrpcClient.wrapResponseLogger(channel);
            Metadata headerMetadata = GrpcClient.attachRequestHeaders(headers);
            CourierGrpc.CourierStub rawStub = CourierGrpc.newStub(wrappedChannel);
            CourierGrpc.CourierStub futureStub = (CourierGrpc.CourierStub)MetadataUtils.attachHeaders((AbstractStub)rawStub, (Metadata)headerMetadata);
            LOGGER.info("will try to send package from " + from + " ...");
            final CompletableFuture responsePromise = new CompletableFuture();
            try {
                StreamObserver<CourierRequest> collector = futureStub.collectPackages(new StreamObserver<CourierSummary>(){
                    private long numMessages = 0L;
                    private long totalLength = 0L;

                    public void onNext(CourierSummary response) {
                        LOGGER.info("received response CourierReply{count=" + response.getNumMessages() + ", length=" + response.getTotalLength() + "}");
                        this.numMessages += response.getNumMessages();
                        this.totalLength += response.getTotalLength();
                    }

                    public void onError(Throwable throwable) {
                        LOGGER.info("error in collecting summaries " + throwable);
                        responsePromise.complete(null);
                    }

                    public void onCompleted() {
                        LOGGER.info("completed collecting summaries");
                        responsePromise.complete(CourierSummary.newBuilder().setNumMessages(this.numMessages).setTotalLength(this.totalLength).build());
                    }
                });
                for (int i = 0; i < messages.size(); ++i) {
                    CourierRequest request = CourierRequest.newBuilder().setId(idPrefix + i).setFrom(from).setMessage(messages.get(i)).build();
                    collector.onNext((Object)request);
                    Thread.sleep(interMessageSleepMs);
                }
                LOGGER.info("completed sending packages");
                collector.onCompleted();
                CourierSummary courierSummary = (CourierSummary)responsePromise.get();
                return courierSummary;
            }
            catch (StatusRuntimeException e) {
                LOGGER.log(Level.WARNING, "RPC failed, status: {0}", e.getStatus());
                CourierSummary courierSummary = null;
                GrpcClient.shutdownChannel(channel);
                return courierSummary;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "RPC failed, message: {0}", e.getMessage());
                CourierSummary courierSummary = null;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                GrpcClient.shutdownChannel(channel);
                return courierSummary;
            }
        }
        finally {
            GrpcClient.shutdownChannel(channel);
        }
    }

    public static void main(String ... args) throws Exception {
        String host = "localhost";
        int port = 8080;
        HashMap<String, Object> headers = new HashMap<String, Object>();
        String id = UUID.randomUUID().toString();
        String user = "Jim";
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < 100000; ++i2) {
            sb.append("a");
            if (i2 % 1000 != 0) continue;
            sb.append(".");
        }
        CourierReply courierReply = GrpcClient.sendPackage("localhost", 8080, headers, id, "Jim", sb.toString());
        System.out.println("sendPackage response = " + courierReply);
        List<String> messages = IntStream.range(0, 100).mapToObj(i -> "message-" + i).collect(Collectors.toList());
        CourierSummary courierSummary = GrpcClient.collectPackages("localhost", 8080, headers, "id-", "Jim", messages, 10);
        System.out.println("collectPackages response = " + courierSummary);
    }
}

