/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.cook.jobclient.constraint;

import com.google.common.base.Preconditions;
import com.twosigma.cook.jobclient.constraint.Constraint;
import com.twosigma.cook.jobclient.constraint.OneToOneConstraint;
import com.twosigma.cook.jobclient.constraint.Operator;
import org.json.JSONArray;
import org.json.JSONException;

public class Constraints {
    public static Constraint buildEqualsConstraint(String attribute, String value) {
        return new OneToOneConstraint(Operator.EQUALS, attribute, value);
    }

    public static Constraint parseFrom(JSONArray constraint) throws JSONException {
        Operator operator = Operator.fromString(constraint.getString(1));
        switch (operator) {
            case EQUALS: {
                Preconditions.checkArgument((constraint.length() == 3 ? 1 : 0) != 0, (Object)"The constraint must be form of [<attribute>, <operator>, <value>]");
                return new OneToOneConstraint(operator, constraint.getString(0), constraint.getString(2));
            }
        }
        throw new UnsupportedOperationException((Object)((Object)operator) + " is not supported.");
    }
}

