/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.cook.jobclient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.twosigma.cook.jobclient.InstanceDecorator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class StragglerHandling {
    private final Type _type;
    private final Map<String, Object> _parameters;

    private StragglerHandling(Type type, Map<String, Object> parameters) {
        this._type = type;
        this._parameters = ImmutableMap.copyOf(parameters);
    }

    public Type getType() {
        return this._type;
    }

    public Map<String, Object> getParameters() {
        return this._parameters;
    }

    public Object getParameter(String name) {
        return this._parameters.get(name);
    }

    public static JSONObject jsonize(StragglerHandling sh) throws JSONException {
        JSONObject object = new JSONObject();
        object.put("type", (Object)sh.getType().toString().toLowerCase());
        object.put("parameters", sh.getParameters());
        return object;
    }

    public static StragglerHandling parseFromJSON(JSONObject shJson, InstanceDecorator decorator) throws JSONException {
        Builder shBuilder = new Builder();
        String type = shJson.getString("type");
        shBuilder.setType(Type.fromString(type.toUpperCase()));
        if (shJson.has("parameters")) {
            JSONObject paramJson = shJson.getJSONObject("parameters");
            Iterator names = paramJson.keys();
            while (names.hasNext()) {
                String name = (String)names.next();
                shBuilder.setParameter(name, paramJson.get(name));
            }
        }
        return shBuilder.build();
    }

    public String toString() {
        return "StragglerHandling [_type=" + (Object)((Object)this._type) + ", _parameters=" + this._parameters.toString() + "]" + '\n';
    }

    public static enum Type {
        NONE("NONE"),
        QUANTILE_DEVIATION("QUANTILE-DEVIATION");

        private final String name;
        private static final Map<String, Type> lookup;

        private Type(String name) {
            this.name = name;
        }

        public static Type fromString(String name) {
            return lookup.get(name);
        }

        public String toString() {
            return this.name;
        }

        static {
            lookup = new HashMap<String, Type>();
            for (Type type : Type.values()) {
                lookup.put(type.name, type);
            }
        }
    }

    public static class Builder {
        private Type _type;
        private Map<String, Object> _parameters = new HashMap<String, Object>();

        public StragglerHandling build() {
            if (this._type == null) {
                this._type = Type.fromString("NONE");
            } else if (this._type == Type.QUANTILE_DEVIATION) {
                Preconditions.checkNotNull((Object)this._parameters.get("quantile"), (Object)"quantile parameter is required with type quantile-deviation");
                Preconditions.checkNotNull((Object)this._parameters.get("multiplier"), (Object)"multiplier parameter is required with type quantile-deviation");
            }
            return new StragglerHandling(this._type, this._parameters);
        }

        public Builder of(StragglerHandling sh) {
            this.setType(sh.getType());
            this.setParameters(sh.getParameters());
            return this;
        }

        public Builder setType(Type type) {
            this._type = type;
            return this;
        }

        public Builder setParameters(Map<String, Object> parameters) {
            this._parameters = ImmutableMap.copyOf(parameters);
            return this;
        }

        public Builder setParameter(String name, Object val) {
            this._parameters.put(name, val);
            return this;
        }
    }
}

