/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.cook.jobclient;

import com.google.common.base.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;

public final class FetchableURI {
    private final String _value;
    private final boolean _cache;
    private final boolean _extract;
    private final boolean _executable;

    private FetchableURI(String value, boolean cache, boolean extract, boolean executable) {
        this._value = value;
        this._cache = cache;
        this._extract = extract;
        this._executable = executable;
    }

    public String getValue() {
        return this._value;
    }

    public boolean isCache() {
        return this._cache;
    }

    public boolean isExecutable() {
        return this._executable;
    }

    public boolean isExtract() {
        return this._extract;
    }

    public static JSONObject jsonizeUri(FetchableURI uri) throws JSONException {
        JSONObject object = new JSONObject();
        object.put("value", (Object)uri.getValue());
        object.put("executable", uri.isExecutable());
        object.put("extract", uri.isExtract());
        object.put("cache", uri.isCache());
        return object;
    }

    public static FetchableURI parseFromJSON(JSONObject object) throws JSONException {
        Builder builder = new Builder();
        builder.setValue(object.getString("value"));
        builder.setExtract(object.getBoolean("extract"));
        builder.setExecutable(object.getBoolean("executable"));
        builder.setCache(object.getBoolean("cache"));
        return builder.build();
    }

    public String toString() {
        return "FetchableURI [_value=" + this._value + ", _extract=" + this._extract + ", _executable=" + this._executable + ", _cache=" + this._cache + "]";
    }

    public int hashCode() {
        int prime = 37;
        int result = 1;
        result = 37 * result + this._value.hashCode();
        result = 37 * result + (this._extract ? 0 : 1);
        result = 37 * result + (this._executable ? 0 : 3);
        result = 37 * result + (this._cache ? 0 : 5);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        FetchableURI other = (FetchableURI)obj;
        if (this._extract != other._extract) {
            return false;
        }
        if (this._executable != other._executable) {
            return false;
        }
        if (this._cache != other._cache) {
            return false;
        }
        return this._value.equals(other._value);
    }

    public static class Builder {
        private String _value;
        private boolean _cache = false;
        private boolean _extract = true;
        private boolean _executable = false;

        public FetchableURI build() {
            Preconditions.checkNotNull((Object)this._value, (Object)"value must be set");
            Preconditions.checkArgument((!this._executable || !this._extract ? 1 : 0) != 0, (Object)"URI cannot be executable and extracted");
            return new FetchableURI(this._value, this._cache, this._extract, this._executable);
        }

        public Builder of(FetchableURI uri) {
            this.setValue(uri.getValue());
            this.setCache(uri.isCache());
            this.setExtract(uri.isExtract());
            this.setExecutable(uri.isExecutable());
            return this;
        }

        public Builder setValue(String value) {
            this._value = value;
            return this;
        }

        public Builder setCache(boolean cache) {
            this._cache = cache;
            return this;
        }

        public Builder setExtract(boolean extract) {
            this._extract = extract;
            return this;
        }

        public Builder setExecutable(boolean executable) {
            this._executable = executable;
            return this;
        }
    }
}

