/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.cook.jobclient;

import com.google.common.base.Preconditions;
import com.twosigma.cook.jobclient.Executor;
import com.twosigma.cook.jobclient.InstanceDecorator;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Instance {
    private final UUID _taskID;
    private final String _slaveID;
    private final String _executorID;
    private final Long _startTime;
    private final Long _endTime;
    private final Status _status;
    private final Integer _progress;
    private final String _progressMessage;
    private final Long _reasonCode;
    private final Boolean _preempted;
    private final String _outputURL;
    private final String _hostName;
    private final Executor _executor;
    private final Boolean _reasonMeaCulpa;
    private final String _reasonString;

    private Instance(UUID taskID, String slaveID, String executorID, Long startTime, Long endTime, Status status, Integer progress, String progressMessage, Long reasonCode, Boolean preempted, String outputURL, String hostName, Executor executor, Boolean reasonMeaCulpa, String reasonString) {
        this._taskID = taskID;
        this._slaveID = slaveID;
        this._executorID = executorID;
        this._startTime = startTime;
        this._endTime = endTime;
        this._status = status;
        this._progress = progress;
        this._progressMessage = progressMessage;
        this._reasonCode = reasonCode;
        this._preempted = preempted;
        this._outputURL = outputURL;
        this._hostName = hostName;
        this._executor = executor;
        this._reasonMeaCulpa = reasonMeaCulpa;
        this._reasonString = reasonString;
    }

    public static List<Instance> parseFromJSON(String listOfInstances) throws JSONException {
        return Instance.parseFromJSON(new JSONArray(listOfInstances));
    }

    public static List<Instance> parseFromJSON(JSONArray listOfInstances, InstanceDecorator decorator) throws JSONException {
        ArrayList<Instance> instances = new ArrayList<Instance>(listOfInstances.length());
        for (int i = 0; i < listOfInstances.length(); ++i) {
            JSONObject json = listOfInstances.getJSONObject(i);
            Builder instanceBuilder = new Builder();
            instanceBuilder.setTaskID(UUID.fromString(json.getString("task_id")));
            instanceBuilder.setSlaveID(json.getString("slave_id"));
            instanceBuilder.setExecutorID(json.getString("executor_id"));
            instanceBuilder.setHostName(json.getString("hostname"));
            if (json.has("executor")) {
                instanceBuilder.setExecutor(json.getString("executor"));
            }
            instanceBuilder.setStatus(Status.fromString(json.getString("status")));
            if (json.has("progress")) {
                instanceBuilder.setProgress(json.getInt("progress"));
            }
            if (json.has("progress_message")) {
                instanceBuilder.setProgressMessage(json.getString("progress_message"));
            }
            instanceBuilder.setPreempted(json.getBoolean("preempted"));
            instanceBuilder.setStartTime(json.getLong("start_time"));
            if (json.has("end_time")) {
                instanceBuilder.setEndTime(json.getLong("end_time"));
            }
            if (json.has("output_url")) {
                instanceBuilder.setOutputURL(json.getString("output_url"));
            }
            if (json.has("reason_code")) {
                instanceBuilder.setReasonCode(json.getLong("reason_code"));
            }
            if (json.has("reason_mea_culpa")) {
                instanceBuilder.setReasonMeaCulpa(json.getBoolean("reason_mea_culpa"));
            }
            if (json.has("reason_string")) {
                instanceBuilder.setReasonString(json.getString("reason_string"));
            }
            if (decorator != null) {
                instanceBuilder = decorator.decorate(instanceBuilder);
            }
            Instance instance = instanceBuilder.build();
            instances.add(instance);
        }
        return instances;
    }

    public static List<Instance> parseFromJSON(JSONArray listOfInstances) throws JSONException {
        return Instance.parseFromJSON(listOfInstances, null);
    }

    public String toString() {
        return "Instance [_taskID=" + this._taskID + ", _slaveID=" + this._slaveID + ", _executorID=" + this._executorID + ", _startTime=" + this._startTime + ", _endTime=" + this._endTime + ", _status=" + (Object)((Object)this._status) + ", _progress=" + this._progress + ", _progressMessage=" + this._progressMessage + ", _reasonCode=" + this._reasonCode + ", _preempted=" + this._preempted + ", _outputURL=" + this._outputURL + ", _hostName=" + this._hostName + ", _executor=" + (Object)((Object)this._executor) + ", _reasonMeaCulpa=" + this._reasonMeaCulpa + ", _reasonString=" + this._reasonString + "]";
    }

    public UUID getTaskID() {
        return this._taskID;
    }

    public String getSlaveID() {
        return this._slaveID;
    }

    public String getExecutorID() {
        return this._executorID;
    }

    public Long getStartTime() {
        return this._startTime;
    }

    public Long getEndTime() {
        return this._endTime;
    }

    public Status getStatus() {
        return this._status;
    }

    public Integer getProgress() {
        return this._progress;
    }

    public String getProgressMessage() {
        return this._progressMessage;
    }

    public Long getReasonCode() {
        return this._reasonCode;
    }

    public String getReasonString() {
        return this._reasonString;
    }

    public Boolean getPreempted() {
        return this._preempted;
    }

    public String getOutputURL() {
        return this._outputURL;
    }

    public String getHostName() {
        return this._hostName;
    }

    public Executor getExecutor() {
        return this._executor;
    }

    public Boolean getReasonMeaCulpa() {
        return this._reasonMeaCulpa;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._status == null ? 0 : this._status.hashCode());
        result = 31 * result + (this._taskID == null ? 0 : this._taskID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        Instance other = (Instance)obj;
        if (this._status != other._status) {
            return false;
        }
        return !(this._taskID == null ? other._taskID != null : !this._taskID.equals(other._taskID));
    }

    public static class Builder {
        private UUID _taskID;
        private String _slaveID;
        private String _executorID;
        private Long _startTime;
        private Long _endTime;
        private Status _status;
        private Integer _progress;
        private String _progressMessage;
        private Long _reasonCode;
        private Boolean _preempted;
        private String _outputURL;
        private String _hostName;
        private Executor _executor;
        private Boolean _reasonMeaCulpa;
        private String _reasonString;

        public Instance build() {
            Preconditions.checkNotNull((Object)this._taskID, (Object)"TaskID can not be null!");
            if (this._status == null) {
                this._status = Status.UNKNOWN;
            }
            return new Instance(this._taskID, this._slaveID, this._executorID, this._startTime, this._endTime, this._status, this._progress, this._progressMessage, this._reasonCode, this._preempted, this._outputURL, this._hostName, this._executor, this._reasonMeaCulpa, this._reasonString);
        }

        public Builder setTaskID(UUID uuid) {
            Preconditions.checkNotNull((Object)uuid, (Object)"TaskID can not be null!");
            this._taskID = uuid;
            return this;
        }

        public Builder setSlaveID(String slaveID) {
            this._slaveID = slaveID;
            return this;
        }

        public Builder setExecutorID(String executorID) {
            this._executorID = executorID;
            return this;
        }

        public Builder setStartTime(Long startTime) {
            this._startTime = startTime;
            return this;
        }

        public Builder setEndTime(Long endTime) {
            this._endTime = endTime;
            return this;
        }

        public Builder setStatus(Status status) {
            this._status = status;
            return this;
        }

        public Builder setProgress(Integer progress) {
            this._progress = progress;
            return this;
        }

        public Builder setProgressMessage(String progressMessage) {
            this._progressMessage = progressMessage;
            return this;
        }

        public Builder setReasonCode(Long reasonCode) {
            this._reasonCode = reasonCode;
            return this;
        }

        public Builder setReasonString(String reasonString) {
            this._reasonString = reasonString;
            return this;
        }

        public Builder setPreempted(Boolean preempted) {
            this._preempted = preempted;
            return this;
        }

        public Builder setOutputURL(String outputURL) {
            this._outputURL = outputURL;
            return this;
        }

        public Builder setHostName(String hostName) {
            this._hostName = hostName;
            return this;
        }

        public Builder setExecutor(String executor) {
            return this.setExecutor(Executor.fromString(executor));
        }

        public Builder setExecutor(Executor executor) {
            this._executor = executor;
            return this;
        }

        public Builder setReasonMeaCulpa(Boolean meaCulpa) {
            this._reasonMeaCulpa = meaCulpa;
            return this;
        }

        public UUID getTaskID() {
            return this._taskID;
        }

        public String getSlaveID() {
            return this._slaveID;
        }

        public String getExecutorID() {
            return this._executorID;
        }

        public Long getStartTime() {
            return this._startTime;
        }

        public Long getEndTime() {
            return this._endTime;
        }

        public Status getStatus() {
            return this._status;
        }

        public Integer getProgress() {
            return this._progress;
        }

        public String getProgressMessage() {
            return this._progressMessage;
        }

        public String getOutputURL() {
            return this._outputURL;
        }

        public String getHostName() {
            return this._hostName;
        }

        public Executor getExecutor() {
            return this._executor;
        }

        public Boolean getReasonMeaCulpa() {
            return this._reasonMeaCulpa;
        }
    }

    public static enum Status {
        UNKNOWN("UNKNOWN"),
        RUNNING("RUNNING"),
        SUCCESS("SUCCESS"),
        FAILED("FAILED");


        private Status(String name) {
        }

        public static Status fromString(String name) {
            return Enum.valueOf(Status.class, name.trim().toUpperCase());
        }
    }
}

