/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.cook.jobclient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.twosigma.cook.jobclient.InstanceDecorator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class HostPlacement {
    private final Type _type;
    private final Map<String, String> _parameters;

    private HostPlacement(Type type, Map<String, String> parameters) {
        this._type = type;
        this._parameters = ImmutableMap.copyOf(parameters);
    }

    public Type getType() {
        return this._type;
    }

    public Map<String, String> getParameters() {
        return this._parameters;
    }

    public String getParameters(String name) {
        return this._parameters.get(name);
    }

    public static JSONObject jsonize(HostPlacement hp) throws JSONException {
        JSONObject object = new JSONObject();
        object.put("type", (Object)hp.getType().toString().toLowerCase());
        object.put("parameters", hp.getParameters());
        return object;
    }

    public static HostPlacement parseFromJSON(JSONObject hpJson, InstanceDecorator decorator) throws JSONException {
        Builder hpBuilder = new Builder();
        String type = hpJson.getString("type");
        hpBuilder.setType(Type.fromString(type.substring(type.lastIndexOf("/") + 1).toUpperCase()));
        if (hpJson.has("parameters")) {
            JSONObject paramJson = hpJson.getJSONObject("parameters");
            Iterator names = paramJson.keys();
            while (names.hasNext()) {
                String name = (String)names.next();
                hpBuilder.setParameter(name, paramJson.getString(name));
            }
        }
        return hpBuilder.build();
    }

    public String toString() {
        return "HostPlacement [_type=" + (Object)((Object)this._type) + ", _parameters=" + this._parameters.toString() + "]" + '\n';
    }

    public static class Builder {
        private Type _type;
        private Map<String, String> _parameters = new HashMap<String, String>();

        public HostPlacement build() {
            if (this._type == null) {
                this._type = Type.fromString("ALL");
            } else if (this._type == Type.ATTRIBUTE_EQUALS) {
                Preconditions.checkNotNull((Object)this._parameters.get("attribute"), (Object)"attribute parameter is required with type attribute-equals");
            }
            return new HostPlacement(this._type, this._parameters);
        }

        public Builder of(HostPlacement hp) {
            this.setType(hp.getType());
            this.setParameters(hp.getParameters());
            return this;
        }

        public Builder setType(Type type) {
            this._type = type;
            return this;
        }

        public Builder setParameters(Map<String, String> parameters) {
            this._parameters = ImmutableMap.copyOf(parameters);
            return this;
        }

        public Builder setParameter(String name, String val) {
            this._parameters.put(name, val);
            return this;
        }
    }

    public static enum Type {
        UNIQUE("UNIQUE"),
        BALANCED("BALANCED"),
        ONE("ONE"),
        ATTRIBUTE_EQUALS("ATTRIBUTE-EQUALS"),
        ALL("ALL");

        private final String name;
        private static final Map<String, Type> lookup;

        private Type(String name) {
            this.name = name;
        }

        public static Type fromString(String name) {
            return lookup.get(name);
        }

        public String toString() {
            return this.name;
        }

        static {
            lookup = new HashMap<String, Type>();
            for (Type type : Type.values()) {
                lookup.put(type.name, type);
            }
        }
    }
}

