(ns bikeshed-runner.cmdline
  (:require [clojure.tools.cli :as tools-cli]
            [bikeshed-runner.utils :refer [exit parse-paths printseq validate-paths]])
  (:gen-class))

#_(+ 1 1)

(def cli-options
  [["-p" "--paths PATH1,PATH2,..." "File or directory paths to be scanned (default is: .)"
    :default (parse-paths ".")
    :parse-fn parse-paths
    :validate [validate-paths "Paths must exist"]]
   ["-h" "--help"]])

(defn bikeshed-fn
  [& args]
  true)

(defn -main
  [& args]
  (let [{:keys [options arguments summary errors]} (tools-cli/parse-opts args cli-options)]
    (cond
      (:help options) (do (println summary) (exit 0))
      errors (do (printseq (into errors [summary])) (exit 1)))
    (apply (partial bikeshed-fn (:paths options) nil) arguments)))
