(ns tusk.coerce
  (:require
   [tusk.util :as u])
  (:import
   ;; [org.postgresql.jdbc PgArray]
   [org.postgresql.util
    PGobject]))

(defn pg-object
  [v t]
  (doto (PGobject.)
    (.setType t)
    (.setValue v)))

(defn parameter-name
  [stmt idx]
  (some-> stmt
          (.getParameterMetaData)
          (.getParameterTypeName idx)))

(defn coerce
  [from to]
  [from (u/ident-key to)])

(defmulti coerce (fn [val conn dispatch] dispatch))

;; [:vector _]
;; [:set _]
;; [:map _]
;; [:keyword _]

(defmethod coerce :default
  [val conn dispatch]
  val)
