(ns tusk.core.types.range
  ;; (:require )
  ;; (:import )
  )

(defn read-with
  "takes a string representing a postgres range
  and returns a map with the keys"
  [rng read-val]
  (let [inclusive? #(condp = %
                      "(" false
                      ")" false
                      "[" true
                      "]" true
                      nil)
        parse      #(when-not (empty? %)
                      (read-val %))
        [_ lower-cap lower upper upper-cap]
        (re-matches #"(\[|\()([^,]+),([^,]+)(\]|\))" rng)]
    {:lower-inc? (inclusive? lower-cap)
     :lower      (parse lower)
     :upper      (parse upper)
     :upper-inc? (inclusive? upper-cap)}))

(defn read-int4range
  [r]
  (read-with r #(Integer. %)))

(defn read-int8range
  [r]
  (read-with r #(Long. %)))

(defn read-numrange
  [r]
  (read-with r #(BigDecimal. %)))

(defn read-tsrange
  [r]
  (read-with r #(java.sql.Time. %)))

(defn read-tstzrange
  [r]
  (read-with r #(java.sql.Time. %)))

(defn read-daterange
  [r]
  (read-with r #(java.sql.Date. %)))
