(ns tusk.tusk-core.types.json
  (:require
   [tusk.tusk-core.util :as u]
   [clojure.data.json :as json]))

(defn ^:dynamic
  *encode-json*
  [c]
  (json/write-str c))

(defn ^:dynamic
  *decode-json*
  [s]
  (json/read-str s))

(defn pg-json
  [v]
  (u/pg-object (*encode-json* v) "json"))

(defn pg-jsonb
  [v]
  (u/pg-object (*encode-json* v) "jsonb"))
