(ns tusk.types.json
  (:require
   [tusk
    [core :as c]
    [util :as u]]
   [tusk.types.clojure :as clj]
   [clojure.data.json :as json]))

(defn ^:dynamic
  *encode-json*
  [c]
  (json/write-str c))

(defn ^:dynamic
  *decode-json*
  [s]
  (json/read-str s))

(defmethod c/coerce [::clj/collection  :json] [m _] (*encode-json* m))
(defmethod c/coerce [::clj/collection :jsonb] [m _] (*encode-json* m))
(defmethod c/read :json [m _] (*decode-json* m))
(defmethod c/read :jsonb [m _] (*decode-json* m))
