(ns tusk.types.enum
  (:refer-clojure :exclude [> >= < <=])
  (:require
   [clojure.core :as clj])
  #_(:import ))

(defn ^:private
  enum-compare
  [pred]
  (fn [m & args]
     (apply pred (map m args))))

(def >
  (enum-compare clj/>))

(def >=
  (enum-compare clj/>=))

(def <
  (enum-compare clj/<))

(def <=
  (enum-compare clj/<=))
