(ns tusk.types.clojure
  (:require
   [tusk
    [util :as u]])
  (:import
   [clojure.lang
    IObj
    Keyword
    BigInt
    PersistentHashSet
    PersistentVector
    PersistentList
    PersistentList$EmptyList
    PersistentHashMap
    PersistentArrayMap]))

(def hierarchy-tree
  {::generic {::collection {::map        {::hash-map  PersistentHashMap
                                          ::array-map PersistentArrayMap}
                            ::sequential {::vector PersistentVector
                                          ::list   {PersistentList           nil
                                                    PersistentList$EmptyList nil}}
                            ::set        PersistentHashSet}
              ::number     {::integer Integer
                            ::float   Float
                            ::short   Short
                            ::long    Long
                            ::double  Double
                            ::bigint  BigInt
                            ::bigdec  BigDecimal}
              ::named      {::string  String
                            ::keyword Keyword}}})

(u/set-hierarchy hierarchy-tree)

(defn vector-dispatch
  [v stmt index]
  (condp re-matches (u/parameter-name stmt index)
    #"^_(.*)$" :>> #(vector true (second %))
    #"^.*$"    :>> #(vector false %)
    [false nil]))
