(ns tusk.types.array
  (:import
   [java.sql
    Date
    Time
    Timestamp]
   [org.postgresql.util
    PGInterval]))

(def ^:private brackets
  #(apply str (repeat % (first "[]"))))

(def base-class-names
  (let [base-types   (mapv #(str (brackets 1) (name %))
                           [:S   ;; short
                            :I   ;; int
                            :J   ;; long
                            :F   ;; float
                            :D   ;; double
                            :B   ;; byte
                            :C   ;; char
                            :Z]) ;; boolean
        object-types (mapv #(str "L" (.getName %) ";")
                           [String
                            Integer
                            Float
                            Short
                            Long
                            Double
                            BigDecimal])]
    (into base-types object-types)))

(defn array-class
  [class-name depth]
  (Class/forName (str (brackets depth) (name class-name))))

(defn array-classes
  [class-names max-depth]
  (for [n class-names
        d (range 1 (inc max-depth))]
    (array-class n d)))

(def default-classes
  (array-classes base-class-names 2))

(defrecord PgArray [pg-type vector])

(defn pg-array
  [pg-type coll]
  (->PgArray pg-type coll))

(defn into-nested-array
  ([v] (into-nested-array identity v))
  ([coerce v]
   (let [build (fn loop-on [a]
                 (if (sequential? a)
                   (into-array (map loop-on a))
                   (coerce a)))]
     (build v))))
