(ns tusk.core
  (:refer-clojure :exclude [read])
  (:require
   [tusk.util :as u]))

(defmulti coerce (fn [value {:keys [from to] :as config}]
                   [(or (u/ident-key from)
                        (type value))
                    (u/ident-key to)]))

(defmulti read (fn [value config]
                 (-> config :from u/ident-key)))
