(ns tusk.types.json
  (:require
   [tusk
    [core :as c]
    [util :as u]]
   [tusk.types.clojure :as clj]
   [clojure.data.json :as json]))

(defn ^:dynamic
  *encode-json*
  [c]
  (json/write-str c))

(defn ^:dynamic
  *decode-json*
  [s]
  (json/read-str s))

(defmethod c/coerce [::clj/collection  :json] [m _] (*encode-json* m))
(defmethod c/coerce [::clj/collection :jsonb] [m _] (*encode-json* m))
(defmethod c/coerce [:json  ::clj/collection] [m _] (*decode-json* m))
(defmethod c/coerce [:jsonb ::clj/collection] [m _] (*decode-json* m))
