(ns tusk.types
  (:require
   [tusk
    [core :as c]
    [util :as u]])
  (:import
   [org.postgresql.geometric
    PGpoint
    PGlseg
    PGbox
    PGpath
    PGpolygon
    PGcircle]
   [java.sql
    Date
    Time
    Timestamp]
   [org.postgresql.util
    PGInterval]))

(defn sql-int2
  [d]
  (cond
    (string? d) (Integer. d)
    (number? d) (int d)
    :else       (throw (ex-info "cannot cast to int4"
                                {:value d}))))

(def sql-int4 #'sql-int2)

(defn sql-int8
  [d]
  (cond
    (string? d) (Long. d)
    (number? d) (long d)
    :else       (throw (ex-info "cannot cast to int8"
                                {:value d}))))

(def sql-numeric #'bigint)
(def sql-decimal #'bigint)

(defn sql-date
  [d]
  (cond
    (instance? java.sql.Date d) d
    (string? d)                 (Date/valueOf d)
    (integer? d)                (Date. (long d))
    :else                       (-> "cannot cast to java.sql.Date"
                                    (ex-info {:value d})
                                    (throw))))

(defn sql-tstz
  [d]
  (cond
    (instance? java.sql.Time d) d
    (string? d)                 (Time/valueOf d)
    (integer? d)                (Time. (long d))
    :else                       (-> "cannot cast to java.sql.Time"
                                    (ex-info {:value d})
                                    (throw))))

;;;; https://www.postgresql.org/message-id/AANLkTinsk4rwT7v-751bwQkgTN1rkA=8uE-jk69nape-@mail.gmail.com
;; (def lookup
;;   (let [ByteArray (type (byte-array 1))]
;;     (set
;;      (for [[pg j] [
;;                    {:int2        Integer
;;                     :int4        Integer
;;                     :int8        Long
;;                     :decimal     BigDecimal
;;                     :numeric     BigDecimal
;;                     :float4      Float
;;                     :float8      Double
;;                     ;; :int8        Long
;;                     :varchar     String
;;                     :bpchar      String
;;                     ;; :bigserial
;;                     :text        String
;;                     :bytea       ByteArray
;;                     :date        Date
;;                     :time        Time
;;                     :timetz      Time
;;                     :timestamp   Timestamp
;;                     :timestamptz Timestamp
;;                     :interval    PGInterval
;;                     :bool        Boolean
;;                     :point       PGpoint
;;                     :lseg        PGlseg
;;                     :box         PGbox
;;                     :path        PGpath
;;                     :polygon     PGpolygon
;;                     :circle      PGcircle
;;                     :cidr        Object
;;                     :inet        Object
;;                     :macaddr     Object
;;                     :bit         Boolean
;;                     :varbit      Object}]]
;;        {:clj-type j
;;         :pg-name  (u/ident-str pg)}))))

;; (defn ^:dynamic *type-assumptions*
;;   [o]
;;   (let [boolean? (partial instance? Boolean)]
;;     (condp #(%1 %2) o
;;       integer? "integer"
;;       float?   "float"
;;       number?  "numeric"
;;       boolean? "boolean"
;;       string?  "text"
;;       char?    "char"
;;       "text")))
