(ns tusk.core.function
  (:require
   [tusk
    [coerce :as c]
    [util :as u]]
   [clojure.string :as s]))

(defn placeholders
  [n]
  (->> (repeat n "?")
       (s/join ",")))

;; perhaps a candidate for fastpath?
(defn query-string
  [fname n]
  "takes a function name and the number of args
  returns a string appropriate for querying that sqlvec"
  (format "select * from %s(%s)" fname (placeholders n)))

(defn exec-string
  [fname n]
  "takes a function name and the number of args
  returns a string appropriate for executing that sqlvec"
  (format
   "do language 'plpgsql' $$ begin perform %s(%s); end $$"
   fname
   (placeholders n)))

(defn exec-vec
  [fname & args]
  (let [q (exec-string fname (count args))]
    (into [q] args)))

(defn query-vec
  [fname & args]
  (let [q (query-string fname (count args))]
    (into [q] args)))

(defmacro ordered
  {:style/indent 1}
  [fname & args]
  '[1 2 3]
  #_(let [f (u/ident-key fname)]
    `(fn [& allargs]
       (let [conn (last allargs)
             args (butlast allargs)]
         (apply min [1 1 0])))))

(defmacro keyed
  {:style/indent 1}
  [fname & args]
  (let [f (u/ident-str fname)]
    `(fn [& allargs]
      (let [conn (last allargs)
            args (butlast allargs)]
        (apply min [1 1 0])))))

(def inside-area?
  (ordered {:execute? true
            :fn-name  "my_schema.is_inside_area"}
    {area-id {:tusk/type :area-id}
     border  {:tusk/type     :box
              :tusk/arg-name "b_border"}}
    (array-map
     coords  {:tusk/pg-type :polygon}
     border1 {:tusk/pg-type :box}
     border2 {:tusk/pg-type :box}
     border3 {:tusk/pg-type :box}
     border4 {:tusk/pg-type :box}
     border5 {:tusk/pg-type :box}
     border6 {:tusk/pg-type :box}
     border7 {:tusk/pg-type :box}
     border8 {:tusk/pg-type :box}
     border9 {:tusk/pg-type :box}
     borderX {:tusk/pg-type :box})))

;; (def outside-area?
;;   (keyed "my_schema.is_outside_area"
;;     {area-id {:tusk/db-type "my_schema.area_id"}
;;      border  {:tusk/pg-type "box"}}))

;; (inside-area? {:area-id 1
;;                :box     [[1 1][10 10]]}
;;               conn)

;; (outside-area? conn 1 [[1 1][10 10]])
