// Compiled by ClojureScript 0.0-2138
goog.provide('turbovote.imbarcode');
goog.require('cljs.core');
goog.require('turbovote.imbarcode.binary');
goog.require('turbovote.imbarcode.characters');
goog.require('turbovote.imbarcode.codewords');
goog.require('turbovote.imbarcode.crc');
goog.require('turbovote.imbarcode.bars');
goog.require('turbovote.imbarcode.bars');
goog.require('turbovote.imbarcode.characters');
goog.require('turbovote.imbarcode.crc');
goog.require('turbovote.imbarcode.codewords');
goog.require('turbovote.imbarcode.binary');
turbovote.imbarcode.encode_binary_data = (function encode_binary_data(binary_data){var fcs = turbovote.imbarcode.crc.IMb_fcs(binary_data);return turbovote.imbarcode.bars.bars(turbovote.imbarcode.characters.codewords__GT_characters(turbovote.imbarcode.codewords.data__GT_codewords(binary_data,fcs),fcs));
});
turbovote.imbarcode.barcode_id_COLON_default = "00";
goog.exportSymbol('turbovote.imbarcode.barcode_id_COLON_default', turbovote.imbarcode.barcode_id_COLON_default);
turbovote.imbarcode.service_type_id_COLON_destination = "040";
goog.exportSymbol('turbovote.imbarcode.service_type_id_COLON_destination', turbovote.imbarcode.service_type_id_COLON_destination);
turbovote.imbarcode.service_type_id_COLON_origin = "050";
goog.exportSymbol('turbovote.imbarcode.service_type_id_COLON_origin', turbovote.imbarcode.service_type_id_COLON_origin);
turbovote.imbarcode.origin_service_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["050",null,"051",null,"052",null], null), null);
/**
* Split IMbarcode structure digits into their constituent parts
*/
turbovote.imbarcode.split_structure_digits = (function split_structure_digits(imb){var barcode = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(imb,0,2);var service = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(imb,2,5);var routing = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(imb,20);var response = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$63,barcode,cljs.core.constant$keyword$64,service,cljs.core.constant$keyword$65,routing], null);if(cljs.core.truth_((turbovote.imbarcode.origin_service_types.cljs$core$IFn$_invoke$arity$1 ? turbovote.imbarcode.origin_service_types.cljs$core$IFn$_invoke$arity$1(service) : turbovote.imbarcode.origin_service_types.call(null,service))))
{return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(response,cljs.core.constant$keyword$66,cljs.core.subs.cljs$core$IFn$_invoke$arity$3(imb,5,20));
} else
{var mailer_and_serial = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(imb,5,20);return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(response,cljs.core.constant$keyword$67,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$68,cljs.core.subs.cljs$core$IFn$_invoke$arity$3(mailer_and_serial,0,6),cljs.core.constant$keyword$69,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(mailer_and_serial,6)], null),cljs.core.array_seq([cljs.core.constant$keyword$70,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$68,cljs.core.subs.cljs$core$IFn$_invoke$arity$3(mailer_and_serial,0,9),cljs.core.constant$keyword$69,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(mailer_and_serial,9)], null)], 0));
}
});
goog.exportSymbol('turbovote.imbarcode.split_structure_digits', turbovote.imbarcode.split_structure_digits);
/**
* Generate the texual representation of an encoded USPS IMbarcode
* from the data provided. You can pass in the full numerical
* sequence if you have that available. For origin tracing, pass in
* a barcode id, service type id, customer number, and routing
* number.  For destination tracing, pass in a barcode id, service
* type id, mailer id, serial number, and routing number.
* 
* The generated string will consist of the characters [ADFT].  See
* section 3.1.3 of the IMb spec for a detailed description of the
* parameters.
*/
turbovote.imbarcode.encode = (function() {
var encode = null;
var encode__1 = (function (structure_digits){if(typeof structure_digits === 'string')
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"string?","string?",772676615,null),new cljs.core.Symbol(null,"structure-digits","structure-digits",1461316665,null))], 0)))].join('')));
}
if(!((cljs.core.re_find(/^\d*$/,structure_digits) == null)))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"not","not",-1640422260,null),cljs.core.list(new cljs.core.Symbol(null,"nil?","nil?",-1637150201,null),cljs.core.list(new cljs.core.Symbol(null,"re-find","re-find",-608081204,null),/^\d*$/,new cljs.core.Symbol(null,"structure-digits","structure-digits",1461316665,null))))], 0)))].join('')));
}
if((20 <= cljs.core.count(structure_digits)))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"<=","<=",-1640529606,null),20,cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"structure-digits","structure-digits",1461316665,null)))], 0)))].join('')));
}
if((31 >= cljs.core.count(structure_digits)))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,">=",">=",-1640529544,null),31,cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"structure-digits","structure-digits",1461316665,null)))], 0)))].join('')));
}
var map__5206 = turbovote.imbarcode.split_structure_digits(structure_digits);var map__5206__$1 = ((cljs.core.seq_QMARK_(map__5206))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__5206):map__5206);var imb_data = map__5206__$1;var routing = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5206__$1,cljs.core.constant$keyword$65);var service = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5206__$1,cljs.core.constant$keyword$64);var barcode = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5206__$1,cljs.core.constant$keyword$63);if(cljs.core.contains_QMARK_(turbovote.imbarcode.origin_service_types,service))
{return encode.cljs$core$IFn$_invoke$arity$4(barcode,service,cljs.core.constant$keyword$66.cljs$core$IFn$_invoke$arity$1(imb_data),routing);
} else
{return encode.cljs$core$IFn$_invoke$arity$5(barcode,service,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(imb_data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$67,cljs.core.constant$keyword$68], null)),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(imb_data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$67,cljs.core.constant$keyword$69], null)),routing);
}
});
var encode__4 = (function (barcode,service,customer_number,routing){if(cljs.core.every_QMARK_(cljs.core.string_QMARK_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [barcode,service,customer_number,routing], null)))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"every?","every?",1363110461,null),new cljs.core.Symbol(null,"string?","string?",772676615,null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"barcode","barcode",-1974115783,null),new cljs.core.Symbol(null,"service","service",343621742,null),new cljs.core.Symbol(null,"customer-number","customer-number",-1672525359,null),new cljs.core.Symbol(null,"routing","routing",-254879105,null)], null))], 0)))].join('')));
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(barcode),2))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"barcode","barcode",-1974115783,null)),2)], 0)))].join('')));
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(service),3))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"service","service",343621742,null)),3)], 0)))].join('')));
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(customer_number),15))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"customer-number","customer-number",-1672525359,null)),15)], 0)))].join('')));
}
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [0,null,5,null,9,null,11,null], null), null).call(null,cljs.core.count(routing))))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [0,null,5,null,9,null,11,null], null), null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"routing","routing",-254879105,null)))], 0)))].join('')));
}
return turbovote.imbarcode.encode_binary_data(turbovote.imbarcode.binary.binary_encode.cljs$core$IFn$_invoke$arity$4(barcode,service,customer_number,routing));
});
var encode__5 = (function (barcode,service,mailer,serial_number,routing){if(cljs.core.every_QMARK_(cljs.core.string_QMARK_,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [barcode,service,mailer,serial_number,routing], null)))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"every?","every?",1363110461,null),new cljs.core.Symbol(null,"string?","string?",772676615,null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"barcode","barcode",-1974115783,null),new cljs.core.Symbol(null,"service","service",343621742,null),new cljs.core.Symbol(null,"mailer","mailer",1572862557,null),new cljs.core.Symbol(null,"serial-number","serial-number",1541334779,null),new cljs.core.Symbol(null,"routing","routing",-254879105,null)], null))], 0)))].join('')));
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(barcode),2))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"barcode","barcode",-1974115783,null)),2)], 0)))].join('')));
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(service),3))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"service","service",343621742,null)),3)], 0)))].join('')));
}
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mailer),6)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(serial_number),9))) || ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mailer),9)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(serial_number),6))))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"or","or",-1640527972,null),cljs.core.list(new cljs.core.Symbol(null,"and","and",-1640434800,null),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"mailer","mailer",1572862557,null)),6),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"serial-number","serial-number",1541334779,null)),9)),cljs.core.list(new cljs.core.Symbol(null,"and","and",-1640434800,null),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"mailer","mailer",1572862557,null)),9),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"serial-number","serial-number",1541334779,null)),6)))], 0)))].join('')));
}
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [0,null,5,null,9,null,11,null], null), null).call(null,cljs.core.count(routing))))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [0,null,5,null,9,null,11,null], null), null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"routing","routing",-254879105,null)))], 0)))].join('')));
}
return turbovote.imbarcode.encode_binary_data(turbovote.imbarcode.binary.binary_encode.cljs$core$IFn$_invoke$arity$5(barcode,service,mailer,serial_number,routing));
});
encode = function(barcode,service,mailer,serial_number,routing){
switch(arguments.length){
case 1:
return encode__1.call(this,barcode);
case 4:
return encode__4.call(this,barcode,service,mailer,serial_number);
case 5:
return encode__5.call(this,barcode,service,mailer,serial_number,routing);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
encode.cljs$core$IFn$_invoke$arity$1 = encode__1;
encode.cljs$core$IFn$_invoke$arity$4 = encode__4;
encode.cljs$core$IFn$_invoke$arity$5 = encode__5;
return encode;
})()
;
goog.exportSymbol('turbovote.imbarcode.encode', turbovote.imbarcode.encode);
