// Compiled by ClojureScript 0.0-2138
goog.provide('turbovote.imbarcode.crc');
goog.require('cljs.core');
goog.require('turbovote.big_integer');
goog.require('turbovote.big_integer');
goog.require('clojure.string');
goog.require('clojure.string');
turbovote.imbarcode.crc.pad = (function pad(data,n){return cljs.core.concat.call(null,data,cljs.core.repeat.call(null,n,0));
});
turbovote.imbarcode.crc.front_pad_to = (function front_pad_to(data,n){return cljs.core.concat.call(null,cljs.core.repeat.call(null,(n - cljs.core.count.call(null,data)),0),data);
});
turbovote.imbarcode.crc.int__GT_binvector = (function int__GT_binvector(i){var v = cljs.core.List.EMPTY;var n = i;while(true){
if(cljs.core.truth_(turbovote.big_integer.zero_QMARK_.call(null,n)))
{return v;
} else
{{
var G__4764 = cljs.core.conj.call(null,v,turbovote.big_integer.int$.call(null,turbovote.big_integer.rem.call(null,n,2)));
var G__4765 = turbovote.big_integer.quot.call(null,n,2);
v = G__4764;
n = G__4765;
continue;
}
}
break;
}
});
turbovote.imbarcode.crc.xor = (function xor(data,p){return cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.bit_xor,cljs.core.take.call(null,cljs.core.count.call(null,p),data),p),cljs.core.drop.call(null,cljs.core.count.call(null,p),data));
});
turbovote.imbarcode.crc.crc = (function crc(input,poly_div){var crc_len = (cljs.core.count.call(null,poly_div) - 1);var padded = turbovote.imbarcode.crc.pad.call(null,input,crc_len);var result = turbovote.imbarcode.crc.xor.call(null,padded,cljs.core.repeat.call(null,crc_len,1));while(true){
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,result),crc_len))
{return result;
} else
{if((cljs.core.first.call(null,result) === 0))
{{
var G__4766 = cljs.core.rest.call(null,result);
result = G__4766;
continue;
}
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{{
var G__4767 = turbovote.imbarcode.crc.xor.call(null,result,poly_div);
result = G__4767;
continue;
}
} else
{return null;
}
}
}
break;
}
});
/**
* Returns the 11 bit IMb frame check sequence
* represented as a vector of 0s and 1s.
* binary-data should be a vector of 0s and 1s representing
* the calculated binary data
*/
turbovote.imbarcode.crc.IMb_fcs = (function IMb_fcs(binary_data){var fcs_11 = turbovote.imbarcode.crc.crc.call(null,cljs.core.drop.call(null,2,turbovote.imbarcode.crc.front_pad_to.call(null,turbovote.imbarcode.crc.int__GT_binvector.call(null,binary_data),104)),turbovote.imbarcode.crc.int__GT_binvector.call(null,3893));return turbovote.big_integer.int$.call(null,turbovote.big_integer.from_string.call(null,clojure.string.join.call(null,fcs_11),2));
});

//# sourceMappingURL=crc.js.map