// Compiled by ClojureScript 0.0-2138
goog.provide('turbovote.imbarcode');
goog.require('cljs.core');
goog.require('turbovote.imbarcode.binary');
goog.require('turbovote.imbarcode.characters');
goog.require('turbovote.imbarcode.codewords');
goog.require('turbovote.imbarcode.crc');
goog.require('turbovote.imbarcode.bars');
goog.require('turbovote.imbarcode.bars');
goog.require('turbovote.imbarcode.characters');
goog.require('turbovote.imbarcode.crc');
goog.require('turbovote.imbarcode.codewords');
goog.require('turbovote.imbarcode.binary');
turbovote.imbarcode.encode_binary_data = (function encode_binary_data(binary_data){var fcs = turbovote.imbarcode.crc.IMb_fcs(binary_data);return turbovote.imbarcode.bars.bars(turbovote.imbarcode.characters.codewords__GT_characters(turbovote.imbarcode.codewords.data__GT_codewords(binary_data,fcs),fcs));
});
turbovote.imbarcode.barcode_id_COLON_default = "00";
goog.exportSymbol('turbovote.imbarcode.barcode_id_COLON_default', turbovote.imbarcode.barcode_id_COLON_default);
turbovote.imbarcode.service_type_id_COLON_destination = "040";
goog.exportSymbol('turbovote.imbarcode.service_type_id_COLON_destination', turbovote.imbarcode.service_type_id_COLON_destination);
turbovote.imbarcode.service_type_id_COLON_origin = "050";
goog.exportSymbol('turbovote.imbarcode.service_type_id_COLON_origin', turbovote.imbarcode.service_type_id_COLON_origin);
/**
* Generate the texual representation of an encoded USPS IMbarcode
* from the data provided. For origin tracing, pass in a barcode id,
* service type id, customer number, and routing number.  For
* destination tracing, pass in a barcode id, service type id, mailer
* id, serial number, and routing number.
* 
* The generated string will consist of the characters [ADFT].  See
* section 3.1.3 of the IMb spec for a detailed description of the
* parameters.
*/
turbovote.imbarcode.encode = (function() {
var encode = null;
var encode__4 = (function (barcode,service,customer_number,routing){if(cljs.core.every_QMARK_(cljs.core.string_QMARK_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [barcode,service,customer_number,routing], null)))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"every?","every?",1363110461,null),new cljs.core.Symbol(null,"string?","string?",772676615,null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"barcode","barcode",-1974115783,null),new cljs.core.Symbol(null,"service","service",343621742,null),new cljs.core.Symbol(null,"customer-number","customer-number",-1672525359,null),new cljs.core.Symbol(null,"routing","routing",-254879105,null)], null))], 0)))].join('')));
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(barcode),2))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"barcode","barcode",-1974115783,null)),2)], 0)))].join('')));
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(service),3))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"service","service",343621742,null)),3)], 0)))].join('')));
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(customer_number),15))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"customer-number","customer-number",-1672525359,null)),15)], 0)))].join('')));
}
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [0,null,5,null,9,null,11,null], null), null).call(null,cljs.core.count(routing))))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [0,null,5,null,9,null,11,null], null), null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"routing","routing",-254879105,null)))], 0)))].join('')));
}
return turbovote.imbarcode.encode_binary_data(turbovote.imbarcode.binary.binary_encode.cljs$core$IFn$_invoke$arity$4(barcode,service,customer_number,routing));
});
var encode__5 = (function (barcode,service,mailer,serial_number,routing){if(cljs.core.every_QMARK_(cljs.core.string_QMARK_,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [barcode,service,mailer,serial_number,routing], null)))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"every?","every?",1363110461,null),new cljs.core.Symbol(null,"string?","string?",772676615,null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"barcode","barcode",-1974115783,null),new cljs.core.Symbol(null,"service","service",343621742,null),new cljs.core.Symbol(null,"mailer","mailer",1572862557,null),new cljs.core.Symbol(null,"serial-number","serial-number",1541334779,null),new cljs.core.Symbol(null,"routing","routing",-254879105,null)], null))], 0)))].join('')));
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(barcode),2))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"barcode","barcode",-1974115783,null)),2)], 0)))].join('')));
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(service),3))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"service","service",343621742,null)),3)], 0)))].join('')));
}
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mailer),6)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(serial_number),9))) || ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mailer),9)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(serial_number),6))))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"or","or",-1640527972,null),cljs.core.list(new cljs.core.Symbol(null,"and","and",-1640434800,null),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"mailer","mailer",1572862557,null)),6),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"serial-number","serial-number",1541334779,null)),9)),cljs.core.list(new cljs.core.Symbol(null,"and","and",-1640434800,null),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"mailer","mailer",1572862557,null)),9),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"serial-number","serial-number",1541334779,null)),6)))], 0)))].join('')));
}
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [0,null,5,null,9,null,11,null], null), null).call(null,cljs.core.count(routing))))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [0,null,5,null,9,null,11,null], null), null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"routing","routing",-254879105,null)))], 0)))].join('')));
}
return turbovote.imbarcode.encode_binary_data(turbovote.imbarcode.binary.binary_encode.cljs$core$IFn$_invoke$arity$5(barcode,service,mailer,serial_number,routing));
});
encode = function(barcode,service,mailer,serial_number,routing){
switch(arguments.length){
case 4:
return encode__4.call(this,barcode,service,mailer,serial_number);
case 5:
return encode__5.call(this,barcode,service,mailer,serial_number,routing);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
encode.cljs$core$IFn$_invoke$arity$4 = encode__4;
encode.cljs$core$IFn$_invoke$arity$5 = encode__5;
return encode;
})()
;
goog.exportSymbol('turbovote.imbarcode.encode', turbovote.imbarcode.encode);
