// Compiled by ClojureScript 0.0-2138
goog.provide('turbovote.imbarcode.crc');
goog.require('cljs.core');
goog.require('turbovote.big_integer');
goog.require('turbovote.big_integer');
goog.require('clojure.string');
goog.require('clojure.string');
turbovote.imbarcode.crc.pad = (function pad(data,n){return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(data,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(n,0));
});
turbovote.imbarcode.crc.front_pad_to = (function front_pad_to(data,n){return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((n - cljs.core.count(data)),0),data);
});
turbovote.imbarcode.crc.int__GT_binvector = (function int__GT_binvector(i){var v = cljs.core.List.EMPTY;var n = i;while(true){
if(cljs.core.truth_(turbovote.big_integer.zero_QMARK_(n)))
{return v;
} else
{{
var G__5217 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,turbovote.big_integer.int$(turbovote.big_integer.rem(n,2)));
var G__5218 = turbovote.big_integer.quot(n,2);
v = G__5217;
n = G__5218;
continue;
}
}
break;
}
});
turbovote.imbarcode.crc.xor = (function xor(data,p){return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor,cljs.core.take(cljs.core.count(p),data),p),cljs.core.drop(cljs.core.count(p),data));
});
turbovote.imbarcode.crc.crc = (function crc(input,poly_div){var crc_len = (cljs.core.count(poly_div) - 1);var padded = turbovote.imbarcode.crc.pad(input,crc_len);var result = turbovote.imbarcode.crc.xor(padded,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(crc_len,1));while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(result),crc_len))
{return result;
} else
{if((cljs.core.first(result) === 0))
{{
var G__5219 = cljs.core.rest(result);
result = G__5219;
continue;
}
} else
{if(cljs.core.constant$keyword$33)
{{
var G__5220 = turbovote.imbarcode.crc.xor(result,poly_div);
result = G__5220;
continue;
}
} else
{return null;
}
}
}
break;
}
});
/**
* Returns the 11 bit IMb frame check sequence
* represented as a vector of 0s and 1s.
* binary-data should be a vector of 0s and 1s representing
* the calculated binary data
*/
turbovote.imbarcode.crc.IMb_fcs = (function IMb_fcs(binary_data){var fcs_11 = turbovote.imbarcode.crc.crc(cljs.core.drop(2,turbovote.imbarcode.crc.front_pad_to(turbovote.imbarcode.crc.int__GT_binvector(binary_data),104)),turbovote.imbarcode.crc.int__GT_binvector(3893));return turbovote.big_integer.int$((turbovote.big_integer.from_string.cljs$core$IFn$_invoke$arity$2 ? turbovote.big_integer.from_string.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$1(fcs_11),2) : turbovote.big_integer.from_string.call(null,clojure.string.join.cljs$core$IFn$_invoke$arity$1(fcs_11),2)));
});
