/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapi;

import com.bloomberglp.blpapi.CorrelationID;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.Name;
import com.bloomberglp.blpapi.impl.aE;
import com.bloomberglp.blpapi.impl.dm;

public class TopicList {
    private static final Name uV = Name.getName("TopicSubscribed");
    private static final Name uW = Name.getName("ResolutionSuccess");
    private static final Name uX = Name.getName("topic");
    private static final Name uY = Name.getName("resolvedTopic");
    private aE uZ = new aE(Status.NOT_CREATED.ordinal());

    public void add(String string) {
        this.add(string, new CorrelationID());
    }

    public void add(String string, CorrelationID correlationID) {
        if (string == null || correlationID == null) {
            throw new IllegalArgumentException("Null arguments");
        }
        if (!this.af(string)) {
            throw new IllegalArgumentException("Invalid topic string");
        }
        this.uZ.add(string, correlationID);
    }

    private boolean af(String string) {
        return string.matches("//[^/]+/[^/]+/[^?]+(\\?[^&]+(&[^&]+)*)?");
    }

    public void add(Message message) {
        this.add(message, new CorrelationID());
    }

    public void add(Message message, CorrelationID correlationID) {
        Name name = message.asElement().name();
        if (name.equals(uV)) {
            this.uZ.a(message.getElementAsString(uX), correlationID, ((dm)message).cT());
        } else if (name.equals(uW)) {
            this.uZ.a(message.getElementAsString(uY), correlationID, ((dm)message).cT());
        } else {
            throw new IllegalArgumentException("Invalid message to add into topic list");
        }
    }

    public CorrelationID correlationIdAt(int n2) {
        return this.uZ.C(n2);
    }

    public String topicString(CorrelationID correlationID) {
        return this.uZ.f(correlationID);
    }

    public String topicStringAt(int n2) {
        return this.uZ.D(n2);
    }

    public Status status(CorrelationID correlationID) {
        return Status.I(this.uZ.g(correlationID));
    }

    public Status statusAt(int n2) {
        return Status.I(this.uZ.E(n2));
    }

    public Message message(CorrelationID correlationID) {
        return this.uZ.h(correlationID);
    }

    public Message messageAt(int n2) {
        return this.uZ.F(n2);
    }

    public int size() {
        return this.uZ.size();
    }

    aE hr() {
        return this.uZ;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status NOT_CREATED = new Status();
        public static final /* enum */ Status CREATED = new Status();
        public static final /* enum */ Status FAILURE = new Status();
        private static final /* synthetic */ Status[] jR;

        public static Status[] values() {
            return (Status[])jR.clone();
        }

        public static Status valueOf(String string) {
            return Enum.valueOf(Status.class, string);
        }

        static Status I(int n2) {
            if (n2 == NOT_CREATED.ordinal()) {
                return NOT_CREATED;
            }
            if (n2 == CREATED.ordinal()) {
                return CREATED;
            }
            assert (FAILURE.ordinal() == n2);
            return FAILURE;
        }

        static {
            jR = new Status[]{NOT_CREATED, CREATED, FAILURE};
        }
    }
}

