/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapi;

import com.bloomberglp.blpapi.CorrelationID;
import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.EventDispatcher;
import com.bloomberglp.blpapi.EventQueue;
import com.bloomberglp.blpapi.Identity;
import com.bloomberglp.blpapi.Request;
import com.bloomberglp.blpapi.Service;
import com.bloomberglp.blpapi.SessionOptions;
import com.bloomberglp.blpapi.UserHandle;
import com.bloomberglp.blpapi.impl.aU;
import com.bloomberglp.blpapi.impl.aZ;
import com.bloomberglp.blpapi.impl.ao;
import com.bloomberglp.blpapi.impl.az;
import com.bloomberglp.blpapi.impl.c;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSession {
    private final ArrayList<AtomicReference<c.b>> wf = new ArrayList();

    protected AbstractSession() {
        for (int i2 = 0; i2 < Event.EventType.count(); ++i2) {
            this.wf.add(new AtomicReference());
        }
    }

    public boolean start() throws IOException, InterruptedException {
        return this.eE().start();
    }

    public void startAsync() throws IOException {
        this.eE().startAsync();
    }

    public void stop() throws InterruptedException {
        this.stop(StopOption.SYNC);
    }

    public void stop(StopOption stopOption) throws InterruptedException {
        this.eE().a(stopOption.CP);
    }

    public Event nextEvent() throws InterruptedException {
        return this.eE().nextEvent();
    }

    public Event nextEvent(long l2) throws InterruptedException {
        return this.eE().nextEvent(l2);
    }

    public Event tryNextEvent() {
        return this.eE().tryNextEvent();
    }

    public CorrelationID openServiceAsync(String string) throws IOException {
        CorrelationID correlationID = new CorrelationID();
        this.eE().openServiceAsync(string, correlationID);
        return correlationID;
    }

    public void openServiceAsync(String string, CorrelationID correlationID) throws IOException {
        this.eE().openServiceAsync(string, correlationID);
    }

    public boolean openService(String string) throws InterruptedException, IOException {
        CorrelationID correlationID = new CorrelationID();
        return this.eE().a(string, correlationID) != null;
    }

    public Service getService(String string) {
        return this.eE().o(string);
    }

    public CorrelationID sendAuthorizationRequest(Request request, Identity identity, CorrelationID correlationID) throws IOException {
        return this.sendAuthorizationRequest(request, identity, null, correlationID, null);
    }

    public CorrelationID sendAuthorizationRequest(Request request, UserHandle userHandle, CorrelationID correlationID) throws IOException {
        return this.sendAuthorizationRequest(request, (Identity)userHandle, correlationID);
    }

    public CorrelationID sendAuthorizationRequest(Request request, Identity identity, CorrelationID correlationID, String string) throws IOException {
        return this.sendAuthorizationRequest(request, identity, null, correlationID, string);
    }

    public CorrelationID sendAuthorizationRequest(Request request, UserHandle userHandle, CorrelationID correlationID, String string) throws IOException {
        return this.sendAuthorizationRequest(request, (Identity)userHandle, correlationID, string);
    }

    public CorrelationID sendAuthorizationRequest(Request request, Identity identity, EventQueue eventQueue, CorrelationID correlationID) throws IOException {
        return this.sendAuthorizationRequest(request, identity, eventQueue, correlationID, null);
    }

    public CorrelationID sendAuthorizationRequest(Request request, UserHandle userHandle, EventQueue eventQueue, CorrelationID correlationID) throws IOException {
        return this.sendAuthorizationRequest(request, (Identity)userHandle, eventQueue, correlationID);
    }

    public CorrelationID sendAuthorizationRequest(Request request, Identity identity, EventQueue eventQueue, CorrelationID correlationID, String string) throws IOException {
        if (correlationID == null) {
            correlationID = new CorrelationID();
        }
        this.eE().b((az)request, (aZ)identity, eventQueue != null ? eventQueue.E() : null, correlationID, string);
        return correlationID;
    }

    public CorrelationID sendAuthorizationRequest(Request request, UserHandle userHandle, EventQueue eventQueue, CorrelationID correlationID, String string) throws IOException {
        return this.sendAuthorizationRequest(request, (Identity)userHandle, eventQueue, correlationID, string);
    }

    public void cancel(CorrelationID correlationID) {
        this.eE().cancel(correlationID, null);
    }

    public void cancel(CorrelationID correlationID, String string) {
        this.eE().cancel(correlationID, string);
    }

    public void cancel(List<CorrelationID> list) {
        this.eE().cancel(list, null);
    }

    public void cancel(List<CorrelationID> list, String string) {
        this.eE().cancel(list, string);
    }

    public Identity createIdentity() {
        return this.eE().gV();
    }

    public UserHandle createUserHandle() {
        return (UserHandle)this.createIdentity();
    }

    public CorrelationID generateToken(CorrelationID correlationID, EventQueue eventQueue) throws IOException, InterruptedException {
        if (correlationID == null) {
            correlationID = new CorrelationID();
        }
        this.eE().a(correlationID, eventQueue != null ? eventQueue.E() : null);
        return correlationID;
    }

    public CorrelationID generateToken(CorrelationID correlationID) throws IOException, InterruptedException {
        return this.generateToken(correlationID, null);
    }

    public CorrelationID generateToken() throws IOException, InterruptedException {
        return this.generateToken(null, null);
    }

    protected abstract c eE();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void a(c.b b2, Event.EventType eventType) {
        assert (b2 != null);
        ArrayList<AtomicReference<c.b>> arrayList = this.wf;
        synchronized (arrayList) {
            if (this.wf.get(eventType.gt()).get() == null) {
                throw new IllegalArgumentException("Event handler can't be set on a synchronous session");
            }
            this.wf.get(eventType.gt()).set(b2);
        }
    }

    protected void a(c.b b2) {
        for (int i2 = 0; i2 < this.wf.size(); ++i2) {
            this.wf.get(i2).set(b2);
        }
    }

    protected void a(SessionOptions sessionOptions, EventDispatcher eventDispatcher, boolean bl2) {
        if (sessionOptions == null) {
            sessionOptions = new SessionOptions();
        }
        c.b b2 = null;
        if (bl2) {
            b2 = new c.b(){

                public void a(Event event) {
                    c.b b2 = (c.b)((AtomicReference)AbstractSession.this.wf.get(event.eventType().gt())).get();
                    assert (b2 != null);
                    b2.a(event);
                }
            };
        }
        ao ao2 = null;
        if (eventDispatcher != null) {
            ao2 = eventDispatcher.jb();
        }
        this.b(sessionOptions.iy(), b2, ao2);
    }

    protected abstract void b(aU var1, c.b var2, ao var3);

    public static class StopOption {
        private final c.h CP;
        public static final StopOption SYNC = new StopOption(c.h.Cp);
        public static final StopOption ASYNC = new StopOption(c.h.Cq);

        private StopOption(c.h h2) {
            this.CP = h2;
        }

        public String toString() {
            return this.CP.toString();
        }

        public int intValue() {
            return this.CP.intValue();
        }

        public static class Constants {
            public static final int SYNC = 0;
            public static final int ASYNC = 1;
        }
    }
}

