# unilog-appenders [![Circle CI](https://circleci.com/gh/truckerpathteam/unilog-appenders.svg?style=shield)](https://circleci.com/gh/truckerpathteam/unilog-appenders)

Additional appenders for [spootnik/unilog](https://github.com/pyr/unilog). Available appenders:
 * [Logentries](https://logentries.com/)

## Usage

[![Clojars Project](http://clojars.org/truckerpath/unilog-appenders/latest-version.svg)](https://clojars.org/truckerpath/unilog-appenders)

You have to `require` appender you want to use in a file where you're calling `start-logging!`
and add appropriate section into you logging config.

### Logentries

```clojure
(require '[truckerpath.unilog-appenders.logentries])
(require '[unilog.config :as unilog])
(require '[clojure.tools.logging :as log])

(let [config {:appenders [{:appender :logentries
                           :token "your-logentries-token"
                           :debug true   ; default - false
                           :ssl true     ; default - false
                           :pattern "%d{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n"}]}]

  (unilog/start-logging! config)
  (log/info "Log message"))
```

## License

Copyright © 2016 Trucker Path Inc.<br>
Licensed under the [MIT License](LICENSE)
