(ns truckerpath.clj-config.core
  (:require [clojure.edn :as edn]
            [clojure.tools.logging :as log])
  (:refer-clojure :exclude [get get-in]))

(defn read-edn
  "Reads file and parse it assuming it's EDN format."
  [filename]
  (log/info "Reading EDN file" filename)
  (edn/read-string (slurp filename)))

(defn get-in
  "Returns the value in a nested config. Return nil if the key is not present."
  [cfg [& keys]]
  (if cfg
    (let [not-found ::not-found
          value (clojure.core/get-in cfg keys not-found)]
      (if (not= value not-found)
        value
        (log/error "Unable to get value for" keys "- config doesn't have such key")))
    (log/error "Unable to get value for" keys "- config isn't initialized yet.")))

(defn get
  "Returns the value in config. Return nil if the key is not present."
  [cfg key]
  (get-in cfg [key]))
