(ns truckerpath.clj-config.component
  (:refer-clojure :exclude [get get-in])
  (:require [com.stuartsierra.component :as component]
            [truckerpath.clj-config.core :as cfg]))

(defrecord Config [data])

(defn config
  [data]
  (map->Config {:data data}))

(defn read-edn
  [filename]
  (cfg/read-edn filename))

(defn get-in
  [config [& keys]]
  (cfg/get-in (:data config) keys))

(defn get
  [config key]
  (cfg/get (:data config) key))
