# clj-config [![Circle CI](https://circleci.com/gh/truckerpathteam/clj-config.svg?style=shield)](https://circleci.com/gh/truckerpathteam/clj-config)

A very simple Clojure library for loading configs from [edn files](https://github.com/edn-format/edn) with basic functions for keys look up.
The only difference between using this library and clojure `get` and `get-in` functions is logging in case of wrong keys and Component.
Starting from version `1.0.0` config state is no longer stored by the library but has to be provided explicitly.

## Usage

[![Clojars Project](http://clojars.org/truckerpath/clj-config/latest-version.svg)](https://clojars.org/truckerpath/clj-config)

```clojure
(require '[truckerpath.clj-config.core :as cfg])

(def config (atom nil))

(reset! config (cfg/read-edn "config.edn"))
(cfg/get @config "db")
(cfg/get-in @config ["db" "host"])
```

Or with component
```clojure
(require '[truckerpath.clj-config.component :as cfg])
(require '[com.stuartsierra.component :as component])

(def system (component/start
             (component/system-map
              :config (config {:key "value"}))))

(cfg/get (:config system) "db")
(cfg/get-in (:config system) ["db" "host"])
```

## License

Copyright © 2016 Trucker Path Inc.

Licensed under the [MIT License](LICENSE)
