/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import org.zeromq.ZMQ;
import org.zeromq.ZMQException;

public class ZMQForwarder
implements Runnable {
    private final ZMQ.Poller poller;
    private final ZMQ.Socket inSocket;
    private final ZMQ.Socket outSocket;

    public ZMQForwarder(ZMQ.Context context, ZMQ.Socket inSocket, ZMQ.Socket outSocket) {
        this.inSocket = inSocket;
        this.outSocket = outSocket;
        this.poller = context.poller(1);
        this.poller.register(inSocket, 1);
    }

    @Override
    public void run() {
        byte[] msg = null;
        boolean more = true;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                if (this.poller.poll(250000L) < 1L) continue;
                msg = this.inSocket.recv(0);
                more = this.inSocket.hasReceiveMore();
                if (msg == null) continue;
                this.outSocket.send(msg, more ? 2 : 0);
            }
            catch (ZMQException e) {
                if (ZMQ.Error.ETERM.getCode() == (long)e.getErrorCode()) break;
                throw e;
            }
        }
    }
}

